/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.batch.api.IBatchJobSubmitter;
import ca.uhn.fhir.jpa.bulk.export.api.IBulkDataExportJobSchedulingHelper;
import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportHelperService;
import ca.uhn.fhir.jpa.dao.data.IBulkExportCollectionDao;
import ca.uhn.fhir.jpa.dao.data.IBulkExportCollectionFileDao;
import ca.uhn.fhir.jpa.dao.data.IBulkExportJobDao;
import ca.uhn.fhir.jpa.entity.BulkExportCollectionEntity;
import ca.uhn.fhir.jpa.entity.BulkExportCollectionFileEntity;
import ca.uhn.fhir.jpa.entity.BulkExportJobEntity;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.Date;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.transaction.Transactional;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IIdType;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class BulkDataExportJobSchedulingHelperImpl
implements IBulkDataExportJobSchedulingHelper {
    private static final Logger ourLog = LoggerFactory.getLogger(BulkDataExportJobSchedulingHelperImpl.class);
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IBatchJobSubmitter myJobSubmitter;
    @Autowired
    private IBulkExportCollectionDao myBulkExportCollectionDao;
    @Autowired
    private IBulkExportCollectionFileDao myBulkExportCollectionFileDao;
    @Autowired
    private PlatformTransactionManager myTxManager;
    private TransactionTemplate myTxTemplate;
    @Autowired
    private ISchedulerService mySchedulerService;
    @Autowired
    private IBulkExportJobDao myBulkExportJobDao;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private BulkExportHelperService myBulkExportHelperSvc;

    @PostConstruct
    public void start() {
        this.myTxTemplate = new TransactionTemplate(this.myTxManager);
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(PurgeExpiredFilesJob.class.getName());
        jobDetail.setJobClass(PurgeExpiredFilesJob.class);
        this.mySchedulerService.scheduleClusteredJob(3600000L, jobDetail);
    }

    @Transactional(value=Transactional.TxType.NEVER)
    public synchronized void cancelAndPurgeAllJobs() {
        this.myTxTemplate.execute(t -> {
            ourLog.info("Deleting all files");
            this.myBulkExportCollectionFileDao.deleteAllFiles();
            ourLog.info("Deleting all collections");
            this.myBulkExportCollectionDao.deleteAllFiles();
            ourLog.info("Deleting all jobs");
            this.myBulkExportJobDao.deleteAllFiles();
            return null;
        });
    }

    @Transactional(value=Transactional.TxType.NEVER)
    public void purgeExpiredFiles() {
        if (!this.myDaoConfig.isEnableTaskBulkExportJobExecution()) {
            return;
        }
        Optional jobToDelete = (Optional)this.myTxTemplate.execute(t -> {
            PageRequest page = PageRequest.of((int)0, (int)1);
            Slice<BulkExportJobEntity> submittedJobs = this.myBulkExportJobDao.findNotRunningByExpiry((Pageable)page, new Date());
            if (submittedJobs.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((BulkExportJobEntity)submittedJobs.getContent().get(0));
        });
        if (jobToDelete.isPresent()) {
            ourLog.info("Deleting bulk export job: {}", jobToDelete.get());
            this.myTxTemplate.execute(t -> {
                BulkExportJobEntity job = (BulkExportJobEntity)this.myBulkExportJobDao.getOne(((BulkExportJobEntity)jobToDelete.get()).getId());
                for (BulkExportCollectionEntity nextCollection : job.getCollections()) {
                    for (BulkExportCollectionFileEntity nextFile : nextCollection.getFiles()) {
                        ourLog.info("Purging bulk data file: {}", (Object)nextFile.getResourceId());
                        IIdType id = this.myBulkExportHelperSvc.toId(nextFile.getResourceId());
                        this.getBinaryDao().delete(id, (RequestDetails)new SystemRequestDetails());
                        this.getBinaryDao().forceExpungeInExistingTransaction(id, new ExpungeOptions().setExpungeDeletedResources(true).setExpungeOldVersions(true), (RequestDetails)new SystemRequestDetails());
                        this.myBulkExportCollectionFileDao.deleteByPid(nextFile.getId());
                    }
                    this.myBulkExportCollectionDao.deleteByPid(nextCollection.getId());
                }
                ourLog.debug("*** About to delete job with ID {}", (Object)job.getId());
                this.myBulkExportJobDao.deleteByPid(job.getId());
                return null;
            });
            ourLog.info("Finished deleting bulk export job: {}", jobToDelete.get());
        }
    }

    private IFhirResourceDao<IBaseBinary> getBinaryDao() {
        return this.myDaoRegistry.getResourceDao("Binary");
    }

    public static class PurgeExpiredFilesJob
    implements HapiJob {
        @Autowired
        private IBulkDataExportJobSchedulingHelper myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.purgeExpiredFiles();
        }
    }
}

