/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.bulk.export.api.IBulkExportProcessor;
import ca.uhn.fhir.jpa.bulk.export.model.ExportPIDIteratorParameters;
import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportHelperService;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.mdm.MdmExpansionCacheSvc;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.mdm.model.MdmPidTuple;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkDataExportOptions;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.HasOrListParam;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.SearchParameterUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class JpaBulkExportProcessor
implements IBulkExportProcessor {
    private static final Logger ourLog = LoggerFactory.getLogger(JpaBulkExportProcessor.class);
    public static final int QUERY_CHUNK_SIZE = 100;
    public static final List<String> PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES = List.of("Practitioner", "Organization");
    @Autowired
    private FhirContext myContext;
    @Autowired
    private BulkExportHelperService myBulkExportHelperSvc;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    protected SearchBuilderFactory mySearchBuilderFactory;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private IMdmLinkDao myMdmLinkDao;
    @Autowired
    private MdmExpansionCacheSvc myMdmExpansionCacheSvc;
    private final HashMap<String, ISearchBuilder> myResourceTypeToSearchBuilder = new HashMap();
    private final HashMap<String, String> myResourceTypeToFhirPath = new HashMap();
    private IFhirPath myFhirPath;

    @Transactional
    public Iterator<ResourcePersistentId> getResourcePidIterator(ExportPIDIteratorParameters theParams) {
        String resourceType = theParams.getResourceType();
        String jobId = theParams.getJobId();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resourceType);
        HashSet<ResourcePersistentId> pids = new HashSet<ResourcePersistentId>();
        if (theParams.getExportStyle() == BulkDataExportOptions.ExportStyle.PATIENT) {
            if (this.myDaoConfig.getIndexMissingFields() == DaoConfig.IndexEnabledEnum.DISABLED) {
                String errorMessage = "You attempted to start a Patient Bulk Export, but the system has `Index Missing Fields` disabled. It must be enabled for Patient Bulk Export";
                ourLog.error(errorMessage);
                throw new IllegalStateException(Msg.code((int)797) + errorMessage);
            }
            List maps = this.myBulkExportHelperSvc.createSearchParameterMapsForResourceType(def, theParams);
            String patientSearchParam = this.getPatientSearchParamForCurrentResourceType(theParams.getResourceType()).getName();
            for (SearchParameterMap map : maps) {
                this.validateSearchParametersForPatient(map, theParams);
                ISearchBuilder searchBuilder = this.getSearchBuilderForLocalResourceType(theParams);
                if (!resourceType.equalsIgnoreCase("Patient")) {
                    map.add(patientSearchParam, (IQueryParameterType)new ReferenceParam().setMissing(Boolean.valueOf(false)));
                }
                IResultIterator resultIterator = searchBuilder.createQuery(map, new SearchRuntimeDetails(null, jobId), null, RequestPartitionId.allPartitions());
                while (resultIterator.hasNext()) {
                    pids.add((ResourcePersistentId)resultIterator.next());
                }
            }
        } else if (theParams.getExportStyle() == BulkDataExportOptions.ExportStyle.GROUP) {
            if (resourceType.equalsIgnoreCase("Patient")) {
                return this.getExpandedPatientIterator(theParams);
            }
            Set<String> expandedMemberResourceIds = this.expandAllPatientPidsFromGroup(theParams);
            if (ourLog.isDebugEnabled()) {
                ourLog.debug("Group/{} has been expanded to members:[{}]", (Object)theParams, (Object)String.join((CharSequence)",", expandedMemberResourceIds));
            }
            QueryChunker<String> queryChunker = new QueryChunker<String>();
            queryChunker.chunk(new ArrayList<String>(expandedMemberResourceIds), 100, idChunk -> this.queryResourceTypeWithReferencesToPatients((Set<ResourcePersistentId>)pids, (List<String>)idChunk, theParams, def));
        } else {
            List maps = this.myBulkExportHelperSvc.createSearchParameterMapsForResourceType(def, theParams);
            ISearchBuilder searchBuilder = this.getSearchBuilderForLocalResourceType(theParams);
            for (SearchParameterMap map : maps) {
                IResultIterator resultIterator = searchBuilder.createQuery(map, new SearchRuntimeDetails(null, jobId), null, RequestPartitionId.allPartitions());
                while (resultIterator.hasNext()) {
                    pids.add((ResourcePersistentId)resultIterator.next());
                }
            }
        }
        return pids.iterator();
    }

    protected ISearchBuilder getSearchBuilderForLocalResourceType(ExportPIDIteratorParameters theParams) {
        String resourceType = theParams.getResourceType();
        if (!this.myResourceTypeToSearchBuilder.containsKey(resourceType)) {
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resourceType);
            Class nextTypeClass = def.getImplementingClass();
            ISearchBuilder sb = this.mySearchBuilderFactory.newSearchBuilder((IDao)dao, resourceType, nextTypeClass);
            this.myResourceTypeToSearchBuilder.put(resourceType, sb);
        }
        return this.myResourceTypeToSearchBuilder.get(resourceType);
    }

    protected RuntimeSearchParam getPatientSearchParamForCurrentResourceType(String theResourceType) {
        RuntimeSearchParam searchParam = null;
        Optional onlyPatientSearchParamForResourceType = SearchParameterUtil.getOnlyPatientSearchParamForResourceType((FhirContext)this.myContext, (String)theResourceType);
        if (onlyPatientSearchParamForResourceType.isPresent()) {
            searchParam = (RuntimeSearchParam)onlyPatientSearchParamForResourceType.get();
        }
        return searchParam;
    }

    public void expandMdmResources(List<IBaseResource> theResources) {
        for (IBaseResource resource : theResources) {
            if (PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(resource.fhirType())) continue;
            this.annotateBackwardsReferences(resource);
        }
        this.myResourceTypeToFhirPath.clear();
    }

    private RuntimeSearchParam validateSearchParametersForPatient(SearchParameterMap expandedSpMap, ExportPIDIteratorParameters theParams) {
        RuntimeSearchParam runtimeSearchParam = this.getPatientSearchParamForCurrentResourceType(theParams.getResourceType());
        if (expandedSpMap.get(runtimeSearchParam.getName()) != null) {
            throw new IllegalArgumentException(Msg.code((int)796) + String.format("Patient Bulk Export manually modifies the Search Parameter called [%s], so you may not include this search parameter in your _typeFilter!", runtimeSearchParam.getName()));
        }
        return runtimeSearchParam;
    }

    private void validateSearchParametersForGroup(SearchParameterMap expandedSpMap, String theResourceType) {
        RuntimeSearchParam runtimeSearchParam;
        if (!PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(theResourceType) && expandedSpMap.get((runtimeSearchParam = this.getPatientSearchParamForCurrentResourceType(theResourceType)).getName()) != null) {
            throw new IllegalArgumentException(Msg.code((int)792) + String.format("Group Bulk Export manually modifies the Search Parameter called [%s], so you may not include this search parameter in your _typeFilter!", runtimeSearchParam.getName()));
        }
    }

    private Iterator<ResourcePersistentId> getExpandedPatientIterator(ExportPIDIteratorParameters theParameters) {
        List<String> members = this.getMembersFromGroupWithFilter(theParameters);
        List ids = members.stream().map(member -> new IdDt("Patient/" + member)).collect(Collectors.toList());
        List pidsOrThrowException = this.myIdHelperService.getPidsOrThrowException(RequestPartitionId.allPartitions(), ids);
        HashSet patientPidsToExport = new HashSet(pidsOrThrowException);
        if (theParameters.isExpandMdm()) {
            SystemRequestDetails srd = SystemRequestDetails.newSystemRequestAllPartitions();
            IBaseResource group = this.myDaoRegistry.getResourceDao("Group").read((IIdType)new IdDt(theParameters.getGroupId()), (RequestDetails)srd);
            ResourcePersistentId pidOrNull = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), group);
            List goldenPidSourcePidTuple = this.myMdmLinkDao.expandPidsFromGroupPidGivenMatchResult(pidOrNull, MdmMatchResultEnum.MATCH);
            goldenPidSourcePidTuple.forEach(tuple -> {
                patientPidsToExport.add(tuple.getGoldenPid());
                patientPidsToExport.add(tuple.getSourcePid());
            });
            this.populateMdmResourceCache(goldenPidSourcePidTuple);
        }
        return patientPidsToExport.iterator();
    }

    private List<String> getMembersFromGroupWithFilter(ExportPIDIteratorParameters theParameters) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theParameters.getResourceType());
        ArrayList<String> pids = new ArrayList<String>();
        List maps = this.myBulkExportHelperSvc.createSearchParameterMapsForResourceType(def, theParameters);
        for (SearchParameterMap map : maps) {
            this.validateSearchParametersForPatient(map, theParameters);
            ISearchBuilder searchBuilder = this.getSearchBuilderForLocalResourceType(theParameters);
            HasOrListParam hasOrListParam = new HasOrListParam();
            hasOrListParam.addOr(new HasParam("Group", "member", "_id", theParameters.getGroupId()));
            map.add("_has", (IQueryParameterOr)hasOrListParam);
            IResultIterator resultIterator = searchBuilder.createQuery(map, new SearchRuntimeDetails(null, theParameters.getJobId()), null, RequestPartitionId.allPartitions());
            while (resultIterator.hasNext()) {
                pids.add(((ResourcePersistentId)resultIterator.next()).toString());
            }
        }
        return pids;
    }

    private void populateMdmResourceCache(List<MdmPidTuple> thePidTuples) {
        if (this.myMdmExpansionCacheSvc.hasBeenPopulated()) {
            return;
        }
        HashMap<ResourcePersistentId, Set<ResourcePersistentId>> goldenResourceToSourcePidMap = new HashMap<ResourcePersistentId, Set<ResourcePersistentId>>();
        this.extract(thePidTuples, goldenResourceToSourcePidMap);
        HashMap<String, String> sourceResourceIdToGoldenResourceIdMap = new HashMap<String, String>();
        goldenResourceToSourcePidMap.forEach((key, value) -> {
            String goldenResourceId = this.myIdHelperService.translatePidIdToForcedIdWithCache(new ResourcePersistentId(key)).orElse(key.toString());
            PersistentIdToForcedIdMap pidsToForcedIds = this.myIdHelperService.translatePidsToForcedIds(value);
            Set sourceResourceIds = pidsToForcedIds.getResolvedResourceIds();
            sourceResourceIds.forEach(sourceResourceId -> sourceResourceIdToGoldenResourceIdMap.put((String)sourceResourceId, goldenResourceId));
        });
        this.myMdmExpansionCacheSvc.setCacheContents(sourceResourceIdToGoldenResourceIdMap);
    }

    private void extract(List<MdmPidTuple> theGoldenPidTargetPidTuples, Map<ResourcePersistentId, Set<ResourcePersistentId>> theGoldenResourceToSourcePidMap) {
        for (MdmPidTuple goldenPidTargetPidTuple : theGoldenPidTargetPidTuples) {
            ResourcePersistentId goldenPid = goldenPidTargetPidTuple.getGoldenPid();
            ResourcePersistentId sourcePid = goldenPidTargetPidTuple.getSourcePid();
            theGoldenResourceToSourcePidMap.computeIfAbsent(goldenPid, key -> new HashSet()).add(sourcePid);
        }
    }

    private void queryResourceTypeWithReferencesToPatients(Set<ResourcePersistentId> myReadPids, List<String> idChunk, ExportPIDIteratorParameters theParams, RuntimeResourceDefinition theDef) {
        List expandedSpMaps = this.myBulkExportHelperSvc.createSearchParameterMapsForResourceType(theDef, theParams);
        for (SearchParameterMap expandedSpMap : expandedSpMaps) {
            this.validateSearchParametersForGroup(expandedSpMap, theParams.getResourceType());
            ISearchBuilder searchBuilder = this.getSearchBuilderForLocalResourceType(theParams);
            if (PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(theParams.getResourceType())) {
                this.filterSearchByHasParam(idChunk, expandedSpMap, theParams);
            } else {
                this.filterSearchByResourceIds(idChunk, expandedSpMap, theParams);
            }
            IResultIterator resultIterator = searchBuilder.createQuery(expandedSpMap, new SearchRuntimeDetails(null, theParams.getJobId()), null, RequestPartitionId.allPartitions());
            while (resultIterator.hasNext()) {
                myReadPids.add((ResourcePersistentId)resultIterator.next());
            }
        }
    }

    private void filterSearchByResourceIds(List<String> idChunk, SearchParameterMap expandedSpMap, ExportPIDIteratorParameters theParams) {
        ReferenceOrListParam orList = new ReferenceOrListParam();
        idChunk.forEach(id -> orList.add((IQueryParameterType)new ReferenceParam(id)));
        expandedSpMap.add(this.getPatientSearchParamForCurrentResourceType(theParams.getResourceType()).getName(), (IQueryParameterOr)orList);
    }

    private void filterSearchByHasParam(List<String> idChunk, SearchParameterMap expandedSpMap, ExportPIDIteratorParameters theParams) {
        HasOrListParam hasOrListParam = new HasOrListParam();
        idChunk.stream().forEach(id -> hasOrListParam.addOr(this.buildHasParam((String)id, theParams.getResourceType())));
        expandedSpMap.add("_has", (IQueryParameterOr)hasOrListParam);
    }

    private HasParam buildHasParam(String theId, String theResourceType) {
        if ("Practitioner".equalsIgnoreCase(theResourceType)) {
            return new HasParam("Patient", "general-practitioner", "_id", theId);
        }
        if ("Organization".equalsIgnoreCase(theResourceType)) {
            return new HasParam("Patient", "organization", "_id", theId);
        }
        throw new IllegalArgumentException(Msg.code((int)2077) + " We can't handle forward references onto type " + theResourceType);
    }

    private Set<String> expandAllPatientPidsFromGroup(ExportPIDIteratorParameters theParams) {
        HashSet<String> expandedIds = new HashSet<String>();
        SystemRequestDetails requestDetails = SystemRequestDetails.newSystemRequestAllPartitions();
        IBaseResource group = this.myDaoRegistry.getResourceDao("Group").read((IIdType)new IdDt(theParams.getGroupId()), (RequestDetails)requestDetails);
        ResourcePersistentId pidOrNull = this.myIdHelperService.getPidOrNull(RequestPartitionId.allPartitions(), group);
        if (theParams.isExpandMdm()) {
            List goldenPidTargetPidTuples = this.myMdmLinkDao.expandPidsFromGroupPidGivenMatchResult(pidOrNull, MdmMatchResultEnum.MATCH);
            HashSet uniquePids = new HashSet();
            goldenPidTargetPidTuples.forEach(tuple -> {
                uniquePids.add(tuple.getGoldenPid());
                uniquePids.add(tuple.getSourcePid());
            });
            PersistentIdToForcedIdMap pidToForcedIdMap = this.myIdHelperService.translatePidsToForcedIds(uniquePids);
            HashMap<ResourcePersistentId, Set<ResourcePersistentId>> goldenResourceToSourcePidMap = new HashMap<ResourcePersistentId, Set<ResourcePersistentId>>();
            this.extract(goldenPidTargetPidTuples, goldenResourceToSourcePidMap);
            this.populateMdmResourceCache(goldenPidTargetPidTuples);
            Set resolvedResourceIds = pidToForcedIdMap.getResolvedResourceIds();
            expandedIds.addAll(resolvedResourceIds);
        }
        expandedIds.addAll(this.getMembersFromGroupWithFilter(theParams));
        return expandedIds;
    }

    private RuntimeSearchParam getRuntimeSearchParam(IBaseResource theResource) {
        Optional oPatientSearchParam = SearchParameterUtil.getOnlyPatientSearchParamForResourceType((FhirContext)this.myContext, (String)theResource.fhirType());
        if (!oPatientSearchParam.isPresent()) {
            String errorMessage = String.format("[%s] has  no search parameters that are for patients, so it is invalid for Group Bulk Export!", theResource.fhirType());
            throw new IllegalArgumentException(Msg.code((int)2103) + errorMessage);
        }
        return (RuntimeSearchParam)oPatientSearchParam.get();
    }

    private void annotateBackwardsReferences(IBaseResource iBaseResource) {
        Optional<String> patientReference = this.getPatientReference(iBaseResource);
        if (patientReference.isPresent()) {
            this.addGoldenResourceExtension(iBaseResource, patientReference.get());
        } else {
            ourLog.error("Failed to find the patient reference information for resource {}. This is a bug, as all resources which can be exported via Group Bulk Export must reference a patient.", (Object)iBaseResource);
        }
    }

    private Optional<String> getPatientReference(IBaseResource iBaseResource) {
        String fhirPath;
        String resourceType = iBaseResource.fhirType();
        if (this.myResourceTypeToFhirPath.containsKey(resourceType)) {
            fhirPath = this.myResourceTypeToFhirPath.get(resourceType);
        } else {
            RuntimeSearchParam runtimeSearchParam = this.getRuntimeSearchParam(iBaseResource);
            fhirPath = this.getPatientFhirPath(runtimeSearchParam);
            this.myResourceTypeToFhirPath.put(resourceType, fhirPath);
        }
        if (iBaseResource.fhirType().equalsIgnoreCase("Patient")) {
            return Optional.of(iBaseResource.getIdElement().getIdPart());
        }
        Optional optionalReference = this.getFhirParser().evaluateFirst((IBase)iBaseResource, fhirPath, IBaseReference.class);
        if (optionalReference.isPresent()) {
            return optionalReference.map(theIBaseReference -> theIBaseReference.getReferenceElement().getIdPart());
        }
        return Optional.empty();
    }

    private void addGoldenResourceExtension(IBaseResource iBaseResource, String sourceResourceId) {
        String goldenResourceId = this.myMdmExpansionCacheSvc.getGoldenResourceId(sourceResourceId);
        IBaseExtension extension = ExtensionUtil.getOrCreateExtension((IBase)iBaseResource, (String)"https://hapifhir.org/associated-patient-golden-resource/");
        if (!StringUtils.isBlank((CharSequence)goldenResourceId)) {
            ExtensionUtil.setExtension((FhirContext)this.myContext, (IBaseExtension)extension, (String)"reference", (Object)this.prefixPatient(goldenResourceId));
        }
    }

    private String prefixPatient(String theResourceId) {
        return "Patient/" + theResourceId;
    }

    private IFhirPath getFhirParser() {
        if (this.myFhirPath == null) {
            this.myFhirPath = this.myContext.newFhirPath();
        }
        return this.myFhirPath;
    }

    private String getPatientFhirPath(RuntimeSearchParam theRuntimeParam) {
        String path = theRuntimeParam.getPath();
        if (path.contains(".where")) {
            path = path.substring(0, path.indexOf(".where"));
        }
        return path;
    }
}

