/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.imprt.job;

import ca.uhn.fhir.jpa.bulk.imprt.api.IBulkDataImportSvc;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobStatusEnum;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivateBulkImportEntityStepListener
implements StepExecutionListener {
    @Autowired
    private IBulkDataImportSvc myBulkImportDaoSvc;

    public void beforeStep(StepExecution theStepExecution) {
        String jobUuid = theStepExecution.getJobExecution().getJobParameters().getString("jobUUID");
        if (jobUuid != null) {
            this.myBulkImportDaoSvc.setJobToStatus(jobUuid, BulkImportJobStatusEnum.RUNNING);
        }
    }

    public ExitStatus afterStep(StepExecution theStepExecution) {
        return ExitStatus.EXECUTING;
    }
}

