/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.imprt.job;

import ca.uhn.fhir.jpa.bulk.imprt.api.IBulkDataImportSvc;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobJson;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BulkImportPartitioner
implements Partitioner {
    public static final String FILE_INDEX = "fileIndex";
    public static final String FILE_DESCRIPTION = "fileDescription";
    public static final String JOB_DESCRIPTION = "jobDescription";
    public static final String ROW_PROCESSING_MODE = "rowProcessingMode";
    private static final Logger ourLog = LoggerFactory.getLogger(BulkImportPartitioner.class);
    @Value(value="#{jobParameters['jobUUID']}")
    private String myJobUUID;
    @Autowired
    private IBulkDataImportSvc myBulkDataImportSvc;

    @Nonnull
    public Map<String, ExecutionContext> partition(int gridSize) {
        HashMap<String, ExecutionContext> retVal = new HashMap<String, ExecutionContext>();
        BulkImportJobJson job = this.myBulkDataImportSvc.fetchJob(this.myJobUUID);
        for (int i = 0; i < job.getFileCount(); ++i) {
            String fileDescription = this.myBulkDataImportSvc.getFileDescription(this.myJobUUID, i);
            ExecutionContext context = new ExecutionContext();
            context.putString("jobUUID", this.myJobUUID);
            context.putInt(FILE_INDEX, i);
            context.put(ROW_PROCESSING_MODE, (Object)job.getProcessingMode());
            context.put(JOB_DESCRIPTION, (Object)job.getJobDescription());
            context.put(FILE_DESCRIPTION, (Object)fileDescription);
            String key = "FILE" + i + ":" + fileDescription;
            retVal.put(key, context);
        }
        return retVal;
    }
}

