/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.imprt.job;

import ca.uhn.fhir.util.ValidateUtil;
import java.util.Map;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class CreateBulkImportEntityTasklet
implements Tasklet {
    public RepeatStatus execute(StepContribution theStepContribution, ChunkContext theChunkContext) throws Exception {
        Map jobParameters = theChunkContext.getStepContext().getJobParameters();
        ValidateUtil.isTrueOrThrowInvalidRequest((boolean)jobParameters.containsKey("jobUUID"), (String)"Job doesn't have a UUID", (Object[])new Object[0]);
        this.addUUIDToJobContext(theChunkContext, (String)jobParameters.get("jobUUID"));
        return RepeatStatus.FINISHED;
    }

    public void addUUIDToJobContext(ChunkContext theChunkContext, String theJobUUID) {
        theChunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().putString("jobUUID", theJobUUID);
    }
}

