/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.cache.IResourceVersionSvc;
import ca.uhn.fhir.jpa.cache.ResourcePersistentIdMap;
import ca.uhn.fhir.jpa.cache.ResourceVersionMap;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceVersionSvcDaoImpl
implements IResourceVersionSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceVersionSvcDaoImpl.class);
    @Autowired
    DaoRegistry myDaoRegistry;
    @Autowired
    IResourceTableDao myResourceTableDao;
    @Autowired
    IIdHelperService myIdHelperService;

    @Nonnull
    @Transactional
    public ResourceVersionMap getVersionMap(RequestPartitionId theRequestPartitionId, String theResourceName, SearchParameterMap theSearchParamMap) {
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceName);
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("About to retrieve version map for resource type: {}", (Object)theResourceName);
        }
        List matchingIds = dao.searchForIds(theSearchParamMap, (RequestDetails)new SystemRequestDetails().setRequestPartitionId(theRequestPartitionId)).stream().map(ResourcePersistentId::getIdAsLong).collect(Collectors.toList());
        ArrayList allById = new ArrayList();
        new QueryChunker().chunk(matchingIds, t -> {
            List nextBatch = this.myResourceTableDao.findAllById((Iterable)t);
            allById.addAll(nextBatch);
        });
        return ResourceVersionMap.fromResourceTableEntities(allById);
    }

    public ResourcePersistentIdMap getLatestVersionIdsForResourceIds(RequestPartitionId theRequestPartitionId, List<IIdType> theIds) {
        ResourcePersistentIdMap idToPID = new ResourcePersistentIdMap();
        HashMap resourceTypeToIds = new HashMap();
        for (IIdType id : theIds) {
            String resourceType = id.getResourceType();
            if (!resourceTypeToIds.containsKey(resourceType)) {
                resourceTypeToIds.put(resourceType, new ArrayList());
            }
            ((List)resourceTypeToIds.get(resourceType)).add(id);
        }
        for (String resourceType : resourceTypeToIds.keySet()) {
            ResourcePersistentIdMap idAndPID = this.getIdsOfExistingResources(theRequestPartitionId, (Collection)resourceTypeToIds.get(resourceType));
            idToPID.putAll(idAndPID);
        }
        return idToPID;
    }

    private ResourcePersistentIdMap getIdsOfExistingResources(RequestPartitionId thePartitionId, Collection<IIdType> theIds) {
        ResourcePersistentIdMap retval = new ResourcePersistentIdMap();
        if (theIds == null || theIds.isEmpty()) {
            return retval;
        }
        List resourcePersistentIds = this.myIdHelperService.resolveResourcePersistentIdsWithCache(thePartitionId, theIds.stream().collect(Collectors.toList()));
        HashMap<Long, ResourcePersistentId> pidsToVersionToResourcePid = new HashMap<Long, ResourcePersistentId>();
        for (ResourcePersistentId pid : resourcePersistentIds) {
            if (pid.getVersion() == null) {
                pidsToVersionToResourcePid.put(pid.getIdAsLong(), pid);
            }
            Optional<IIdType> idOp = theIds.stream().filter(i -> i.getIdPart().equals(pid.getAssociatedResourceId().getIdPart())).findFirst();
            idOp.ifPresent(id -> retval.put(id, pid));
        }
        if (!pidsToVersionToResourcePid.isEmpty()) {
            Collection<Object[]> resourceEntries = this.myResourceTableDao.getResourceVersionsForPid(new ArrayList<Long>(pidsToVersionToResourcePid.keySet()));
            for (Object[] record : resourceEntries) {
                Long retPid = (Long)record[0];
                String resType = (String)record[1];
                Long version = (Long)record[2];
                ((ResourcePersistentId)pidsToVersionToResourcePid.get(retPid)).setVersion(version);
            }
        }
        return retval;
    }
}

