/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.fhir.jpa.api.IDaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.batch.config.NonPersistedBatchConfigurer;
import ca.uhn.fhir.jpa.config.JpaConfig;
import ca.uhn.fhir.jpa.config.util.ResourceCountCacheUtil;
import ca.uhn.fhir.jpa.config.util.ValidationSupportConfigUtil;
import ca.uhn.fhir.jpa.dao.FulltextSearchSvcImpl;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.mdm.MdmLinkDaoJpaImpl;
import ca.uhn.fhir.jpa.dao.search.HSearchSortHelperImpl;
import ca.uhn.fhir.jpa.dao.search.IHSearchSortHelper;
import ca.uhn.fhir.jpa.provider.DaoRegistryResourceSupportedSvc;
import ca.uhn.fhir.jpa.search.DatabaseBackedPagingProvider;
import ca.uhn.fhir.jpa.search.IStaleSearchDeletingSvc;
import ca.uhn.fhir.jpa.search.StaleSearchDeletingSvcImpl;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import ca.uhn.fhir.jpa.validation.JpaValidationSupportChain;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.rest.api.IResourceSupportedSvc;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={JpaConfig.class})
public class HapiJpaConfig {
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;

    @Bean
    public IHSearchSortHelper extendedFulltextSortHelper() {
        return new HSearchSortHelperImpl(this.mySearchParamRegistry);
    }

    @Bean
    public IFulltextSearchSvc fullTextSearchSvc() {
        return new FulltextSearchSvcImpl();
    }

    @Bean
    public IStaleSearchDeletingSvc staleSearchDeletingSvc() {
        return new StaleSearchDeletingSvcImpl();
    }

    @Primary
    @Bean
    public CachingValidationSupport validationSupportChain(JpaValidationSupportChain theJpaValidationSupportChain) {
        return ValidationSupportConfigUtil.newCachingValidationSupport(theJpaValidationSupportChain);
    }

    @Bean
    public BatchConfigurer batchConfigurer() {
        return new NonPersistedBatchConfigurer();
    }

    @Bean
    public DatabaseBackedPagingProvider databaseBackedPagingProvider() {
        return new DatabaseBackedPagingProvider();
    }

    @Bean
    public IResourceSupportedSvc resourceSupportedSvc(IDaoRegistry theDaoRegistry) {
        return new DaoRegistryResourceSupportedSvc(theDaoRegistry);
    }

    @Bean(name={"myResourceCountsCache"})
    public ResourceCountCache resourceCountsCache(IFhirSystemDao<?, ?> theSystemDao) {
        return ResourceCountCacheUtil.newResourceCountCache(theSystemDao);
    }

    @Bean
    public static IMdmLinkDao mdmLinkDao() {
        return new MdmLinkDaoJpaImpl();
    }
}

