/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.fhir.util.ReflectionUtil;
import com.google.common.annotations.VisibleForTesting;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.dialect.Dialect;
import org.hibernate.search.engine.cfg.BackendSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public class HibernatePropertiesProvider {
    @Autowired
    private LocalContainerEntityManagerFactoryBean myEntityManagerFactory;
    private Dialect myDialect;
    private String myHibernateSearchBackend;

    @VisibleForTesting
    public void setDialectForUnitTest(Dialect theDialect) {
        this.myDialect = theDialect;
    }

    public Dialect getDialect() {
        Dialect dialect = this.myDialect;
        if (dialect == null) {
            String dialectClass = (String)this.myEntityManagerFactory.getJpaPropertyMap().get("hibernate.dialect");
            dialect = (Dialect)ReflectionUtil.newInstanceOrReturnNull((String)dialectClass, Dialect.class);
            Validate.notNull((Object)dialect, (String)"Unable to create instance of class: %s", (Object[])new Object[]{dialectClass});
            this.myDialect = dialect;
        }
        return dialect;
    }

    public String getHibernateSearchBackend() {
        String hibernateSearchBackend = this.myHibernateSearchBackend;
        if (StringUtils.isBlank((CharSequence)hibernateSearchBackend)) {
            hibernateSearchBackend = (String)this.myEntityManagerFactory.getJpaPropertyMap().get(BackendSettings.backendKey((String)"type"));
            Validate.notNull((Object)hibernateSearchBackend, (String)(BackendSettings.backendKey((String)"type") + " property is unset!"), (Object[])new Object[0]);
            this.myHibernateSearchBackend = hibernateSearchBackend;
        }
        return this.myHibernateSearchBackend;
    }

    public DataSource getDataSource() {
        return this.myEntityManagerFactory.getDataSource();
    }
}

