/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.config.FhirContextDstu2Config;
import ca.uhn.fhir.jpa.config.GeneratedDaoAndResourceProviderConfigDstu2;
import ca.uhn.fhir.jpa.config.JpaConfig;
import ca.uhn.fhir.jpa.dao.FhirSystemDaoDstu2;
import ca.uhn.fhir.jpa.dao.ITransactionProcessorVersionAdapter;
import ca.uhn.fhir.jpa.dao.TransactionProcessorVersionAdapterDstu2;
import ca.uhn.fhir.jpa.provider.JpaSystemProviderDstu2;
import ca.uhn.fhir.jpa.term.TermReadSvcDstu2;
import ca.uhn.fhir.jpa.term.TermVersionAdapterSvcDstu2;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.model.dstu2.composite.MetaDt;
import ca.uhn.fhir.model.dstu2.resource.Bundle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@Import(value={FhirContextDstu2Config.class, GeneratedDaoAndResourceProviderConfigDstu2.class, JpaConfig.class})
public class JpaDstu2Config {
    @Bean
    public ITransactionProcessorVersionAdapter transactionProcessorVersionFacade() {
        return new TransactionProcessorVersionAdapterDstu2();
    }

    @Bean
    public ITermVersionAdapterSvc translationAdaptorVersion() {
        return new TermVersionAdapterSvcDstu2();
    }

    @Bean(name={"mySystemDaoDstu2"})
    public IFhirSystemDao<Bundle, MetaDt> systemDaoDstu2() {
        FhirSystemDaoDstu2 retVal = new FhirSystemDaoDstu2();
        return retVal;
    }

    @Bean(name={"mySystemProviderDstu2"})
    public JpaSystemProviderDstu2 systemProviderDstu2(FhirContext theFhirContext) {
        JpaSystemProviderDstu2 retVal = new JpaSystemProviderDstu2();
        retVal.setDao(this.systemDaoDstu2());
        retVal.setContext(theFhirContext);
        return retVal;
    }

    @Bean
    public ITermReadSvc terminologyService() {
        return new TermReadSvcDstu2();
    }
}

