/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.dao.JpaPersistedResourceValidationSupport;
import ca.uhn.fhir.jpa.validation.JpaValidationSupportChain;
import ca.uhn.fhir.jpa.validation.ValidatorPolicyAdvisor;
import ca.uhn.fhir.jpa.validation.ValidatorResourceFetcher;
import ca.uhn.fhir.validation.IInstanceValidatorModule;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.common.hapi.validation.validator.HapiToHl7OrgDstu2ValidatingSupportWrapper;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class ValidationSupportConfig {
    @Bean(name={"myDefaultProfileValidationSupport"})
    public DefaultProfileValidationSupport defaultProfileValidationSupport(FhirContext theFhirContext) {
        return new DefaultProfileValidationSupport(theFhirContext);
    }

    @Bean(name={"myJpaValidationSupportChain"})
    public JpaValidationSupportChain jpaValidationSupportChain(FhirContext theFhirContext) {
        return new JpaValidationSupportChain(theFhirContext);
    }

    @Bean(name={"myJpaValidationSupport"})
    public IValidationSupport jpaValidationSupport(FhirContext theFhirContext) {
        return new JpaPersistedResourceValidationSupport(theFhirContext);
    }

    @Bean(name={"myInstanceValidator"})
    public IInstanceValidatorModule instanceValidator(FhirContext theFhirContext, CachingValidationSupport theCachingValidationSupport, ValidationSupportChain theValidationSupportChain) {
        if (theFhirContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3)) {
            FhirInstanceValidator val = new FhirInstanceValidator((IValidationSupport)theCachingValidationSupport);
            val.setValidatorResourceFetcher((IValidatorResourceFetcher)this.jpaValidatorResourceFetcher());
            val.setValidatorPolicyAdvisor((IValidationPolicyAdvisor)this.jpaValidatorPolicyAdvisor());
            val.setBestPracticeWarningLevel(BestPracticeWarningLevel.Warning);
            val.setValidationSupport((IValidationSupport)theCachingValidationSupport);
            return val;
        }
        CachingValidationSupport cachingValidationSupport = new CachingValidationSupport((IValidationSupport)new HapiToHl7OrgDstu2ValidatingSupportWrapper((IValidationSupport)theValidationSupportChain));
        FhirInstanceValidator retVal = new FhirInstanceValidator((IValidationSupport)cachingValidationSupport);
        retVal.setBestPracticeWarningLevel(BestPracticeWarningLevel.Warning);
        return retVal;
    }

    @Bean
    @Lazy
    public ValidatorResourceFetcher jpaValidatorResourceFetcher() {
        return new ValidatorResourceFetcher();
    }

    @Bean
    @Lazy
    public ValidatorPolicyAdvisor jpaValidatorPolicyAdvisor() {
        return new ValidatorPolicyAdvisor();
    }
}

