/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.dstu3;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.IDaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.config.GeneratedDaoAndResourceProviderConfigDstu3;
import ca.uhn.fhir.jpa.config.JpaConfig;
import ca.uhn.fhir.jpa.config.SharedConfigDstu3Plus;
import ca.uhn.fhir.jpa.config.dstu3.FhirContextDstu3Config;
import ca.uhn.fhir.jpa.dao.ITransactionProcessorVersionAdapter;
import ca.uhn.fhir.jpa.dao.dstu3.FhirSystemDaoDstu3;
import ca.uhn.fhir.jpa.dao.dstu3.TransactionProcessorVersionAdapterDstu3;
import ca.uhn.fhir.jpa.graphql.GraphQLProvider;
import ca.uhn.fhir.jpa.graphql.GraphQLProviderWithIntrospection;
import ca.uhn.fhir.jpa.provider.dstu3.JpaSystemProviderDstu3;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import ca.uhn.fhir.jpa.term.TermReadSvcDstu3;
import ca.uhn.fhir.jpa.term.TermVersionAdapterSvcDstu3;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermLoaderSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcDstu3;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.utilities.graphql.IGraphQLStorageServices;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@Import(value={FhirContextDstu3Config.class, GeneratedDaoAndResourceProviderConfigDstu3.class, SharedConfigDstu3Plus.class, JpaConfig.class})
public class JpaDstu3Config {
    @Bean
    public ITermVersionAdapterSvc terminologyVersionAdapterSvc() {
        return new TermVersionAdapterSvcDstu3();
    }

    @Bean(name={"myGraphQLProvider"})
    @Lazy
    public GraphQLProvider graphQLProvider(FhirContext theFhirContext, IGraphQLStorageServices theGraphqlStorageServices, IValidationSupport theValidationSupport, ISearchParamRegistry theSearchParamRegistry, IDaoRegistry theDaoRegistry) {
        return new GraphQLProviderWithIntrospection(theFhirContext, theValidationSupport, theGraphqlStorageServices, theSearchParamRegistry, theDaoRegistry);
    }

    @Bean
    public ITransactionProcessorVersionAdapter transactionProcessorVersionFacade() {
        return new TransactionProcessorVersionAdapterDstu3();
    }

    @Bean(name={"mySystemDaoDstu3"})
    public IFhirSystemDao<Bundle, Meta> systemDaoDstu3() {
        return new FhirSystemDaoDstu3();
    }

    @Bean(name={"mySystemProviderDstu3"})
    public JpaSystemProviderDstu3 systemProviderDstu3(FhirContext theFhirContext) {
        JpaSystemProviderDstu3 retVal = new JpaSystemProviderDstu3();
        retVal.setContext(theFhirContext);
        retVal.setDao(this.systemDaoDstu3());
        return retVal;
    }

    @Bean
    public ITermLoaderSvc termLoaderService(ITermDeferredStorageSvc theDeferredStorageSvc, ITermCodeSystemStorageSvc theCodeSystemStorageSvc) {
        return new TermLoaderSvcImpl(theDeferredStorageSvc, theCodeSystemStorageSvc);
    }

    @Bean
    public ITermReadSvcDstu3 terminologyService() {
        return new TermReadSvcDstu3();
    }
}

