/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.config.HapiFhirHibernateJpaDialect;
import ca.uhn.fhir.jpa.config.HapiFhirLocalContainerEntityManagerFactoryBean;
import javax.persistence.spi.PersistenceProvider;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public final class HapiEntityManagerFactoryUtil {
    private HapiEntityManagerFactoryUtil() {
    }

    public static LocalContainerEntityManagerFactoryBean newEntityManagerFactory(ConfigurableListableBeanFactory myConfigurableListableBeanFactory, FhirContext theFhirContext) {
        HapiFhirLocalContainerEntityManagerFactoryBean retVal = new HapiFhirLocalContainerEntityManagerFactoryBean(myConfigurableListableBeanFactory);
        HapiEntityManagerFactoryUtil.configureEntityManagerFactory((LocalContainerEntityManagerFactoryBean)retVal, theFhirContext);
        return retVal;
    }

    public static void configureEntityManagerFactory(LocalContainerEntityManagerFactoryBean theFactory, FhirContext theFhirContext) {
        theFactory.setJpaDialect((JpaDialect)new HapiFhirHibernateJpaDialect(theFhirContext.getLocalizer()));
        theFactory.setPackagesToScan(new String[]{"ca.uhn.fhir.jpa.model.entity", "ca.uhn.fhir.jpa.entity"});
        theFactory.setPersistenceProvider((PersistenceProvider)new HibernatePersistenceProvider());
    }
}

