/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildResourceDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IJpaDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.api.svc.ISearchCoordinatorSvc;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.EncodedResource;
import ca.uhn.fhir.jpa.dao.GZipUtil;
import ca.uhn.fhir.jpa.dao.HistoryBuilderFactory;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.TolerantJsonParser;
import ca.uhn.fhir.jpa.dao.data.IForcedIdDao;
import ca.uhn.fhir.jpa.dao.data.IResourceHistoryTableDao;
import ca.uhn.fhir.jpa.dao.data.IResourceProvenanceDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTagDao;
import ca.uhn.fhir.jpa.dao.expunge.ExpungeService;
import ca.uhn.fhir.jpa.dao.index.DaoSearchParamSynchronizer;
import ca.uhn.fhir.jpa.dao.index.SearchParamWithInlineReferencesExtractor;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.delete.DeleteConflictService;
import ca.uhn.fhir.jpa.entity.PartitionEntity;
import ca.uhn.fhir.jpa.entity.ResourceSearchView;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchTypeEnum;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.model.search.ExtendedHSearchIndexData;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.partition.IPartitionLookupSvc;
import ca.uhn.fhir.jpa.partition.RequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProviderFactory;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import ca.uhn.fhir.jpa.searchparam.extractor.LogicalReferenceHelper;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import ca.uhn.fhir.jpa.sp.ISearchParamPresenceSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.util.AddRemoveCount;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.MetaUtil;
import ca.uhn.fhir.util.XmlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Repository
public abstract class BaseHapiFhirDao<T extends IBaseResource>
extends BaseStorageDao
implements IDao,
IJpaDao<T>,
ApplicationContextAware {
    public static final long INDEX_STATUS_INDEXED = 1L;
    public static final long INDEX_STATUS_INDEXING_FAILED = 2L;
    public static final String NS_JPA_PROFILE = "https://github.com/hapifhir/hapi-fhir/ns/jpa/profile";
    private static final int TOTAL_TAG_READ_ATTEMPTS = 10;
    private static final Logger ourLog = LoggerFactory.getLogger(BaseHapiFhirDao.class);
    private static boolean ourValidationDisabledForUnitTest;
    private static boolean ourDisableIncrementOnUpdateForUnitTest;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    protected IIdHelperService myIdHelperService;
    @Autowired
    protected IForcedIdDao myForcedIdDao;
    @Autowired
    protected IResourceProvenanceDao myResourceProvenanceDao;
    @Autowired
    protected ISearchCoordinatorSvc mySearchCoordinatorSvc;
    @Autowired
    protected ITermReadSvc myTerminologySvc;
    @Autowired
    protected IResourceHistoryTableDao myResourceHistoryTableDao;
    @Autowired
    protected IResourceTableDao myResourceTableDao;
    @Autowired
    protected IResourceTagDao myResourceTagDao;
    @Autowired
    protected DeleteConflictService myDeleteConflictService;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    protected DaoRegistry myDaoRegistry;
    @Autowired
    protected InMemoryResourceMatcher myInMemoryResourceMatcher;
    @Autowired
    ExpungeService myExpungeService;
    @Autowired
    private HistoryBuilderFactory myHistoryBuilderFactory;
    @Autowired
    private DaoConfig myConfig;
    @Autowired
    private PlatformTransactionManager myPlatformTransactionManager;
    @Autowired
    private ISearchCacheSvc mySearchCacheSvc;
    @Autowired
    private ISearchParamPresenceSvc mySearchParamPresenceSvc;
    @Autowired
    private SearchParamWithInlineReferencesExtractor mySearchParamWithInlineReferencesExtractor;
    @Autowired
    private DaoSearchParamSynchronizer myDaoSearchParamSynchronizer;
    @Autowired
    private SearchBuilderFactory mySearchBuilderFactory;
    private FhirContext myContext;
    private ApplicationContext myApplicationContext;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private RequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    private PersistedJpaBundleProviderFactory myPersistedJpaBundleProviderFactory;
    @Autowired
    private IPartitionLookupSvc myPartitionLookupSvc;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearchSvc;
    @Autowired
    private PlatformTransactionManager myTransactionManager;

    @VisibleForTesting
    public void setSearchParamPresenceSvc(ISearchParamPresenceSvc theSearchParamPresenceSvc) {
        this.mySearchParamPresenceSvc = theSearchParamPresenceSvc;
    }

    protected IInterceptorBroadcaster getInterceptorBroadcaster() {
        return this.myInterceptorBroadcaster;
    }

    protected ApplicationContext getApplicationContext() {
        return this.myApplicationContext;
    }

    public void setApplicationContext(ApplicationContext theApplicationContext) throws BeansException {
        if (this.myApplicationContext == null) {
            this.myApplicationContext = theApplicationContext;
        }
    }

    private void extractTagsHapi(TransactionDetails theTransactionDetails, IResource theResource, ResourceTable theEntity, Set<ResourceTag> allDefs) {
        List profiles;
        List securityLabels;
        TagList tagList = (TagList)ResourceMetadataKeyEnum.TAG_LIST.get(theResource);
        if (tagList != null) {
            for (Object next : tagList) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.TAG, next.getScheme(), next.getTerm(), next.getLabel());
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                allDefs.add(tag);
                theEntity.setHasTags(true);
            }
        }
        if ((securityLabels = (List)ResourceMetadataKeyEnum.SECURITY_LABELS.get(theResource)) != null) {
            for (BaseCodingDt next : securityLabels) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.SECURITY_LABEL, (String)next.getSystemElement().getValue(), (String)next.getCodeElement().getValue(), (String)next.getDisplayElement().getValue());
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                allDefs.add(tag);
                theEntity.setHasTags(true);
            }
        }
        if ((profiles = (List)ResourceMetadataKeyEnum.PROFILES.get(theResource)) != null) {
            for (IIdType next : profiles) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.PROFILE, NS_JPA_PROFILE, next.getValue(), null);
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                allDefs.add(tag);
                theEntity.setHasTags(true);
            }
        }
    }

    private void extractTagsRi(TransactionDetails theTransactionDetails, IAnyResource theResource, ResourceTable theEntity, Set<ResourceTag> theAllTags) {
        List profiles;
        List securityLabels;
        List tagList = theResource.getMeta().getTag();
        if (tagList != null) {
            for (IBaseCoding next : tagList) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.TAG, next.getSystem(), next.getCode(), next.getDisplay());
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                theAllTags.add(tag);
                theEntity.setHasTags(true);
            }
        }
        if ((securityLabels = theResource.getMeta().getSecurity()) != null) {
            for (IBaseCoding next : securityLabels) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.SECURITY_LABEL, next.getSystem(), next.getCode(), next.getDisplay());
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                theAllTags.add(tag);
                theEntity.setHasTags(true);
            }
        }
        if ((profiles = theResource.getMeta().getProfile()) != null) {
            for (IPrimitiveType next : profiles) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.PROFILE, NS_JPA_PROFILE, (String)next.getValue(), null);
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                theAllTags.add(tag);
                theEntity.setHasTags(true);
            }
        }
    }

    private Set<ResourceTag> getAllTagDefinitions(ResourceTable theEntity) {
        HashSet retVal = Sets.newHashSet();
        if (theEntity.isHasTags()) {
            for (ResourceTag next : theEntity.getTags()) {
                retVal.add(next);
            }
        }
        return retVal;
    }

    public DaoConfig getConfig() {
        return this.myConfig;
    }

    public FhirContext getContext() {
        return this.myContext;
    }

    @Autowired
    public void setContext(FhirContext theContext) {
        this.myFhirContext = theContext;
        this.myContext = theContext;
    }

    public FhirContext getContext(FhirVersionEnum theVersion) {
        Validate.notNull((Object)theVersion, (String)"theVersion must not be null", (Object[])new Object[0]);
        if (theVersion == this.myFhirContext.getVersion().getVersion()) {
            return this.myFhirContext;
        }
        return FhirContext.forCached((FhirVersionEnum)theVersion);
    }

    protected TagDefinition getTagOrNull(TransactionDetails theTransactionDetails, TagTypeEnum theTagType, String theScheme, String theTerm, String theLabel) {
        HashMap resolvedTagDefinitions;
        if (StringUtils.isBlank((CharSequence)theScheme) && StringUtils.isBlank((CharSequence)theTerm) && StringUtils.isBlank((CharSequence)theLabel)) {
            return null;
        }
        MemoryCacheService.TagDefinitionCacheKey key = BaseHapiFhirDao.toTagDefinitionMemoryCacheKey(theTagType, theScheme, theTerm);
        TagDefinition retVal = (TagDefinition)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.TAG_DEFINITION, (Object)key);
        if (retVal == null && (retVal = (TagDefinition)(resolvedTagDefinitions = (HashMap)theTransactionDetails.getOrCreateUserData(HapiTransactionService.XACT_USERDATA_KEY_RESOLVED_TAG_DEFINITIONS, () -> new HashMap())).get(key)) == null) {
            retVal = this.getOrCreateTag(theTagType, theScheme, theTerm, theLabel);
            AddTagDefinitionToCacheAfterCommitSynchronization sync = new AddTagDefinitionToCacheAfterCommitSynchronization(key, retVal);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)sync);
            resolvedTagDefinitions.put(key, retVal);
        }
        return retVal;
    }

    private TagDefinition getOrCreateTag(final TagTypeEnum theTagType, final String theScheme, final String theTerm, final String theLabel) {
        TagDefinition retVal;
        CriteriaBuilder builder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(TagDefinition.class);
        Root from = cq.from(TagDefinition.class);
        if (StringUtils.isNotBlank((CharSequence)theScheme)) {
            cq.where((Expression)builder.and(new Predicate[]{builder.equal((Expression)from.get("myTagType"), (Object)theTagType), builder.equal((Expression)from.get("mySystem"), (Object)theScheme), builder.equal((Expression)from.get("myCode"), (Object)theTerm)}));
        } else {
            cq.where((Expression)builder.and(new Predicate[]{builder.equal((Expression)from.get("myTagType"), (Object)theTagType), builder.isNull((Expression)from.get("mySystem")), builder.equal((Expression)from.get("myCode"), (Object)theTerm)}));
        }
        final TypedQuery q = this.myEntityManager.createQuery(cq);
        TransactionTemplate template = new TransactionTemplate(this.myTransactionManager);
        template.setPropagationBehavior(3);
        int count = 0;
        final HashSet throwables = new HashSet();
        do {
            try {
                retVal = (TagDefinition)template.execute((TransactionCallback)new TransactionCallback<TagDefinition>(){

                    private TagDefinition readOrCreate() {
                        TagDefinition val;
                        try {
                            val = (TagDefinition)q.getSingleResult();
                        }
                        catch (NoResultException e) {
                            val = new TagDefinition(theTagType, theScheme, theTerm, theLabel);
                            BaseHapiFhirDao.this.myEntityManager.persist((Object)val);
                        }
                        return val;
                    }

                    public TagDefinition doInTransaction(TransactionStatus status) {
                        TagDefinition tag = null;
                        try {
                            tag = this.readOrCreate();
                        }
                        catch (Exception ex) {
                            ourLog.warn("Tag read/write failed: " + ex.getMessage() + ". This is not a failure on its own, but could be useful information in the result of an actual failure.");
                            throwables.add(ex);
                        }
                        return tag;
                    }
                });
            }
            catch (Exception ex) {
                ourLog.warn("Transaction failed with: " + ex.getMessage() + ". Transaction will rollback and be reattempted.");
                retVal = null;
            }
        } while (retVal == null && ++count < 10);
        if (retVal == null) {
            String msg = throwables.stream().map(Throwable::getMessage).collect(Collectors.joining(", "));
            throw new InternalErrorException(Msg.code((int)2023) + "Tag get/create failed after 10 attempts with error(s): " + msg);
        }
        return retVal;
    }

    protected IBundleProvider history(RequestDetails theRequest, String theResourceType, Long theResourcePid, Date theRangeStartInclusive, Date theRangeEndInclusive, Integer theOffset) {
        String resourceName = (String)StringUtils.defaultIfBlank((CharSequence)theResourceType, null);
        Search search = new Search();
        search.setOffset(theOffset);
        search.setDeleted(false);
        search.setCreated(new Date());
        search.setLastUpdated(theRangeStartInclusive, theRangeEndInclusive);
        search.setUuid(UUID.randomUUID().toString());
        search.setResourceType(resourceName);
        search.setResourceId(theResourcePid);
        search.setSearchType(SearchTypeEnum.HISTORY);
        search.setStatus(SearchStatusEnum.FINISHED);
        return this.myPersistedJpaBundleProviderFactory.newInstance(theRequest, search);
    }

    void incrementId(T theResource, ResourceTable theSavedEntity, IIdType theResourceId) {
        long newVersionLong;
        String newVersion;
        if (theResourceId == null || theResourceId.getVersionIdPart() == null) {
            newVersion = "1";
            newVersionLong = 1L;
        } else {
            newVersionLong = theResourceId.getVersionIdPartAsLong() + 1L;
            newVersion = Long.toString(newVersionLong);
        }
        assert (theResourceId != null);
        IIdType newId = theResourceId.withVersion(newVersion);
        theResource.getIdElement().setValue(newId.getValue());
        theSavedEntity.setVersion(newVersionLong);
    }

    public boolean isLogicalReference(IIdType theId) {
        return LogicalReferenceHelper.isLogicalReference((ModelConfig)this.myConfig.getModelConfig(), (IIdType)theId);
    }

    protected EncodedResource populateResourceIntoEntity(TransactionDetails theTransactionDetails, RequestDetails theRequest, IBaseResource theResource, ResourceTable theEntity, boolean thePerformIndexing) {
        byte[] resourceBinary;
        String resourceText;
        ResourceEncodingEnum encoding;
        if (theEntity.getResourceType() == null) {
            theEntity.setResourceType(this.toResourceName(theResource));
        }
        boolean changed = false;
        if (theEntity.getDeleted() == null) {
            if (thePerformIndexing) {
                HashCode hashCode;
                encoding = this.myConfig.getResourceEncoding();
                String resourceType = theEntity.getResourceType();
                ArrayList<String> excludeElements = new ArrayList<String>(8);
                IBaseMetaType meta = theResource.getMeta();
                IBaseExtension<?, ?> sourceExtension = this.getExcludedElements(resourceType, excludeElements, meta);
                theEntity.setFhirVersion(this.myContext.getVersion().getVersion());
                HashFunction sha256 = Hashing.sha256();
                String encodedResource = BaseHapiFhirDao.encodeResource(theResource, encoding, excludeElements, this.myContext);
                if (this.getConfig().getInlineResourceTextBelowSize() > 0 && encodedResource.length() < this.getConfig().getInlineResourceTextBelowSize()) {
                    resourceText = encodedResource;
                    resourceBinary = null;
                    encoding = ResourceEncodingEnum.JSON;
                    hashCode = sha256.hashUnencodedChars((CharSequence)encodedResource);
                } else {
                    resourceText = null;
                    resourceBinary = this.getResourceBinary(encoding, encodedResource);
                    hashCode = sha256.hashBytes(resourceBinary);
                }
                String hashSha256 = hashCode.toString();
                if (!hashSha256.equals(theEntity.getHashSha256())) {
                    changed = true;
                }
                theEntity.setHashSha256(hashSha256);
                if (sourceExtension != null) {
                    IBaseExtension newSourceExtension = ((IBaseHasExtensions)meta).addExtension();
                    newSourceExtension.setUrl(sourceExtension.getUrl());
                    newSourceExtension.setValue(sourceExtension.getValue());
                }
            } else {
                encoding = null;
                resourceBinary = null;
                resourceText = null;
            }
            boolean skipUpdatingTags = this.myConfig.isMassIngestionMode() && theEntity.isHasTags();
            if (!(skipUpdatingTags |= this.myConfig.getTagStorageMode() == DaoConfig.TagStorageModeEnum.INLINE)) {
                changed |= this.updateTags(theTransactionDetails, theRequest, theResource, theEntity);
            }
        } else {
            theEntity.setHashSha256(null);
            resourceBinary = null;
            resourceText = null;
            encoding = ResourceEncodingEnum.DEL;
        }
        if (thePerformIndexing && !changed) {
            if (theEntity.getId() == null) {
                changed = true;
            } else if (!(this.myConfig.isMassIngestionMode() || theEntity.getVersion() == 1L && theEntity.getCurrentVersionEntity() == null)) {
                ResourceHistoryTable currentHistoryVersion = theEntity.getCurrentVersionEntity();
                if (currentHistoryVersion == null) {
                    currentHistoryVersion = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(theEntity.getId(), theEntity.getVersion());
                }
                changed = currentHistoryVersion == null || !currentHistoryVersion.hasResource() ? true : !Arrays.equals(currentHistoryVersion.getResource(), resourceBinary);
            }
        }
        EncodedResource retVal = new EncodedResource();
        retVal.setEncoding(encoding);
        retVal.setResourceBinary(resourceBinary);
        retVal.setResourceText(resourceText);
        retVal.setChanged(changed);
        return retVal;
    }

    @Nonnull
    private byte[] getResourceBinary(ResourceEncodingEnum encoding, String encodedResource) {
        byte[] resourceBinary;
        switch (encoding) {
            case JSON: {
                resourceBinary = encodedResource.getBytes(Charsets.UTF_8);
                break;
            }
            case JSONC: {
                resourceBinary = GZipUtil.compress((String)encodedResource);
                break;
            }
            default: {
                resourceBinary = new byte[]{};
            }
        }
        return resourceBinary;
    }

    private IBaseExtension<?, ?> getExcludedElements(String theResourceType, List<String> theExcludeElements, IBaseMetaType theMeta) {
        boolean inlineTagMode;
        List extensions;
        boolean hasExtensions = false;
        IBaseExtension sourceExtension = null;
        if (theMeta instanceof IBaseHasExtensions && !(extensions = ((IBaseHasExtensions)theMeta).getExtension()).isEmpty()) {
            hasExtensions = true;
            if (this.myFhirContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3)) {
                for (int i = 0; i < extensions.size(); ++i) {
                    if (!((IBaseExtension)extensions.get(i)).getUrl().equals("http://hapifhir.io/fhir/StructureDefinition/resource-meta-source")) continue;
                    sourceExtension = (IBaseExtension)extensions.remove(i);
                    --i;
                }
            }
        }
        theExcludeElements.add("id");
        boolean bl = inlineTagMode = this.getConfig().getTagStorageMode() == DaoConfig.TagStorageModeEnum.INLINE;
        if (hasExtensions || inlineTagMode) {
            if (!inlineTagMode) {
                theExcludeElements.add(theResourceType + ".meta.profile");
                theExcludeElements.add(theResourceType + ".meta.tag");
                theExcludeElements.add(theResourceType + ".meta.security");
            }
            theExcludeElements.add(theResourceType + ".meta.versionId");
            theExcludeElements.add(theResourceType + ".meta.lastUpdated");
            theExcludeElements.add(theResourceType + ".meta.source");
        } else {
            theExcludeElements.add(theResourceType + ".meta");
        }
        return sourceExtension;
    }

    private boolean updateTags(TransactionDetails theTransactionDetails, RequestDetails theRequest, IBaseResource theResource, ResourceTable theEntity) {
        String profile;
        HashSet<ResourceTag> allDefs = new HashSet<ResourceTag>();
        Set<ResourceTag> allTagsOld = this.getAllTagDefinitions(theEntity);
        if (theResource instanceof IResource) {
            this.extractTagsHapi(theTransactionDetails, (IResource)theResource, theEntity, allDefs);
        } else {
            this.extractTagsRi(theTransactionDetails, (IAnyResource)theResource, theEntity, allDefs);
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        if (!def.isStandardType() && StringUtils.isNotBlank((CharSequence)(profile = def.getResourceProfile("")))) {
            TagDefinition profileDef = this.getTagOrNull(theTransactionDetails, TagTypeEnum.PROFILE, NS_JPA_PROFILE, profile, null);
            ResourceTag tag2 = theEntity.addTag(profileDef);
            allDefs.add(tag2);
            theEntity.setHasTags(true);
        }
        Set<ResourceTag> allTagsNew = this.getAllTagDefinitions(theEntity);
        HashSet allDefsPresent = new HashSet();
        allTagsNew.forEach(tag -> {
            if (!allDefsPresent.add(tag.getTag())) {
                theEntity.getTags().remove(tag);
            }
            if (!allDefs.contains(tag) && this.shouldDroppedTagBeRemovedOnUpdate(theRequest, (ResourceTag)tag)) {
                theEntity.getTags().remove(tag);
            }
        });
        theEntity.setHasTags(!allTagsNew.isEmpty());
        return !allTagsOld.equals(allTagsNew);
    }

    private <R extends IBaseResource> R populateResourceMetadataHapi(Class<R> theResourceType, IBaseResourceEntity theEntity, @Nullable Collection<? extends BaseTag> theTagList, boolean theForHistoryOperation, IResource res, Long theVersion) {
        IResource retVal = res;
        if (theEntity.getDeleted() != null) {
            retVal = res = (IResource)this.myContext.getResourceDefinition(theResourceType).newInstance();
            ResourceMetadataKeyEnum.DELETED_AT.put(res, (Object)new InstantDt(theEntity.getDeleted()));
            if (theForHistoryOperation) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(res, (Object)BundleEntryTransactionMethodEnum.DELETE);
            }
        } else if (theForHistoryOperation) {
            Date updated;
            Date published = (Date)theEntity.getPublished().getValue();
            if (published.equals(updated = (Date)theEntity.getUpdated().getValue())) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(res, (Object)BundleEntryTransactionMethodEnum.POST);
            } else {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(res, (Object)BundleEntryTransactionMethodEnum.PUT);
            }
        }
        res.setId(theEntity.getIdDt().withVersion(theVersion.toString()));
        ResourceMetadataKeyEnum.VERSION.put(res, (Object)Long.toString(theEntity.getVersion()));
        ResourceMetadataKeyEnum.PUBLISHED.put(res, (Object)theEntity.getPublished());
        ResourceMetadataKeyEnum.UPDATED.put(res, (Object)theEntity.getUpdated());
        IDao.RESOURCE_PID.put(res, theEntity.getResourceId());
        if (theTagList != null && theEntity.isHasTags()) {
            TagList tagList = new TagList();
            ArrayList<IBaseCoding> securityLabels = new ArrayList<IBaseCoding>();
            ArrayList<IdDt> profiles = new ArrayList<IdDt>();
            for (BaseTag baseTag : theTagList) {
                switch (baseTag.getTag().getTagType()) {
                    case PROFILE: {
                        profiles.add(new IdDt(baseTag.getTag().getCode()));
                        break;
                    }
                    case SECURITY_LABEL: {
                        IBaseCoding secLabel = (IBaseCoding)this.myContext.getVersion().newCodingDt();
                        secLabel.setSystem(baseTag.getTag().getSystem());
                        secLabel.setCode(baseTag.getTag().getCode());
                        secLabel.setDisplay(baseTag.getTag().getDisplay());
                        securityLabels.add(secLabel);
                        break;
                    }
                    case TAG: {
                        tagList.add(new Tag(baseTag.getTag().getSystem(), baseTag.getTag().getCode(), baseTag.getTag().getDisplay()));
                    }
                }
            }
            if (tagList.size() > 0) {
                ResourceMetadataKeyEnum.TAG_LIST.put(res, (Object)tagList);
            }
            if (securityLabels.size() > 0) {
                ResourceMetadataKeyEnum.SECURITY_LABELS.put(res, BaseHapiFhirDao.toBaseCodingList(securityLabels));
            }
            if (profiles.size() > 0) {
                ResourceMetadataKeyEnum.PROFILES.put(res, profiles);
            }
        }
        return (R)retVal;
    }

    private <R extends IBaseResource> R populateResourceMetadataRi(Class<R> theResourceType, IBaseResourceEntity theEntity, @Nullable Collection<? extends BaseTag> theTagList, boolean theForHistoryOperation, IAnyResource res, Long theVersion) {
        IAnyResource retVal = res;
        if (theEntity.getDeleted() != null) {
            retVal = res = (IAnyResource)this.myContext.getResourceDefinition(theResourceType).newInstance();
            ResourceMetadataKeyEnum.DELETED_AT.put(res, (Object)new InstantDt(theEntity.getDeleted()));
            if (theForHistoryOperation) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(res, (Object)Bundle.HTTPVerb.DELETE.toCode());
            }
        } else if (theForHistoryOperation) {
            Date date;
            Date published = (Date)theEntity.getPublished().getValue();
            if (published.equals(date = (Date)theEntity.getUpdated().getValue())) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(res, (Object)Bundle.HTTPVerb.POST.toCode());
            } else {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(res, (Object)Bundle.HTTPVerb.PUT.toCode());
            }
        }
        res.getMeta().setLastUpdated(null);
        res.getMeta().setVersionId(null);
        this.updateResourceMetadata(theEntity, (IBaseResource)res);
        res.setId(res.getIdElement().withVersion(theVersion.toString()));
        res.getMeta().setLastUpdated(theEntity.getUpdatedDate());
        IDao.RESOURCE_PID.put(res, theEntity.getResourceId());
        if (theTagList != null) {
            res.getMeta().getTag().clear();
            res.getMeta().getProfile().clear();
            res.getMeta().getSecurity().clear();
            for (BaseTag baseTag : theTagList) {
                switch (baseTag.getTag().getTagType()) {
                    case PROFILE: {
                        res.getMeta().addProfile(baseTag.getTag().getCode());
                        break;
                    }
                    case SECURITY_LABEL: {
                        IBaseCoding sec = res.getMeta().addSecurity();
                        sec.setSystem(baseTag.getTag().getSystem());
                        sec.setCode(baseTag.getTag().getCode());
                        sec.setDisplay(baseTag.getTag().getDisplay());
                        break;
                    }
                    case TAG: {
                        IBaseCoding tag = res.getMeta().addTag();
                        tag.setSystem(baseTag.getTag().getSystem());
                        tag.setCode(baseTag.getTag().getCode());
                        tag.setDisplay(baseTag.getTag().getDisplay());
                    }
                }
            }
        }
        return (R)retVal;
    }

    protected void postDelete(ResourceTable theEntity) {
    }

    protected void postPersist(ResourceTable theEntity, T theResource, RequestDetails theRequestDetails) {
    }

    protected void postUpdate(ResourceTable theEntity, T theResource, RequestDetails theRequestDetails) {
    }

    @CoverageIgnore
    public BaseHasResource readEntity(IIdType theValueId, RequestDetails theRequest) {
        throw new NotImplementedException(Msg.code((int)927));
    }

    protected boolean shouldDroppedTagBeRemovedOnUpdate(RequestDetails theRequest, ResourceTag theTag) {
        List metaSnapshotMode;
        Set<TagTypeEnum> metaSnapshotModeTokens = null;
        if (theRequest != null && (metaSnapshotMode = theRequest.getHeaders("X-Meta-Snapshot-Mode")) != null && !metaSnapshotMode.isEmpty()) {
            metaSnapshotModeTokens = new HashSet<TagTypeEnum>();
            for (String nextHeaderValue : metaSnapshotMode) {
                StringTokenizer tok = new StringTokenizer(nextHeaderValue, ",");
                while (tok.hasMoreTokens()) {
                    switch (StringUtils.trim((String)tok.nextToken())) {
                        case "TAG": {
                            metaSnapshotModeTokens.add(TagTypeEnum.TAG);
                            break;
                        }
                        case "PROFILE": {
                            metaSnapshotModeTokens.add(TagTypeEnum.PROFILE);
                            break;
                        }
                        case "SECURITY_LABEL": {
                            metaSnapshotModeTokens.add(TagTypeEnum.SECURITY_LABEL);
                        }
                    }
                }
            }
        }
        if (metaSnapshotModeTokens == null) {
            metaSnapshotModeTokens = Collections.singleton(TagTypeEnum.PROFILE);
        }
        return metaSnapshotModeTokens.contains(theTag.getTag().getTagType());
    }

    public IBaseResource toResource(BaseHasResource theEntity, boolean theForHistoryOperation) {
        RuntimeResourceDefinition type = this.myContext.getResourceDefinition(theEntity.getResourceType());
        Class resourceType = type.getImplementingClass();
        return this.toResource(resourceType, (IBaseResourceEntity)theEntity, null, theForHistoryOperation);
    }

    public <R extends IBaseResource> R toResource(Class<R> theResourceType, IBaseResourceEntity theEntity, Collection<ResourceTag> theTagList, boolean theForHistoryOperation) {
        Object retVal;
        long version;
        ResourceEncodingEnum resourceEncoding;
        String resourceText;
        byte[] resourceBytes;
        Collection<Object> tagList = Collections.emptyList();
        String provenanceSourceUri = null;
        String provenanceRequestId = null;
        if (theEntity instanceof ResourceHistoryTable) {
            ResourceHistoryTable history = (ResourceHistoryTable)theEntity;
            resourceBytes = history.getResource();
            resourceText = history.getResourceTextVc();
            resourceEncoding = history.getEncoding();
            switch (this.getConfig().getTagStorageMode()) {
                default: {
                    if (!history.isHasTags()) break;
                    tagList = history.getTags();
                    break;
                }
                case NON_VERSIONED: {
                    if (!history.getResourceTable().isHasTags()) break;
                    tagList = history.getResourceTable().getTags();
                    break;
                }
                case INLINE: {
                    tagList = null;
                }
            }
            version = history.getVersion();
            if (history.getProvenance() != null) {
                provenanceRequestId = history.getProvenance().getRequestId();
                provenanceSourceUri = history.getProvenance().getSourceUri();
            }
        } else if (theEntity instanceof ResourceTable) {
            ResourceHistoryTable history;
            ResourceTable resource = (ResourceTable)theEntity;
            if (resource.getCurrentVersionEntity() != null) {
                history = resource.getCurrentVersionEntity();
            } else {
                version = theEntity.getVersion();
                history = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(theEntity.getId(), version);
                ((ResourceTable)theEntity).setCurrentVersionEntity(history);
                while (history == null) {
                    if (version > 1L) {
                        history = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(theEntity.getId(), --version);
                        continue;
                    }
                    return null;
                }
            }
            resourceBytes = history.getResource();
            resourceEncoding = history.getEncoding();
            resourceText = history.getResourceTextVc();
            switch (this.getConfig().getTagStorageMode()) {
                case VERSIONED: 
                case NON_VERSIONED: {
                    if (resource.isHasTags()) {
                        tagList = resource.getTags();
                        break;
                    }
                    tagList = Collections.emptyList();
                    break;
                }
                case INLINE: {
                    tagList = null;
                }
            }
            version = history.getVersion();
            if (history.getProvenance() != null) {
                provenanceRequestId = history.getProvenance().getRequestId();
                provenanceSourceUri = history.getProvenance().getSourceUri();
            }
        } else if (theEntity instanceof ResourceSearchView) {
            ResourceSearchView view = (ResourceSearchView)theEntity;
            resourceBytes = view.getResource();
            resourceText = view.getResourceTextVc();
            resourceEncoding = view.getEncoding();
            version = view.getVersion();
            provenanceRequestId = view.getProvenanceRequestId();
            provenanceSourceUri = view.getProvenanceSourceUri();
            switch (this.getConfig().getTagStorageMode()) {
                case VERSIONED: 
                case NON_VERSIONED: {
                    if (theTagList != null) {
                        tagList = theTagList;
                        break;
                    }
                    tagList = Collections.emptyList();
                    break;
                }
                case INLINE: {
                    tagList = null;
                }
            }
        } else {
            return null;
        }
        String decodedResourceText = resourceText != null ? resourceText : BaseHapiFhirDao.decodeResource(resourceBytes, resourceEncoding);
        Class resourceType = theResourceType;
        if (tagList != null && this.myContext.hasDefaultTypeForProfile()) {
            for (BaseTag baseTag : tagList) {
                Class newType;
                String profile;
                if (baseTag.getTag().getTagType() != TagTypeEnum.PROFILE || !StringUtils.isNotBlank((CharSequence)(profile = baseTag.getTag().getCode())) || (newType = this.myContext.getDefaultTypeForProfile(profile)) == null || !theResourceType.isAssignableFrom(newType)) continue;
                ourLog.debug("Using custom type {} for profile: {}", (Object)newType.getName(), (Object)profile);
                resourceType = newType;
                break;
            }
        }
        if (resourceEncoding != ResourceEncodingEnum.DEL) {
            LenientErrorHandler lenientErrorHandler = new LenientErrorHandler(false).setErrorOnInvalidValue(false);
            TolerantJsonParser parser = new TolerantJsonParser(this.getContext(theEntity.getFhirVersion()), (IParserErrorHandler)lenientErrorHandler, theEntity.getId());
            try {
                retVal = parser.parseResource(resourceType, decodedResourceText);
            }
            catch (Exception e) {
                StringBuilder b = new StringBuilder();
                b.append("Failed to parse database resource[");
                b.append(this.myFhirContext.getResourceType(resourceType));
                b.append("/");
                b.append(theEntity.getIdDt().getIdPart());
                b.append(" (pid ");
                b.append(theEntity.getId());
                b.append(", version ");
                b.append(theEntity.getFhirVersion().name());
                b.append("): ");
                b.append(e.getMessage());
                String msg = b.toString();
                ourLog.error(msg, (Throwable)e);
                throw new DataFormatException(Msg.code((int)928) + msg, (Throwable)e);
            }
        } else {
            retVal = (IBaseResource)this.myContext.getResourceDefinition(theEntity.getResourceType()).newInstance();
        }
        if (retVal instanceof IResource) {
            IResource iResource = (IResource)retVal;
            retVal = this.populateResourceMetadataHapi(resourceType, theEntity, tagList, theForHistoryOperation, iResource, version);
        } else {
            IAnyResource iAnyResource = (IAnyResource)retVal;
            retVal = this.populateResourceMetadataRi(resourceType, theEntity, tagList, theForHistoryOperation, iAnyResource, version);
        }
        if (StringUtils.isNotBlank((CharSequence)provenanceRequestId) || StringUtils.isNotBlank((CharSequence)provenanceSourceUri)) {
            String string = BaseHapiFhirDao.cleanProvenanceSourceUri(provenanceSourceUri) + (StringUtils.isNotBlank((CharSequence)provenanceRequestId) ? "#" : "") + StringUtils.defaultString((String)provenanceRequestId);
            MetaUtil.setSource((FhirContext)this.myContext, (IBaseResource)retVal, (String)string);
        }
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            PartitionablePartitionId partitionablePartitionId = theEntity.getPartitionId();
            if (partitionablePartitionId != null && partitionablePartitionId.getPartitionId() != null) {
                PartitionEntity persistedPartition = this.myPartitionLookupSvc.getPartitionById(partitionablePartitionId.getPartitionId());
                retVal.setUserData(Constants.RESOURCE_PARTITION_ID, (Object)persistedPartition.toRequestPartitionId());
            } else {
                retVal.setUserData(Constants.RESOURCE_PARTITION_ID, null);
            }
        }
        return (R)retVal;
    }

    public String toResourceName(Class<? extends IBaseResource> theResourceType) {
        return this.myContext.getResourceType(theResourceType);
    }

    String toResourceName(IBaseResource theResource) {
        return this.myContext.getResourceType(theResource);
    }

    protected ResourceTable updateEntityForDelete(RequestDetails theRequest, TransactionDetails theTransactionDetails, ResourceTable entity) {
        Date updateTime = new Date();
        return this.updateEntity(theRequest, null, (IBasePersistedResource)entity, updateTime, true, true, theTransactionDetails, false, true);
    }

    @VisibleForTesting
    public void setEntityManager(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
    }

    @VisibleForTesting
    public void setSearchParamWithInlineReferencesExtractor(SearchParamWithInlineReferencesExtractor theSearchParamWithInlineReferencesExtractor) {
        this.mySearchParamWithInlineReferencesExtractor = theSearchParamWithInlineReferencesExtractor;
    }

    @VisibleForTesting
    public void setResourceHistoryTableDao(IResourceHistoryTableDao theResourceHistoryTableDao) {
        this.myResourceHistoryTableDao = theResourceHistoryTableDao;
    }

    @VisibleForTesting
    public void setDaoSearchParamSynchronizer(DaoSearchParamSynchronizer theDaoSearchParamSynchronizer) {
        this.myDaoSearchParamSynchronizer = theDaoSearchParamSynchronizer;
    }

    private void verifyMatchUrlForConditionalCreate(IBaseResource theResource, String theIfNoneExist, ResourceTable entity, ResourceIndexedSearchParams theParams) {
        InMemoryMatchResult outcome = this.myInMemoryResourceMatcher.match(theIfNoneExist, theResource, theParams);
        if (outcome.supported() && !outcome.matched()) {
            throw new InvalidRequestException(Msg.code((int)929) + "Failed to process conditional create. The supplied resource did not satisfy the conditional URL.");
        }
    }

    public ResourceTable updateEntity(RequestDetails theRequest, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        Map<String, Boolean> searchParamPresenceMap;
        AddRemoveCount presenceCount;
        EncodedResource changed;
        Validate.notNull((Object)theEntity);
        Validate.isTrue((theDeletedTimestampOrNull != null || theResource != null ? 1 : 0) != 0, (String)"Must have either a resource[%s] or a deleted timestamp[%s] for resource PID[%s]", (Object[])new Object[]{theDeletedTimestampOrNull != null, theResource != null, theEntity.getPersistentId()});
        ourLog.debug("Starting entity update");
        ResourceTable entity = (ResourceTable)theEntity;
        if (theResource != null) {
            if (thePerformIndexing && !ourValidationDisabledForUnitTest) {
                this.validateResourceForStorage(theResource, entity);
            }
            if (!StringUtils.isBlank((CharSequence)entity.getResourceType())) {
                this.validateIncomingResourceTypeMatchesExisting(theResource, (BaseHasResource)entity);
            }
        }
        if (entity.getPublished() == null) {
            ourLog.debug("Entity has published time: {}", (Object)theTransactionDetails.getTransactionDate());
            entity.setPublished(theTransactionDetails.getTransactionDate());
        }
        ResourceIndexedSearchParams existingParams = null;
        ResourceIndexedSearchParams newParams = null;
        if (theDeletedTimestampOrNull != null) {
            entity.setDeleted(theDeletedTimestampOrNull);
            entity.setUpdated(theDeletedTimestampOrNull);
            entity.setNarrativeText(null);
            entity.setContentText(null);
            entity.setHashSha256(null);
            entity.setIndexStatus(Long.valueOf(1L));
            changed = this.populateResourceIntoEntity(theTransactionDetails, theRequest, theResource, entity, true);
        } else {
            IdentityHashMap existingSearchParams = (IdentityHashMap)theTransactionDetails.getOrCreateUserData(HapiTransactionService.XACT_USERDATA_KEY_EXISTING_SEARCH_PARAMS, () -> new IdentityHashMap());
            existingParams = (ResourceIndexedSearchParams)existingSearchParams.get(entity);
            if (existingParams == null) {
                existingParams = new ResourceIndexedSearchParams(entity);
                existingSearchParams.put(entity, existingParams);
            }
            entity.setDeleted(null);
            if (thePerformIndexing || ((ResourceTable)theEntity).getVersion() == 1L) {
                newParams = new ResourceIndexedSearchParams();
                RequestPartitionId requestPartitionId = !this.myPartitionSettings.isPartitioningEnabled() ? RequestPartitionId.allPartitions() : (entity.getPartitionId() != null ? entity.getPartitionId().toPartitionId() : RequestPartitionId.defaultPartition());
                this.failIfPartitionMismatch(theRequest, entity);
                this.mySearchParamWithInlineReferencesExtractor.populateFromResource(requestPartitionId, newParams, theTransactionDetails, entity, theResource, existingParams, theRequest, thePerformIndexing);
                changed = this.populateResourceIntoEntity(theTransactionDetails, theRequest, theResource, entity, true);
                if (theForceUpdate) {
                    changed.setChanged(true);
                }
                if (changed.isChanged()) {
                    if (entity.getVersion() <= 1L && entity.getCreatedByMatchUrl() != null && thePerformIndexing) {
                        this.verifyMatchUrlForConditionalCreate(theResource, entity.getCreatedByMatchUrl(), entity, newParams);
                    }
                    entity.setUpdated(theTransactionDetails.getTransactionDate());
                    newParams.populateResourceTableSearchParamsPresentFlags(entity);
                    entity.setIndexStatus(Long.valueOf(1L));
                }
                if (this.myFulltextSearchSvc != null && !this.myFulltextSearchSvc.isDisabled()) {
                    this.populateFullTextFields(this.myContext, theResource, entity, newParams);
                }
            } else {
                changed = this.populateResourceIntoEntity(theTransactionDetails, theRequest, theResource, entity, false);
                entity.setUpdated(theTransactionDetails.getTransactionDate());
                entity.setIndexStatus(null);
            }
        }
        if (thePerformIndexing && changed != null && !changed.isChanged() && !theForceUpdate && this.myConfig.isSuppressUpdatesWithNoChange() && (entity.getVersion() > 1L || theUpdateVersion)) {
            ourLog.debug("Resource {} has not changed", (Object)entity.getIdDt().toUnqualified().getValue());
            if (theResource != null) {
                this.updateResourceMetadata((IBaseResourceEntity)entity, theResource);
            }
            entity.setUnchangedInCurrentOperation(true);
            return entity;
        }
        if (theUpdateVersion) {
            long newVersion = entity.getVersion() + 1L;
            entity.setVersion(newVersion);
        }
        if (entity.getId() == null) {
            this.myEntityManager.persist((Object)entity);
            if (entity.getForcedId() != null) {
                this.myEntityManager.persist((Object)entity.getForcedId());
            }
            this.postPersist(entity, theResource, theRequest);
        } else if (entity.getDeleted() != null) {
            entity = (ResourceTable)this.myEntityManager.merge((Object)entity);
            this.postDelete(entity);
        } else {
            entity = (ResourceTable)this.myEntityManager.merge((Object)entity);
            this.postUpdate(entity, theResource, theRequest);
        }
        if (theCreateNewHistoryEntry) {
            this.createHistoryEntry(theRequest, theResource, entity, changed);
        }
        if (thePerformIndexing && newParams != null && !(presenceCount = this.mySearchParamPresenceSvc.updatePresence(entity, searchParamPresenceMap = this.getSearchParamPresenceMap(entity, newParams))).isEmpty() && CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_INFO, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
            StorageProcessingMessage message = new StorageProcessingMessage();
            message.setMessage("For " + entity.getIdDt().toUnqualifiedVersionless().getValue() + " added " + presenceCount.getAddCount() + " and removed " + presenceCount.getRemoveCount() + " resource search parameter presence entries");
            HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)message);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
        }
        if (thePerformIndexing) {
            if (newParams == null) {
                this.myExpungeService.deleteAllSearchParams(new ResourcePersistentId((Object)entity.getId()));
            } else {
                AddRemoveCount searchParamAddRemoveCount = this.myDaoSearchParamSynchronizer.synchronizeSearchParamsToDatabase(newParams, entity, existingParams);
                newParams.populateResourceTableParamCollections(entity);
                if (!searchParamAddRemoveCount.isEmpty() && CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_INFO, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
                    StorageProcessingMessage message = new StorageProcessingMessage();
                    message.setMessage("For " + entity.getIdDt().toUnqualifiedVersionless().getValue() + " added " + searchParamAddRemoveCount.getAddCount() + " and removed " + searchParamAddRemoveCount.getRemoveCount() + " resource search parameter index entries");
                    HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)message);
                    CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
                }
                this.mySearchParamWithInlineReferencesExtractor.storeUniqueComboParameters(newParams, entity, existingParams);
            }
        }
        if (theResource != null) {
            this.updateResourceMetadata((IBaseResourceEntity)entity, theResource);
        }
        return entity;
    }

    public IBasePersistedResource updateHistoryEntity(RequestDetails theRequest, T theResource, IBasePersistedResource theEntity, IBasePersistedResource theHistoryEntity, IIdType theResourceId, TransactionDetails theTransactionDetails, boolean isUpdatingCurrent) {
        ResourceHistoryTable historyEntity;
        Validate.notNull((Object)theEntity);
        Validate.isTrue((theResource != null ? 1 : 0) != 0, (String)"Must have either a resource[%s] for resource PID[%s]", (Object[])new Object[]{theResource != null, theEntity.getPersistentId()});
        ourLog.debug("Starting history entity update");
        EncodedResource encodedResource = new EncodedResource();
        if (isUpdatingCurrent) {
            ResourceTable entity = (ResourceTable)theEntity;
            IBaseResource oldResource = this.getConfig().isMassIngestionMode() ? null : this.toResource((BaseHasResource)entity, false);
            if (theRequest.getServer() != null) {
                IServerInterceptor.ActionRequestDetails actionRequestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, theResource, theResourceId.getResourceType(), theResourceId);
            }
            this.notifyInterceptors(theRequest, theResource, oldResource, theTransactionDetails, true);
            ResourceTable savedEntity = this.updateEntity(theRequest, (IBaseResource)theResource, (IBasePersistedResource)entity, null, true, false, theTransactionDetails, false, false);
            encodedResource = this.populateResourceIntoEntity(theTransactionDetails, theRequest, (IBaseResource)theResource, entity, true);
            historyEntity = ((ResourceTable)this.readEntity(theResourceId, theRequest)).getCurrentVersionEntity();
            this.updateResourceMetadata((IBaseResourceEntity)savedEntity, (IBaseResource)theResource);
            this.addPidToResource((IBasePersistedResource)savedEntity, (IBaseResource)theResource);
            if (!savedEntity.isUnchangedInCurrentOperation()) {
                this.notifyInterceptors(theRequest, theResource, oldResource, theTransactionDetails, false);
            }
        } else {
            historyEntity = (ResourceHistoryTable)theHistoryEntity;
            if (!StringUtils.isBlank((CharSequence)historyEntity.getResourceType())) {
                this.validateIncomingResourceTypeMatchesExisting((IBaseResource)theResource, (BaseHasResource)historyEntity);
            }
            historyEntity.setDeleted(null);
            ResourceEncodingEnum encoding = this.myConfig.getResourceEncoding();
            ArrayList<String> excludeElements = new ArrayList<String>(8);
            this.getExcludedElements(historyEntity.getResourceType(), excludeElements, theResource.getMeta());
            String encodedResourceString = BaseHapiFhirDao.encodeResource(theResource, encoding, excludeElements, this.myContext);
            byte[] resourceBinary = this.getResourceBinary(encoding, encodedResourceString);
            boolean changed = !Arrays.equals(historyEntity.getResource(), resourceBinary);
            historyEntity.setUpdated(theTransactionDetails.getTransactionDate());
            if (!changed && this.myConfig.isSuppressUpdatesWithNoChange() && historyEntity.getVersion() > 1L) {
                ourLog.debug("Resource {} has not changed", (Object)historyEntity.getIdDt().toUnqualified().getValue());
                this.updateResourceMetadata((IBaseResourceEntity)historyEntity, (IBaseResource)theResource);
                return historyEntity;
            }
            if (this.getConfig().getInlineResourceTextBelowSize() > 0 && encodedResourceString.length() < this.getConfig().getInlineResourceTextBelowSize()) {
                this.populateEncodedResource(encodedResource, encodedResourceString, null, ResourceEncodingEnum.JSON);
            } else {
                this.populateEncodedResource(encodedResource, null, resourceBinary, encoding);
            }
        }
        historyEntity = (ResourceHistoryTable)this.myEntityManager.merge((Object)historyEntity);
        historyEntity.setEncoding(encodedResource.getEncoding());
        historyEntity.setResource(encodedResource.getResourceBinary());
        historyEntity.setResourceTextVc(encodedResource.getResourceText());
        this.myResourceHistoryTableDao.save(historyEntity);
        this.updateResourceMetadata((IBaseResourceEntity)historyEntity, (IBaseResource)theResource);
        return historyEntity;
    }

    private void populateEncodedResource(EncodedResource encodedResource, String encodedResourceString, byte[] theResourceBinary, ResourceEncodingEnum theEncoding) {
        encodedResource.setResourceText(encodedResourceString);
        encodedResource.setResourceBinary(theResourceBinary);
        encodedResource.setEncoding(theEncoding);
    }

    @Nonnull
    private Map<String, Boolean> getSearchParamPresenceMap(ResourceTable entity, ResourceIndexedSearchParams newParams) {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        for (String nextKey : newParams.getPopulatedResourceLinkParameters()) {
            retval.put(nextKey, Boolean.TRUE);
        }
        ResourceSearchParams activeSearchParams = this.mySearchParamRegistry.getActiveSearchParams(entity.getResourceType());
        activeSearchParams.getReferenceSearchParamNames().forEach(key -> {
            if (!retval.containsKey(key)) {
                retval.put((String)key, Boolean.FALSE);
            }
        });
        return retval;
    }

    private void failIfPartitionMismatch(RequestDetails theRequest, ResourceTable entity) {
        PartitionEntity partitionEntity;
        if (this.myPartitionSettings.isPartitioningEnabled() && theRequest != null && theRequest.getTenantId() != null && entity.getPartitionId() != null && theRequest.getTenantId() != "ALL_PARTITIONS" && (partitionEntity = this.myPartitionLookupSvc.getPartitionByName(theRequest.getTenantId())) != null && !partitionEntity.getId().equals(entity.getPartitionId().getPartitionId())) {
            throw new InvalidRequestException(Msg.code((int)2079) + "Resource " + entity.getResourceType() + "/" + entity.getId() + " is not known");
        }
    }

    private void createHistoryEntry(RequestDetails theRequest, IBaseResource theResource, ResourceTable theEntity, EncodedResource theChanged) {
        boolean haveRequestId;
        String requestId;
        boolean versionedTags = this.getConfig().getTagStorageMode() == DaoConfig.TagStorageModeEnum.VERSIONED;
        ResourceHistoryTable historyEntry = theEntity.toHistory(versionedTags);
        historyEntry.setEncoding(theChanged.getEncoding());
        historyEntry.setResource(theChanged.getResourceBinary());
        historyEntry.setResourceTextVc(theChanged.getResourceText());
        ourLog.debug("Saving history entry {}", (Object)historyEntry.getIdDt());
        this.myResourceHistoryTableDao.save(historyEntry);
        theEntity.setCurrentVersionEntity(historyEntry);
        String source = null;
        String string = requestId = theRequest != null ? theRequest.getRequestId() : null;
        if (theResource != null) {
            if (this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
                IBaseMetaType meta = theResource.getMeta();
                source = MetaUtil.getSource((FhirContext)this.myContext, (IBaseMetaType)meta);
            }
            if (this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3)) {
                source = ((IBaseHasExtensions)theResource.getMeta()).getExtension().stream().filter(t -> "http://hapifhir.io/fhir/StructureDefinition/resource-meta-source".equals(t.getUrl())).filter(t -> t.getValue() instanceof IPrimitiveType).map(t -> ((IPrimitiveType)t.getValue()).getValueAsString()).findFirst().orElse(null);
            }
        }
        boolean haveSource = StringUtils.isNotBlank(source) && this.myConfig.getStoreMetaSourceInformation().isStoreSourceUri();
        boolean bl = haveRequestId = StringUtils.isNotBlank((CharSequence)requestId) && this.myConfig.getStoreMetaSourceInformation().isStoreRequestId();
        if (haveSource || haveRequestId) {
            ResourceHistoryProvenanceEntity provenance = new ResourceHistoryProvenanceEntity();
            provenance.setResourceHistoryTable(historyEntry);
            provenance.setResourceTable(theEntity);
            provenance.setPartitionId(theEntity.getPartitionId());
            if (haveRequestId) {
                provenance.setRequestId(StringUtils.left((String)requestId, (int)16));
            }
            if (haveSource) {
                provenance.setSourceUri(source);
            }
            this.myEntityManager.persist((Object)provenance);
        }
    }

    private void validateIncomingResourceTypeMatchesExisting(IBaseResource theResource, BaseHasResource entity) {
        String resourceType = this.myContext.getResourceType(theResource);
        if (!resourceType.equals(entity.getResourceType())) {
            throw new UnprocessableEntityException(Msg.code((int)930) + "Existing resource ID[" + entity.getIdDt().toUnqualifiedVersionless() + "] is of type[" + entity.getResourceType() + "] - Cannot update with [" + resourceType + "]");
        }
    }

    public ResourceTable updateInternal(RequestDetails theRequestDetails, T theResource, boolean thePerformIndexing, boolean theForceUpdateVersion, IBasePersistedResource theEntity, IIdType theResourceId, IBaseResource theOldResource, TransactionDetails theTransactionDetails) {
        ResourceTable entity = (ResourceTable)theEntity;
        theResource.setId((IIdType)entity.getIdDt());
        if (theRequestDetails != null && theRequestDetails.getServer() != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequestDetails, theResource, theResourceId.getResourceType(), theResourceId);
            this.notifyInterceptors(RestOperationTypeEnum.UPDATE, requestDetails);
        }
        this.notifyInterceptors(theRequestDetails, theResource, theOldResource, theTransactionDetails, true);
        ResourceTable savedEntity = this.updateEntity(theRequestDetails, (IBaseResource)theResource, (IBasePersistedResource)entity, null, thePerformIndexing, thePerformIndexing, theTransactionDetails, theForceUpdateVersion, thePerformIndexing);
        if (!(thePerformIndexing || savedEntity.isUnchangedInCurrentOperation() || ourDisableIncrementOnUpdateForUnitTest)) {
            if (!theResourceId.hasVersionIdPart()) {
                theResourceId = theResourceId.withVersion(Long.toString(savedEntity.getVersion()));
            }
            this.incrementId(theResource, savedEntity, theResourceId);
        }
        this.updateResourceMetadata((IBaseResourceEntity)savedEntity, (IBaseResource)theResource);
        this.addPidToResource((IBasePersistedResource)savedEntity, (IBaseResource)theResource);
        if (!savedEntity.isUnchangedInCurrentOperation()) {
            this.notifyInterceptors(theRequestDetails, theResource, theOldResource, theTransactionDetails, false);
        }
        return savedEntity;
    }

    private void notifyInterceptors(RequestDetails theRequestDetails, T theResource, IBaseResource theOldResource, TransactionDetails theTransactionDetails, boolean isUnchanged) {
        Pointcut interceptorPointcut = Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED;
        HookParams hookParams = new HookParams().add(IBaseResource.class, (Object)theOldResource).add(IBaseResource.class, theResource).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails);
        if (!isUnchanged) {
            hookParams.add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED));
            interceptorPointcut = Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED;
        }
        this.doCallHooks(theTransactionDetails, theRequestDetails, interceptorPointcut, hookParams);
    }

    protected void addPidToResource(IBasePersistedResource theEntity, IBaseResource theResource) {
        if (theResource instanceof IAnyResource) {
            IDao.RESOURCE_PID.put((IAnyResource)theResource, theEntity.getPersistentId().getIdAsLong());
        } else if (theResource instanceof IResource) {
            IDao.RESOURCE_PID.put((IResource)theResource, theEntity.getPersistentId().getIdAsLong());
        }
    }

    protected void updateResourceMetadata(IBaseResourceEntity theEntity, IBaseResource theResource) {
        IdDt id = theEntity.getIdDt();
        if (this.getContext().getVersion().getVersion().isRi()) {
            id = this.getContext().getVersion().newIdType().setValue(id.getValue());
        }
        if (!id.hasResourceType()) {
            id = id.withResourceType(theEntity.getResourceType());
        }
        theResource.setId((IIdType)id);
        if (theResource instanceof IResource) {
            ResourceMetadataKeyEnum.VERSION.put((IResource)theResource, (Object)id.getVersionIdPart());
            ResourceMetadataKeyEnum.UPDATED.put((IResource)theResource, (Object)theEntity.getUpdated());
        } else {
            IBaseMetaType meta = theResource.getMeta();
            meta.setVersionId(id.getVersionIdPart());
            meta.setLastUpdated(theEntity.getUpdatedDate());
        }
    }

    private void validateChildReferenceTargetTypes(IBase theElement, String thePath) {
        if (theElement == null) {
            return;
        }
        BaseRuntimeElementDefinition def = this.myContext.getElementDefinition(theElement.getClass());
        if (!(def instanceof BaseRuntimeElementCompositeDefinition)) {
            return;
        }
        BaseRuntimeElementCompositeDefinition cdef = (BaseRuntimeElementCompositeDefinition)def;
        for (BaseRuntimeChildDefinition nextChildDef : cdef.getChildren()) {
            List values = nextChildDef.getAccessor().getValues(theElement);
            if (values == null || values.isEmpty()) continue;
            String newPath = thePath + "." + nextChildDef.getElementName();
            for (IBase nextChild : values) {
                this.validateChildReferenceTargetTypes(nextChild, newPath);
            }
            if (!(nextChildDef instanceof RuntimeChildResourceDefinition)) continue;
            RuntimeChildResourceDefinition nextChildDefRes = (RuntimeChildResourceDefinition)nextChildDef;
            HashSet<String> validTypes = new HashSet<String>();
            boolean allowAny = false;
            for (Class nextValidType : nextChildDefRes.getResourceTypes()) {
                if (nextValidType.isInterface()) {
                    allowAny = true;
                    break;
                }
                validTypes.add(this.getContext().getResourceType(nextValidType));
            }
            if (allowAny || !this.getConfig().isEnforceReferenceTargetTypes()) continue;
            for (IBase nextChild : values) {
                IBaseReference nextRef = (IBaseReference)nextChild;
                IIdType referencedId = nextRef.getReferenceElement();
                if (StringUtils.isBlank((CharSequence)referencedId.getResourceType()) || this.isLogicalReference(referencedId) || referencedId.getValue().contains("?") || validTypes.contains(referencedId.getResourceType())) continue;
                throw new UnprocessableEntityException(Msg.code((int)931) + "Invalid reference found at path '" + newPath + "'. Resource type '" + referencedId.getResourceType() + "' is not valid for this path");
            }
        }
    }

    protected void validateMetaCount(int theMetaCount) {
        if (this.myConfig.getResourceMetaCountHardLimit() != null && theMetaCount > this.myConfig.getResourceMetaCountHardLimit()) {
            throw new UnprocessableEntityException(Msg.code((int)932) + "Resource contains " + theMetaCount + " meta entries (tag/profile/security label), maximum is " + this.myConfig.getResourceMetaCountHardLimit());
        }
    }

    protected void validateResourceForStorage(T theResource, ResourceTable theEntityToSave) {
        IResource res;
        IBaseCoding tag = null;
        int totalMetaCount = 0;
        if (theResource instanceof IResource) {
            List profileList;
            res = (IResource)theResource;
            TagList tagList = (TagList)ResourceMetadataKeyEnum.TAG_LIST.get(res);
            if (tagList != null) {
                tag = tagList.getTag("http://hl7.org/fhir/v3/ObservationValue", "SUBSETTED");
                totalMetaCount += tagList.size();
            }
            if ((profileList = (List)ResourceMetadataKeyEnum.PROFILES.get(res)) != null) {
                totalMetaCount += profileList.size();
            }
        } else {
            res = (IAnyResource)theResource;
            tag = res.getMeta().getTag("http://hl7.org/fhir/v3/ObservationValue", "SUBSETTED");
            totalMetaCount += res.getMeta().getTag().size();
            totalMetaCount += res.getMeta().getProfile().size();
            totalMetaCount += res.getMeta().getSecurity().size();
        }
        if (tag != null) {
            throw new UnprocessableEntityException(Msg.code((int)933) + "Resource contains the 'subsetted' tag, and must not be stored as it may contain a subset of available data");
        }
        if (this.getConfig().isEnforceReferenceTargetTypes()) {
            String resName = this.getContext().getResourceType(theResource);
            this.validateChildReferenceTargetTypes((IBase)theResource, resName);
        }
        this.validateMetaCount(totalMetaCount);
    }

    @PostConstruct
    public void start() {
    }

    @VisibleForTesting
    public void setDaoConfigForUnitTest(DaoConfig theDaoConfig) {
        this.myConfig = theDaoConfig;
    }

    public void populateFullTextFields(FhirContext theContext, IBaseResource theResource, ResourceTable theEntity, ResourceIndexedSearchParams theNewParams) {
        if (theEntity.getDeleted() != null) {
            theEntity.setNarrativeText(null);
            theEntity.setContentText(null);
        } else {
            theEntity.setNarrativeText(BaseHapiFhirDao.parseNarrativeTextIntoWords(theResource));
            theEntity.setContentText(BaseHapiFhirDao.parseContentTextIntoWords(theContext, theResource));
            if (this.myDaoConfig.isAdvancedHSearchIndexing()) {
                ExtendedHSearchIndexData hSearchIndexData = this.myFulltextSearchSvc.extractLuceneIndexData(theResource, theNewParams);
                theEntity.setLuceneIndexData(hSearchIndexData);
            }
        }
    }

    @VisibleForTesting
    public void setPartitionSettingsForUnitTest(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    @Nonnull
    public static MemoryCacheService.TagDefinitionCacheKey toTagDefinitionMemoryCacheKey(TagTypeEnum theTagType, String theScheme, String theTerm) {
        return new MemoryCacheService.TagDefinitionCacheKey(theTagType, theScheme, theTerm);
    }

    static String cleanProvenanceSourceUri(String theProvenanceSourceUri) {
        int hashIndex;
        if (StringUtils.isNotBlank((CharSequence)theProvenanceSourceUri) && (hashIndex = theProvenanceSourceUri.indexOf(35)) != -1) {
            theProvenanceSourceUri = theProvenanceSourceUri.substring(0, hashIndex);
        }
        return StringUtils.defaultString((String)theProvenanceSourceUri);
    }

    public static String parseContentTextIntoWords(FhirContext theContext, IBaseResource theResource) {
        Class stringType = theContext.getElementDefinition("string").getImplementingClass();
        StringBuilder retVal = new StringBuilder();
        List childElements = theContext.newTerser().getAllPopulatedChildElementsOfType(theResource, stringType);
        for (IPrimitiveType nextType : childElements) {
            String nextValue;
            if (!stringType.equals(nextType.getClass()) || !StringUtils.isNotBlank((CharSequence)(nextValue = nextType.getValueAsString()))) continue;
            retVal.append(nextValue.replace("\n", " ").replace("\r", " "));
            retVal.append("\n");
        }
        return retVal.toString();
    }

    public static String decodeResource(byte[] theResourceBytes, ResourceEncodingEnum theResourceEncoding) {
        String resourceText = null;
        switch (theResourceEncoding) {
            case JSON: {
                resourceText = new String(theResourceBytes, Charsets.UTF_8);
                break;
            }
            case JSONC: {
                resourceText = GZipUtil.decompress((byte[])theResourceBytes);
                break;
            }
        }
        return resourceText;
    }

    public static String encodeResource(IBaseResource theResource, ResourceEncodingEnum theEncoding, List<String> theExcludeElements, FhirContext theContext) {
        IParser parser = theEncoding.newParser(theContext);
        parser.setDontEncodeElements(theExcludeElements);
        return parser.encodeResourceToString(theResource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parseNarrativeTextIntoWords(IBaseResource theResource) {
        StringBuilder b = new StringBuilder();
        if (theResource instanceof IResource) {
            IResource resource = (IResource)theResource;
            List xmlEvents = XmlUtil.parse((String)resource.getText().getDiv().getValue());
            if (xmlEvents == null) return b.toString();
            for (XMLEvent next : xmlEvents) {
                if (!next.isCharacters()) continue;
                Characters characters = next.asCharacters();
                b.append(characters.getData()).append(" ");
            }
            return b.toString();
        } else {
            if (!(theResource instanceof IDomainResource)) return b.toString();
            IDomainResource resource = (IDomainResource)theResource;
            try {
                String divAsString = resource.getText().getDivAsString();
                List xmlEvents = XmlUtil.parse((String)divAsString);
                if (xmlEvents == null) return b.toString();
                for (XMLEvent next : xmlEvents) {
                    if (!next.isCharacters()) continue;
                    Characters characters = next.asCharacters();
                    b.append(characters.getData()).append(" ");
                }
                return b.toString();
            }
            catch (Exception e) {
                throw new DataFormatException(Msg.code((int)934) + "Unable to convert DIV to string", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public static void setDisableIncrementOnUpdateForUnitTest(boolean theDisableIncrementOnUpdateForUnitTest) {
        ourDisableIncrementOnUpdateForUnitTest = theDisableIncrementOnUpdateForUnitTest;
    }

    @VisibleForTesting
    public static void setValidationDisabledForUnitTest(boolean theValidationDisabledForUnitTest) {
        ourValidationDisabledForUnitTest = theValidationDisabledForUnitTest;
    }

    private static List<BaseCodingDt> toBaseCodingList(List<IBaseCoding> theSecurityLabels) {
        ArrayList<BaseCodingDt> retVal = new ArrayList<BaseCodingDt>(theSecurityLabels.size());
        for (IBaseCoding next : theSecurityLabels) {
            retVal.add((BaseCodingDt)next);
        }
        return retVal;
    }

    public static void validateResourceType(BaseHasResource theEntity, String theResourceName) {
        if (!theResourceName.equals(theEntity.getResourceType())) {
            throw new ResourceNotFoundException(Msg.code((int)935) + "Resource with ID " + theEntity.getIdDt().getIdPart() + " exists but it is not of type " + theResourceName + ", found resource of type " + theEntity.getResourceType());
        }
    }

    static {
        ourDisableIncrementOnUpdateForUnitTest = false;
    }

    private class AddTagDefinitionToCacheAfterCommitSynchronization
    implements TransactionSynchronization {
        private final TagDefinition myTagDefinition;
        private final MemoryCacheService.TagDefinitionCacheKey myKey;

        public AddTagDefinitionToCacheAfterCommitSynchronization(MemoryCacheService.TagDefinitionCacheKey theKey, TagDefinition theTagDefinition) {
            this.myTagDefinition = theTagDefinition;
            this.myKey = theKey;
        }

        public void afterCommit() {
            BaseHapiFhirDao.this.myMemoryCacheService.put(MemoryCacheService.CacheEnum.TAG_DEFINITION, (Object)this.myKey, (Object)this.myTagDefinition);
        }
    }
}

