/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.jobs.parameters.UrlPartitioner;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexJobParameters;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.jpa.api.model.DeleteMethodOutcome;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.api.model.LazyDaoMethodOutcome;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.MatchResourceUrlService;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.delete.DeleteConflictUtil;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.model.util.JpaConstants;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.jpa.patch.FhirPatch;
import ca.uhn.fhir.jpa.patch.JsonPatchUtils;
import ca.uhn.fhir.jpa.patch.XmlPatchUtils;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProvider;
import ca.uhn.fhir.jpa.search.cache.SearchCacheStatusEnum;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.ResourceSearch;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.ValidationModeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.ObjectUtil;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IInstanceValidatorModule;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ValidationOptions;
import ca.uhn.fhir.validation.ValidationResult;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseHapiFhirResourceDao<T extends IBaseResource>
extends BaseHapiFhirDao<T>
implements IFhirResourceDao<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseHapiFhirResourceDao.class);
    public static final String BASE_RESOURCE_NAME = "resource";
    @Autowired
    protected PlatformTransactionManager myPlatformTransactionManager;
    @Autowired(required=false)
    protected IFulltextSearchSvc mySearchDao;
    @Autowired
    protected HapiTransactionService myTransactionService;
    @Autowired
    private MatchResourceUrlService myMatchResourceUrlService;
    @Autowired
    private SearchBuilderFactory mySearchBuilderFactory;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private IDeleteExpungeJobSubmitter myDeleteExpungeJobSubmitter;
    @Autowired
    private IJobCoordinator myJobCoordinator;
    private IInstanceValidatorModule myInstanceValidator;
    private String myResourceName;
    private Class<T> myResourceType;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    private TransactionTemplate myTxTemplate;
    @Autowired
    private UrlPartitioner myUrlPartitioner;

    public DaoMethodOutcome create(T theResource) {
        return this.create(theResource, null, true, new TransactionDetails(), null);
    }

    public DaoMethodOutcome create(T theResource, RequestDetails theRequestDetails) {
        return this.create(theResource, null, true, new TransactionDetails(), theRequestDetails);
    }

    public DaoMethodOutcome create(T theResource, String theIfNoneExist) {
        return this.create(theResource, theIfNoneExist, null);
    }

    public DaoMethodOutcome create(T theResource, String theIfNoneExist, RequestDetails theRequestDetails) {
        return this.create(theResource, theIfNoneExist, true, new TransactionDetails(), theRequestDetails);
    }

    @VisibleForTesting
    public void setTransactionService(HapiTransactionService theTransactionService) {
        this.myTransactionService = theTransactionService;
    }

    public DaoMethodOutcome create(T theResource, String theIfNoneExist, boolean thePerformIndexing, @Nonnull TransactionDetails theTransactionDetails, RequestDetails theRequestDetails) {
        return (DaoMethodOutcome)this.myTransactionService.execute(theRequestDetails, theTransactionDetails, tx -> this.doCreateForPost(theResource, theIfNoneExist, thePerformIndexing, theTransactionDetails, theRequestDetails));
    }

    @VisibleForTesting
    public void setRequestPartitionHelperService(IRequestPartitionHelperSvc theRequestPartitionHelperService) {
        this.myRequestPartitionHelperService = theRequestPartitionHelperService;
    }

    protected DaoMethodOutcome doCreateForPost(T theResource, String theIfNoneExist, boolean thePerformIndexing, TransactionDetails theTransactionDetails, RequestDetails theRequestDetails) {
        if (theResource == null) {
            String msg = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "missingBody", new Object[0]);
            throw new InvalidRequestException(Msg.code((int)956) + msg);
        }
        if (StringUtils.isNotBlank((CharSequence)theResource.getIdElement().getIdPart())) {
            if (this.getContext().getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                String message = this.getMessageSanitized("failedToCreateWithClientAssignedId", theResource.getIdElement().getIdPart());
                throw new InvalidRequestException(Msg.code((int)957) + message, this.createErrorOperationOutcome(message, "processing"));
            }
            theResource.setId("");
        }
        if (this.getConfig().getResourceServerIdStrategy() == DaoConfig.IdStrategyEnum.UUID) {
            theResource.setId(UUID.randomUUID().toString());
            theResource.setUserData(JpaConstants.RESOURCE_ID_SERVER_ASSIGNED, (Object)Boolean.TRUE);
        }
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineCreatePartitionForRequest(theRequestDetails, theResource, this.getResourceName());
        return this.doCreateForPostOrPut(theResource, theIfNoneExist, thePerformIndexing, theTransactionDetails, theRequestDetails, requestPartitionId);
    }

    private DaoMethodOutcome doCreateForPostOrPut(T theResource, String theIfNoneExist, boolean thePerformIndexing, TransactionDetails theTransactionDetails, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        boolean createForPureNumericIds;
        HookParams hookParams;
        boolean resourceIdWasServerAssigned;
        StopWatch w = new StopWatch();
        this.preProcessResourceForStorage((IBaseResource)theResource);
        this.preProcessResourceForStorage((IBaseResource)theResource, theRequest, theTransactionDetails, thePerformIndexing);
        ResourceTable entity = new ResourceTable();
        entity.setResourceType(this.toResourceName((IBaseResource)theResource));
        entity.setPartitionId(this.myRequestPartitionHelperService.toStoragePartition(theRequestPartitionId));
        entity.setCreatedByMatchUrl(theIfNoneExist);
        entity.setVersion(1L);
        if (StringUtils.isNotBlank((CharSequence)theIfNoneExist)) {
            Set match = this.myMatchResourceUrlService.processMatchUrl(theIfNoneExist, this.myResourceType, theTransactionDetails, theRequest);
            if (match.size() > 1) {
                String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithMultipleMatchFailure", new Object[]{"CREATE", theIfNoneExist, match.size()});
                throw new PreconditionFailedException(Msg.code((int)958) + msg);
            }
            if (match.size() == 1) {
                ResourcePersistentId pid = (ResourcePersistentId)match.iterator().next();
                Supplier<LazyDaoMethodOutcome.EntityAndResource> entitySupplier = () -> (LazyDaoMethodOutcome.EntityAndResource)this.myTxTemplate.execute(tx -> {
                    ResourceTable foundEntity = (ResourceTable)this.myEntityManager.find(ResourceTable.class, pid.getId());
                    IBaseResource resource = this.toResource((BaseHasResource)foundEntity, false);
                    theResource.setId(resource.getIdElement().getValue());
                    return new LazyDaoMethodOutcome.EntityAndResource((IBasePersistedResource)foundEntity, resource);
                });
                Supplier<IIdType> idSupplier = () -> (IIdType)this.myTxTemplate.execute(tx -> {
                    IIdType retVal = this.myIdHelperService.translatePidIdToForcedId(this.myFhirContext, this.myResourceName, pid);
                    if (!retVal.hasVersionIdPart()) {
                        IIdType idWithVersion = (IIdType)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.RESOURCE_CONDITIONAL_CREATE_VERSION, (Object)pid.getIdAsLong());
                        if (idWithVersion == null) {
                            Long version = this.myResourceTableDao.findCurrentVersionByPid(pid.getIdAsLong());
                            if (version != null) {
                                retVal = this.myFhirContext.getVersion().newIdType().setParts(retVal.getBaseUrl(), retVal.getResourceType(), retVal.getIdPart(), Long.toString(version));
                                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_CONDITIONAL_CREATE_VERSION, (Object)pid.getIdAsLong(), (Object)retVal);
                            }
                        } else {
                            retVal = idWithVersion;
                        }
                    }
                    return retVal;
                });
                return this.toMethodOutcomeLazy(theRequest, pid, entitySupplier, idSupplier).setCreated(Boolean.valueOf(false)).setNop(true);
            }
        }
        if (theRequest != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, this.getContext(), theResource);
            this.notifyInterceptors(RestOperationTypeEnum.CREATE, requestDetails);
        }
        String resourceIdBeforeStorage = theResource.getIdElement().getIdPart();
        boolean resourceHadIdBeforeStorage = StringUtils.isNotBlank((CharSequence)resourceIdBeforeStorage);
        boolean bl = resourceIdWasServerAssigned = theResource.getUserData(JpaConstants.RESOURCE_ID_SERVER_ASSIGNED) == Boolean.TRUE;
        if (!resourceIdWasServerAssigned && resourceHadIdBeforeStorage) {
            hookParams = new HookParams().add(IBaseResource.class, theResource).add(RequestDetails.class, (Object)theRequest);
            this.doCallHooks(theTransactionDetails, theRequest, Pointcut.STORAGE_PRESTORAGE_CLIENT_ASSIGNED_ID, hookParams);
        }
        hookParams = new HookParams().add(IBaseResource.class, theResource).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(RequestPartitionId.class, (Object)theRequestPartitionId).add(TransactionDetails.class, (Object)theTransactionDetails);
        this.doCallHooks(theTransactionDetails, theRequest, Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED, hookParams);
        if (resourceHadIdBeforeStorage && !resourceIdWasServerAssigned) {
            this.validateResourceIdCreation(theResource, theRequest);
        }
        ResourceTable updatedEntity = this.updateEntity(theRequest, (IBaseResource)theResource, (IBasePersistedResource)entity, null, thePerformIndexing, false, theTransactionDetails, false, thePerformIndexing);
        ResourcePersistentId persistentId = new ResourcePersistentId((Object)updatedEntity.getResourceId());
        if (resourceHadIdBeforeStorage) {
            if (resourceIdWasServerAssigned) {
                createForPureNumericIds = true;
                this.createForcedIdIfNeeded(entity, resourceIdBeforeStorage, createForPureNumericIds);
            } else {
                createForPureNumericIds = this.getConfig().getResourceClientIdStrategy() != DaoConfig.ClientIdStrategyEnum.ALPHANUMERIC;
                this.createForcedIdIfNeeded(entity, resourceIdBeforeStorage, createForPureNumericIds);
            }
        } else {
            switch (this.getConfig().getResourceClientIdStrategy()) {
                case NOT_ALLOWED: 
                case ALPHANUMERIC: {
                    break;
                }
                case ANY: {
                    createForPureNumericIds = true;
                    this.createForcedIdIfNeeded(updatedEntity, theResource.getIdElement().getIdPart(), createForPureNumericIds);
                    assert (updatedEntity.getTransientForcedId() != null);
                    break;
                }
            }
        }
        theResource.setId((IIdType)entity.getIdDt());
        persistentId.setAssociatedResourceId(entity.getIdType(this.myFhirContext));
        this.myIdHelperService.addResolvedPidToForcedId(persistentId, theRequestPartitionId, this.getResourceName(), entity.getTransientForcedId(), null);
        theTransactionDetails.addResolvedResourceId(persistentId.getAssociatedResourceId(), persistentId);
        if (theIfNoneExist != null) {
            this.myMatchResourceUrlService.matchUrlResolved(theTransactionDetails, this.getResourceName(), theIfNoneExist, persistentId);
        }
        this.updateResourceMetadata((IBaseResourceEntity)entity, (IBaseResource)theResource);
        this.addPidToResource((IBasePersistedResource)entity, (IBaseResource)theResource);
        if (!updatedEntity.isUnchangedInCurrentOperation()) {
            hookParams = new HookParams().add(IBaseResource.class, theResource).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED));
            this.doCallHooks(theTransactionDetails, theRequest, Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED, hookParams);
        }
        DaoMethodOutcome outcome = this.toMethodOutcome(theRequest, (IBasePersistedResource)entity, (IBaseResource)theResource).setCreated(Boolean.valueOf(true));
        if (!thePerformIndexing) {
            outcome.setId(theResource.getIdElement());
        }
        String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulCreate", new Object[]{outcome.getId(), w.getMillisAndRestart()});
        outcome.setOperationOutcome(this.createInfoOperationOutcome(msg));
        ourLog.debug(msg);
        return outcome;
    }

    private void createForcedIdIfNeeded(ResourceTable theEntity, String theResourceId, boolean theCreateForPureNumericIds) {
        if (StringUtils.isNotBlank((CharSequence)theResourceId) && theEntity.getForcedId() == null && (theCreateForPureNumericIds || !IdHelperService.isValidPid(theResourceId))) {
            ForcedId forcedId = new ForcedId();
            forcedId.setResourceType(theEntity.getResourceType());
            forcedId.setForcedId(theResourceId);
            forcedId.setResource(theEntity);
            forcedId.setPartitionId(theEntity.getPartitionId());
            theEntity.setTransientForcedId(forcedId.getForcedId());
            this.myForcedIdDao.save(forcedId);
        }
    }

    void validateResourceIdCreation(T theResource, RequestDetails theRequest) {
        DaoConfig.ClientIdStrategyEnum strategy = this.getConfig().getResourceClientIdStrategy();
        if (strategy == DaoConfig.ClientIdStrategyEnum.NOT_ALLOWED && !this.isSystemRequest(theRequest)) {
            throw new ResourceNotFoundException(Msg.code((int)959) + this.getMessageSanitized("failedToCreateWithClientAssignedIdNotAllowed", theResource.getIdElement().getIdPart()));
        }
        if (strategy == DaoConfig.ClientIdStrategyEnum.ALPHANUMERIC && theResource.getIdElement().isIdPartValidLong()) {
            throw new InvalidRequestException(Msg.code((int)960) + this.getMessageSanitized("failedToCreateWithClientAssignedNumericId", theResource.getIdElement().getIdPart()));
        }
    }

    protected String getMessageSanitized(String theKey, String theIdPart) {
        return this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, theKey, new Object[]{theIdPart});
    }

    private boolean isSystemRequest(RequestDetails theRequest) {
        return theRequest instanceof SystemRequestDetails;
    }

    private IInstanceValidatorModule getInstanceValidator() {
        return this.myInstanceValidator;
    }

    public DaoMethodOutcome delete(IIdType theId) {
        return this.delete(theId, null);
    }

    public DaoMethodOutcome delete(IIdType theId, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        this.validateIdPresentForDelete(theId);
        this.validateDeleteEnabled();
        return (DaoMethodOutcome)this.myTransactionService.execute(theRequestDetails, transactionDetails, tx -> {
            DeleteConflictList deleteConflicts = new DeleteConflictList();
            if (StringUtils.isNotBlank((CharSequence)theId.getValue())) {
                deleteConflicts.setResourceIdMarkedForDeletion(theId);
            }
            StopWatch w = new StopWatch();
            DaoMethodOutcome retVal = this.delete(theId, deleteConflicts, theRequestDetails, transactionDetails);
            DeleteConflictUtil.validateDeleteConflictsEmptyOrThrowException((FhirContext)this.getContext(), (DeleteConflictList)deleteConflicts);
            ourLog.debug("Processed delete on {} in {}ms", (Object)theId.getValue(), (Object)w.getMillisAndRestart());
            return retVal;
        });
    }

    private DaoMethodOutcome createMethodOutcomeForDelete(String theId) {
        DaoMethodOutcome outcome = new DaoMethodOutcome();
        IIdType id = this.getContext().getVersion().newIdType();
        id.setValue(theId);
        outcome.setId(id);
        IBaseOperationOutcome oo = OperationOutcomeUtil.newInstance((FhirContext)this.getContext());
        String message = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "successfulDeletes", new Object[]{1, 0});
        String severity = "information";
        String code = "informational";
        OperationOutcomeUtil.addIssue((FhirContext)this.getContext(), (IBaseOperationOutcome)oo, (String)severity, (String)message, null, (String)code);
        outcome.setOperationOutcome(oo);
        return outcome;
    }

    public DaoMethodOutcome delete(IIdType theId, DeleteConflictList theDeleteConflicts, RequestDetails theRequestDetails, @Nonnull TransactionDetails theTransactionDetails) {
        ResourceTable entity;
        this.validateIdPresentForDelete(theId);
        this.validateDeleteEnabled();
        try {
            entity = this.readEntityLatestVersion(theId, theRequestDetails, theTransactionDetails);
        }
        catch (ResourceNotFoundException ex) {
            DaoMethodOutcome outcome = this.createMethodOutcomeForDelete(theId.getValue());
            return outcome;
        }
        if (theId.hasVersionIdPart() && Long.parseLong(theId.getVersionIdPart()) != entity.getVersion()) {
            throw new ResourceVersionConflictException(Msg.code((int)961) + "Trying to delete " + theId + " but this is not the current version");
        }
        if (this.isDeleted((BaseHasResource)entity)) {
            DaoMethodOutcome outcome = this.createMethodOutcomeForDelete(entity.getIdDt().getValue());
            outcome.setPersistentId(new ResourcePersistentId((Object)entity.getResourceId()));
            outcome.setEntity((IBasePersistedResource)entity);
            return outcome;
        }
        StopWatch w = new StopWatch();
        T resourceToDelete = this.toResource(this.myResourceType, (IBaseResourceEntity)entity, null, false);
        theDeleteConflicts.setResourceIdMarkedForDeletion(theId);
        HookParams hook = new HookParams().add(IBaseResource.class, resourceToDelete).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails);
        this.doCallHooks(theTransactionDetails, theRequestDetails, Pointcut.STORAGE_PRESTORAGE_RESOURCE_DELETED, hook);
        this.myDeleteConflictService.validateOkToDelete(theDeleteConflicts, entity, false, theRequestDetails, theTransactionDetails);
        this.preDelete(resourceToDelete, entity, theRequestDetails);
        if (theRequestDetails != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequestDetails, this.getContext(), theId.getResourceType(), theId);
            this.notifyInterceptors(RestOperationTypeEnum.DELETE, requestDetails);
        }
        ResourceTable savedEntity = this.updateEntityForDelete(theRequestDetails, theTransactionDetails, entity);
        resourceToDelete.setId((IIdType)entity.getIdDt());
        HookParams hookParams = new HookParams().add(IBaseResource.class, resourceToDelete).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED));
        this.doCallHooks(theTransactionDetails, theRequestDetails, Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED, hookParams);
        DaoMethodOutcome outcome = this.toMethodOutcome(theRequestDetails, (IBasePersistedResource)savedEntity, (IBaseResource)resourceToDelete).setCreated(Boolean.valueOf(true));
        IBaseOperationOutcome oo = OperationOutcomeUtil.newInstance((FhirContext)this.getContext());
        String message = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "successfulDeletes", new Object[]{1, w.getMillis()});
        String severity = "information";
        String code = "informational";
        OperationOutcomeUtil.addIssue((FhirContext)this.getContext(), (IBaseOperationOutcome)oo, (String)severity, (String)message, null, (String)code);
        outcome.setOperationOutcome(oo);
        return outcome;
    }

    public DeleteMethodOutcome deleteByUrl(String theUrl, RequestDetails theRequest) {
        this.validateDeleteEnabled();
        TransactionDetails transactionDetails = new TransactionDetails();
        ResourceSearch resourceSearch = this.myMatchUrlService.getResourceSearch(theUrl);
        if (resourceSearch.isDeleteExpunge()) {
            return this.deleteExpunge(theUrl, theRequest);
        }
        return (DeleteMethodOutcome)this.myTransactionService.execute(theRequest, transactionDetails, tx -> {
            DeleteConflictList deleteConflicts = new DeleteConflictList();
            DeleteMethodOutcome outcome = this.deleteByUrl(theUrl, deleteConflicts, theRequest);
            DeleteConflictUtil.validateDeleteConflictsEmptyOrThrowException((FhirContext)this.getContext(), (DeleteConflictList)deleteConflicts);
            return outcome;
        });
    }

    public DeleteMethodOutcome deleteByUrl(String theUrl, DeleteConflictList deleteConflicts, RequestDetails theRequestDetails) {
        this.validateDeleteEnabled();
        TransactionDetails transactionDetails = new TransactionDetails();
        return (DeleteMethodOutcome)this.myTransactionService.execute(theRequestDetails, transactionDetails, tx -> this.doDeleteByUrl(theUrl, deleteConflicts, theRequestDetails));
    }

    @Nonnull
    private DeleteMethodOutcome doDeleteByUrl(String theUrl, DeleteConflictList deleteConflicts, RequestDetails theRequest) {
        ResourceSearch resourceSearch = this.myMatchUrlService.getResourceSearch(theUrl);
        SearchParameterMap paramMap = resourceSearch.getSearchParameterMap();
        paramMap.setLoadSynchronous(true);
        Set resourceIds = this.myMatchResourceUrlService.search(paramMap, this.myResourceType, theRequest, null);
        if (resourceIds.size() > 1 && !this.getConfig().isAllowMultipleDelete()) {
            throw new PreconditionFailedException(Msg.code((int)962) + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithMultipleMatchFailure", new Object[]{"DELETE", theUrl, resourceIds.size()}));
        }
        return this.deletePidList(theUrl, resourceIds, deleteConflicts, theRequest);
    }

    private DeleteMethodOutcome deleteExpunge(String theUrl, RequestDetails theRequest) {
        if (!this.getConfig().canDeleteExpunge()) {
            throw new MethodNotAllowedException(Msg.code((int)963) + "_expunge is not enabled on this server: " + this.getConfig().cannotDeleteExpungeReason());
        }
        if (theUrl.contains("_cascade") || theRequest.getHeader("X-Cascade") != null && theRequest.getHeader("X-Cascade").equals("delete")) {
            throw new InvalidRequestException(Msg.code((int)964) + "_expunge cannot be used with _cascade");
        }
        List<String> urlsToDeleteExpunge = Collections.singletonList(theUrl);
        try {
            String jobId = this.myDeleteExpungeJobSubmitter.submitJob(Integer.valueOf(this.getConfig().getExpungeBatchSize()), urlsToDeleteExpunge, theRequest);
            return new DeleteMethodOutcome(this.createInfoOperationOutcome("Delete job submitted with id " + jobId));
        }
        catch (InvalidRequestException e) {
            throw new InvalidRequestException(Msg.code((int)965) + "Invalid Delete Expunge Request: " + e.getMessage(), (Throwable)e);
        }
    }

    @Nonnull
    public DeleteMethodOutcome deletePidList(String theUrl, Collection<ResourcePersistentId> theResourceIds, DeleteConflictList theDeleteConflicts, RequestDetails theRequest) {
        String code;
        String severity;
        String message;
        IBaseOperationOutcome oo;
        StopWatch w = new StopWatch();
        TransactionDetails transactionDetails = new TransactionDetails();
        ArrayList<ResourceTable> deletedResources = new ArrayList<ResourceTable>();
        for (ResourcePersistentId pid : theResourceIds) {
            ResourceTable entity = (ResourceTable)this.myEntityManager.find(ResourceTable.class, (Object)pid.getIdAsLong());
            deletedResources.add(entity);
            T resourceToDelete = this.toResource(this.myResourceType, (IBaseResourceEntity)entity, null, false);
            HookParams hooks = new HookParams().add(IBaseResource.class, resourceToDelete).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(TransactionDetails.class, (Object)transactionDetails);
            this.doCallHooks(transactionDetails, theRequest, Pointcut.STORAGE_PRESTORAGE_RESOURCE_DELETED, hooks);
            this.myDeleteConflictService.validateOkToDelete(theDeleteConflicts, entity, false, theRequest, transactionDetails);
            IdDt idToDelete = entity.getIdDt();
            if (theRequest != null) {
                IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, idToDelete.getResourceType(), (IIdType)idToDelete);
                this.notifyInterceptors(RestOperationTypeEnum.DELETE, requestDetails);
            }
            this.updateEntityForDelete(theRequest, transactionDetails, entity);
            resourceToDelete.setId((IIdType)entity.getIdDt());
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter((IBaseResource)resourceToDelete, theRequest, transactionDetails){
                final /* synthetic */ IBaseResource val$resourceToDelete;
                final /* synthetic */ RequestDetails val$theRequest;
                final /* synthetic */ TransactionDetails val$transactionDetails;
                {
                    this.val$resourceToDelete = iBaseResource;
                    this.val$theRequest = requestDetails;
                    this.val$transactionDetails = transactionDetails;
                }

                public void beforeCommit(boolean readOnly) {
                    HookParams hookParams = new HookParams().add(IBaseResource.class, (Object)this.val$resourceToDelete).add(RequestDetails.class, (Object)this.val$theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.val$theRequest).add(TransactionDetails.class, (Object)this.val$transactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)this.val$transactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED));
                    BaseHapiFhirResourceDao.this.doCallHooks(this.val$transactionDetails, this.val$theRequest, Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED, hookParams);
                }
            });
        }
        if (deletedResources.isEmpty()) {
            oo = OperationOutcomeUtil.newInstance((FhirContext)this.getContext());
            message = this.getMessageSanitized("unableToDeleteNotFound", theUrl);
            severity = "warning";
            code = "not-found";
            OperationOutcomeUtil.addIssue((FhirContext)this.getContext(), (IBaseOperationOutcome)oo, (String)severity, (String)message, null, (String)code);
        } else {
            oo = OperationOutcomeUtil.newInstance((FhirContext)this.getContext());
            message = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "successfulDeletes", new Object[]{deletedResources.size(), w.getMillis()});
            severity = "information";
            code = "informational";
            OperationOutcomeUtil.addIssue((FhirContext)this.getContext(), (IBaseOperationOutcome)oo, (String)severity, (String)message, null, (String)code);
        }
        ourLog.debug("Processed delete on {} (matched {} resource(s)) in {}ms", new Object[]{theUrl, deletedResources.size(), w.getMillis()});
        DeleteMethodOutcome retVal = new DeleteMethodOutcome();
        retVal.setDeletedEntities(deletedResources);
        retVal.setOperationOutcome(oo);
        return retVal;
    }

    private void validateDeleteEnabled() {
        if (!this.getConfig().isDeleteEnabled()) {
            String msg = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "deleteBlockedBecauseDisabled", new Object[0]);
            throw new PreconditionFailedException(Msg.code((int)966) + msg);
        }
    }

    private void validateIdPresentForDelete(IIdType theId) {
        if (theId == null || !theId.hasIdPart()) {
            throw new InvalidRequestException(Msg.code((int)967) + "Can not perform delete, no ID provided");
        }
    }

    @PostConstruct
    public void detectSearchDaoDisabled() {
        if (this.mySearchDao != null && this.mySearchDao.isDisabled()) {
            this.mySearchDao = null;
        }
    }

    private <MT extends IBaseMetaType> void doMetaAdd(MT theMetaAdd, BaseHasResource theEntity, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        IBaseResource oldVersion = this.toResource(theEntity, false);
        ArrayList<TagDefinition> tags = this.toTagList(theMetaAdd);
        for (TagDefinition nextDef : tags) {
            BaseTag newEntity;
            boolean hasTag = false;
            for (BaseTag next : new ArrayList(theEntity.getTags())) {
                if (!ObjectUtil.equals((Object)next.getTag().getTagType(), (Object)nextDef.getTagType()) || !ObjectUtil.equals((Object)next.getTag().getSystem(), (Object)nextDef.getSystem()) || !ObjectUtil.equals((Object)next.getTag().getCode(), (Object)nextDef.getCode())) continue;
                hasTag = true;
                break;
            }
            if (hasTag) continue;
            theEntity.setHasTags(true);
            TagDefinition def = this.getTagOrNull(theTransactionDetails, nextDef.getTagType(), nextDef.getSystem(), nextDef.getCode(), nextDef.getDisplay());
            if (def == null || (newEntity = theEntity.addTag(def)).getTagId() != null) continue;
            this.myEntityManager.persist((Object)newEntity);
        }
        this.validateMetaCount(theEntity.getTags().size());
        this.myEntityManager.merge((Object)theEntity);
        IBaseResource newVersion = this.toResource(theEntity, false);
        HookParams preStorageParams = new HookParams().add(IBaseResource.class, (Object)oldVersion).add(IBaseResource.class, (Object)newVersion).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails);
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED, preStorageParams);
        HookParams preCommitParams = new HookParams().add(IBaseResource.class, (Object)oldVersion).add(IBaseResource.class, (Object)newVersion).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED));
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED, preCommitParams);
    }

    private <MT extends IBaseMetaType> void doMetaDelete(MT theMetaDel, BaseHasResource theEntity, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        IBaseResource oldVersion = this.toResource(theEntity, false);
        ArrayList<TagDefinition> tags = this.toTagList(theMetaDel);
        for (TagDefinition nextDef : tags) {
            for (BaseTag next : new ArrayList(theEntity.getTags())) {
                if (!ObjectUtil.equals((Object)next.getTag().getTagType(), (Object)nextDef.getTagType()) || !ObjectUtil.equals((Object)next.getTag().getSystem(), (Object)nextDef.getSystem()) || !ObjectUtil.equals((Object)next.getTag().getCode(), (Object)nextDef.getCode())) continue;
                this.myEntityManager.remove((Object)next);
                theEntity.getTags().remove(next);
            }
        }
        if (theEntity.getTags().isEmpty()) {
            theEntity.setHasTags(false);
        }
        theEntity = (BaseHasResource)this.myEntityManager.merge((Object)theEntity);
        IBaseResource newVersion = this.toResource(theEntity, false);
        HookParams preStorageParams = new HookParams().add(IBaseResource.class, (Object)oldVersion).add(IBaseResource.class, (Object)newVersion).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails);
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED, preStorageParams);
        HookParams preCommitParams = new HookParams().add(IBaseResource.class, (Object)oldVersion).add(IBaseResource.class, (Object)newVersion).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED));
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED, preCommitParams);
    }

    private void validateExpungeEnabled() {
        if (!this.getConfig().isExpungeEnabled()) {
            throw new MethodNotAllowedException(Msg.code((int)968) + "$expunge is not enabled on this server");
        }
    }

    @Transactional(propagation=Propagation.NEVER)
    public ExpungeOutcome expunge(IIdType theId, ExpungeOptions theExpungeOptions, RequestDetails theRequest) {
        this.validateExpungeEnabled();
        return this.forceExpungeInExistingTransaction(theId, theExpungeOptions, theRequest);
    }

    public ExpungeOutcome forceExpungeInExistingTransaction(IIdType theId, ExpungeOptions theExpungeOptions, RequestDetails theRequest) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myPlatformTransactionManager);
        BaseHasResource entity = (BaseHasResource)txTemplate.execute(t -> this.readEntity(theId, theRequest));
        Validate.notNull((Object)entity, (String)"Resource with ID %s not found in database", (Object[])new Object[]{theId});
        if (theId.hasVersionIdPart()) {
            BaseHasResource currentVersion = (BaseHasResource)txTemplate.execute(t -> this.readEntity(theId.toVersionless(), theRequest));
            Validate.notNull((Object)currentVersion, (String)"Current version of resource with ID %s not found in database", (Object[])new Object[]{theId.toVersionless()});
            if (entity.getVersion() == currentVersion.getVersion()) {
                throw new PreconditionFailedException(Msg.code((int)969) + "Can not perform version-specific expunge of resource " + theId.toUnqualified().getValue() + " as this is the current version");
            }
            return this.myExpungeService.expunge(this.getResourceName(), new ResourcePersistentId((Object)entity.getResourceId(), Long.valueOf(entity.getVersion())), theExpungeOptions, theRequest);
        }
        return this.myExpungeService.expunge(this.getResourceName(), new ResourcePersistentId((Object)entity.getResourceId()), theExpungeOptions, theRequest);
    }

    @Transactional(propagation=Propagation.NEVER)
    public ExpungeOutcome expunge(ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        ourLog.info("Beginning TYPE[{}] expunge operation", (Object)this.getResourceName());
        return this.myExpungeService.expunge(this.getResourceName(), null, theExpungeOptions, theRequestDetails);
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    public Class<T> getResourceType() {
        return this.myResourceType;
    }

    @Required
    public void setResourceType(Class<? extends IBaseResource> theTableType) {
        this.myResourceType = theTableType;
    }

    @Transactional
    public IBundleProvider history(Date theSince, Date theUntil, Integer theOffset, RequestDetails theRequestDetails) {
        IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequestDetails);
        this.notifyInterceptors(RestOperationTypeEnum.HISTORY_TYPE, requestDetails);
        StopWatch w = new StopWatch();
        IBundleProvider retVal = super.history(theRequestDetails, this.myResourceName, null, theSince, theUntil, theOffset);
        ourLog.debug("Processed history on {} in {}ms", (Object)this.myResourceName, (Object)w.getMillisAndRestart());
        return retVal;
    }

    @Transactional
    public IBundleProvider history(IIdType theId, Date theSince, Date theUntil, Integer theOffset, RequestDetails theRequest) {
        if (theRequest != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, this.getResourceName(), theId);
            this.notifyInterceptors(RestOperationTypeEnum.HISTORY_INSTANCE, requestDetails);
        }
        StopWatch w = new StopWatch();
        IIdType id = theId.withResourceType(this.myResourceName).toUnqualifiedVersionless();
        BaseHasResource entity = this.readEntity(id, theRequest);
        IBundleProvider retVal = super.history(theRequest, this.myResourceName, entity.getId(), theSince, theUntil, theOffset);
        ourLog.debug("Processed history on {} in {}ms", (Object)id, (Object)w.getMillisAndRestart());
        return retVal;
    }

    protected boolean isPagingProviderDatabaseBacked(RequestDetails theRequestDetails) {
        if (theRequestDetails == null || theRequestDetails.getServer() == null) {
            return false;
        }
        IRestfulServerDefaults server = theRequestDetails.getServer();
        IPagingProvider pagingProvider = server.getPagingProvider();
        return pagingProvider != null;
    }

    protected void requestReindexForRelatedResources(Boolean theCurrentlyReindexing, List<String> theBase, RequestDetails theRequestDetails) {
        if (Boolean.TRUE.equals(theCurrentlyReindexing) || this.shouldSkipReindex(theRequestDetails)) {
            return;
        }
        if (this.getConfig().isMarkResourcesForReindexingUponSearchParameterChange()) {
            ReindexJobParameters params = new ReindexJobParameters();
            if (!this.isCommonSearchParam(theBase)) {
                this.addAllResourcesTypesToReindex(theBase, theRequestDetails, params);
            }
            ReadPartitionIdRequestDetails details = new ReadPartitionIdRequestDetails(null, RestOperationTypeEnum.EXTENDED_OPERATION_SERVER, null, null, null);
            RequestPartitionId requestPartition = this.myRequestPartitionHelperService.determineReadPartitionForRequest(theRequestDetails, null, details);
            params.setRequestPartitionId(requestPartition);
            JobInstanceStartRequest request = new JobInstanceStartRequest();
            request.setJobDefinitionId("REINDEX");
            request.setParameters((IModelJson)params);
            this.myJobCoordinator.startInstance(request);
            ourLog.debug("Started reindex job with parameters {}", (Object)params);
        }
        this.mySearchParamRegistry.requestRefresh();
    }

    private boolean shouldSkipReindex(RequestDetails theRequestDetails) {
        if (theRequestDetails == null) {
            return false;
        }
        Boolean shouldSkip = theRequestDetails.getUserData().getOrDefault("SKIP-REINDEX-ON-UPDATE", false);
        return Boolean.parseBoolean(((Object)shouldSkip).toString());
    }

    private void addAllResourcesTypesToReindex(List<String> theBase, RequestDetails theRequestDetails, ReindexJobParameters params) {
        theBase.stream().map(t -> t + "?").map(url -> this.myUrlPartitioner.partitionUrl(url, theRequestDetails)).forEach(arg_0 -> ((ReindexJobParameters)params).addPartitionedUrl(arg_0));
    }

    private boolean isCommonSearchParam(List<String> theBase) {
        return theBase.stream().map(String::toLowerCase).anyMatch(BASE_RESOURCE_NAME::equals);
    }

    @Transactional
    public <MT extends IBaseMetaType> MT metaAddOperation(IIdType theResourceId, MT theMetaAdd, RequestDetails theRequest) {
        TransactionDetails transactionDetails = new TransactionDetails();
        if (theRequest != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, this.getResourceName(), theResourceId);
            this.notifyInterceptors(RestOperationTypeEnum.META_ADD, requestDetails);
        }
        StopWatch w = new StopWatch();
        BaseHasResource entity = this.readEntity(theResourceId, theRequest);
        if (entity == null) {
            throw new ResourceNotFoundException(Msg.code((int)1993) + theResourceId);
        }
        ResourceTable latestVersion = this.readEntityLatestVersion(theResourceId, theRequest, transactionDetails);
        if (latestVersion.getVersion() != entity.getVersion()) {
            this.doMetaAdd(theMetaAdd, entity, theRequest, transactionDetails);
        } else {
            this.doMetaAdd(theMetaAdd, (BaseHasResource)latestVersion, theRequest, transactionDetails);
            ResourceHistoryTable history = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(entity.getId(), entity.getVersion());
            this.doMetaAdd(theMetaAdd, (BaseHasResource)history, theRequest, transactionDetails);
        }
        ourLog.debug("Processed metaAddOperation on {} in {}ms", (Object)theResourceId, (Object)w.getMillisAndRestart());
        Object retVal = this.metaGetOperation(theMetaAdd.getClass(), theResourceId, theRequest);
        return (MT)retVal;
    }

    @Transactional
    public <MT extends IBaseMetaType> MT metaDeleteOperation(IIdType theResourceId, MT theMetaDel, RequestDetails theRequest) {
        TransactionDetails transactionDetails = new TransactionDetails();
        if (theRequest != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, this.getResourceName(), theResourceId);
            this.notifyInterceptors(RestOperationTypeEnum.META_DELETE, requestDetails);
        }
        StopWatch w = new StopWatch();
        BaseHasResource entity = this.readEntity(theResourceId, theRequest);
        if (entity == null) {
            throw new ResourceNotFoundException(Msg.code((int)1994) + theResourceId);
        }
        ResourceTable latestVersion = this.readEntityLatestVersion(theResourceId, theRequest, transactionDetails);
        if (latestVersion.getVersion() != entity.getVersion()) {
            this.doMetaDelete(theMetaDel, entity, theRequest, transactionDetails);
        } else {
            this.doMetaDelete(theMetaDel, (BaseHasResource)latestVersion, theRequest, transactionDetails);
            ResourceHistoryTable history = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(entity.getId(), entity.getVersion());
            this.doMetaDelete(theMetaDel, (BaseHasResource)history, theRequest, transactionDetails);
        }
        ourLog.debug("Processed metaDeleteOperation on {} in {}ms", (Object)theResourceId.getValue(), (Object)w.getMillisAndRestart());
        Object retVal = this.metaGetOperation(theMetaDel.getClass(), theResourceId, theRequest);
        return (MT)retVal;
    }

    @Transactional
    public <MT extends IBaseMetaType> MT metaGetOperation(Class<MT> theType, IIdType theId, RequestDetails theRequest) {
        if (theRequest != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, this.getResourceName(), theId);
            this.notifyInterceptors(RestOperationTypeEnum.META, requestDetails);
        }
        HashSet<TagDefinition> tagDefs = new HashSet<TagDefinition>();
        BaseHasResource entity = this.readEntity(theId, theRequest);
        for (BaseTag next : entity.getTags()) {
            tagDefs.add(next.getTag());
        }
        MT retVal = this.toMetaDt(theType, tagDefs);
        retVal.setLastUpdated(entity.getUpdatedDate());
        retVal.setVersionId(Long.toString(entity.getVersion()));
        return retVal;
    }

    @Transactional
    public <MT extends IBaseMetaType> MT metaGetOperation(Class<MT> theType, RequestDetails theRequestDetails) {
        if (theRequestDetails != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequestDetails, this.getResourceName(), null);
            this.notifyInterceptors(RestOperationTypeEnum.META, requestDetails);
        }
        String sql = "SELECT d FROM TagDefinition d WHERE d.myId IN (SELECT DISTINCT t.myTagId FROM ResourceTag t WHERE t.myResourceType = :res_type)";
        TypedQuery q = this.myEntityManager.createQuery(sql, TagDefinition.class);
        q.setParameter("res_type", (Object)this.myResourceName);
        List tagDefinitions = q.getResultList();
        return this.toMetaDt(theType, tagDefinitions);
    }

    public DaoMethodOutcome patch(IIdType theId, String theConditionalUrl, PatchTypeEnum thePatchType, String thePatchBody, IBaseParameters theFhirPatchBody, RequestDetails theRequest) {
        TransactionDetails transactionDetails = new TransactionDetails();
        return (DaoMethodOutcome)this.myTransactionService.execute(theRequest, transactionDetails, tx -> this.doPatch(theId, theConditionalUrl, thePatchType, thePatchBody, theFhirPatchBody, theRequest, transactionDetails));
    }

    /*
     * Enabled aggressive block sorting
     */
    private DaoMethodOutcome doPatch(IIdType theId, String theConditionalUrl, PatchTypeEnum thePatchType, String thePatchBody, IBaseParameters theFhirPatchBody, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        IBaseResource destination;
        ResourceTable entityToUpdate;
        if (StringUtils.isNotBlank((CharSequence)theConditionalUrl)) {
            Set match = this.myMatchResourceUrlService.processMatchUrl(theConditionalUrl, this.myResourceType, theTransactionDetails, theRequest);
            if (match.size() > 1) {
                String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithMultipleMatchFailure", new Object[]{"PATCH", theConditionalUrl, match.size()});
                throw new PreconditionFailedException(Msg.code((int)972) + msg);
            }
            if (match.size() != 1) {
                String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidMatchUrlNoMatches", new Object[]{theConditionalUrl});
                throw new ResourceNotFoundException(Msg.code((int)973) + msg);
            }
            ResourcePersistentId pid = (ResourcePersistentId)match.iterator().next();
            entityToUpdate = (ResourceTable)this.myEntityManager.find(ResourceTable.class, pid.getId());
        } else {
            entityToUpdate = this.readEntityLatestVersion(theId, theRequest, theTransactionDetails);
            if (theId.hasVersionIdPart() && theId.getVersionIdPartAsLong().longValue() != entityToUpdate.getVersion()) {
                throw new ResourceVersionConflictException(Msg.code((int)974) + "Version " + theId.getVersionIdPart() + " is not the most recent version of this resource, unable to apply patch");
            }
        }
        this.validateResourceType((BaseHasResource)entityToUpdate);
        if (this.isDeleted((BaseHasResource)entityToUpdate)) {
            throw this.createResourceGoneException((IBasePersistedResource)entityToUpdate);
        }
        IBaseResource resourceToUpdate = this.toResource((BaseHasResource)entityToUpdate, false);
        switch (thePatchType) {
            case JSON_PATCH: {
                destination = JsonPatchUtils.apply((FhirContext)this.getContext(), (IBaseResource)resourceToUpdate, (String)thePatchBody);
                break;
            }
            case XML_PATCH: {
                destination = XmlPatchUtils.apply((FhirContext)this.getContext(), (IBaseResource)resourceToUpdate, (String)thePatchBody);
                break;
            }
            default: {
                IBaseParameters fhirPatchJson = theFhirPatchBody;
                new FhirPatch(this.getContext()).apply(resourceToUpdate, (IBaseResource)fhirPatchJson);
                destination = resourceToUpdate;
            }
        }
        IBaseResource destinationCasted = destination;
        return this.update(destinationCasted, null, true, theRequest);
    }

    private boolean isDeleted(BaseHasResource entityToUpdate) {
        return entityToUpdate.getDeleted() != null;
    }

    @Override
    @PostConstruct
    public void start() {
        assert (this.getConfig() != null);
        ourLog.debug("Starting resource DAO for type: {}", (Object)this.getResourceName());
        this.myInstanceValidator = (IInstanceValidatorModule)this.getApplicationContext().getBean(IInstanceValidatorModule.class);
        this.myTxTemplate = new TransactionTemplate(this.myPlatformTransactionManager);
        super.start();
    }

    @PostConstruct
    public void postConstruct() {
        RuntimeResourceDefinition def = this.getContext().getResourceDefinition(this.myResourceType);
        this.myResourceName = def.getName();
    }

    protected void preDelete(T theResourceToDelete, ResourceTable theEntityToDelete, RequestDetails theRequestDetails) {
    }

    @Transactional
    public T readByPid(ResourcePersistentId thePid) {
        return this.readByPid(thePid, false);
    }

    @Transactional
    public T readByPid(ResourcePersistentId thePid, boolean theDeletedOk) {
        StopWatch w = new StopWatch();
        Optional entity = this.myResourceTableDao.findById(thePid.getIdAsLong());
        if (!entity.isPresent()) {
            throw new ResourceNotFoundException(Msg.code((int)975) + "No resource found with PID " + thePid);
        }
        if (this.isDeleted((BaseHasResource)entity.get()) && !theDeletedOk) {
            throw this.createResourceGoneException((IBasePersistedResource)entity.get());
        }
        T retVal = this.toResource(this.myResourceType, (IBaseResourceEntity)entity.get(), null, false);
        ourLog.debug("Processed read on {} in {}ms", (Object)thePid, (Object)w.getMillis());
        return retVal;
    }

    public T read(IIdType theId) {
        return this.read(theId, null);
    }

    public T read(IIdType theId, RequestDetails theRequestDetails) {
        return this.read(theId, theRequestDetails, false);
    }

    public T read(IIdType theId, RequestDetails theRequest, boolean theDeletedOk) {
        this.validateResourceTypeAndThrowInvalidRequestException(theId);
        TransactionDetails transactionDetails = new TransactionDetails();
        return (T)((IBaseResource)this.myTransactionService.execute(theRequest, transactionDetails, tx -> this.doRead(theId, theRequest, theDeletedOk)));
    }

    public T doRead(IIdType theId, RequestDetails theRequest, boolean theDeletedOk) {
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        if (theRequest != null && theRequest.getServer() != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, this.getResourceName(), theId);
            RestOperationTypeEnum operationType = theId.hasVersionIdPart() ? RestOperationTypeEnum.VREAD : RestOperationTypeEnum.READ;
            this.notifyInterceptors(operationType, requestDetails);
        }
        StopWatch w = new StopWatch();
        BaseHasResource entity = this.readEntity(theId, theRequest);
        this.validateResourceType(entity);
        Object retVal = this.toResource(this.myResourceType, (IBaseResourceEntity)entity, null, false);
        if (!theDeletedOk && this.isDeleted(entity)) {
            throw this.createResourceGoneException((IBasePersistedResource)entity);
        }
        SimplePreResourceAccessDetails accessDetails = new SimplePreResourceAccessDetails(retVal);
        HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
        if (accessDetails.isDontReturnResourceAtIndex(0)) {
            throw new ResourceNotFoundException(Msg.code((int)1995) + "Resource " + theId + " is not known");
        }
        SimplePreResourceShowDetails showDetails = new SimplePreResourceShowDetails(retVal);
        params = new HookParams().add(IPreResourceShowDetails.class, (Object)showDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, (HookParams)params);
        retVal = showDetails.getResource(0);
        ourLog.debug("Processed read on {} in {}ms", (Object)theId.getValue(), (Object)w.getMillisAndRestart());
        return retVal;
    }

    @Override
    @Transactional
    public BaseHasResource readEntity(IIdType theId, RequestDetails theRequest) {
        return this.readEntity(theId, true, theRequest);
    }

    @Transactional
    public String getCurrentVersionId(IIdType theReferenceElement) {
        return Long.toString(this.readEntity(theReferenceElement.toVersionless(), null).getVersion());
    }

    public void reindex(ResourcePersistentId theResourcePersistentId, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        Optional entityOpt = this.myResourceTableDao.findById(theResourcePersistentId.getIdAsLong());
        if (!entityOpt.isPresent()) {
            ourLog.warn("Unable to find entity with PID: {}", theResourcePersistentId.getId());
            return;
        }
        ResourceTable entity = (ResourceTable)entityOpt.get();
        try {
            IBaseResource resource = this.toResource((BaseHasResource)entity, false);
            this.reindex(resource, entity);
        }
        catch (DataFormatException | BaseServerResponseException e) {
            this.myResourceTableDao.updateIndexStatus(entity.getId(), 2L);
            throw e;
        }
    }

    @Transactional
    public BaseHasResource readEntity(IIdType theId, boolean theCheckForForcedId, RequestDetails theRequest) {
        BaseHasResource entity;
        this.validateResourceTypeAndThrowInvalidRequestException(theId);
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForRead(theRequest, this.getResourceName(), theId);
        ResourcePersistentId pid = this.myIdHelperService.resolveResourcePersistentIds(requestPartitionId, this.getResourceName(), theId.getIdPart());
        Set readPartitions = null;
        if (requestPartitionId.isAllPartitions()) {
            entity = (BaseHasResource)this.myEntityManager.find(ResourceTable.class, (Object)pid.getIdAsLong());
        } else {
            readPartitions = this.myRequestPartitionHelperService.toReadPartitions(requestPartitionId);
            if (readPartitions.size() == 1) {
                entity = readPartitions.contains(null) ? (BaseHasResource)this.myResourceTableDao.readByPartitionIdNull(pid.getIdAsLong()).orElse(null) : (BaseHasResource)this.myResourceTableDao.readByPartitionId((Integer)readPartitions.iterator().next(), pid.getIdAsLong()).orElse(null);
            } else if (readPartitions.contains(null)) {
                List<Integer> readPartitionsWithoutNull = readPartitions.stream().filter(t -> t != null).collect(Collectors.toList());
                entity = this.myResourceTableDao.readByPartitionIdsOrNull(readPartitionsWithoutNull, pid.getIdAsLong()).orElse(null);
            } else {
                entity = this.myResourceTableDao.readByPartitionIds(readPartitions, pid.getIdAsLong()).orElse(null);
            }
        }
        if (entity != null && readPartitions != null && entity.getPartitionId() != null && !readPartitions.contains(entity.getPartitionId().getPartitionId())) {
            ourLog.debug("Performing a read for PartitionId={} but entity has partition: {}", (Object)requestPartitionId, (Object)entity.getPartitionId());
            entity = null;
        }
        if (entity == null) {
            throw new ResourceNotFoundException(Msg.code((int)1996) + "Resource " + theId + " is not known");
        }
        if (theId.hasVersionIdPart()) {
            if (!theId.isVersionIdPartValidLong()) {
                throw new ResourceNotFoundException(Msg.code((int)978) + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidVersion", new Object[]{theId.getVersionIdPart(), theId.toUnqualifiedVersionless()}));
            }
            if (entity.getVersion() != theId.getVersionIdPartAsLong().longValue()) {
                entity = null;
            }
        }
        if (entity == null && theId.hasVersionIdPart()) {
            TypedQuery q = this.myEntityManager.createQuery("SELECT t from ResourceHistoryTable t WHERE t.myResourceId = :RID AND t.myResourceType = :RTYP AND t.myResourceVersion = :RVER", ResourceHistoryTable.class);
            q.setParameter("RID", pid.getId());
            q.setParameter("RTYP", (Object)this.myResourceName);
            q.setParameter("RVER", (Object)theId.getVersionIdPartAsLong());
            try {
                entity = (BaseHasResource)q.getSingleResult();
            }
            catch (NoResultException e) {
                throw new ResourceNotFoundException(Msg.code((int)979) + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidVersion", new Object[]{theId.getVersionIdPart(), theId.toUnqualifiedVersionless()}));
            }
        }
        Validate.notNull((Object)entity);
        this.validateResourceType(entity);
        if (theCheckForForcedId) {
            this.validateGivenIdIsAppropriateToRetrieveResource(theId, entity);
        }
        return entity;
    }

    @Nonnull
    protected ResourceTable readEntityLatestVersion(IIdType theId, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForRead(theRequestDetails, this.getResourceName(), theId);
        return this.readEntityLatestVersion(theId, requestPartitionId, theTransactionDetails);
    }

    @Nonnull
    private ResourceTable readEntityLatestVersion(IIdType theId, @Nonnull RequestPartitionId theRequestPartitionId, TransactionDetails theTransactionDetails) {
        ResourceTable entity;
        this.validateResourceTypeAndThrowInvalidRequestException(theId);
        ResourcePersistentId persistentId = null;
        if (theTransactionDetails != null) {
            if (theTransactionDetails.isResolvedResourceIdEmpty(theId.toUnqualifiedVersionless())) {
                throw new ResourceNotFoundException(Msg.code((int)1997) + theId);
            }
            if (theTransactionDetails.hasResolvedResourceIds()) {
                persistentId = theTransactionDetails.getResolvedResourceId(theId);
            }
        }
        if (persistentId == null) {
            persistentId = this.myIdHelperService.resolveResourcePersistentIds(theRequestPartitionId, this.getResourceName(), theId.getIdPart());
        }
        if ((entity = (ResourceTable)this.myEntityManager.find(ResourceTable.class, persistentId.getId())) == null) {
            throw new ResourceNotFoundException(Msg.code((int)1998) + theId);
        }
        this.validateGivenIdIsAppropriateToRetrieveResource(theId, (BaseHasResource)entity);
        entity.setTransientForcedId(theId.getIdPart());
        return entity;
    }

    public void reindex(T theResource, ResourceTable theEntity) {
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        ourLog.debug("Indexing resource {} - PID {}", (Object)theEntity.getIdDt().getValue(), (Object)theEntity.getId());
        if (theResource != null) {
            CURRENTLY_REINDEXING.put(theResource, Boolean.TRUE);
        }
        TransactionDetails transactionDetails = new TransactionDetails(theEntity.getUpdatedDate());
        ResourceTable resourceTable = this.updateEntity(null, (IBaseResource)theResource, (IBasePersistedResource)theEntity, theEntity.getDeleted(), true, false, transactionDetails, true, false);
        if (theResource != null) {
            CURRENTLY_REINDEXING.put(theResource, null);
        }
    }

    @Transactional
    public void removeTag(IIdType theId, TagTypeEnum theTagType, String theScheme, String theTerm) {
        this.removeTag(theId, theTagType, theScheme, theTerm, null);
    }

    @Transactional
    public void removeTag(IIdType theId, TagTypeEnum theTagType, String theScheme, String theTerm, RequestDetails theRequest) {
        if (theRequest != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, this.getResourceName(), theId);
            this.notifyInterceptors(RestOperationTypeEnum.DELETE_TAGS, requestDetails);
        }
        StopWatch w = new StopWatch();
        BaseHasResource entity = this.readEntity(theId, theRequest);
        if (entity == null) {
            throw new ResourceNotFoundException(Msg.code((int)1999) + theId);
        }
        for (BaseTag next : new ArrayList(entity.getTags())) {
            if (!ObjectUtil.equals((Object)next.getTag().getTagType(), (Object)theTagType) || !ObjectUtil.equals((Object)next.getTag().getSystem(), (Object)theScheme) || !ObjectUtil.equals((Object)next.getTag().getCode(), (Object)theTerm)) continue;
            this.myEntityManager.remove((Object)next);
            entity.getTags().remove(next);
        }
        if (entity.getTags().isEmpty()) {
            entity.setHasTags(false);
        }
        this.myEntityManager.merge((Object)entity);
        ourLog.debug("Processed remove tag {}/{} on {} in {}ms", new Object[]{theScheme, theTerm, theId.getValue(), w.getMillisAndRestart()});
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public IBundleProvider search(SearchParameterMap theParams) {
        return this.search(theParams, null);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public IBundleProvider search(SearchParameterMap theParams, RequestDetails theRequest) {
        return this.search(theParams, theRequest, null);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public IBundleProvider search(SearchParameterMap theParams, RequestDetails theRequest, HttpServletResponse theServletResponse) {
        PersistedJpaBundleProvider provider;
        if (theParams.getSearchContainedMode() == SearchContainedModeEnum.BOTH) {
            throw new MethodNotAllowedException(Msg.code((int)983) + "Contained mode 'both' is not currently supported");
        }
        if (theParams.getSearchContainedMode() != SearchContainedModeEnum.FALSE && !this.myModelConfig.isIndexOnContainedResources()) {
            throw new MethodNotAllowedException(Msg.code((int)984) + "Searching with _contained mode enabled is not enabled on this server");
        }
        if (this.getConfig().getIndexMissingFields() == DaoConfig.IndexEnabledEnum.DISABLED) {
            for (List nextAnds : theParams.values()) {
                for (List nextOrs : nextAnds) {
                    for (IQueryParameterType next : nextOrs) {
                        if (next.getMissing() == null) continue;
                        throw new MethodNotAllowedException(Msg.code((int)985) + ":missing modifier is disabled on this server");
                    }
                }
            }
        }
        this.translateListSearchParams(theParams);
        this.notifySearchInterceptors(theParams, theRequest);
        CacheControlDirective cacheControlDirective = new CacheControlDirective();
        if (theRequest != null) {
            cacheControlDirective.parse(theRequest.getHeaders("Cache-Control"));
        }
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForSearchType(theRequest, this.getResourceName(), theParams, null);
        IBundleProvider retVal = this.mySearchCoordinatorSvc.registerSearch((IFhirResourceDao)this, theParams, this.getResourceName(), cacheControlDirective, theRequest, requestPartitionId);
        if (retVal instanceof PersistedJpaBundleProvider && (provider = (PersistedJpaBundleProvider)retVal).getCacheStatus() == SearchCacheStatusEnum.HIT && theServletResponse != null && theRequest != null) {
            String value = "HIT from " + theRequest.getFhirServerBase();
            theServletResponse.addHeader("X-Cache", value);
        }
        return retVal;
    }

    private void translateListSearchParams(SearchParameterMap theParams) {
        for (String key : theParams.keySet()) {
            if (!"_list".equals(key)) continue;
            List andOrValues = theParams.get(key);
            theParams.remove(key);
            ArrayList hasParamValues = new ArrayList();
            for (List orValues : andOrValues) {
                ArrayList<HasParam> orList = new ArrayList<HasParam>();
                for (IQueryParameterType value : orValues) {
                    orList.add(new HasParam("List", "item", "_id", value.getValueAsQueryToken(null)));
                }
                hasParamValues.add(orList);
            }
            theParams.put("_has", hasParamValues);
        }
    }

    private void notifySearchInterceptors(SearchParameterMap theParams, RequestDetails theRequest) {
        if (theRequest != null) {
            Integer count;
            Integer offset;
            Integer max;
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, this.getContext(), this.getResourceName(), null);
            this.notifyInterceptors(RestOperationTypeEnum.SEARCH_TYPE, requestDetails);
            if (theRequest.isSubRequest() && (max = this.getConfig().getMaximumSearchResultCountInTransaction()) != null) {
                Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)max.intValue(), (String)"Maximum search result count in transaction ust be a positive integer");
                theParams.setLoadSynchronousUpTo(this.getConfig().getMaximumSearchResultCountInTransaction());
            }
            if ((offset = RestfulServerUtils.extractOffsetParameter((RequestDetails)theRequest)) != null || !this.isPagingProviderDatabaseBacked(theRequest)) {
                theParams.setLoadSynchronous(true);
                if (offset != null) {
                    Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)offset.intValue(), (String)"Offset must be a positive integer");
                }
                theParams.setOffset(offset);
            }
            if ((count = RestfulServerUtils.extractCountParameter((RequestDetails)theRequest)) != null) {
                Integer maxPageSize = theRequest.getServer().getMaximumPageSize();
                if (maxPageSize != null && count > maxPageSize) {
                    ourLog.info("Reducing {} from {} to {} which is the maximum allowable page size.", new Object[]{"_count", count, maxPageSize});
                    count = maxPageSize;
                }
                theParams.setCount(count);
            } else if (theRequest.getServer().getDefaultPageSize() != null) {
                theParams.setCount(theRequest.getServer().getDefaultPageSize());
            }
        }
    }

    public List<ResourcePersistentId> searchForIds(SearchParameterMap theParams, RequestDetails theRequest, @Nullable IBaseResource theConditionalOperationTargetOrNull) {
        TransactionDetails transactionDetails = new TransactionDetails();
        return (List)this.myTransactionService.execute(theRequest, transactionDetails, tx -> {
            if (theParams.getLoadSynchronousUpTo() != null) {
                theParams.setLoadSynchronousUpTo(Integer.valueOf(Math.min(this.getConfig().getInternalSynchronousSearchSize(), theParams.getLoadSynchronousUpTo())));
            } else {
                theParams.setLoadSynchronousUpTo(this.getConfig().getInternalSynchronousSearchSize());
            }
            ISearchBuilder builder = this.mySearchBuilderFactory.newSearchBuilder((IDao)this, this.getResourceName(), this.getResourceType());
            ArrayList<ResourcePersistentId> ids = new ArrayList<ResourcePersistentId>();
            String uuid = UUID.randomUUID().toString();
            RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForSearchType(theRequest, this.getResourceName(), theParams, theConditionalOperationTargetOrNull);
            SearchRuntimeDetails searchRuntimeDetails = new SearchRuntimeDetails(theRequest, uuid);
            try (IResultIterator iter = builder.createQuery(theParams, searchRuntimeDetails, theRequest, requestPartitionId);){
                while (iter.hasNext()) {
                    ids.add((ResourcePersistentId)iter.next());
                }
            }
            catch (IOException e) {
                ourLog.error("IO failure during database access", (Throwable)e);
            }
            return ids;
        });
    }

    protected <MT extends IBaseMetaType> MT toMetaDt(Class<MT> theType, Collection<TagDefinition> tagDefinitions) {
        IBaseMetaType retVal = (IBaseMetaType)ReflectionUtil.newInstance(theType);
        for (TagDefinition next : tagDefinitions) {
            switch (next.getTagType()) {
                case PROFILE: {
                    retVal.addProfile(next.getCode());
                    break;
                }
                case SECURITY_LABEL: {
                    retVal.addSecurity().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                    break;
                }
                case TAG: {
                    retVal.addTag().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                }
            }
        }
        return (MT)retVal;
    }

    private ArrayList<TagDefinition> toTagList(IBaseMetaType theMeta) {
        ArrayList<TagDefinition> retVal = new ArrayList<TagDefinition>();
        for (IBaseCoding next : theMeta.getTag()) {
            retVal.add(new TagDefinition(TagTypeEnum.TAG, next.getSystem(), next.getCode(), next.getDisplay()));
        }
        for (IBaseCoding next : theMeta.getSecurity()) {
            retVal.add(new TagDefinition(TagTypeEnum.SECURITY_LABEL, next.getSystem(), next.getCode(), next.getDisplay()));
        }
        for (IBaseCoding next : theMeta.getProfile()) {
            retVal.add(new TagDefinition(TagTypeEnum.PROFILE, "https://github.com/hapifhir/hapi-fhir/ns/jpa/profile", (String)next.getValue(), null));
        }
        return retVal;
    }

    public DaoMethodOutcome update(T theResource) {
        return this.update(theResource, null, null);
    }

    public DaoMethodOutcome update(T theResource, RequestDetails theRequestDetails) {
        return this.update(theResource, null, theRequestDetails);
    }

    public DaoMethodOutcome update(T theResource, String theMatchUrl) {
        return this.update(theResource, theMatchUrl, null);
    }

    public DaoMethodOutcome update(T theResource, String theMatchUrl, RequestDetails theRequestDetails) {
        return this.update(theResource, theMatchUrl, true, theRequestDetails);
    }

    public DaoMethodOutcome update(T theResource, String theMatchUrl, boolean thePerformIndexing, RequestDetails theRequestDetails) {
        return this.update(theResource, theMatchUrl, thePerformIndexing, false, theRequestDetails, new TransactionDetails());
    }

    public DaoMethodOutcome update(T theResource, String theMatchUrl, boolean thePerformIndexing, boolean theForceUpdateVersion, RequestDetails theRequest, @Nonnull TransactionDetails theTransactionDetails) {
        if (theResource == null) {
            String msg = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "missingBody", new Object[0]);
            throw new InvalidRequestException(Msg.code((int)986) + msg);
        }
        if (!theResource.getIdElement().hasIdPart() && StringUtils.isBlank((CharSequence)theMatchUrl)) {
            String type = this.myFhirContext.getResourceType(theResource);
            String msg = this.myFhirContext.getLocalizer().getMessage(BaseStorageDao.class, "updateWithNoId", new Object[]{type});
            throw new InvalidRequestException(Msg.code((int)987) + msg);
        }
        String id = theResource.getIdElement().getValue();
        Runnable onRollback = () -> theResource.getIdElement().setValue(id);
        if (this.myDaoConfig.isUpdateWithHistoryRewriteEnabled() && theRequest.isRewriteHistory()) {
            return (DaoMethodOutcome)this.myTransactionService.execute(theRequest, theTransactionDetails, tx -> this.doUpdateWithHistoryRewrite(theResource, theRequest, theTransactionDetails), onRollback);
        }
        return (DaoMethodOutcome)this.myTransactionService.execute(theRequest, theTransactionDetails, tx -> this.doUpdate(theResource, theMatchUrl, thePerformIndexing, theForceUpdateVersion, theRequest, theTransactionDetails), onRollback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DaoMethodOutcome doUpdate(T theResource, String theMatchUrl, boolean thePerformIndexing, boolean theForceUpdateVersion, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        IIdType resourceId;
        ResourceTable entity;
        T resource;
        StopWatch w;
        block17: {
            String existenceCheck;
            w = new StopWatch();
            resource = theResource;
            this.preProcessResourceForStorage((IBaseResource)resource);
            this.preProcessResourceForStorage((IBaseResource)theResource, theRequest, theTransactionDetails, thePerformIndexing);
            entity = null;
            if (StringUtils.isNotBlank((CharSequence)theMatchUrl)) {
                Set match = this.myMatchResourceUrlService.processMatchUrl(theMatchUrl, this.myResourceType, theTransactionDetails, theRequest, theResource);
                if (match.size() > 1) {
                    String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithMultipleMatchFailure", new Object[]{"UPDATE", theMatchUrl, match.size()});
                    throw new PreconditionFailedException(Msg.code((int)988) + msg);
                }
                if (match.size() == 1) {
                    ResourcePersistentId pid = (ResourcePersistentId)match.iterator().next();
                    entity = (ResourceTable)this.myEntityManager.find(ResourceTable.class, pid.getId());
                    resourceId = entity.getIdDt();
                    break block17;
                } else {
                    DaoMethodOutcome outcome = this.create(resource, null, thePerformIndexing, theTransactionDetails, theRequest);
                    if (outcome.getPersistentId() != null) {
                        this.myMatchResourceUrlService.matchUrlResolved(theTransactionDetails, this.getResourceName(), theMatchUrl, outcome.getPersistentId());
                    }
                    return outcome;
                }
            }
            resourceId = theResource.getIdElement();
            assert (resourceId != null);
            assert (resourceId.hasIdPart());
            RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineCreatePartitionForRequest(theRequest, theResource, this.getResourceName());
            boolean create = false;
            if (theRequest != null && "disabled".equals(existenceCheck = theRequest.getHeader("X-Upsert-Extistence-Check"))) {
                create = true;
            }
            if (!create) {
                try {
                    entity = this.readEntityLatestVersion(resourceId, requestPartitionId, theTransactionDetails);
                }
                catch (ResourceNotFoundException e) {
                    create = true;
                }
            }
            if (create) {
                return this.doCreateForPostOrPut(resource, null, thePerformIndexing, theTransactionDetails, theRequest, requestPartitionId);
            }
        }
        if (resourceId.hasVersionIdPart() && Long.parseLong(resourceId.getVersionIdPart()) != entity.getVersion()) {
            throw new ResourceVersionConflictException(Msg.code((int)989) + "Trying to update " + resourceId + " but this is not the current version");
        }
        if (resourceId.hasResourceType() && !resourceId.getResourceType().equals(this.getResourceName())) {
            throw new UnprocessableEntityException(Msg.code((int)990) + "Invalid resource ID[" + entity.getIdDt().toUnqualifiedVersionless() + "] of type[" + entity.getResourceType() + "] - Does not match expected [" + this.getResourceName() + "]");
        }
        IBaseResource oldResource = this.getConfig().isMassIngestionMode() ? null : this.toResource((BaseHasResource)entity, false);
        boolean wasDeleted = this.isDeleted((BaseHasResource)entity);
        entity.setDeleted(null);
        if (!thePerformIndexing) {
            resource.setId(entity.getIdDt().getValue());
            DaoMethodOutcome outcome = this.toMethodOutcome(theRequest, (IBasePersistedResource)entity, (IBaseResource)resource).setCreated(Boolean.valueOf(wasDeleted));
            outcome.setPreviousResource(oldResource);
            if (!outcome.isNop()) {
                outcome.setId(outcome.getId().withVersion(Long.toString(outcome.getId().getVersionIdPartAsLong() + 1L)));
            }
            return outcome;
        }
        ResourceTable savedEntity = this.updateInternal(theRequest, resource, thePerformIndexing, theForceUpdateVersion, (IBasePersistedResource)entity, resourceId, oldResource, theTransactionDetails);
        DaoMethodOutcome outcome = this.toMethodOutcome(theRequest, (IBasePersistedResource)savedEntity, (IBaseResource)resource).setCreated(Boolean.valueOf(wasDeleted));
        if (!thePerformIndexing) {
            IIdType id = this.getContext().getVersion().newIdType();
            id.setValue(entity.getIdDt().getValue());
            outcome.setId(id);
        }
        String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulUpdate", new Object[]{outcome.getId(), w.getMillisAndRestart()});
        outcome.setOperationOutcome(this.createInfoOperationOutcome(msg));
        ourLog.debug(msg);
        return outcome;
    }

    private DaoMethodOutcome doUpdateWithHistoryRewrite(T theResource, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        StopWatch w = new StopWatch();
        this.preProcessResourceForStorage((IBaseResource)theResource, theRequest, theTransactionDetails, false);
        BaseHasResource entity = null;
        ResourceTable currentEntity = null;
        IIdType resourceId = theResource.getIdElement();
        assert (resourceId != null);
        assert (resourceId.hasIdPart());
        try {
            currentEntity = this.readEntityLatestVersion(resourceId.toVersionless(), theRequest, theTransactionDetails);
            if (!resourceId.hasVersionIdPart()) {
                throw new InvalidRequestException(Msg.code((int)2093) + "Invalid resource ID, ID must contain a history version");
            }
            entity = this.readEntity(resourceId, theRequest);
            this.validateResourceType(entity);
        }
        catch (ResourceNotFoundException e) {
            throw new ResourceNotFoundException(Msg.code((int)2087) + "Resource not found [" + resourceId + "] - Doesn't exist");
        }
        if (resourceId.hasResourceType() && !resourceId.getResourceType().equals(this.getResourceName())) {
            throw new UnprocessableEntityException(Msg.code((int)2088) + "Invalid resource ID[" + entity.getIdDt().toUnqualifiedVersionless() + "] of type[" + entity.getResourceType() + "] - Does not match expected [" + this.getResourceName() + "]");
        }
        assert (resourceId.hasVersionIdPart());
        boolean wasDeleted = this.isDeleted(entity);
        entity.setDeleted(null);
        boolean isUpdatingCurrent = resourceId.hasVersionIdPart() && Long.parseLong(resourceId.getVersionIdPart()) == currentEntity.getVersion();
        IBasePersistedResource savedEntity = this.updateHistoryEntity(theRequest, theResource, (IBasePersistedResource)currentEntity, (IBasePersistedResource)entity, resourceId, theTransactionDetails, isUpdatingCurrent);
        DaoMethodOutcome outcome = this.toMethodOutcome(theRequest, savedEntity, (IBaseResource)theResource).setCreated(Boolean.valueOf(wasDeleted));
        String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulUpdate", new Object[]{outcome.getId(), w.getMillisAndRestart()});
        outcome.setOperationOutcome(this.createInfoOperationOutcome(msg));
        ourLog.debug(msg);
        return outcome;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Transactional(propagation=Propagation.SUPPORTS)
    public MethodOutcome validate(T theResource, IIdType theId, String theRawResource, EncodingEnum theEncoding, ValidationModeEnum theMode, String theProfile, RequestDetails theRequest) {
        ValidationResult result;
        TransactionDetails transactionDetails = new TransactionDetails();
        if (theRequest != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequest, theResource, null, theId);
            this.notifyInterceptors(RestOperationTypeEnum.VALIDATE, requestDetails);
        }
        if (theMode == ValidationModeEnum.DELETE) {
            if (theId == null || !theId.hasIdPart()) {
                throw new InvalidRequestException(Msg.code((int)991) + "No ID supplied. ID is required when validating with mode=DELETE");
            }
            ResourceTable entity = this.readEntityLatestVersion(theId, theRequest, transactionDetails);
            DeleteConflictList deleteConflicts = new DeleteConflictList();
            if (this.getConfig().isEnforceReferentialIntegrityOnDelete()) {
                this.myDeleteConflictService.validateOkToDelete(deleteConflicts, entity, true, theRequest, new TransactionDetails());
            }
            DeleteConflictUtil.validateDeleteConflictsEmptyOrThrowException((FhirContext)this.getContext(), (DeleteConflictList)deleteConflicts);
            IBaseOperationOutcome oo = this.createInfoOperationOutcome("Ok to delete");
            return new MethodOutcome((IIdType)new IdDt(theId.getValue()), oo);
        }
        FhirValidator validator = this.getContext().newValidator();
        validator.setInterceptorBroadcaster(CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest));
        validator.registerValidatorModule((IValidatorModule)this.getInstanceValidator());
        validator.registerValidatorModule((IValidatorModule)new IdChecker(theMode));
        IBaseResource resourceToValidateById = null;
        if (theId != null && theId.hasResourceType() && theId.hasIdPart()) {
            Class type = this.getContext().getResourceDefinition(theId.getResourceType()).getImplementingClass();
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDaoOrNull(type);
            resourceToValidateById = dao.read(theId, theRequest);
        }
        ValidationOptions options = new ValidationOptions().addProfileIfNotBlank(theProfile);
        if (theResource == null) {
            if (resourceToValidateById == null) {
                String msg = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "cantValidateWithNoResource", new Object[0]);
                throw new InvalidRequestException(Msg.code((int)992) + msg);
            }
            result = validator.validateWithResult(resourceToValidateById, options);
        } else {
            result = StringUtils.isNotBlank((CharSequence)theRawResource) ? validator.validateWithResult(theRawResource, options) : validator.validateWithResult(theResource, options);
        }
        if (result.isSuccessful()) {
            MethodOutcome retVal = new MethodOutcome();
            retVal.setOperationOutcome(result.toOperationOutcome());
            return retVal;
        }
        throw new PreconditionFailedException(Msg.code((int)993) + "Validation failed", result.toOperationOutcome());
    }

    public RuntimeResourceDefinition validateCriteriaAndReturnResourceDefinition(String criteria) {
        if (criteria == null || criteria.trim().isEmpty()) {
            throw new IllegalArgumentException(Msg.code((int)994) + "Criteria cannot be empty");
        }
        String resourceName = criteria.contains("?") ? criteria.substring(0, criteria.indexOf("?")) : criteria;
        return this.getContext().getResourceDefinition(resourceName);
    }

    private void validateGivenIdIsAppropriateToRetrieveResource(IIdType theId, BaseHasResource entity) {
        if (entity.getForcedId() != null && this.getConfig().getResourceClientIdStrategy() != DaoConfig.ClientIdStrategyEnum.ANY && theId.isIdPartValidLong()) {
            throw new ResourceNotFoundException(Msg.code((int)2000) + theId);
        }
    }

    private void validateResourceType(BaseHasResource entity) {
        BaseHapiFhirResourceDao.validateResourceType(entity, this.myResourceName);
    }

    private void validateResourceTypeAndThrowInvalidRequestException(IIdType theId) {
        if (theId.hasResourceType() && !theId.getResourceType().equals(this.myResourceName)) {
            throw new InvalidRequestException(Msg.code((int)996) + "Incorrect resource type (" + theId.getResourceType() + ") for this DAO, wanted: " + this.myResourceName);
        }
    }

    @VisibleForTesting
    public void setIdHelperSvcForUnitTest(IIdHelperService theIdHelperService) {
        this.myIdHelperService = theIdHelperService;
    }

    private static class IdChecker
    implements IValidatorModule {
        private final ValidationModeEnum myMode;

        IdChecker(ValidationModeEnum theMode) {
            this.myMode = theMode;
        }

        public void validateResource(IValidationContext<IBaseResource> theCtx) {
            boolean hasId = ((IBaseResource)theCtx.getResource()).getIdElement().hasIdPart();
            if (this.myMode == ValidationModeEnum.CREATE) {
                if (hasId) {
                    throw new UnprocessableEntityException(Msg.code((int)997) + "Resource has an ID - ID must not be populated for a FHIR create");
                }
            } else if (this.myMode == ValidationModeEnum.UPDATE && !hasId) {
                throw new UnprocessableEntityException(Msg.code((int)998) + "Resource has no ID - ID must be populated for a FHIR update");
            }
        }
    }
}

