/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.jpa.dao.TransactionProcessor;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.search.builder.SearchBuilder;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseHapiFhirSystemDao<T extends IBaseBundle, MT>
extends BaseHapiFhirDao<IBaseResource>
implements IFhirSystemDao<T, MT> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseHapiFhirSystemDao.class);
    public static final Predicate[] EMPTY_PREDICATE_ARRAY = new Predicate[0];
    public ResourceCountCache myResourceCountsCache;
    @Autowired
    private TransactionProcessor myTransactionProcessor;
    @Autowired
    private ApplicationContext myApplicationContext;

    @VisibleForTesting
    public void setTransactionProcessorForUnitTest(TransactionProcessor theTransactionProcessor) {
        this.myTransactionProcessor = theTransactionProcessor;
    }

    @Override
    @PostConstruct
    public void start() {
        super.start();
        this.myTransactionProcessor.setDao(this);
    }

    @Transactional(propagation=Propagation.NEVER)
    public ExpungeOutcome expunge(ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        this.validateExpungeEnabled(theExpungeOptions);
        return this.myExpungeService.expunge(null, null, theExpungeOptions, theRequestDetails);
    }

    private void validateExpungeEnabled(ExpungeOptions theExpungeOptions) {
        if (!this.getConfig().isExpungeEnabled()) {
            throw new MethodNotAllowedException(Msg.code((int)2080) + "$expunge is not enabled on this server");
        }
        if (theExpungeOptions.isExpungeEverything() && !this.getConfig().isAllowMultipleDelete()) {
            throw new MethodNotAllowedException(Msg.code((int)2081) + "Multiple delete is not enabled on this server");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Long> getResourceCounts() {
        HashMap<String, Long> retVal = new HashMap<String, Long>();
        List<Map<?, ?>> counts = this.myResourceTableDao.getResourceCounts();
        for (Map<?, ?> next : counts) {
            retVal.put(next.get("type").toString(), Long.parseLong(next.get("count").toString()));
        }
        return retVal;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    @Nullable
    public Map<String, Long> getResourceCountsFromCache() {
        if (this.myResourceCountsCache == null) {
            this.myResourceCountsCache = (ResourceCountCache)this.myApplicationContext.getBean("myResourceCountsCache", ResourceCountCache.class);
        }
        return this.myResourceCountsCache.get();
    }

    public IBundleProvider history(Date theSince, Date theUntil, Integer theOffset, RequestDetails theRequestDetails) {
        if (theRequestDetails != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequestDetails);
            this.notifyInterceptors(RestOperationTypeEnum.HISTORY_SYSTEM, requestDetails);
        }
        StopWatch w = new StopWatch();
        IBundleProvider retVal = super.history(theRequestDetails, null, null, theSince, theUntil, theOffset);
        ourLog.info("Processed global history in {}ms", (Object)w.getMillisAndRestart());
        return retVal;
    }

    @Transactional(propagation=Propagation.NEVER)
    public T transaction(RequestDetails theRequestDetails, T theRequest) {
        return (T)this.myTransactionProcessor.transaction(theRequestDetails, (IBaseBundle)theRequest, false);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public T transactionNested(RequestDetails theRequestDetails, T theRequest) {
        return (T)this.myTransactionProcessor.transaction(theRequestDetails, (IBaseBundle)theRequest, true);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void preFetchResources(List<ResourcePersistentId> theResolvedIds) {
        List pids = theResolvedIds.stream().map(t -> t.getIdAsLong()).collect(Collectors.toList());
        new QueryChunker().chunk(pids, ids -> {
            if (ids.size() >= 2) {
                ArrayList<ResourceTable> loadedResourceTableEntries = new ArrayList<ResourceTable>();
                this.preFetchIndexes((List<Long>)ids, "forcedId", "myForcedId", (List<ResourceTable>)loadedResourceTableEntries);
                List<Long> entityIds = loadedResourceTableEntries.stream().filter(t -> t.isParamsStringPopulated()).map(t -> t.getId()).collect(Collectors.toList());
                if (entityIds.size() > 0) {
                    this.preFetchIndexes(entityIds, "string", "myParamsString", null);
                }
                if ((entityIds = loadedResourceTableEntries.stream().filter(t -> t.isParamsTokenPopulated()).map(t -> t.getId()).collect(Collectors.toList())).size() > 0) {
                    this.preFetchIndexes(entityIds, "token", "myParamsToken", null);
                }
                if ((entityIds = loadedResourceTableEntries.stream().filter(t -> t.isParamsDatePopulated()).map(t -> t.getId()).collect(Collectors.toList())).size() > 0) {
                    this.preFetchIndexes(entityIds, "date", "myParamsDate", null);
                }
                if ((entityIds = loadedResourceTableEntries.stream().filter(t -> t.isParamsQuantityPopulated()).map(t -> t.getId()).collect(Collectors.toList())).size() > 0) {
                    this.preFetchIndexes(entityIds, "quantity", "myParamsQuantity", null);
                }
                if ((entityIds = loadedResourceTableEntries.stream().filter(t -> t.isHasLinks()).map(t -> t.getId()).collect(Collectors.toList())).size() > 0) {
                    this.preFetchIndexes(entityIds, "resourceLinks", "myResourceLinks", null);
                }
                if ((entityIds = loadedResourceTableEntries.stream().filter(t -> t.isHasTags()).map(t -> t.getId()).collect(Collectors.toList())).size() > 0) {
                    this.myResourceTagDao.findByResourceIds(entityIds);
                    this.preFetchIndexes(entityIds, "tags", "myTags", null);
                }
                entityIds = loadedResourceTableEntries.stream().map(t -> t.getId()).collect(Collectors.toList());
                if (this.myDaoConfig.getIndexMissingFields() == DaoConfig.IndexEnabledEnum.ENABLED) {
                    this.preFetchIndexes(entityIds, "searchParamPresence", "mySearchParamPresents", null);
                }
                new QueryChunker<ResourceTable>().chunk(loadedResourceTableEntries, SearchBuilder.getMaximumPageSize() / 2, entries -> {
                    Map<Long, ResourceTable> entities = entries.stream().collect(Collectors.toMap(t -> t.getId(), t -> t));
                    CriteriaBuilder b = this.myEntityManager.getCriteriaBuilder();
                    CriteriaQuery q = b.createQuery(ResourceHistoryTable.class);
                    Root from = q.from(ResourceHistoryTable.class);
                    from.fetch("myProvenance", JoinType.LEFT);
                    ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
                    for (ResourceTable next : entries) {
                        Predicate resId = b.equal((Expression)from.get("myResourceId"), (Object)next.getId());
                        Predicate resVer = b.equal((Expression)from.get("myResourceVersion"), (Object)next.getVersion());
                        orPredicates.add(b.and((Expression)resId, (Expression)resVer));
                    }
                    q.where((Expression)b.or(orPredicates.toArray(EMPTY_PREDICATE_ARRAY)));
                    List resultList = this.myEntityManager.createQuery(q).getResultList();
                    for (ResourceHistoryTable next : resultList) {
                        ResourceTable nextEntity = entities.get(next.getResourceId());
                        if (nextEntity == null) continue;
                        nextEntity.setCurrentVersionEntity(next);
                    }
                });
            }
        });
    }

    private void preFetchIndexes(List<Long> theIds, String typeDesc, String fieldName, @Nullable List<ResourceTable> theEntityListToPopulate) {
        new QueryChunker<Long>().chunk(theIds, ids -> {
            TypedQuery query = this.myEntityManager.createQuery("FROM ResourceTable r LEFT JOIN FETCH r." + fieldName + " WHERE r.myId IN ( :IDS )", ResourceTable.class);
            query.setParameter("IDS", ids);
            List indexFetchOutcome = query.getResultList();
            ourLog.debug("Pre-fetched {} {}} indexes", (Object)indexFetchOutcome.size(), (Object)typeDesc);
            if (theEntityListToPopulate != null) {
                theEntityListToPopulate.addAll(indexFetchOutcome);
            }
        });
    }

    @Nullable
    protected String getResourceName() {
        return null;
    }
}

