/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoSearchParameter;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.r4.FhirResourceDaoSearchParameterR4;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.dstu2.resource.SearchParameter;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_40;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;

public class FhirResourceDaoSearchParameterDstu2
extends BaseHapiFhirResourceDao<SearchParameter>
implements IFhirResourceDaoSearchParameter<SearchParameter> {
    @Autowired
    private ISearchParamExtractor mySearchParamExtractor;
    private FhirContext myDstu2Hl7OrgContext = FhirContext.forDstu2Hl7Org();

    protected void reindexAffectedResources(SearchParameter theResource, RequestDetails theRequestDetails) {
        Boolean reindex = theResource != null ? CURRENTLY_REINDEXING.get((IResource)theResource) : null;
        String expression = theResource != null ? theResource.getXpath() : null;
        ArrayList base = theResource != null ? Lists.newArrayList((Object[])new String[]{theResource.getBase()}) : null;
        this.requestReindexForRelatedResources(reindex, base, theRequestDetails);
    }

    @Override
    protected void postPersist(ResourceTable theEntity, SearchParameter theResource, RequestDetails theRequestDetails) {
        super.postPersist(theEntity, theResource, theRequestDetails);
        this.reindexAffectedResources(theResource, theRequestDetails);
    }

    @Override
    protected void postUpdate(ResourceTable theEntity, SearchParameter theResource, RequestDetails theRequestDetails) {
        super.postUpdate(theEntity, theResource, theRequestDetails);
        this.reindexAffectedResources(theResource, theRequestDetails);
    }

    @Override
    protected void preDelete(SearchParameter theResourceToDelete, ResourceTable theEntityToDelete, RequestDetails theRequestDetails) {
        super.preDelete(theResourceToDelete, theEntityToDelete, theRequestDetails);
        this.reindexAffectedResources(theResourceToDelete, theRequestDetails);
    }

    @Override
    protected void validateResourceForStorage(SearchParameter theResource, ResourceTable theEntityToSave) {
        super.validateResourceForStorage(theResource, theEntityToSave);
        String encoded = this.getContext().newJsonParser().encodeResourceToString((IBaseResource)theResource);
        org.hl7.fhir.dstu2.model.SearchParameter hl7Org = (org.hl7.fhir.dstu2.model.SearchParameter)this.myDstu2Hl7OrgContext.newJsonParser().parseResource(org.hl7.fhir.dstu2.model.SearchParameter.class, encoded);
        org.hl7.fhir.r4.model.SearchParameter convertedSp = (org.hl7.fhir.r4.model.SearchParameter)VersionConvertorFactory_10_40.convertResource((Resource)hl7Org, (BaseAdvisor_10_40)new BaseAdvisor_10_40(Boolean.valueOf(false)));
        if (StringUtils.isBlank((CharSequence)convertedSp.getExpression()) && StringUtils.isNotBlank((CharSequence)hl7Org.getXpath())) {
            convertedSp.setExpression(hl7Org.getXpath());
        }
        FhirResourceDaoSearchParameterR4.validateSearchParam(convertedSp, this.getContext(), this.getConfig(), this.mySearchParamRegistry, this.mySearchParamExtractor);
    }
}

