/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.IHSearchEventListener;
import ca.uhn.fhir.jpa.dao.search.ExtendedHSearchClauseBuilder;
import ca.uhn.fhir.jpa.dao.search.ExtendedHSearchIndexExtractor;
import ca.uhn.fhir.jpa.dao.search.ExtendedHSearchResourceProjection;
import ca.uhn.fhir.jpa.dao.search.ExtendedHSearchSearchBuilder;
import ca.uhn.fhir.jpa.dao.search.IHSearchSortHelper;
import ca.uhn.fhir.jpa.dao.search.LastNOperation;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.search.ExtendedHSearchIndexData;
import ca.uhn.fhir.jpa.search.autocomplete.ValueSetAutocompleteOptions;
import ca.uhn.fhir.jpa.search.autocomplete.ValueSetAutocompleteSearch;
import ca.uhn.fhir.jpa.search.builder.ISearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.SearchQueryExecutors;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.search.backend.elasticsearch.ElasticsearchExtension;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactoryExtension;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQueryOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.mapper.orm.Search;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.util.common.SearchException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

public class FulltextSearchSvcImpl
implements IFulltextSearchSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(FulltextSearchSvcImpl.class);
    private static final int DEFAULT_MAX_NON_PAGED_SIZE = 500;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired
    private PlatformTransactionManager myTxManager;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    ISearchParamExtractor mySearchParamExtractor;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    ModelConfig myModelConfig;
    @Autowired
    private IHSearchSortHelper myExtendedFulltextSortHelper;
    private final ExtendedHSearchSearchBuilder myAdvancedIndexQueryBuilder = new ExtendedHSearchSearchBuilder();
    @Autowired(required=false)
    private IHSearchEventListener myHSearchEventListener;
    private Boolean ourDisabled;

    @Override
    public ExtendedHSearchIndexData extractLuceneIndexData(IBaseResource theResource, ResourceIndexedSearchParams theNewParams) {
        String resourceType = this.myFhirContext.getResourceType(theResource);
        ResourceSearchParams activeSearchParams = this.mySearchParamRegistry.getActiveSearchParams(resourceType);
        ExtendedHSearchIndexExtractor extractor = new ExtendedHSearchIndexExtractor(this.myDaoConfig, this.myFhirContext, activeSearchParams, this.mySearchParamExtractor, this.myModelConfig);
        return extractor.extract(theResource, theNewParams);
    }

    @Override
    public boolean supportsSomeOf(SearchParameterMap myParams) {
        boolean requiresHibernateSearchAccess = myParams.containsKey("_content") || myParams.containsKey("_text") || myParams.isLastN();
        return requiresHibernateSearchAccess |= this.myDaoConfig.isAdvancedHSearchIndexing() && this.myAdvancedIndexQueryBuilder.isSupportsSomeOf(myParams);
    }

    @Override
    public void reindex(ResourceTable theEntity) {
        SearchIndexingPlan plan = this.getSearchSession().indexingPlan();
        plan.addOrUpdate((Object)theEntity);
    }

    @Override
    public ISearchQueryExecutor searchNotScrolled(String theResourceName, SearchParameterMap theParams, Integer theMaxResultsToFetch) {
        return this.doSearch(theResourceName, theParams, null, theMaxResultsToFetch);
    }

    private ISearchQueryExecutor doSearch(String theResourceType, SearchParameterMap theParams, ResourcePersistentId theReferencingPid, Integer theMaxResultsToFetch) {
        int offset = theParams.getOffset() == null ? 0 : theParams.getOffset();
        int count = this.getMaxFetchSize(theParams, theMaxResultsToFetch);
        List queryFetchResult = this.getSearchQueryOptionsStep(theResourceType, theParams, theReferencingPid).fetchHits(Integer.valueOf(offset), Integer.valueOf(count));
        theParams.setOffset(null);
        return SearchQueryExecutors.from(queryFetchResult);
    }

    private int getMaxFetchSize(SearchParameterMap theParams, Integer theMax) {
        if (theParams.getCount() != null) {
            return theParams.getCount();
        }
        if (theMax != null) {
            return theMax;
        }
        return 500;
    }

    private SearchQueryOptionsStep<?, Long, SearchLoadingOptionsStep, ?, ?> getSearchQueryOptionsStep(String theResourceType, SearchParameterMap theParams, ResourcePersistentId theReferencingPid) {
        this.dispatchEvent(IHSearchEventListener.HSearchEventType.SEARCH);
        SearchQueryOptionsStep query = this.getSearchSession().search(ResourceTable.class).select(f -> f.composite(docRef -> Long.valueOf(docRef.id()), (ProjectionFinalStep)f.documentReference())).where(f -> this.buildWhereClause((SearchPredicateFactory)f, theResourceType, theParams, theReferencingPid));
        if (theParams.getSort() != null) {
            query.sort(f -> this.myExtendedFulltextSortHelper.getSortClauses((SearchSortFactory)f, theParams.getSort(), theResourceType));
            theParams.setSort(null);
        }
        return query;
    }

    private PredicateFinalStep buildWhereClause(SearchPredicateFactory f, String theResourceType, SearchParameterMap theParams, ResourcePersistentId theReferencingPid) {
        return f.bool(b -> {
            ExtendedHSearchClauseBuilder builder = new ExtendedHSearchClauseBuilder(this.myFhirContext, this.myModelConfig, (BooleanPredicateClausesStep<?>)b, f);
            List contentAndTerms = theParams.remove("_content");
            builder.addStringTextSearch("_content", contentAndTerms);
            List textAndTerms = theParams.remove("_text");
            builder.addStringTextSearch("_text", textAndTerms);
            if (theReferencingPid != null) {
                b.must((PredicateFinalStep)f.match().field("myResourceLinksField").matching((Object)theReferencingPid.toString()));
            }
            if (StringUtils.isNotBlank((CharSequence)theResourceType)) {
                builder.addResourceTypeClause(theResourceType);
            }
            if (this.myDaoConfig.isAdvancedHSearchIndexing() && theParams.getEverythingMode() == null) {
                this.myAdvancedIndexQueryBuilder.addAndConsumeAdvancedQueryClauses(builder, theResourceType, theParams, this.mySearchParamRegistry);
            }
        });
    }

    @Nonnull
    private SearchSession getSearchSession() {
        return Search.session((EntityManager)this.myEntityManager);
    }

    private List<ResourcePersistentId> convertLongsToResourcePersistentIds(List<Long> theLongPids) {
        return theLongPids.stream().map(ResourcePersistentId::new).collect(Collectors.toList());
    }

    @Override
    public List<ResourcePersistentId> everything(String theResourceName, SearchParameterMap theParams, ResourcePersistentId theReferencingPid) {
        List<ResourcePersistentId> retVal = this.toList(this.doSearch(null, theParams, theReferencingPid, 10000), 10000L);
        if (theReferencingPid != null) {
            retVal.add(theReferencingPid);
        }
        return retVal;
    }

    @Override
    public boolean isDisabled() {
        Boolean retVal = this.ourDisabled;
        if (retVal == null) {
            this.ourDisabled = retVal = (Boolean)new TransactionTemplate(this.myTxManager).execute(t -> {
                try {
                    SearchSession searchSession = this.getSearchSession();
                    searchSession.search(ResourceTable.class);
                    return Boolean.FALSE;
                }
                catch (Exception e) {
                    ourLog.trace("FullText test failed", (Throwable)e);
                    ourLog.debug("Hibernate Search (Lucene) appears to be disabled on this server, fulltext will be disabled");
                    return Boolean.TRUE;
                }
            });
        }
        assert (retVal != null);
        return retVal;
    }

    @Override
    @Transactional
    public List<ResourcePersistentId> search(String theResourceName, SearchParameterMap theParams) {
        return this.toList(this.doSearch(theResourceName, theParams, null, 500), 500L);
    }

    private List<ResourcePersistentId> toList(ISearchQueryExecutor theSearchResultStream, long theMaxSize) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(theSearchResultStream, 0), false).map(ResourcePersistentId::new).limit(theMaxSize).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public IBaseResource tokenAutocompleteValueSetSearch(ValueSetAutocompleteOptions theOptions) {
        this.ensureElastic();
        ValueSetAutocompleteSearch autocomplete = new ValueSetAutocompleteSearch(this.myFhirContext, this.myModelConfig, this.getSearchSession());
        this.dispatchEvent(IHSearchEventListener.HSearchEventType.SEARCH);
        return autocomplete.search(theOptions);
    }

    private void ensureElastic() {
        try {
            this.getSearchSession().scope(ResourceTable.class).aggregation().extension((SearchAggregationFactoryExtension)ElasticsearchExtension.get());
        }
        catch (SearchException e) {
            throw new IllegalStateException(Msg.code((int)2070) + "This operation requires Elasticsearch.  Lucene is not supported.");
        }
    }

    @Override
    public List<ResourcePersistentId> lastN(SearchParameterMap theParams, Integer theMaximumResults) {
        this.ensureElastic();
        this.dispatchEvent(IHSearchEventListener.HSearchEventType.SEARCH);
        List<Long> pidList = new LastNOperation(this.getSearchSession(), this.myFhirContext, this.myModelConfig, this.mySearchParamRegistry).executeLastN(theParams, theMaximumResults);
        return this.convertLongsToResourcePersistentIds(pidList);
    }

    @Override
    public List<IBaseResource> getResources(Collection<Long> thePids) {
        if (thePids.isEmpty()) {
            return Collections.emptyList();
        }
        SearchSession session = this.getSearchSession();
        this.dispatchEvent(IHSearchEventListener.HSearchEventType.SEARCH);
        List rawResourceDataList = session.search(ResourceTable.class).select(this::buildResourceSelectClause).where(f -> f.id().matchingAny(thePids)).fetchAllHits();
        ArrayList<Long> pidList = new ArrayList<Long>(thePids);
        List<ExtendedHSearchResourceProjection> orderedAsPidsResourceDataList = rawResourceDataList.stream().sorted(Ordering.explicit(pidList).onResultOf(ExtendedHSearchResourceProjection::getPid)).collect(Collectors.toList());
        return this.resourceProjectionsToResources(orderedAsPidsResourceDataList);
    }

    @Nonnull
    private List<IBaseResource> resourceProjectionsToResources(List<ExtendedHSearchResourceProjection> theResourceDataList) {
        IParser parser = this.myFhirContext.newJsonParser();
        return theResourceDataList.stream().map(p -> p.toResource(parser)).collect(Collectors.toList());
    }

    private CompositeProjectionOptionsStep<?, ExtendedHSearchResourceProjection> buildResourceSelectClause(SearchProjectionFactory<EntityReference, ResourceTable> f) {
        return f.composite(ExtendedHSearchResourceProjection::new, (ProjectionFinalStep)f.field("myId", Long.class), (ProjectionFinalStep)f.field("myForcedId", String.class), (ProjectionFinalStep)f.field("myRawResource", String.class));
    }

    @Override
    public long count(String theResourceName, SearchParameterMap theParams) {
        SearchQueryOptionsStep<?, Long, SearchLoadingOptionsStep, ?, ?> queryOptionsStep = this.getSearchQueryOptionsStep(theResourceName, theParams, null);
        return queryOptionsStep.fetchTotalHitCount();
    }

    @Override
    @Transactional(readOnly=true)
    public List<IBaseResource> searchForResources(String theResourceType, SearchParameterMap theParams) {
        int limit;
        int offset = 0;
        int n = limit = theParams.getCount() == null ? 50 : theParams.getCount();
        if (theParams.getOffset() != null && theParams.getOffset() != 0) {
            offset = theParams.getOffset();
            theParams.setOffset(null);
        }
        this.dispatchEvent(IHSearchEventListener.HSearchEventType.SEARCH);
        SearchQueryOptionsStep query = this.getSearchSession().search(ResourceTable.class).select(this::buildResourceSelectClause).where(f -> this.buildWhereClause((SearchPredicateFactory)f, theResourceType, theParams, null));
        if (theParams.getSort() != null && offset == 0) {
            query.sort(f -> this.myExtendedFulltextSortHelper.getSortClauses((SearchSortFactory)f, theParams.getSort(), theResourceType));
        }
        List extendedLuceneResourceProjections = query.fetchHits(Integer.valueOf(offset), Integer.valueOf(limit));
        return this.resourceProjectionsToResources(extendedLuceneResourceProjections);
    }

    @Override
    public boolean supportsAllOf(SearchParameterMap theParams) {
        return this.myAdvancedIndexQueryBuilder.isSupportsAllOf(theParams);
    }

    private void dispatchEvent(IHSearchEventListener.HSearchEventType theEventType) {
        if (this.myHSearchEventListener != null) {
            this.myHSearchEventListener.hsearchEvent(theEventType);
        }
    }

    @Override
    public void deleteIndexedDocumentsByTypeAndId(Class theClazz, List<Object> theGivenIds) {
        SearchSession session = Search.session((EntityManager)this.myEntityManager);
        SearchIndexingPlan indexingPlan = session.indexingPlan();
        for (Object givenId : theGivenIds) {
            indexingPlan.purge(theClazz, givenId, null);
        }
        indexingPlan.process();
        indexingPlan.execute();
    }
}

