/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.util.CodeSystemHash;
import ca.uhn.fhir.jpa.search.lastn.IElasticsearchSvc;
import ca.uhn.fhir.jpa.search.lastn.json.CodeJson;
import ca.uhn.fhir.jpa.search.lastn.json.ObservationJson;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.PathAndRef;
import ca.uhn.fhir.parser.IParser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;

public class ObservationLastNIndexPersistSvc {
    @Autowired
    private ISearchParamExtractor mySearchParameterExtractor;
    @Autowired(required=false)
    private IElasticsearchSvc myElasticsearchSvc;
    @Autowired
    private DaoConfig myConfig;
    @Autowired
    private FhirContext myContext;

    public void indexObservation(IBaseResource theResource) {
        List observationCodeCodeableConcepts;
        if (this.myElasticsearchSvc == null) {
            return;
        }
        List subjectReferenceElement = this.mySearchParameterExtractor.extractValues("Observation.subject", theResource);
        String subjectId = subjectReferenceElement.stream().map(refElement -> this.mySearchParameterExtractor.extractReferenceLinkFromResource(refElement, "Observation.subject")).filter(Objects::nonNull).map(PathAndRef::getRef).filter(Objects::nonNull).map(subjectRef -> subjectRef.getReferenceElement().getValue()).filter(Objects::nonNull).findFirst().orElse(null);
        Date effectiveDtm = null;
        List effectiveDateElement = this.mySearchParameterExtractor.extractValues("Observation.effective", theResource);
        if (effectiveDateElement.size() > 0) {
            effectiveDtm = this.mySearchParameterExtractor.extractDateFromResource((IBase)effectiveDateElement.get(0), "Observation.effective");
        }
        if ((observationCodeCodeableConcepts = this.mySearchParameterExtractor.extractValues("Observation.code", theResource)).size() == 0) {
            return;
        }
        List observationCategoryCodeableConcepts = this.mySearchParameterExtractor.extractValues("Observation.category", theResource);
        this.createOrUpdateIndexedObservation(theResource, effectiveDtm, subjectId, observationCodeCodeableConcepts, observationCategoryCodeableConcepts);
    }

    private void createOrUpdateIndexedObservation(IBaseResource theResource, Date theEffectiveDtm, String theSubjectId, List<IBase> theObservationCodeCodeableConcepts, List<IBase> theObservationCategoryCodeableConcepts) {
        String resourcePID = theResource.getIdElement().getIdPart();
        ObservationJson indexedObservation = null;
        if (resourcePID != null) {
            indexedObservation = this.myElasticsearchSvc.getObservationDocument(resourcePID);
        }
        if (indexedObservation == null) {
            indexedObservation = new ObservationJson();
        }
        indexedObservation.setEffectiveDtm(theEffectiveDtm);
        indexedObservation.setIdentifier(resourcePID);
        if (this.myConfig.isStoreResourceInHSearchIndex()) {
            indexedObservation.setResource(this.encodeResource(theResource));
        }
        indexedObservation.setSubject(theSubjectId);
        this.addCodeToObservationIndex(theObservationCodeCodeableConcepts, indexedObservation);
        this.addCategoriesToObservationIndex(theObservationCategoryCodeableConcepts, indexedObservation);
        this.myElasticsearchSvc.createOrUpdateObservationIndex(resourcePID, indexedObservation);
    }

    private String encodeResource(IBaseResource theResource) {
        IParser parser = this.myContext.newJsonParser();
        return parser.encodeResourceToString(theResource);
    }

    private void addCodeToObservationIndex(List<IBase> theObservationCodeCodeableConcepts, ObservationJson theIndexedObservation) {
        String existingObservationCodeNormalizedId = this.getCodeCodeableConceptId(theObservationCodeCodeableConcepts.get(0));
        CodeJson codeableConceptField = this.getCodeCodeableConcept(theObservationCodeCodeableConcepts.get(0), existingObservationCodeNormalizedId);
        this.myElasticsearchSvc.createOrUpdateObservationCodeIndex(codeableConceptField.getCodeableConceptId(), codeableConceptField);
        theIndexedObservation.setCode(codeableConceptField);
    }

    private void addCategoriesToObservationIndex(List<IBase> observationCategoryCodeableConcepts, ObservationJson indexedObservation) {
        ArrayList<CodeJson> categoryCodeableConceptEntities = new ArrayList<CodeJson>();
        for (IBase categoryCodeableConcept : observationCategoryCodeableConcepts) {
            categoryCodeableConceptEntities.add(this.getCategoryCodeableConceptEntities(categoryCodeableConcept));
        }
        indexedObservation.setCategories(categoryCodeableConceptEntities);
    }

    private CodeJson getCategoryCodeableConceptEntities(IBase theValue) {
        String text = this.mySearchParameterExtractor.getDisplayTextFromCodeableConcept(theValue);
        CodeJson categoryCodeableConcept = new CodeJson();
        categoryCodeableConcept.setCodeableConceptText(text);
        List codings = this.mySearchParameterExtractor.getCodingsFromCodeableConcept(theValue);
        for (IBase nextCoding : codings) {
            this.addCategoryCoding(nextCoding, categoryCodeableConcept);
        }
        return categoryCodeableConcept;
    }

    private CodeJson getCodeCodeableConcept(IBase theValue, String observationCodeNormalizedId) {
        String text = this.mySearchParameterExtractor.getDisplayTextFromCodeableConcept(theValue);
        CodeJson codeCodeableConcept = new CodeJson();
        codeCodeableConcept.setCodeableConceptText(text);
        codeCodeableConcept.setCodeableConceptId(observationCodeNormalizedId);
        List codings = this.mySearchParameterExtractor.getCodingsFromCodeableConcept(theValue);
        for (IBase nextCoding : codings) {
            this.addCodeCoding(nextCoding, codeCodeableConcept);
        }
        return codeCodeableConcept;
    }

    private String getCodeCodeableConceptId(IBase theValue) {
        List codings = this.mySearchParameterExtractor.getCodingsFromCodeableConcept(theValue);
        Optional<String> codeCodeableConceptIdOptional = Optional.empty();
        for (IBase nextCoding : codings) {
            ResourceIndexedSearchParamToken param = this.mySearchParameterExtractor.createSearchParamForCoding("Observation", new RuntimeSearchParam(null, null, "code", null, null, null, null, null, null, null), nextCoding);
            if (param == null) continue;
            String system = param.getSystem();
            String code = param.getValue();
            String text = this.mySearchParameterExtractor.getDisplayTextForCoding(nextCoding);
            String codeSystemHash = String.valueOf(CodeSystemHash.hashCodeSystem((String)system, (String)code));
            CodeJson codeCodeableConceptDocument = this.myElasticsearchSvc.getObservationCodeDocument(codeSystemHash, text);
            if (codeCodeableConceptDocument == null) continue;
            codeCodeableConceptIdOptional = Optional.of(codeCodeableConceptDocument.getCodeableConceptId());
            break;
        }
        return codeCodeableConceptIdOptional.orElse(UUID.randomUUID().toString());
    }

    private void addCategoryCoding(IBase theValue, CodeJson theCategoryCodeableConcept) {
        ResourceIndexedSearchParamToken param = this.mySearchParameterExtractor.createSearchParamForCoding("Observation", new RuntimeSearchParam(null, null, "category", null, null, null, null, null, null, null), theValue);
        if (param != null) {
            String system = param.getSystem();
            String code = param.getValue();
            String text = this.mySearchParameterExtractor.getDisplayTextForCoding(theValue);
            theCategoryCodeableConcept.addCoding(system, code, text);
        }
    }

    private void addCodeCoding(IBase theValue, CodeJson theObservationCode) {
        ResourceIndexedSearchParamToken param = this.mySearchParameterExtractor.createSearchParamForCoding("Observation", new RuntimeSearchParam(null, null, "code", null, null, null, null, null, null, null), theValue);
        if (param != null) {
            String system = param.getSystem();
            String code = param.getValue();
            String text = this.mySearchParameterExtractor.getDisplayTextForCoding(theValue);
            theObservationCode.addCoding(system, code, text);
        }
    }

    public void deleteObservationIndex(IBasePersistedResource theEntity) {
        if (this.myElasticsearchSvc == null) {
            return;
        }
        ObservationJson deletedObservationLastNEntity = this.myElasticsearchSvc.getObservationDocument(theEntity.getIdDt().getIdPart());
        if (deletedObservationLastNEntity != null) {
            this.myElasticsearchSvc.deleteObservationDocument(deletedObservationLastNEntity.getIdentifier());
        }
    }
}

