/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.config.HapiFhirHibernateJpaDialect;
import ca.uhn.fhir.jpa.dao.BaseTransactionProcessor;
import ca.uhn.fhir.jpa.dao.EntriesToProcessMap;
import ca.uhn.fhir.jpa.dao.ITransactionProcessorVersionAdapter;
import ca.uhn.fhir.jpa.dao.IdSubstitutionMap;
import ca.uhn.fhir.jpa.dao.MatchResourceUrlService;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.internal.SessionImpl;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class TransactionProcessor
extends BaseTransactionProcessor {
    public static final Pattern SINGLE_PARAMETER_MATCH_URL_PATTERN = Pattern.compile("^[^?]+[?][a-z0-9-]+=[^&,]+$");
    private static final Logger ourLog = LoggerFactory.getLogger(TransactionProcessor.class);
    @Autowired
    private ApplicationContext myApplicationContext;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired(required=false)
    private HapiFhirHibernateJpaDialect myHapiFhirHibernateJpaDialect;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private MatchResourceUrlService myMatchResourceUrlService;
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionSvc;

    public void setEntityManagerForUnitTest(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
    }

    protected void validateDependencies() {
        super.validateDependencies();
        Validate.notNull((Object)this.myEntityManager);
    }

    @VisibleForTesting
    public void setFhirContextForUnitTest(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    protected EntriesToProcessMap doTransactionWriteOperations(RequestDetails theRequest, String theActionName, TransactionDetails theTransactionDetails, Set<IIdType> theAllIds, IdSubstitutionMap theIdSubstitutions, Map<IIdType, DaoMethodOutcome> theIdToPersistedOutcome, IBaseBundle theResponse, IdentityHashMap<IBase, Integer> theOriginalRequestOrder, List<IBase> theEntries, StopWatch theTransactionStopWatch) {
        ITransactionProcessorVersionAdapter versionAdapter = this.getVersionAdapter();
        RequestPartitionId requestPartitionId = null;
        if (!this.myPartitionSettings.isPartitioningEnabled()) {
            requestPartitionId = RequestPartitionId.allPartitions();
        } else {
            HashSet<RequestPartitionId> requestPartitionIdsForAllEntries = new HashSet<RequestPartitionId>();
            for (IBase nextEntry : theEntries) {
                IBaseResource resource = versionAdapter.getResource(nextEntry);
                if (resource == null) continue;
                RequestPartitionId requestPartitionId2 = this.myRequestPartitionSvc.determineCreatePartitionForRequest(theRequest, resource, this.myFhirContext.getResourceType(resource));
                requestPartitionIdsForAllEntries.add(requestPartitionId2);
            }
            if (requestPartitionIdsForAllEntries.size() == 1) {
                requestPartitionId = (RequestPartitionId)requestPartitionIdsForAllEntries.iterator().next();
            }
        }
        if (requestPartitionId != null) {
            HashSet<String> foundIds = new HashSet<String>();
            ArrayList<Long> idsToPreFetch = new ArrayList<Long>();
            ArrayList<IIdType> idsToPreResolve = new ArrayList<IIdType>();
            for (IBase iBase : theEntries) {
                String fullUrl;
                boolean isPlaceholder;
                IBaseResource iBaseResource = versionAdapter.getResource(iBase);
                if (iBaseResource == null || (isPlaceholder = StringUtils.defaultString((String)(fullUrl = versionAdapter.getFullUrl(iBase))).startsWith("urn:")) || !iBaseResource.getIdElement().hasIdPart() || !iBaseResource.getIdElement().hasResourceType()) continue;
                idsToPreResolve.add(iBaseResource.getIdElement());
            }
            List outcome = this.myIdHelperService.resolveResourcePersistentIdsWithCache(requestPartitionId, idsToPreResolve);
            for (ResourcePersistentId resourcePersistentId : outcome) {
                foundIds.add(resourcePersistentId.getAssociatedResourceId().toUnqualifiedVersionless().getValue());
                theTransactionDetails.addResolvedResourceId(resourcePersistentId.getAssociatedResourceId(), resourcePersistentId);
                if (this.myDaoConfig.getResourceClientIdStrategy() == DaoConfig.ClientIdStrategyEnum.ANY && resourcePersistentId.getAssociatedResourceId().isIdPartValidLong()) continue;
                idsToPreFetch.add(resourcePersistentId.getIdAsLong());
            }
            for (IIdType iIdType : idsToPreResolve) {
                if (foundIds.contains(iIdType.toUnqualifiedVersionless().getValue())) continue;
                theTransactionDetails.addResolvedResourceId(iIdType.toUnqualifiedVersionless(), null);
            }
            ArrayList<MatchUrlToResolve> arrayList = new ArrayList<MatchUrlToResolve>();
            for (IBase nextEntry : theEntries) {
                SearchParameterMap matchUrlSearchMap;
                RuntimeResourceDefinition resourceDefinition;
                ResourcePersistentId cachedId;
                IBaseResource resource = versionAdapter.getResource(nextEntry);
                if (resource == null) continue;
                String verb = versionAdapter.getEntryRequestVerb(this.myFhirContext, nextEntry);
                String requestUrl = versionAdapter.getEntryRequestUrl(nextEntry);
                String requestIfNoneExist = versionAdapter.getEntryIfNoneExist(nextEntry);
                String resourceType = this.myFhirContext.getResourceType(resource);
                if ("PUT".equals(verb) && requestUrl != null && requestUrl.contains("?")) {
                    cachedId = this.myMatchResourceUrlService.processMatchUrlUsingCacheOnly(resourceType, requestUrl);
                    if (cachedId != null) {
                        idsToPreFetch.add(cachedId.getIdAsLong());
                        continue;
                    }
                    if (!SINGLE_PARAMETER_MATCH_URL_PATTERN.matcher(requestUrl).matches()) continue;
                    resourceDefinition = this.myFhirContext.getResourceDefinition(resource);
                    matchUrlSearchMap = this.myMatchUrlService.translateMatchUrl(requestUrl, resourceDefinition, new MatchUrlService.Flag[0]);
                    arrayList.add(new MatchUrlToResolve(requestUrl, matchUrlSearchMap, resourceDefinition));
                    continue;
                }
                if (!"POST".equals(verb) || requestIfNoneExist == null || !requestIfNoneExist.contains("?")) continue;
                cachedId = this.myMatchResourceUrlService.processMatchUrlUsingCacheOnly(resourceType, requestIfNoneExist);
                if (cachedId != null) {
                    idsToPreFetch.add(cachedId.getIdAsLong());
                    continue;
                }
                if (!SINGLE_PARAMETER_MATCH_URL_PATTERN.matcher(requestIfNoneExist).matches()) continue;
                resourceDefinition = this.myFhirContext.getResourceDefinition(resource);
                matchUrlSearchMap = this.myMatchUrlService.translateMatchUrl(requestIfNoneExist, resourceDefinition, new MatchUrlService.Flag[0]);
                arrayList.add(new MatchUrlToResolve(requestIfNoneExist, matchUrlSearchMap, resourceDefinition));
            }
            if (arrayList.size() > 0) {
                CriteriaBuilder criteriaBuilder = this.myEntityManager.getCriteriaBuilder();
                CriteriaQuery cq = criteriaBuilder.createQuery(ResourceIndexedSearchParamToken.class);
                Root from = cq.from(ResourceIndexedSearchParamToken.class);
                ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
                for (MatchUrlToResolve next : arrayList) {
                    Predicate hashPredicate;
                    List andList;
                    IQueryParameterType param;
                    Collection values = next.myMatchUrlSearchMap.values();
                    if (values.size() != 1 || !((param = (IQueryParameterType)((List)(andList = (List)values.iterator().next()).get(0)).get(0)) instanceof TokenParam) || (hashPredicate = this.buildHashPredicateFromTokenParam((TokenParam)param, requestPartitionId, criteriaBuilder, (Root<ResourceIndexedSearchParamToken>)from, next)) == null) continue;
                    if (this.myPartitionSettings.isPartitioningEnabled() && !this.myPartitionSettings.isIncludePartitionInSearchHashes()) {
                        Predicate partitionIdCriteria;
                        if (requestPartitionId.isDefaultPartition()) {
                            partitionIdCriteria = criteriaBuilder.isNull(from.get("myPartitionIdValue").as(Integer.class));
                            hashPredicate = criteriaBuilder.and((Expression)hashPredicate, (Expression)partitionIdCriteria);
                        } else if (!requestPartitionId.isAllPartitions()) {
                            partitionIdCriteria = from.get("myPartitionIdValue").as(Integer.class).in((Collection)requestPartitionId.getPartitionIds());
                            hashPredicate = criteriaBuilder.and((Expression)hashPredicate, (Expression)partitionIdCriteria);
                        }
                    }
                    orPredicates.add(hashPredicate);
                }
                if (orPredicates.size() > 1) {
                    cq.where((Expression)criteriaBuilder.or(orPredicates.toArray(IdHelperService.EMPTY_PREDICATE_ARRAY)));
                    Map<Long, List<MatchUrlToResolve>> hashToSearchMap = this.buildHashToSearchMap(arrayList);
                    TypedQuery query = this.myEntityManager.createQuery(cq);
                    List results = query.getResultList();
                    for (ResourceIndexedSearchParamToken nextResult : results) {
                        Optional<List<MatchUrlToResolve>> matchedSearch = Optional.ofNullable(hashToSearchMap.get(nextResult.getHashSystemAndValue()));
                        if (!matchedSearch.isPresent()) {
                            matchedSearch = Optional.ofNullable(hashToSearchMap.get(nextResult.getHashValue()));
                        }
                        matchedSearch.ifPresent(matchUrlsToResolve -> matchUrlsToResolve.forEach(matchUrl -> this.setSearchToResolvedAndPrefetchFoundResourcePid(theTransactionDetails, idsToPreFetch, nextResult, (MatchUrlToResolve)matchUrl)));
                    }
                    arrayList.stream().filter(match -> !match.myResolved).forEach(match -> {
                        ourLog.debug("Was unable to match url {} from database", (Object)match.myRequestUrl);
                        theTransactionDetails.addResolvedMatchUrl(match.myRequestUrl, TransactionDetails.NOT_FOUND);
                    });
                }
            }
            IFhirSystemDao iFhirSystemDao = (IFhirSystemDao)this.myApplicationContext.getBean(IFhirSystemDao.class);
            iFhirSystemDao.preFetchResources(ResourcePersistentId.fromLongList(idsToPreFetch));
        }
        return super.doTransactionWriteOperations(theRequest, theActionName, theTransactionDetails, theAllIds, theIdSubstitutions, theIdToPersistedOutcome, theResponse, theOriginalRequestOrder, theEntries, theTransactionStopWatch);
    }

    @Nullable
    private Predicate buildHashPredicateFromTokenParam(TokenParam theTokenParam, RequestPartitionId theRequestPartitionId, CriteriaBuilder cb, Root<ResourceIndexedSearchParamToken> from, MatchUrlToResolve theMatchUrl) {
        Predicate hashPredicate = null;
        if (StringUtils.isNotBlank((CharSequence)theTokenParam.getValue()) && StringUtils.isNotBlank((CharSequence)theTokenParam.getSystem())) {
            theMatchUrl.myHashSystemAndValue = ResourceIndexedSearchParamToken.calculateHashSystemAndValue((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)theRequestPartitionId, (String)theMatchUrl.myResourceDefinition.getName(), (String)((String)theMatchUrl.myMatchUrlSearchMap.keySet().iterator().next()), (String)theTokenParam.getSystem(), (String)theTokenParam.getValue());
            hashPredicate = cb.equal(from.get("myHashSystemAndValue").as(Long.class), (Object)theMatchUrl.myHashSystemAndValue);
        } else if (StringUtils.isNotBlank((CharSequence)theTokenParam.getValue())) {
            theMatchUrl.myHashValue = ResourceIndexedSearchParamToken.calculateHashValue((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)theRequestPartitionId, (String)theMatchUrl.myResourceDefinition.getName(), (String)((String)theMatchUrl.myMatchUrlSearchMap.keySet().iterator().next()), (String)theTokenParam.getValue());
            hashPredicate = cb.equal(from.get("myHashValue").as(Long.class), (Object)theMatchUrl.myHashValue);
        }
        return hashPredicate;
    }

    private Map<Long, List<MatchUrlToResolve>> buildHashToSearchMap(List<MatchUrlToResolve> searchParameterMapsToResolve) {
        HashMap<Long, List<MatchUrlToResolve>> hashToSearch = new HashMap<Long, List<MatchUrlToResolve>>();
        for (MatchUrlToResolve nextSearchParameterMap : searchParameterMapsToResolve) {
            List matchUrlsToResolve;
            if (nextSearchParameterMap.myHashSystemAndValue != null) {
                matchUrlsToResolve = hashToSearch.getOrDefault(nextSearchParameterMap.myHashSystemAndValue, new ArrayList());
                matchUrlsToResolve.add(nextSearchParameterMap);
                hashToSearch.put(nextSearchParameterMap.myHashSystemAndValue, matchUrlsToResolve);
            }
            if (nextSearchParameterMap.myHashValue == null) continue;
            matchUrlsToResolve = hashToSearch.getOrDefault(nextSearchParameterMap.myHashValue, new ArrayList());
            matchUrlsToResolve.add(nextSearchParameterMap);
            hashToSearch.put(nextSearchParameterMap.myHashValue, matchUrlsToResolve);
        }
        return hashToSearch;
    }

    private void setSearchToResolvedAndPrefetchFoundResourcePid(TransactionDetails theTransactionDetails, List<Long> idsToPreFetch, ResourceIndexedSearchParamToken nextResult, MatchUrlToResolve nextSearchParameterMap) {
        ourLog.debug("Matched url {} from database", (Object)nextSearchParameterMap.myRequestUrl);
        idsToPreFetch.add(nextResult.getResourcePid());
        this.myMatchResourceUrlService.matchUrlResolved(theTransactionDetails, nextSearchParameterMap.myResourceDefinition.getName(), nextSearchParameterMap.myRequestUrl, new ResourcePersistentId((Object)nextResult.getResourcePid()));
        theTransactionDetails.addResolvedMatchUrl(nextSearchParameterMap.myRequestUrl, new ResourcePersistentId((Object)nextResult.getResourcePid()));
        nextSearchParameterMap.setResolved(true);
    }

    protected void flushSession(Map<IIdType, DaoMethodOutcome> theIdToPersistedOutcome) {
        try {
            int updateCount;
            int insertionCount;
            SessionImpl session = (SessionImpl)this.myEntityManager.unwrap(SessionImpl.class);
            if (session != null) {
                insertionCount = session.getActionQueue().numberOfInsertions();
                updateCount = session.getActionQueue().numberOfUpdates();
            } else {
                insertionCount = -1;
                updateCount = -1;
            }
            StopWatch sw = new StopWatch();
            this.myEntityManager.flush();
            ourLog.debug("Session flush took {}ms for {} inserts and {} updates", new Object[]{sw.getMillis(), insertionCount, updateCount});
        }
        catch (PersistenceException e) {
            if (this.myHapiFhirHibernateJpaDialect != null) {
                List types = theIdToPersistedOutcome.keySet().stream().filter(t -> t != null).map(t -> t.getResourceType()).collect(Collectors.toList());
                String message = "Error flushing transaction with resource types: " + types;
                throw this.myHapiFhirHibernateJpaDialect.translate(e, message);
            }
            throw e;
        }
    }

    @VisibleForTesting
    public void setPartitionSettingsForUnitTest(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    @VisibleForTesting
    public void setIdHelperServiceForUnitTest(IIdHelperService theIdHelperService) {
        this.myIdHelperService = theIdHelperService;
    }

    @VisibleForTesting
    public void setApplicationContextForUnitTest(ApplicationContext theAppCtx) {
        this.myApplicationContext = theAppCtx;
    }

    private static class MatchUrlToResolve {
        private final String myRequestUrl;
        private final SearchParameterMap myMatchUrlSearchMap;
        private final RuntimeResourceDefinition myResourceDefinition;
        public boolean myResolved;
        private Long myHashValue;
        private Long myHashSystemAndValue;

        public MatchUrlToResolve(String theRequestUrl, SearchParameterMap theMatchUrlSearchMap, RuntimeResourceDefinition theResourceDefinition) {
            this.myRequestUrl = theRequestUrl;
            this.myMatchUrlSearchMap = theMatchUrlSearchMap;
            this.myResourceDefinition = theResourceDefinition;
        }

        public void setResolved(boolean theResolved) {
            this.myResolved = theResolved;
        }
    }
}

