/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.entity.Batch2WorkChunkEntity;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface IBatch2WorkChunkRepository
extends JpaRepository<Batch2WorkChunkEntity, String>,
IHapiFhirJpaRepository {
    @Query(value="SELECT e FROM Batch2WorkChunkEntity e WHERE e.myInstanceId = :instanceId ORDER BY e.mySequence ASC")
    public List<Batch2WorkChunkEntity> fetchChunks(Pageable var1, @Param(value="instanceId") String var2);

    @Query(value="SELECT e FROM Batch2WorkChunkEntity e WHERE e.myInstanceId = :instanceId AND e.myTargetStepId = :targetStepId ORDER BY e.mySequence ASC")
    public List<Batch2WorkChunkEntity> fetchChunksForStep(Pageable var1, @Param(value="instanceId") String var2, @Param(value="targetStepId") String var3);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myEndTime = :et, e.myRecordsProcessed = :rp, e.mySerializedData = null WHERE e.myId = :id")
    public void updateChunkStatusAndClearDataForEndSuccess(@Param(value="id") String var1, @Param(value="et") Date var2, @Param(value="rp") int var3, @Param(value="status") StatusEnum var4);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myEndTime = :et, e.mySerializedData = null, e.myErrorMessage = :em WHERE e.myId IN(:ids)")
    public void updateAllChunksForInstanceStatusClearDataAndSetError(@Param(value="ids") List<String> var1, @Param(value="et") Date var2, @Param(value="status") StatusEnum var3, @Param(value="em") String var4);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myEndTime = :et, e.myErrorMessage = :em, e.myErrorCount = e.myErrorCount + 1 WHERE e.myId = :id")
    public void updateChunkStatusAndIncrementErrorCountForEndError(@Param(value="id") String var1, @Param(value="et") Date var2, @Param(value="em") String var3, @Param(value="status") StatusEnum var4);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myStartTime = :st WHERE e.myId = :id")
    public void updateChunkStatusForStart(@Param(value="id") String var1, @Param(value="st") Date var2, @Param(value="status") StatusEnum var3);

    @Modifying
    @Query(value="DELETE FROM Batch2WorkChunkEntity e WHERE e.myInstanceId = :instanceId")
    public void deleteAllForInstance(@Param(value="instanceId") String var1);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myErrorCount = e.myErrorCount + :by WHERE e.myId = :id")
    public void incrementWorkChunkErrorCount(@Param(value="id") String var1, @Param(value="by") int var2);
}

