/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.bulk.export.model.BulkExportJobStatusEnum;
import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.entity.BulkExportJobEntity;
import java.util.Date;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface IBulkExportJobDao
extends JpaRepository<BulkExportJobEntity, Long>,
IHapiFhirJpaRepository {
    @Query(value="SELECT j FROM BulkExportJobEntity j WHERE j.myJobId = :jobid")
    public Optional<BulkExportJobEntity> findByJobId(@Param(value="jobid") String var1);

    @Query(value="SELECT j FROM BulkExportJobEntity j WHERE j.myStatus = :status")
    public Slice<BulkExportJobEntity> findByStatus(Pageable var1, @Param(value="status") BulkExportJobStatusEnum var2);

    @Query(value="SELECT j FROM BulkExportJobEntity j WHERE j.myExpiry < :cutoff")
    public Slice<BulkExportJobEntity> findByExpiry(Pageable var1, @Param(value="cutoff") Date var2);

    @Query(value="SELECT j FROM BulkExportJobEntity j WHERE j.myExpiry IS NOT NULL and j.myExpiry < :cutoff AND j.myStatus <> 'BUILDING'")
    public Slice<BulkExportJobEntity> findNotRunningByExpiry(Pageable var1, @Param(value="cutoff") Date var2);

    @Query(value="SELECT j FROM BulkExportJobEntity j WHERE j.myRequest = :request AND j.myCreated > :createdAfter AND j.myStatus <> :status ORDER BY j.myCreated DESC")
    public Slice<BulkExportJobEntity> findExistingJob(Pageable var1, @Param(value="request") String var2, @Param(value="createdAfter") Date var3, @Param(value="status") BulkExportJobStatusEnum var4);

    @Modifying
    @Query(value="DELETE FROM BulkExportJobEntity t")
    public void deleteAllFiles();

    @Modifying
    @Query(value="DELETE FROM BulkExportJobEntity t WHERE t.myId = :pid")
    public void deleteByPid(@Param(value="pid") Long var1);
}

