/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface IResourceHistoryTableDao
extends JpaRepository<ResourceHistoryTable, Long>,
IHapiFhirJpaRepository {
    @Query(value="SELECT t FROM ResourceHistoryTable t WHERE t.myResourceId = :resId ORDER BY t.myResourceVersion ASC")
    public List<ResourceHistoryTable> findAllVersionsForResourceIdInOrder(@Param(value="resId") Long var1);

    @Query(value="SELECT t FROM ResourceHistoryTable t LEFT OUTER JOIN FETCH t.myProvenance WHERE t.myResourceId = :id AND t.myResourceVersion = :version")
    public ResourceHistoryTable findForIdAndVersionAndFetchProvenance(@Param(value="id") long var1, @Param(value="version") long var3);

    @Query(value="SELECT t.myId FROM ResourceHistoryTable t WHERE t.myResourceId = :resId AND t.myResourceVersion != :dontWantVersion")
    public Slice<Long> findForResourceId(Pageable var1, @Param(value="resId") Long var2, @Param(value="dontWantVersion") Long var3);

    @Query(value="SELECT v.myId FROM ResourceHistoryTable v LEFT OUTER JOIN ResourceTable t ON (v.myResourceId = t.myId) WHERE v.myResourceVersion != t.myVersion AND t.myId = :resId")
    public Slice<Long> findIdsOfPreviousVersionsOfResourceId(Pageable var1, @Param(value="resId") Long var2);

    @Query(value="SELECT v.myId FROM ResourceHistoryTable v LEFT OUTER JOIN ResourceTable t ON (v.myResourceId = t.myId) WHERE v.myResourceVersion != t.myVersion AND t.myResourceType = :restype")
    public Slice<Long> findIdsOfPreviousVersionsOfResources(Pageable var1, @Param(value="restype") String var2);

    @Query(value="SELECT v.myId FROM ResourceHistoryTable v LEFT OUTER JOIN ResourceTable t ON (v.myResourceId = t.myId) WHERE v.myResourceVersion != t.myVersion")
    public Slice<Long> findIdsOfPreviousVersionsOfResources(Pageable var1);

    @Modifying
    @Query(value="UPDATE ResourceHistoryTable r SET r.myResourceVersion = :newVersion WHERE r.myResourceId = :id AND r.myResourceVersion = :oldVersion")
    public void updateVersion(@Param(value="id") long var1, @Param(value="oldVersion") long var3, @Param(value="newVersion") long var5);

    @Modifying
    @Query(value="DELETE FROM ResourceHistoryTable t WHERE t.myId = :pid")
    public void deleteByPid(@Param(value="pid") Long var1);
}

