/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.dstu3;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.util.LogicUtil;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Transactional
public class FhirResourceDaoCodeSystemDstu3
extends BaseHapiFhirResourceDao<org.hl7.fhir.dstu3.model.CodeSystem>
implements IFhirResourceDaoCodeSystem<org.hl7.fhir.dstu3.model.CodeSystem, Coding, CodeableConcept> {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirResourceDaoCodeSystemDstu3.class);
    @Autowired
    protected ITermCodeSystemStorageSvc myTerminologyCodeSystemStorageSvc;
    @Autowired
    protected ITermDeferredStorageSvc myTermDeferredStorageSvc;
    @Autowired
    private IValidationSupport myValidationSupport;
    @Autowired
    private FhirContext myFhirContext;

    public List<IIdType> findCodeSystemIdsContainingSystemAndCode(String theCode, String theSystem, RequestDetails theRequest) {
        List ids = this.searchForIds(new SearchParameterMap("code", (IQueryParameterType)new TokenParam(theSystem, theCode)), theRequest);
        ArrayList<IIdType> valueSetIds = new ArrayList<IIdType>();
        for (ResourcePersistentId next : ids) {
            IIdType id = this.myIdHelperService.translatePidIdToForcedId(this.myFhirContext, "CodeSystem", next);
            valueSetIds.add(id);
        }
        return valueSetIds;
    }

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, Coding theCoding, RequestDetails theRequestDetails) {
        return this.lookupCode(theCode, theSystem, theCoding, (IPrimitiveType<String>)null, theRequestDetails);
    }

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, Coding theCoding, IPrimitiveType<String> theDisplayLanguage, RequestDetails theRequestDetails) {
        Object system;
        String code;
        boolean haveDisplayLanguage;
        boolean haveCoding = theCoding != null && StringUtils.isNotBlank((CharSequence)theCoding.getSystem()) && StringUtils.isNotBlank((CharSequence)theCoding.getCode());
        boolean haveCode = theCode != null && !theCode.isEmpty();
        boolean haveSystem = theSystem != null && !theSystem.isEmpty();
        boolean bl = haveDisplayLanguage = theDisplayLanguage != null && !theDisplayLanguage.isEmpty();
        if (!(haveCoding || haveSystem && haveCode)) {
            throw new InvalidRequestException(Msg.code((int)1075) + "No code, coding, or codeableConcept provided to validate");
        }
        boolean[] blArray = new boolean[2];
        blArray[0] = haveCoding;
        boolean bl2 = blArray[1] = haveSystem && haveCode;
        if (!LogicUtil.multiXor(blArray) || haveSystem != haveCode) {
            throw new InvalidRequestException(Msg.code((int)1076) + "$lookup can only validate (system AND code) OR (coding.system AND coding.code)");
        }
        if (haveCoding) {
            code = theCoding.getCode();
            system = theCoding.hasVersion() ? theCoding.getSystem() + "|" + theCoding.getVersion() : theCoding.getSystem();
        } else {
            code = (String)theCode.getValue();
            system = (String)theSystem.getValue();
        }
        String displayLanguage = null;
        if (haveDisplayLanguage) {
            displayLanguage = (String)theDisplayLanguage.getValue();
        }
        ourLog.debug("Looking up {} / {}", system, (Object)code);
        if (this.myValidationSupport.isCodeSystemSupported(new ValidationSupportContext(this.myValidationSupport), (String)system)) {
            ourLog.debug("Code system {} is supported", system);
            IValidationSupport.LookupCodeResult result = this.myValidationSupport.lookupCode(new ValidationSupportContext(this.myValidationSupport), (String)system, code, displayLanguage);
            if (result != null) {
                return result;
            }
        }
        return IValidationSupport.LookupCodeResult.notFound((String)system, (String)code);
    }

    public IFhirResourceDaoCodeSystem.SubsumesResult subsumes(IPrimitiveType<String> theCodeA, IPrimitiveType<String> theCodeB, IPrimitiveType<String> theSystem, Coding theCodingA, Coding theCodingB, RequestDetails theRequestDetails) {
        return this.myTerminologySvc.subsumes(theCodeA, theCodeB, theSystem, (IBaseCoding)theCodingA, (IBaseCoding)theCodingB);
    }

    @Override
    protected void preDelete(org.hl7.fhir.dstu3.model.CodeSystem theResourceToDelete, ResourceTable theEntityToDelete, RequestDetails theRequestDetails) {
        super.preDelete(theResourceToDelete, theEntityToDelete, theRequestDetails);
        this.myTermDeferredStorageSvc.deleteCodeSystemForResource(theEntityToDelete);
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequest, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequest, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (!retVal.isUnchangedInCurrentOperation()) {
            org.hl7.fhir.dstu3.model.CodeSystem csDstu3 = (org.hl7.fhir.dstu3.model.CodeSystem)theResource;
            CodeSystem cs = (CodeSystem)VersionConvertorFactory_30_40.convertResource((Resource)csDstu3, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
            this.addPidToResource(theEntity, (IBaseResource)cs);
            this.myTerminologyCodeSystemStorageSvc.storeNewCodeSystemVersionIfNeeded(cs, (ResourceTable)theEntity);
        }
        return retVal;
    }

    public IValidationSupport.CodeValidationResult validateCode(IIdType theCodeSystemId, IPrimitiveType<String> theCodeSystemUrl, IPrimitiveType<String> theVersion, IPrimitiveType<String> theCode, IPrimitiveType<String> theDisplay, Coding theCoding, CodeableConcept theCodeableConcept, RequestDetails theRequestDetails) {
        throw new UnsupportedOperationException(Msg.code((int)1077));
    }
}

