/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.dstu3;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoConceptMap;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.api.ITermConceptMappingSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.Date;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.ConceptMap;
import org.springframework.beans.factory.annotation.Autowired;

public class FhirResourceDaoConceptMapDstu3
extends BaseHapiFhirResourceDao<org.hl7.fhir.dstu3.model.ConceptMap>
implements IFhirResourceDaoConceptMap<org.hl7.fhir.dstu3.model.ConceptMap> {
    @Autowired
    private ITermConceptMappingSvc myTermConceptMappingSvc;
    @Autowired
    private IValidationSupport myValidationSupport;

    public TranslateConceptResults translate(TranslationRequest theTranslationRequest, RequestDetails theRequestDetails) {
        IValidationSupport.TranslateCodeRequest translateCodeRequest = theTranslationRequest.asTranslateCodeRequest();
        return this.myValidationSupport.translateConcept(translateCodeRequest);
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequestDetails, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequestDetails, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (!retVal.isUnchangedInCurrentOperation()) {
            if (retVal.getDeleted() == null) {
                try {
                    org.hl7.fhir.dstu3.model.ConceptMap conceptMap = (org.hl7.fhir.dstu3.model.ConceptMap)theResource;
                    ConceptMap converted = (ConceptMap)VersionConvertorFactory_30_40.convertResource((Resource)conceptMap, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
                    this.myTermConceptMappingSvc.storeTermConceptMapAndChildren(retVal, converted);
                }
                catch (FHIRException fe) {
                    throw new InternalErrorException(Msg.code((int)1083) + fe);
                }
            } else {
                this.myTermConceptMappingSvc.deleteConceptMapAndChildren(retVal);
            }
        }
        return retVal;
    }
}

