/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.dstu3;

import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoValueSet;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.FhirResourceDaoValueSetDstu2;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.Date;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class FhirResourceDaoValueSetDstu3
extends BaseHapiFhirResourceDao<ValueSet>
implements IFhirResourceDaoValueSet<ValueSet, Coding, CodeableConcept> {
    public ValueSet expand(IIdType theId, ValueSetExpansionOptions theOptions, RequestDetails theRequestDetails) {
        ValueSet source = (ValueSet)this.read(theId, theRequestDetails);
        return this.expand(source, theOptions);
    }

    public ValueSet expand(ValueSet theSource, ValueSetExpansionOptions theOptions) {
        org.hl7.fhir.r4.model.ValueSet canonicalInput = (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_30_40.convertResource((Resource)theSource, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
        org.hl7.fhir.r4.model.ValueSet canonicalOutput = this.myTerminologySvc.expandValueSet(theOptions, canonicalInput);
        return (ValueSet)VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)canonicalOutput, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
    }

    public ValueSet expandByIdentifier(String theUri, ValueSetExpansionOptions theOptions) {
        org.hl7.fhir.r4.model.ValueSet canonicalOutput = this.myTerminologySvc.expandValueSet(theOptions, theUri);
        return (ValueSet)VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)canonicalOutput, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
    }

    public IValidationSupport.CodeValidationResult validateCode(IPrimitiveType<String> theValueSetIdentifier, IIdType theId, IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, IPrimitiveType<String> theDisplay, Coding theCoding, CodeableConcept theCodeableConcept, RequestDetails theRequestDetails) {
        return this.myTerminologySvc.validateCode(FhirResourceDaoValueSetDstu3.vsValidateCodeOptions(), theId, FhirResourceDaoValueSetDstu2.toStringOrNull(theValueSetIdentifier), FhirResourceDaoValueSetDstu2.toStringOrNull(theSystem), FhirResourceDaoValueSetDstu2.toStringOrNull(theCode), FhirResourceDaoValueSetDstu2.toStringOrNull(theDisplay), (IBaseDatatype)theCoding, (IBaseDatatype)theCodeableConcept);
    }

    public void purgeCaches() {
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequestDetails, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequestDetails, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (this.getConfig().isPreExpandValueSets() && !retVal.isUnchangedInCurrentOperation()) {
            if (retVal.getDeleted() == null) {
                try {
                    ValueSet valueSet = (ValueSet)theResource;
                    org.hl7.fhir.r4.model.ValueSet converted = (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_30_40.convertResource((Resource)valueSet, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
                    this.myTerminologySvc.storeTermValueSet(retVal, converted);
                }
                catch (FHIRException fe) {
                    throw new InternalErrorException(Msg.code((int)1080) + fe);
                }
            } else {
                this.myTerminologySvc.deleteValueSetAndChildren(retVal);
            }
        }
        return retVal;
    }

    public static ConceptValidationOptions vsValidateCodeOptions() {
        return new ConceptValidationOptions().setValidateDisplay(true);
    }
}

