/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.expunge;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.dao.expunge.IExpungeEverythingService;
import ca.uhn.fhir.jpa.entity.Batch2JobInstanceEntity;
import ca.uhn.fhir.jpa.entity.Batch2WorkChunkEntity;
import ca.uhn.fhir.jpa.entity.BulkImportJobEntity;
import ca.uhn.fhir.jpa.entity.BulkImportJobFileEntity;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.entity.PartitionEntity;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchInclude;
import ca.uhn.fhir.jpa.entity.SearchResult;
import ca.uhn.fhir.jpa.entity.SubscriptionTable;
import ca.uhn.fhir.jpa.entity.TermCodeSystem;
import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptDesignation;
import ca.uhn.fhir.jpa.entity.TermConceptMap;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroup;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElement;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElementTarget;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.entity.TermValueSet;
import ca.uhn.fhir.jpa.entity.TermValueSetConcept;
import ca.uhn.fhir.jpa.entity.TermValueSetConceptDesignation;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.NpmPackageEntity;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionEntity;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTag;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantityNormalized;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresentEntity;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.StopWatch;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ExpungeEverythingService
implements IExpungeEverythingService {
    private static final Logger ourLog = LoggerFactory.getLogger(ExpungeEverythingService.class);
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private PlatformTransactionManager myPlatformTransactionManager;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    private TransactionTemplate myTxTemplate;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    private int deletedResourceEntityCount;

    @PostConstruct
    public void initTxTemplate() {
        this.myTxTemplate = new TransactionTemplate(this.myPlatformTransactionManager);
    }

    public void expungeEverything(@Nullable RequestDetails theRequest) {
        AtomicInteger counter = new AtomicInteger();
        HookParams hooks = new HookParams().add(AtomicInteger.class, (Object)counter).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRESTORAGE_EXPUNGE_EVERYTHING, (HookParams)hooks);
        ourLog.info("BEGINNING GLOBAL $expunge");
        this.myTxTemplate.setPropagationBehavior(3);
        this.myTxTemplate.execute(t -> {
            counter.addAndGet(this.doExpungeEverythingQuery("UPDATE " + TermCodeSystem.class.getSimpleName() + " d SET d.myCurrentVersion = null"));
            return null;
        });
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(Batch2WorkChunkEntity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(Batch2JobInstanceEntity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(NpmPackageVersionResourceEntity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(NpmPackageVersionEntity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(NpmPackageEntity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(SearchParamPresentEntity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(BulkImportJobFileEntity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(BulkImportJobEntity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ForcedId.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedSearchParamDate.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedSearchParamNumber.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedSearchParamQuantity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedSearchParamQuantityNormalized.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedSearchParamString.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedSearchParamToken.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedSearchParamUri.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedSearchParamCoords.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedComboStringUnique.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceIndexedComboTokenNonUnique.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceLink.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(SearchResult.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(SearchInclude.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermValueSetConceptDesignation.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermValueSetConcept.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermValueSet.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermConceptParentChildLink.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermConceptMapGroupElementTarget.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermConceptMapGroupElement.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermConceptMapGroup.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermConceptMap.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermConceptProperty.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermConceptDesignation.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermConcept.class));
        this.myTxTemplate.execute(t -> {
            for (TermCodeSystem next : this.myEntityManager.createQuery("SELECT c FROM " + TermCodeSystem.class.getName() + " c", TermCodeSystem.class).getResultList()) {
                next.setCurrentVersion(null);
                this.myEntityManager.merge((Object)next);
            }
            return null;
        });
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermCodeSystemVersion.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TermCodeSystem.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(SubscriptionTable.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceHistoryTag.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceTag.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(TagDefinition.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceHistoryProvenanceEntity.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceHistoryTable.class));
        int counterBefore = counter.get();
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(ResourceTable.class));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(PartitionEntity.class));
        this.deletedResourceEntityCount = counter.get() - counterBefore;
        this.myTxTemplate.execute(t -> {
            counter.addAndGet(this.doExpungeEverythingQuery("DELETE from " + Search.class.getSimpleName() + " d"));
            return null;
        });
        this.purgeAllCaches();
        ourLog.info("COMPLETED GLOBAL $expunge - Deleted {} rows", (Object)counter.get());
    }

    public int getExpungeDeletedEntityCount() {
        return this.deletedResourceEntityCount;
    }

    private void purgeAllCaches() {
        this.myTxTemplate.execute(t -> {
            this.myMemoryCacheService.invalidateAllCaches();
            return null;
        });
    }

    private int expungeEverythingByTypeWithoutPurging(Class<?> theEntityType) {
        int outcome = 0;
        while (true) {
            StopWatch sw = new StopWatch();
            int count = (Integer)this.myTxTemplate.execute(t -> {
                CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
                CriteriaQuery cq = cb.createQuery(theEntityType);
                cq.from(theEntityType);
                TypedQuery query = this.myEntityManager.createQuery(cq);
                query.setMaxResults(1000);
                List results = query.getResultList();
                for (Object result : results) {
                    this.myEntityManager.remove(result);
                }
                return results.size();
            });
            outcome += count;
            if (count == 0) break;
            ourLog.info("Have deleted {} entities of type {} in {}", new Object[]{outcome, theEntityType.getSimpleName(), sw.toString()});
        }
        return outcome;
    }

    public int expungeEverythingByType(Class<?> theEntityType) {
        int result = this.expungeEverythingByTypeWithoutPurging(theEntityType);
        this.purgeAllCaches();
        return result;
    }

    public int expungeEverythingMdmLinks() {
        return this.expungeEverythingByType(MdmLink.class);
    }

    private int doExpungeEverythingQuery(String theQuery) {
        StopWatch sw = new StopWatch();
        int outcome = this.myEntityManager.createQuery(theQuery).executeUpdate();
        ourLog.debug("SqlQuery affected {} rows in {}: {}", new Object[]{outcome, sw.toString(), theQuery});
        return outcome;
    }
}

