/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.expunge;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.IForcedIdDao;
import ca.uhn.fhir.jpa.dao.data.IResourceHistoryTableDao;
import ca.uhn.fhir.jpa.dao.data.IResourceHistoryTagDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedComboStringUniqueDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedComboTokensNonUniqueDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamCoordsDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamDateDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamNumberDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamQuantityDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamQuantityNormalizedDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamStringDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamTokenDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamUriDao;
import ca.uhn.fhir.jpa.dao.data.IResourceLinkDao;
import ca.uhn.fhir.jpa.dao.data.IResourceProvenanceDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTagDao;
import ca.uhn.fhir.jpa.dao.data.ISearchParamPresentDao;
import ca.uhn.fhir.jpa.dao.expunge.IResourceExpungeService;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class ResourceExpungeService
implements IResourceExpungeService {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceExpungeService.class);
    @Autowired
    private IForcedIdDao myForcedIdDao;
    @Autowired
    private IResourceTableDao myResourceTableDao;
    @Autowired
    private IResourceHistoryTableDao myResourceHistoryTableDao;
    @Autowired
    private IResourceIndexedSearchParamUriDao myResourceIndexedSearchParamUriDao;
    @Autowired
    private IResourceIndexedSearchParamStringDao myResourceIndexedSearchParamStringDao;
    @Autowired
    private IResourceIndexedSearchParamTokenDao myResourceIndexedSearchParamTokenDao;
    @Autowired
    private IResourceIndexedSearchParamDateDao myResourceIndexedSearchParamDateDao;
    @Autowired
    private IResourceIndexedSearchParamQuantityDao myResourceIndexedSearchParamQuantityDao;
    @Autowired
    private IResourceIndexedSearchParamQuantityNormalizedDao myResourceIndexedSearchParamQuantityNormalizedDao;
    @Autowired
    private IResourceIndexedSearchParamCoordsDao myResourceIndexedSearchParamCoordsDao;
    @Autowired
    private IResourceIndexedSearchParamNumberDao myResourceIndexedSearchParamNumberDao;
    @Autowired
    private IResourceIndexedComboStringUniqueDao myResourceIndexedCompositeStringUniqueDao;
    @Autowired
    private IResourceIndexedComboTokensNonUniqueDao myResourceIndexedComboTokensNonUniqueDao;
    @Autowired
    private IResourceLinkDao myResourceLinkDao;
    @Autowired
    private IResourceTagDao myResourceTagDao;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private IResourceHistoryTagDao myResourceHistoryTagDao;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IResourceProvenanceDao myResourceHistoryProvenanceTableDao;
    @Autowired
    private ISearchParamPresentDao mySearchParamPresentDao;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private MemoryCacheService myMemoryCacheService;

    @Transactional
    public List<ResourcePersistentId> findHistoricalVersionsOfNonDeletedResources(String theResourceName, ResourcePersistentId theResourceId, int theRemainingCount) {
        PageRequest page = PageRequest.of((int)0, (int)theRemainingCount);
        Slice<Long> ids = theResourceId != null && theResourceId.getId() != null ? (theResourceId.getVersion() != null ? this.toSlice(this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(theResourceId.getIdAsLong(), theResourceId.getVersion())) : this.myResourceHistoryTableDao.findIdsOfPreviousVersionsOfResourceId((Pageable)page, theResourceId.getIdAsLong())) : (theResourceName != null ? this.myResourceHistoryTableDao.findIdsOfPreviousVersionsOfResources((Pageable)page, theResourceName) : this.myResourceHistoryTableDao.findIdsOfPreviousVersionsOfResources((Pageable)page));
        return ResourcePersistentId.fromLongList((List)ids.getContent());
    }

    @Transactional
    public List<ResourcePersistentId> findHistoricalVersionsOfDeletedResources(String theResourceName, ResourcePersistentId theResourceId, int theRemainingCount) {
        Slice<Long> ids;
        PageRequest page = PageRequest.of((int)0, (int)theRemainingCount);
        if (theResourceId != null) {
            ids = this.myResourceTableDao.findIdsOfDeletedResourcesOfType((Pageable)page, theResourceId.getIdAsLong(), theResourceName);
            ourLog.info("Expunging {} deleted resources of type[{}] and ID[{}]", new Object[]{ids.getNumberOfElements(), theResourceName, theResourceId});
        } else if (theResourceName != null) {
            ids = this.myResourceTableDao.findIdsOfDeletedResourcesOfType((Pageable)page, theResourceName);
            ourLog.info("Expunging {} deleted resources of type[{}]", (Object)ids.getNumberOfElements(), (Object)theResourceName);
        } else {
            ids = this.myResourceTableDao.findIdsOfDeletedResources((Pageable)page);
            ourLog.info("Expunging {} deleted resources (all types)", (Object)ids.getNumberOfElements());
        }
        return ResourcePersistentId.fromLongList((List)ids.getContent());
    }

    @Transactional
    public void expungeCurrentVersionOfResources(RequestDetails theRequestDetails, List<ResourcePersistentId> theResourceIds, AtomicInteger theRemainingCount) {
        for (ResourcePersistentId next : theResourceIds) {
            this.expungeCurrentVersionOfResource(theRequestDetails, next.getIdAsLong(), theRemainingCount);
            if (theRemainingCount.get() > 0) continue;
            return;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                ResourceExpungeService.this.myMemoryCacheService.invalidateAllCaches();
            }
        });
    }

    private void expungeHistoricalVersion(RequestDetails theRequestDetails, Long theNextVersionId, AtomicInteger theRemainingCount) {
        ResourceHistoryTable version = (ResourceHistoryTable)this.myResourceHistoryTableDao.findById(theNextVersionId).orElseThrow(IllegalArgumentException::new);
        IdDt id = version.getIdDt();
        ourLog.info("Deleting resource version {}", (Object)id.getValue());
        this.callHooks(theRequestDetails, theRemainingCount, version, id);
        if (version.getProvenance() != null) {
            this.myResourceHistoryProvenanceTableDao.deleteByPid(version.getProvenance().getId());
        }
        this.myResourceHistoryTagDao.deleteByPid(version.getId());
        this.myResourceHistoryTableDao.deleteByPid(version.getId());
        theRemainingCount.decrementAndGet();
    }

    private void callHooks(RequestDetails theRequestDetails, AtomicInteger theRemainingCount, ResourceHistoryTable theVersion, IdDt theId) {
        AtomicInteger counter = new AtomicInteger();
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PRESTORAGE_EXPUNGE_RESOURCE, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails)) {
            IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(theId.getResourceType());
            IBaseResource resource = resourceDao.toResource((BaseHasResource)theVersion, false);
            HookParams params = new HookParams().add(AtomicInteger.class, (Object)counter).add(IIdType.class, (Object)theId).add(IBaseResource.class, (Object)resource).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_PRESTORAGE_EXPUNGE_RESOURCE, (HookParams)params);
        }
        theRemainingCount.addAndGet(-1 * counter.get());
    }

    @Transactional
    public void expungeHistoricalVersionsOfIds(RequestDetails theRequestDetails, List<ResourcePersistentId> theResourceIds, AtomicInteger theRemainingCount) {
        for (ResourcePersistentId next : theResourceIds) {
            this.expungeHistoricalVersionsOfId(theRequestDetails, next.getIdAsLong(), theRemainingCount);
            if (theRemainingCount.get() > 0) continue;
            return;
        }
    }

    @Transactional
    public void expungeHistoricalVersions(RequestDetails theRequestDetails, List<ResourcePersistentId> theHistoricalIds, AtomicInteger theRemainingCount) {
        for (ResourcePersistentId next : theHistoricalIds) {
            this.expungeHistoricalVersion(theRequestDetails, next.getIdAsLong(), theRemainingCount);
            if (theRemainingCount.get() > 0) continue;
            return;
        }
    }

    private void expungeCurrentVersionOfResource(RequestDetails theRequestDetails, Long theResourceId, AtomicInteger theRemainingCount) {
        ResourceTable resource = (ResourceTable)this.myResourceTableDao.findById(theResourceId).orElseThrow(IllegalStateException::new);
        ResourceHistoryTable currentVersion = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(resource.getId(), resource.getVersion());
        if (currentVersion != null) {
            this.expungeHistoricalVersion(theRequestDetails, currentVersion.getId(), theRemainingCount);
        }
        ourLog.info("Expunging current version of resource {}", (Object)resource.getIdDt().getValue());
        this.deleteAllSearchParams(new ResourcePersistentId((Object)resource.getResourceId()));
        resource.getTags().clear();
        if (resource.getForcedId() != null) {
            ForcedId forcedId = resource.getForcedId();
            resource.setForcedId(null);
            this.myResourceTableDao.saveAndFlush(resource);
            this.myForcedIdDao.deleteByPid(forcedId.getId());
        }
        this.myResourceTableDao.deleteByPid(resource.getId());
    }

    @Transactional
    public void deleteAllSearchParams(ResourcePersistentId theResourceId) {
        ResourceTable resource = this.myResourceTableDao.findById(theResourceId.getIdAsLong()).orElse(null);
        if (resource == null || resource.isParamsUriPopulated()) {
            this.myResourceIndexedSearchParamUriDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isParamsCoordsPopulated()) {
            this.myResourceIndexedSearchParamCoordsDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isParamsDatePopulated()) {
            this.myResourceIndexedSearchParamDateDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isParamsNumberPopulated()) {
            this.myResourceIndexedSearchParamNumberDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isParamsQuantityPopulated()) {
            this.myResourceIndexedSearchParamQuantityDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isParamsQuantityNormalizedPopulated().booleanValue()) {
            this.myResourceIndexedSearchParamQuantityNormalizedDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isParamsStringPopulated()) {
            this.myResourceIndexedSearchParamStringDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isParamsTokenPopulated()) {
            this.myResourceIndexedSearchParamTokenDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isParamsComboStringUniquePresent()) {
            this.myResourceIndexedCompositeStringUniqueDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isParamsComboTokensNonUniquePresent()) {
            this.myResourceIndexedComboTokensNonUniqueDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (this.myDaoConfig.getIndexMissingFields() == DaoConfig.IndexEnabledEnum.ENABLED) {
            this.mySearchParamPresentDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isHasLinks()) {
            this.myResourceLinkDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
        if (resource == null || resource.isHasTags()) {
            this.myResourceTagDao.deleteByResourceId(theResourceId.getIdAsLong());
        }
    }

    private void expungeHistoricalVersionsOfId(RequestDetails theRequestDetails, Long myResourceId, AtomicInteger theRemainingCount) {
        ResourceTable resource = (ResourceTable)this.myResourceTableDao.findById(myResourceId).orElseThrow(IllegalArgumentException::new);
        PageRequest page = PageRequest.of((int)0, (int)theRemainingCount.get());
        Slice<Long> versionIds = this.myResourceHistoryTableDao.findForResourceId((Pageable)page, resource.getId(), resource.getVersion());
        ourLog.debug("Found {} versions of resource {} to expunge", (Object)versionIds.getNumberOfElements(), (Object)resource.getIdDt().getValue());
        for (Long nextVersionId : versionIds) {
            this.expungeHistoricalVersion(theRequestDetails, nextVersionId, theRemainingCount);
            if (theRemainingCount.get() > 0) continue;
            return;
        }
    }

    private Slice<Long> toSlice(ResourceHistoryTable myVersion) {
        Validate.notNull((Object)myVersion);
        return new SliceImpl(Collections.singletonList(myVersion.getId()));
    }
}

