/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.util.AddRemoveCount;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.springframework.stereotype.Service;

@Service
public class DaoSearchParamSynchronizer {
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;

    public AddRemoveCount synchronizeSearchParamsToDatabase(ResourceIndexedSearchParams theParams, ResourceTable theEntity, ResourceIndexedSearchParams existingParams) {
        AddRemoveCount retVal = new AddRemoveCount();
        this.synchronize(theEntity, retVal, theParams.myStringParams, existingParams.myStringParams);
        this.synchronize(theEntity, retVal, theParams.myTokenParams, existingParams.myTokenParams);
        this.synchronize(theEntity, retVal, theParams.myNumberParams, existingParams.myNumberParams);
        this.synchronize(theEntity, retVal, theParams.myQuantityParams, existingParams.myQuantityParams);
        this.synchronize(theEntity, retVal, theParams.myQuantityNormalizedParams, existingParams.myQuantityNormalizedParams);
        this.synchronize(theEntity, retVal, theParams.myDateParams, existingParams.myDateParams);
        this.synchronize(theEntity, retVal, theParams.myUriParams, existingParams.myUriParams);
        this.synchronize(theEntity, retVal, theParams.myCoordsParams, existingParams.myCoordsParams);
        this.synchronize(theEntity, retVal, theParams.myLinks, existingParams.myLinks);
        this.synchronize(theEntity, retVal, theParams.myComboTokenNonUnique, existingParams.myComboTokenNonUnique);
        theEntity.setResourceLinks(theParams.myLinks);
        return retVal;
    }

    @VisibleForTesting
    public void setEntityManager(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
    }

    private <T extends BaseResourceIndex> void synchronize(ResourceTable theEntity, AddRemoveCount theAddRemoveCount, Collection<T> theNewParams, Collection<T> theExistingParams) {
        Collection<T> newParams = theNewParams;
        for (BaseResourceIndex next : newParams) {
            next.setPartitionId(theEntity.getPartitionId());
            next.calculateHashes();
        }
        newParams = new HashSet<T>(newParams);
        List<T> paramsToRemove = this.subtract(theExistingParams, newParams);
        List<T> paramsToAdd = this.subtract(newParams, theExistingParams);
        this.tryToReuseIndexEntities(paramsToRemove, paramsToAdd);
        for (BaseResourceIndex next : paramsToRemove) {
            this.myEntityManager.remove((Object)next);
            theEntity.getParamsQuantity().remove(next);
            theEntity.getParamsQuantityNormalized().remove(next);
        }
        for (BaseResourceIndex next : paramsToAdd) {
            this.myEntityManager.merge((Object)next);
        }
        theAddRemoveCount.addToAddCount(paramsToRemove.size());
        theAddRemoveCount.addToRemoveCount(paramsToRemove.size());
    }

    private <T extends BaseResourceIndex> void tryToReuseIndexEntities(List<T> theIndexesToRemove, List<T> theIndexesToAdd) {
        for (int addIndex = 0; addIndex < theIndexesToAdd.size() && !theIndexesToRemove.isEmpty(); ++addIndex) {
            BaseResourceIndex targetEntity = (BaseResourceIndex)theIndexesToAdd.get(addIndex);
            if (targetEntity.getId() != null) continue;
            BaseResourceIndex entityToReuse = (BaseResourceIndex)theIndexesToRemove.remove(theIndexesToRemove.size() - 1);
            entityToReuse.copyMutableValuesFrom(targetEntity);
            theIndexesToAdd.set(addIndex, entityToReuse);
        }
    }

    <T> List<T> subtract(Collection<T> theSubtractFrom, Collection<T> theToSubtract) {
        assert (theSubtractFrom != theToSubtract);
        if (theSubtractFrom.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<T> retVal = new ArrayList<T>();
        for (T next : theSubtractFrom) {
            if (theToSubtract.contains(next)) continue;
            retVal.add(next);
        }
        return retVal;
    }
}

