/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.IForcedIdDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.model.cross.ResourceLookup;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.search.builder.SearchBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class IdHelperService
implements IIdHelperService {
    public static final Predicate[] EMPTY_PREDICATE_ARRAY = new Predicate[0];
    public static final String RESOURCE_PID = "RESOURCE_PID";
    @Autowired
    protected IForcedIdDao myForcedIdDao;
    @Autowired
    protected IResourceTableDao myResourceTableDao;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private FhirContext myFhirCtx;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired
    private PartitionSettings myPartitionSettings;
    private boolean myDontCheckActiveTransactionForUnitTest;

    @VisibleForTesting
    void setDontCheckActiveTransactionForUnitTest(boolean theDontCheckActiveTransactionForUnitTest) {
        this.myDontCheckActiveTransactionForUnitTest = theDontCheckActiveTransactionForUnitTest;
    }

    @Nonnull
    public IResourceLookup resolveResourceIdentity(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theResourceId) throws ResourceNotFoundException {
        return this.resolveResourceIdentity(theRequestPartitionId, theResourceType, theResourceId, false);
    }

    @Nonnull
    public IResourceLookup resolveResourceIdentity(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theResourceId, boolean theExcludeDeleted) throws ResourceNotFoundException {
        assert (this.myDontCheckActiveTransactionForUnitTest || TransactionSynchronizationManager.isSynchronizationActive());
        assert (theRequestPartitionId != null);
        IdDt id = new IdDt(theResourceType, theResourceId);
        Map<String, List<IResourceLookup>> matches = this.translateForcedIdToPids(theRequestPartitionId, Collections.singletonList(id), theExcludeDeleted);
        if (matches.isEmpty() || !matches.containsKey(theResourceId)) {
            throw new ResourceNotFoundException(Msg.code((int)2001) + "Resource " + id + " is not known");
        }
        if (matches.size() > 1 || matches.get(theResourceId).size() > 1) {
            String msg = this.myFhirCtx.getLocalizer().getMessage(IdHelperService.class, "nonUniqueForcedId", new Object[0]);
            throw new PreconditionFailedException(Msg.code((int)1099) + msg);
        }
        return matches.get(theResourceId).get(0);
    }

    @Nonnull
    public Map<String, ResourcePersistentId> resolveResourcePersistentIds(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, List<String> theIds) {
        return this.resolveResourcePersistentIds(theRequestPartitionId, theResourceType, theIds, false);
    }

    @Nonnull
    public Map<String, ResourcePersistentId> resolveResourcePersistentIds(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, List<String> theIds, boolean theExcludeDeleted) {
        assert (this.myDontCheckActiveTransactionForUnitTest || TransactionSynchronizationManager.isSynchronizationActive());
        Validate.notNull(theIds, (String)"theIds cannot be null", (Object[])new Object[0]);
        Validate.isTrue((!theIds.isEmpty() ? 1 : 0) != 0, (String)"theIds must not be empty", (Object[])new Object[0]);
        HashMap<String, ResourcePersistentId> retVals = new HashMap<String, ResourcePersistentId>();
        for (String id : theIds) {
            ResourcePersistentId retVal;
            if (!this.idRequiresForcedId(id)) {
                retVal = new ResourcePersistentId((Object)Long.parseLong(id));
                retVals.put(id, retVal);
                continue;
            }
            if (this.myDaoConfig.isDeleteEnabled()) {
                retVal = new ResourcePersistentId((Object)this.resolveResourceIdentity(theRequestPartitionId, theResourceType, id, theExcludeDeleted).getResourceId());
                retVals.put(id, retVal);
                continue;
            }
            String key = this.toForcedIdToPidKey(theRequestPartitionId, theResourceType, id);
            retVal = (ResourcePersistentId)this.myMemoryCacheService.getThenPutAfterCommit(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, (Object)key, t -> {
                List<IdType> ids = Collections.singletonList(new IdType(theResourceType, id));
                List<ResourcePersistentId> resolvedIds = this.resolveResourcePersistentIdsWithCache(theRequestPartitionId, ids);
                if (resolvedIds.isEmpty()) {
                    throw new ResourceNotFoundException(Msg.code((int)1100) + ids.get(0));
                }
                return resolvedIds.get(0);
            });
            retVals.put(id, retVal);
        }
        return retVals;
    }

    @Nonnull
    public ResourcePersistentId resolveResourcePersistentIds(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theId) {
        return this.resolveResourcePersistentIds(theRequestPartitionId, theResourceType, theId, false);
    }

    public ResourcePersistentId resolveResourcePersistentIds(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theId, boolean theExcludeDeleted) {
        Validate.notNull((Object)theId, (String)"theId must not be null", (Object[])new Object[0]);
        Map<String, ResourcePersistentId> retVal = this.resolveResourcePersistentIds(theRequestPartitionId, theResourceType, Collections.singletonList(theId), theExcludeDeleted);
        return retVal.get(theId);
    }

    public boolean idRequiresForcedId(String theId) {
        return this.myDaoConfig.getResourceClientIdStrategy() == DaoConfig.ClientIdStrategyEnum.ANY || !IdHelperService.isValidPid(theId);
    }

    @Nonnull
    private String toForcedIdToPidKey(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theId) {
        return RequestPartitionId.stringifyForKey((RequestPartitionId)theRequestPartitionId) + "/" + theResourceType + "/" + theId;
    }

    @Nonnull
    public List<ResourcePersistentId> resolveResourcePersistentIdsWithCache(RequestPartitionId theRequestPartitionId, List<IIdType> theIds) {
        boolean onlyForcedIds = false;
        return this.resolveResourcePersistentIdsWithCache(theRequestPartitionId, theIds, onlyForcedIds);
    }

    @Nonnull
    public List<ResourcePersistentId> resolveResourcePersistentIdsWithCache(RequestPartitionId theRequestPartitionId, List<IIdType> theIds, boolean theOnlyForcedIds) {
        assert (this.myDontCheckActiveTransactionForUnitTest || TransactionSynchronizationManager.isSynchronizationActive());
        ArrayList<ResourcePersistentId> retVal = new ArrayList<ResourcePersistentId>(theIds.size());
        for (IIdType id : theIds) {
            if (id.hasIdPart()) continue;
            throw new InvalidRequestException(Msg.code((int)1101) + "Parameter value missing in request");
        }
        if (!theIds.isEmpty()) {
            HashSet<IIdType> idsToCheck = new HashSet<IIdType>(theIds.size());
            for (IIdType nextId : theIds) {
                if (this.myDaoConfig.getResourceClientIdStrategy() != DaoConfig.ClientIdStrategyEnum.ANY && nextId.isIdPartValidLong()) {
                    if (theOnlyForcedIds) continue;
                    retVal.add(new ResourcePersistentId((Object)nextId.getIdPartAsLong()).setAssociatedResourceId(nextId));
                    continue;
                }
                String key = this.toForcedIdToPidKey(theRequestPartitionId, nextId.getResourceType(), nextId.getIdPart());
                ResourcePersistentId cachedId = (ResourcePersistentId)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, (Object)key);
                if (cachedId != null) {
                    retVal.add(cachedId);
                    continue;
                }
                idsToCheck.add(nextId);
            }
            new QueryChunker<IIdType>().chunk(idsToCheck, SearchBuilder.getMaximumPageSize() / 2, ids -> this.doResolvePersistentIds(theRequestPartitionId, (List<IIdType>)ids, (List<ResourcePersistentId>)retVal));
        }
        return retVal;
    }

    private void doResolvePersistentIds(RequestPartitionId theRequestPartitionId, List<IIdType> theIds, List<ResourcePersistentId> theOutputListToPopulate) {
        CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(ForcedId.class);
        Root from = criteriaQuery.from(ForcedId.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(theIds.size());
        for (IIdType next : theIds) {
            ArrayList<Predicate> andPredicates = new ArrayList<Predicate>(3);
            if (StringUtils.isNotBlank((CharSequence)next.getResourceType())) {
                Predicate typeCriteria = cb.equal(from.get("myResourceType").as(String.class), (Object)next.getResourceType());
                andPredicates.add(typeCriteria);
            }
            Predicate idCriteria = cb.equal(from.get("myForcedId").as(String.class), (Object)next.getIdPart());
            andPredicates.add(idCriteria);
            this.getOptionalPartitionPredicate(theRequestPartitionId, cb, (Root<ForcedId>)from).ifPresent(andPredicates::add);
            predicates.add(cb.and(andPredicates.toArray(EMPTY_PREDICATE_ARRAY)));
        }
        criteriaQuery.where((Expression)cb.or(predicates.toArray(EMPTY_PREDICATE_ARRAY)));
        TypedQuery query = this.myEntityManager.createQuery(criteriaQuery);
        List results = query.getResultList();
        for (ForcedId nextId : results) {
            if (nextId.getResourceId() == null) continue;
            ResourcePersistentId persistentId = new ResourcePersistentId((Object)nextId.getResourceId());
            this.populateAssociatedResourceId(nextId.getResourceType(), nextId.getForcedId(), persistentId);
            theOutputListToPopulate.add(persistentId);
            String key = this.toForcedIdToPidKey(theRequestPartitionId, nextId.getResourceType(), nextId.getForcedId());
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, (Object)key, (Object)persistentId);
        }
    }

    private Optional<Predicate> getOptionalPartitionPredicate(RequestPartitionId theRequestPartitionId, CriteriaBuilder cb, Root<ForcedId> from) {
        if (this.myPartitionSettings.isAllowUnqualifiedCrossPartitionReference()) {
            return Optional.empty();
        }
        if (theRequestPartitionId.isDefaultPartition() && this.myPartitionSettings.getDefaultPartitionId() == null) {
            Predicate partitionIdCriteria = cb.isNull(from.get("myPartitionIdValue").as(Integer.class));
            return Optional.of(partitionIdCriteria);
        }
        if (!theRequestPartitionId.isAllPartitions()) {
            List<Integer> partitionIds = theRequestPartitionId.getPartitionIds();
            if ((partitionIds = BaseJoiningPredicateBuilder.replaceDefaultPartitionIdIfNonNull(this.myPartitionSettings, partitionIds)).size() > 1) {
                Predicate partitionIdCriteria = from.get("myPartitionIdValue").as(Integer.class).in(partitionIds);
                return Optional.of(partitionIdCriteria);
            }
            if (partitionIds.size() == 1) {
                Predicate partitionIdCriteria = cb.equal(from.get("myPartitionIdValue").as(Integer.class), (Object)partitionIds.get(0));
                return Optional.of(partitionIdCriteria);
            }
        }
        return Optional.empty();
    }

    private void populateAssociatedResourceId(String nextResourceType, String forcedId, ResourcePersistentId persistentId) {
        IIdType resourceId = this.myFhirCtx.getVersion().newIdType();
        resourceId.setValue(nextResourceType + "/" + forcedId);
        persistentId.setAssociatedResourceId(resourceId);
    }

    @Nonnull
    public IIdType translatePidIdToForcedId(FhirContext theCtx, String theResourceType, ResourcePersistentId theId) {
        if (theId.getAssociatedResourceId() != null) {
            return theId.getAssociatedResourceId();
        }
        IIdType retVal = theCtx.getVersion().newIdType();
        Optional<String> forcedId = this.translatePidIdToForcedIdWithCache(theId);
        if (forcedId.isPresent()) {
            retVal.setValue(theResourceType + "/" + forcedId.get());
        } else {
            retVal.setValue(theResourceType + "/" + theId);
        }
        return retVal;
    }

    public Optional<String> translatePidIdToForcedIdWithCache(ResourcePersistentId theId) {
        return (Optional)this.myMemoryCacheService.get(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)theId.getIdAsLong(), pid -> this.myForcedIdDao.findByResourcePid((Long)pid).map(t -> t.getForcedId()));
    }

    private ListMultimap<String, String> organizeIdsByResourceType(Collection<IIdType> theIds) {
        ListMultimap typeToIds = MultimapBuilder.hashKeys().arrayListValues().build();
        for (IIdType nextId : theIds) {
            if (this.myDaoConfig.getResourceClientIdStrategy() != DaoConfig.ClientIdStrategyEnum.ANY && IdHelperService.isValidPid(nextId)) continue;
            if (nextId.hasResourceType()) {
                typeToIds.put((Object)nextId.getResourceType(), (Object)nextId.getIdPart());
                continue;
            }
            typeToIds.put((Object)"", (Object)nextId.getIdPart());
        }
        return typeToIds;
    }

    private Map<String, List<IResourceLookup>> translateForcedIdToPids(@Nonnull RequestPartitionId theRequestPartitionId, Collection<IIdType> theId, boolean theExcludeDeleted) {
        List<Long> pids;
        assert (theRequestPartitionId != null);
        theId.forEach(id -> Validate.isTrue((boolean)id.hasIdPart()));
        if (theId.isEmpty()) {
            return new HashMap<String, List<IResourceLookup>>();
        }
        HashMap<String, List<IResourceLookup>> retVal = new HashMap<String, List<IResourceLookup>>();
        RequestPartitionId requestPartitionId = this.replaceDefault(theRequestPartitionId);
        if (this.myDaoConfig.getResourceClientIdStrategy() != DaoConfig.ClientIdStrategyEnum.ANY && !(pids = theId.stream().filter(t -> IdHelperService.isValidPid(t)).map(t -> t.getIdPartAsLong()).collect(Collectors.toList())).isEmpty()) {
            this.resolvePids(requestPartitionId, pids, retVal);
        }
        ListMultimap<String, String> typeToIds = this.organizeIdsByResourceType(theId);
        for (Map.Entry nextEntry : typeToIds.asMap().entrySet()) {
            String nextResourceType = (String)nextEntry.getKey();
            Collection nextIds = (Collection)nextEntry.getValue();
            if (!this.myDaoConfig.isDeleteEnabled()) {
                Iterator forcedIdIterator = nextIds.iterator();
                while (forcedIdIterator.hasNext()) {
                    String nextForcedId = (String)forcedIdIterator.next();
                    String nextKey = nextResourceType + "/" + nextForcedId;
                    IResourceLookup cachedLookup = (IResourceLookup)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)nextKey);
                    if (cachedLookup == null) continue;
                    forcedIdIterator.remove();
                    if (!retVal.containsKey(nextForcedId)) {
                        retVal.put(nextForcedId, new ArrayList());
                    }
                    ((List)retVal.get(nextForcedId)).add(cachedLookup);
                }
            }
            if (nextIds.size() <= 0) continue;
            assert (StringUtils.isNotBlank((CharSequence)nextResourceType));
            Collection views = requestPartitionId.isAllPartitions() ? this.myForcedIdDao.findAndResolveByForcedIdWithNoType(nextResourceType, nextIds, theExcludeDeleted) : (requestPartitionId.isDefaultPartition() ? this.myForcedIdDao.findAndResolveByForcedIdWithNoTypeInPartitionNull(nextResourceType, nextIds, theExcludeDeleted) : (requestPartitionId.hasDefaultPartitionId() ? this.myForcedIdDao.findAndResolveByForcedIdWithNoTypeInPartitionIdOrNullPartitionId(nextResourceType, nextIds, requestPartitionId.getPartitionIdsWithoutDefault(), theExcludeDeleted) : this.myForcedIdDao.findAndResolveByForcedIdWithNoTypeInPartition(nextResourceType, nextIds, requestPartitionId.getPartitionIds(), theExcludeDeleted)));
            for (Object[] next : views) {
                String resourceType = (String)next[0];
                Long resourcePid = (Long)next[1];
                String forcedId = (String)next[2];
                Date deletedAt = (Date)next[3];
                ResourceLookup lookup = new ResourceLookup(resourceType, resourcePid, deletedAt);
                if (!retVal.containsKey(forcedId)) {
                    retVal.put(forcedId, new ArrayList());
                }
                ((List)retVal.get(forcedId)).add(lookup);
                if (this.myDaoConfig.isDeleteEnabled()) continue;
                String key = resourceType + "/" + forcedId;
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)key, (Object)lookup);
            }
        }
        return retVal;
    }

    RequestPartitionId replaceDefault(RequestPartitionId theRequestPartitionId) {
        if (this.myPartitionSettings.getDefaultPartitionId() != null && !theRequestPartitionId.isAllPartitions() && theRequestPartitionId.hasDefaultPartitionId()) {
            List partitionIds = theRequestPartitionId.getPartitionIds().stream().map(t -> t == null ? this.myPartitionSettings.getDefaultPartitionId() : t).collect(Collectors.toList());
            return RequestPartitionId.fromPartitionIds(partitionIds);
        }
        return theRequestPartitionId;
    }

    private void resolvePids(@Nonnull RequestPartitionId theRequestPartitionId, List<Long> thePidsToResolve, Map<String, List<IResourceLookup>> theTargets) {
        if (!this.myDaoConfig.isDeleteEnabled()) {
            Iterator<Long> forcedIdIterator = thePidsToResolve.iterator();
            while (forcedIdIterator.hasNext()) {
                Long nextPid = forcedIdIterator.next();
                String nextKey = Long.toString(nextPid);
                IResourceLookup cachedLookup = (IResourceLookup)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)nextKey);
                if (cachedLookup == null) continue;
                forcedIdIterator.remove();
                if (!theTargets.containsKey(nextKey)) {
                    theTargets.put(nextKey, new ArrayList());
                }
                theTargets.get(nextKey).add(cachedLookup);
            }
        }
        if (thePidsToResolve.size() > 0) {
            Collection<Object[]> lookup = theRequestPartitionId.isAllPartitions() ? this.myResourceTableDao.findLookupFieldsByResourcePid(thePidsToResolve) : (theRequestPartitionId.isDefaultPartition() ? this.myResourceTableDao.findLookupFieldsByResourcePidInPartitionNull(thePidsToResolve) : (theRequestPartitionId.hasDefaultPartitionId() ? this.myResourceTableDao.findLookupFieldsByResourcePidInPartitionIdsOrNullPartition(thePidsToResolve, theRequestPartitionId.getPartitionIdsWithoutDefault()) : this.myResourceTableDao.findLookupFieldsByResourcePidInPartitionIds(thePidsToResolve, theRequestPartitionId.getPartitionIds())));
            lookup.stream().map(t -> new ResourceLookup((String)t[0], (Long)t[1], (Date)t[2])).forEach(t -> {
                String id = t.getResourceId().toString();
                if (!theTargets.containsKey(id)) {
                    theTargets.put(id, new ArrayList());
                }
                ((List)theTargets.get(id)).add(t);
                if (!this.myDaoConfig.isDeleteEnabled()) {
                    String nextKey = Long.toString(t.getResourceId());
                    this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)nextKey, t);
                }
            });
        }
    }

    public PersistentIdToForcedIdMap translatePidsToForcedIds(Set<ResourcePersistentId> theResourceIds) {
        assert (this.myDontCheckActiveTransactionForUnitTest || TransactionSynchronizationManager.isSynchronizationActive());
        Set thePids = theResourceIds.stream().map(t -> t.getIdAsLong()).collect(Collectors.toSet());
        HashMap<Long, Optional> retVal = new HashMap<Long, Optional>(this.myMemoryCacheService.getAllPresent(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, thePids));
        List remainingPids = thePids.stream().filter(t -> !retVal.containsKey(t)).collect(Collectors.toList());
        new QueryChunker().chunk(remainingPids, t -> {
            List<ForcedId> forcedIds = this.myForcedIdDao.findAllByResourcePid((List<Long>)t);
            for (ForcedId forcedId : forcedIds) {
                Long nextResourcePid = forcedId.getResourceId();
                Optional<String> nextForcedId = Optional.of(forcedId.getForcedId());
                retVal.put(nextResourcePid, nextForcedId);
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)nextResourcePid, nextForcedId);
            }
        });
        remainingPids = thePids.stream().filter(t -> !retVal.containsKey(t)).collect(Collectors.toList());
        for (Long nextResourcePid : remainingPids) {
            retVal.put(nextResourcePid, Optional.empty());
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)nextResourcePid, Optional.empty());
        }
        HashMap convertRetVal = new HashMap();
        retVal.forEach((k, v) -> convertRetVal.put(new ResourcePersistentId(k), v));
        return new PersistentIdToForcedIdMap(convertRetVal);
    }

    public void addResolvedPidToForcedId(ResourcePersistentId theResourcePersistentId, @Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, @Nullable String theForcedId, @Nullable Date theDeletedAt) {
        if (theForcedId != null) {
            if (theResourcePersistentId.getAssociatedResourceId() == null) {
                this.populateAssociatedResourceId(theResourceType, theForcedId, theResourcePersistentId);
            }
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)theResourcePersistentId.getIdAsLong(), Optional.of(theForcedId));
            String key = this.toForcedIdToPidKey(theRequestPartitionId, theResourceType, theForcedId);
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, (Object)key, (Object)theResourcePersistentId);
        } else {
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)theResourcePersistentId.getIdAsLong(), Optional.empty());
        }
        if (!this.myDaoConfig.isDeleteEnabled()) {
            ResourceLookup lookup = new ResourceLookup(theResourceType, theResourcePersistentId.getIdAsLong(), theDeletedAt);
            String nextKey = theResourcePersistentId.toString();
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)nextKey, (Object)lookup);
        }
    }

    @VisibleForTesting
    void setPartitionSettingsForUnitTest(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    public static boolean isValidPid(IIdType theId) {
        if (theId == null) {
            return false;
        }
        String idPart = theId.getIdPart();
        return IdHelperService.isValidPid(idPart);
    }

    public static boolean isValidPid(String theIdPart) {
        return StringUtils.isNumeric((CharSequence)theIdPart);
    }

    @Nonnull
    public List<ResourcePersistentId> getPidsOrThrowException(@Nonnull RequestPartitionId theRequestPartitionId, List<IIdType> theIds) {
        List<ResourcePersistentId> resourcePersistentIds = this.resolveResourcePersistentIdsWithCache(theRequestPartitionId, theIds);
        return resourcePersistentIds;
    }

    @Nullable
    public ResourcePersistentId getPidOrNull(@Nonnull RequestPartitionId theRequestPartitionId, IBaseResource theResource) {
        ResourcePersistentId retVal = new ResourcePersistentId(theResource.getUserData(RESOURCE_PID));
        if (retVal.getId() == null) {
            IIdType id = theResource.getIdElement();
            try {
                retVal = this.resolveResourcePersistentIds(theRequestPartitionId, id.getResourceType(), id.getIdPart());
            }
            catch (ResourceNotFoundException e) {
                return null;
            }
        }
        return retVal;
    }

    @Nonnull
    public ResourcePersistentId getPidOrThrowException(@Nonnull RequestPartitionId theRequestPartitionId, IIdType theId) {
        List<IIdType> ids = Collections.singletonList(theId);
        List<ResourcePersistentId> resourcePersistentIds = this.resolveResourcePersistentIdsWithCache(theRequestPartitionId, ids);
        return resourcePersistentIds.get(0);
    }

    @Nonnull
    public ResourcePersistentId getPidOrThrowException(@Nonnull IAnyResource theResource) {
        Object theResourcePID = theResource.getUserData(RESOURCE_PID);
        if (theResourcePID == null) {
            throw new IllegalStateException(Msg.code((int)2108) + String.format("Unable to find %s in the user data for %s with ID %s", RESOURCE_PID, theResource, theResource.getId()));
        }
        return new ResourcePersistentId(theResourcePID);
    }

    public IIdType resourceIdFromPidOrThrowException(ResourcePersistentId thePid, String theResourceType) {
        Optional optionalResource = this.myResourceTableDao.findById(thePid.getIdAsLong());
        if (!optionalResource.isPresent()) {
            throw new ResourceNotFoundException(Msg.code((int)2107) + "Requested resource not found");
        }
        return ((ResourceTable)optionalResource.get()).getIdDt().toVersionless();
    }

    public Set<String> translatePidsToFhirResourceIds(Set<ResourcePersistentId> thePids) {
        assert (TransactionSynchronizationManager.isSynchronizationActive());
        PersistentIdToForcedIdMap pidToForcedIdMap = this.translatePidsToForcedIds(thePids);
        return pidToForcedIdMap.getResolvedResourceIds();
    }
}

