/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.dao.index.IJpaIdHelperService;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JpaIdHelperService
extends IdHelperService
implements IJpaIdHelperService,
IIdHelperService {
    @Autowired
    protected IResourceTableDao myResourceTableDao;

    @Override
    @Deprecated
    @Nonnull
    public List<Long> getPidsOrThrowException(List<IIdType> theIds) {
        List<ResourcePersistentId> resourcePersistentIds = super.resolveResourcePersistentIdsWithCache(RequestPartitionId.allPartitions(), theIds);
        return resourcePersistentIds.stream().map(ResourcePersistentId::getIdAsLong).collect(Collectors.toList());
    }

    @Override
    @Deprecated
    @Nullable
    public Long getPidOrNull(IBaseResource theResource) {
        IAnyResource anyResource = (IAnyResource)theResource;
        Long retVal = (Long)anyResource.getUserData("RESOURCE_PID");
        if (retVal == null) {
            IIdType id = theResource.getIdElement();
            try {
                retVal = super.resolveResourcePersistentIds(RequestPartitionId.allPartitions(), id.getResourceType(), id.getIdPart()).getIdAsLong();
            }
            catch (ResourceNotFoundException e) {
                return null;
            }
        }
        return retVal;
    }

    @Override
    @Deprecated
    @Nonnull
    public Long getPidOrThrowException(IIdType theId) {
        assert (TransactionSynchronizationManager.isSynchronizationActive());
        List<IIdType> ids = Collections.singletonList(theId);
        List<ResourcePersistentId> resourcePersistentIds = super.resolveResourcePersistentIdsWithCache(RequestPartitionId.allPartitions(), ids);
        return resourcePersistentIds.get(0).getIdAsLong();
    }

    @Override
    @Nonnull
    public ResourcePersistentId getPidOrThrowException(@Nonnull IAnyResource theResource) {
        Long retVal = (Long)theResource.getUserData("RESOURCE_PID");
        if (retVal == null) {
            throw new IllegalStateException(Msg.code((int)1102) + String.format("Unable to find %s in the user data for %s with ID %s", "RESOURCE_PID", theResource, theResource.getId()));
        }
        return new ResourcePersistentId((Object)retVal);
    }

    @Override
    public IIdType resourceIdFromPidOrThrowException(Long thePid) {
        Optional optionalResource = this.myResourceTableDao.findById(thePid);
        if (!optionalResource.isPresent()) {
            throw new ResourceNotFoundException(Msg.code((int)1103) + "Requested resource not found");
        }
        return ((ResourceTable)optionalResource.get()).getIdDt().toVersionless();
    }

    @Override
    public Set<String> translatePidsToFhirResourceIds(Set<ResourcePersistentId> thePids) {
        assert (TransactionSynchronizationManager.isSynchronizationActive());
        PersistentIdToForcedIdMap pidToForcedIdMap = super.translatePidsToForcedIds(thePids);
        return pidToForcedIdMap.getResolvedResourceIds();
    }
}

