/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.MatchResourceUrlService;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedComboStringUniqueDao;
import ca.uhn.fhir.jpa.dao.index.DaoResourceLinkResolver;
import ca.uhn.fhir.jpa.dao.index.DaoSearchParamSynchronizer;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorService;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.StringUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class SearchParamWithInlineReferencesExtractor {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchParamWithInlineReferencesExtractor.class);
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private MatchResourceUrlService myMatchResourceUrlService;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private SearchParamExtractorService mySearchParamExtractorService;
    @Autowired
    private DaoResourceLinkResolver myDaoResourceLinkResolver;
    @Autowired
    private DaoSearchParamSynchronizer myDaoSearchParamSynchronizer;
    @Autowired
    private IResourceIndexedComboStringUniqueDao myResourceIndexedCompositeStringUniqueDao;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private MemoryCacheService myMemoryCacheService;

    @VisibleForTesting
    public void setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    @VisibleForTesting
    public void setSearchParamExtractorService(SearchParamExtractorService theSearchParamExtractorService) {
        this.mySearchParamExtractorService = theSearchParamExtractorService;
    }

    @VisibleForTesting
    public void setSearchParamRegistry(ISearchParamRegistry theSearchParamRegistry) {
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    public void populateFromResource(RequestPartitionId theRequestPartitionId, ResourceIndexedSearchParams theParams, TransactionDetails theTransactionDetails, ResourceTable theEntity, IBaseResource theResource, ResourceIndexedSearchParams theExistingParams, RequestDetails theRequest, boolean theFailOnInvalidReference) {
        this.extractInlineReferences(theResource, theTransactionDetails, theRequest);
        this.mySearchParamExtractorService.extractFromResource(theRequestPartitionId, theRequest, theParams, theEntity, theResource, theTransactionDetails, theFailOnInvalidReference);
        ResourceSearchParams activeSearchParams = this.mySearchParamRegistry.getActiveSearchParams(theEntity.getResourceType());
        if (this.myDaoConfig.getIndexMissingFields() == DaoConfig.IndexEnabledEnum.ENABLED) {
            theParams.findMissingSearchParams(this.myPartitionSettings, this.myDaoConfig.getModelConfig(), theEntity, activeSearchParams);
        }
        Iterator existingLinkIter = theExistingParams.getResourceLinks().iterator();
        while (existingLinkIter.hasNext()) {
            ResourceLink nextExisting = (ResourceLink)existingLinkIter.next();
            if (!theParams.myLinks.remove(nextExisting)) continue;
            existingLinkIter.remove();
            theParams.myLinks.add(nextExisting);
        }
        this.extractCompositeStringUniques(theEntity, theParams);
    }

    private void extractCompositeStringUniques(ResourceTable theEntity, ResourceIndexedSearchParams theParams) {
        String resourceType = theEntity.getResourceType();
        List comboSearchParams = this.mySearchParamRegistry.getActiveComboSearchParams(resourceType);
        for (RuntimeSearchParam next : comboSearchParams) {
            switch (Objects.requireNonNull(next.getComboSearchParamType())) {
                case UNIQUE: {
                    this.extractComboUniqueParam(theEntity, theParams, resourceType, next);
                    break;
                }
                case NON_UNIQUE: {
                    this.extractComboNonUniqueParam(theEntity, theParams, resourceType, next);
                }
            }
        }
    }

    private void extractComboNonUniqueParam(ResourceTable theEntity, ResourceIndexedSearchParams theParams, String theResourceType, RuntimeSearchParam theParam) {
        Set<String> queryStringsToPopulate = this.extractParameterCombinationsForComboParam(theParams, theResourceType, theParam);
        for (String nextQueryString : queryStringsToPopulate) {
            ourLog.trace("Adding composite unique SP: {}", (Object)nextQueryString);
            theParams.myComboTokenNonUnique.add(new ResourceIndexedComboTokenNonUnique(this.myPartitionSettings, theEntity, nextQueryString));
        }
    }

    private void extractComboUniqueParam(ResourceTable theEntity, ResourceIndexedSearchParams theParams, String theResourceType, RuntimeSearchParam theParam) {
        Set<String> queryStringsToPopulate = this.extractParameterCombinationsForComboParam(theParams, theResourceType, theParam);
        for (String nextQueryString : queryStringsToPopulate) {
            ourLog.trace("Adding composite unique SP: {}", (Object)nextQueryString);
            theParams.myComboStringUniques.add(new ResourceIndexedComboStringUnique(theEntity, nextQueryString, theParam.getId()));
        }
    }

    @Nonnull
    private Set<String> extractParameterCombinationsForComboParam(ResourceIndexedSearchParams theParams, String theResourceType, RuntimeSearchParam theParam) {
        ArrayList partsChoices = new ArrayList();
        List compositeComponents = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParam);
        for (RuntimeSearchParam nextCompositeOf : compositeComponents) {
            Collection<? extends BaseResourceIndexedSearchParam> paramsListForCompositePart = this.findParameterIndexes(theParams, nextCompositeOf);
            Collection linksForCompositePart = null;
            switch (nextCompositeOf.getParamType()) {
                case REFERENCE: {
                    linksForCompositePart = theParams.myLinks;
                    break;
                }
            }
            HashSet linksForCompositePartWantPaths = null;
            switch (nextCompositeOf.getParamType()) {
                case REFERENCE: {
                    linksForCompositePartWantPaths = new HashSet(nextCompositeOf.getPathsSplit());
                    break;
                }
            }
            ArrayList<CallSite> nextChoicesList = new ArrayList<CallSite>();
            partsChoices.add(nextChoicesList);
            String key = UrlUtil.escapeUrlParam((String)nextCompositeOf.getName());
            if (paramsListForCompositePart != null) {
                for (BaseResourceIndexedSearchParam baseResourceIndexedSearchParam : paramsListForCompositePart) {
                    IQueryParameterType nextParamAsClientParam = baseResourceIndexedSearchParam.toQueryParameterType();
                    String value = nextParamAsClientParam.getValueAsQueryToken(this.myContext);
                    RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(theResourceType, key);
                    if (theParam.getComboSearchParamType() == ComboSearchParamType.NON_UNIQUE && param != null && param.getParamType() == RestSearchParameterTypeEnum.STRING) {
                        value = StringUtil.normalizeStringForSearchIndexing((String)value);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    value = UrlUtil.escapeUrlParam((String)value);
                    nextChoicesList.add((CallSite)((Object)(key + "=" + value)));
                }
            }
            if (linksForCompositePart == null) continue;
            for (ResourceLink resourceLink : linksForCompositePart) {
                if (!linksForCompositePartWantPaths.contains(resourceLink.getSourcePath())) continue;
                assert (StringUtils.isNotBlank((CharSequence)resourceLink.getTargetResourceType()));
                assert (StringUtils.isNotBlank((CharSequence)resourceLink.getTargetResourceId()));
                Object value = resourceLink.getTargetResourceType() + "/" + resourceLink.getTargetResourceId();
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                value = UrlUtil.escapeUrlParam((String)value);
                nextChoicesList.add((CallSite)((Object)(key + "=" + (String)value)));
            }
        }
        return ResourceIndexedSearchParams.extractCompositeStringUniquesValueChains((String)theResourceType, partsChoices);
    }

    @Nullable
    private Collection<? extends BaseResourceIndexedSearchParam> findParameterIndexes(ResourceIndexedSearchParams theParams, RuntimeSearchParam nextCompositeOf) {
        Collection paramsListForCompositePart = null;
        switch (nextCompositeOf.getParamType()) {
            case NUMBER: {
                paramsListForCompositePart = theParams.myNumberParams;
                break;
            }
            case DATE: {
                paramsListForCompositePart = theParams.myDateParams;
                break;
            }
            case STRING: {
                paramsListForCompositePart = theParams.myStringParams;
                break;
            }
            case TOKEN: {
                paramsListForCompositePart = theParams.myTokenParams;
                break;
            }
            case QUANTITY: {
                paramsListForCompositePart = theParams.myQuantityParams;
                break;
            }
            case URI: {
                paramsListForCompositePart = theParams.myUriParams;
                break;
            }
        }
        if (paramsListForCompositePart != null) {
            paramsListForCompositePart = paramsListForCompositePart.stream().filter(t -> t.getParamName().equals(nextCompositeOf.getName())).collect(Collectors.toList());
        }
        return paramsListForCompositePart;
    }

    @VisibleForTesting
    public void setDaoConfig(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    @VisibleForTesting
    public void setContext(FhirContext theContext) {
        this.myContext = theContext;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void extractInlineReferences(IBaseResource theResource, TransactionDetails theTransactionDetails, RequestDetails theRequest) {
        if (!this.myDaoConfig.isAllowInlineMatchUrlReferences()) {
            return;
        }
        FhirTerser terser = this.myContext.newTerser();
        List allRefs = terser.getAllPopulatedChildElementsOfType(theResource, IBaseReference.class);
        Iterator iterator = allRefs.iterator();
        while (iterator.hasNext()) {
            ResourcePersistentId match;
            String resourceTypeString;
            RuntimeResourceDefinition matchResourceDef;
            int qmIndex;
            IBaseReference nextRef = (IBaseReference)iterator.next();
            IIdType nextId = nextRef.getReferenceElement();
            String nextIdText = nextId.getValue();
            if (nextIdText == null || (qmIndex = nextIdText.indexOf(63)) == -1) continue;
            for (int i = qmIndex - 1; i >= 0; --i) {
                if (nextIdText.charAt(i) != '/' || i < nextIdText.length() - 1 && nextIdText.charAt(i + 1) == '?') continue;
                nextIdText = nextIdText.substring(i + 1);
                break;
            }
            if ((matchResourceDef = this.myContext.getResourceDefinition(resourceTypeString = nextIdText.substring(0, nextIdText.indexOf(63)).replace("/", ""))) == null) {
                String msg = this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidMatchUrlInvalidResourceType", new Object[]{nextId.getValue(), resourceTypeString});
                throw new InvalidRequestException(Msg.code((int)1090) + msg);
            }
            Class matchResourceType = matchResourceDef.getImplementingClass();
            Set matches = this.myMatchResourceUrlService.processMatchUrl(nextIdText, matchResourceType, theTransactionDetails, theRequest);
            if (matches.isEmpty()) {
                Optional<ResourceTable> placeholderOpt = this.myDaoResourceLinkResolver.createPlaceholderTargetIfConfiguredToDoSo(matchResourceType, nextRef, null, theRequest, theTransactionDetails);
                if (!placeholderOpt.isPresent()) {
                    String msg = this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidMatchUrlNoMatches", new Object[]{nextId.getValue()});
                    throw new ResourceNotFoundException(Msg.code((int)1091) + msg);
                }
                match = new ResourcePersistentId((Object)placeholderOpt.get().getResourceId());
                match.setAssociatedResourceId(placeholderOpt.get().getIdType(this.myContext));
                theTransactionDetails.addResolvedMatchUrl(nextIdText, match);
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.MATCH_URL, (Object)nextIdText, (Object)match);
            } else {
                if (matches.size() > 1) {
                    String msg = this.myContext.getLocalizer().getMessage(BaseHapiFhirDao.class, "invalidMatchUrlMultipleMatches", new Object[]{nextId.getValue()});
                    throw new PreconditionFailedException(Msg.code((int)1092) + msg);
                }
                match = (ResourcePersistentId)matches.iterator().next();
            }
            IIdType newId = this.myIdHelperService.translatePidIdToForcedId(this.myContext, resourceTypeString, match);
            ourLog.debug("Replacing inline match URL[{}] with ID[{}}", (Object)nextId.getValue(), (Object)newId);
            nextRef.setReference(newId.getValue());
        }
        return;
    }

    @VisibleForTesting
    public void setDaoSearchParamSynchronizer(DaoSearchParamSynchronizer theDaoSearchParamSynchronizer) {
        this.myDaoSearchParamSynchronizer = theDaoSearchParamSynchronizer;
    }

    public void storeUniqueComboParameters(ResourceIndexedSearchParams theParams, ResourceTable theEntity, ResourceIndexedSearchParams theExistingParams) {
        if (this.myDaoConfig.isUniqueIndexesEnabled()) {
            for (ResourceIndexedComboStringUnique next : this.myDaoSearchParamSynchronizer.subtract(theExistingParams.myComboStringUniques, theParams.myComboStringUniques)) {
                ourLog.debug("Removing unique index: {}", (Object)next);
                this.myEntityManager.remove((Object)next);
                theEntity.getParamsComboStringUnique().remove(next);
            }
            boolean haveNewStringUniqueParams = false;
            for (ResourceIndexedComboStringUnique next : this.myDaoSearchParamSynchronizer.subtract(theParams.myComboStringUniques, theExistingParams.myComboStringUniques)) {
                ResourceIndexedComboStringUnique existing;
                if (this.myDaoConfig.isUniqueIndexesCheckedBeforeSave() && (existing = this.myResourceIndexedCompositeStringUniqueDao.findByQueryString(next.getIndexString())) != null) {
                    String searchParameterId = "(unknown)";
                    if (next.getSearchParameterId() != null) {
                        searchParameterId = next.getSearchParameterId().toUnqualifiedVersionless().getValue();
                    }
                    String msg = this.myContext.getLocalizer().getMessage(BaseHapiFhirDao.class, "uniqueIndexConflictFailure", new Object[]{theEntity.getResourceType(), next.getIndexString(), existing.getResource().getIdDt().toUnqualifiedVersionless().getValue(), searchParameterId});
                    throw new PreconditionFailedException(Msg.code((int)1093) + msg);
                }
                ourLog.debug("Persisting unique index: {}", (Object)next);
                this.myEntityManager.persist((Object)next);
                haveNewStringUniqueParams = true;
            }
            if (theParams.myComboStringUniques.size() > 0 || haveNewStringUniqueParams) {
                theEntity.setParamsComboStringUniquePresent(true);
            } else {
                theEntity.setParamsComboStringUniquePresent(false);
            }
        }
    }
}

