/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.mdm;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.IMdmLinkJpaRepository;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.mdm.model.MdmPidTuple;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class MdmLinkDaoJpaImpl
implements IMdmLinkDao<MdmLink> {
    @Autowired
    IMdmLinkJpaRepository myMdmLinkDao;
    @Autowired
    protected EntityManager myEntityManager;
    @Autowired
    private IIdHelperService myIdHelperService;

    public int deleteWithAnyReferenceToPid(ResourcePersistentId thePid) {
        return this.myMdmLinkDao.deleteWithAnyReferenceToPid(thePid.getIdAsLong());
    }

    public int deleteWithAnyReferenceToPidAndMatchResultNot(ResourcePersistentId thePid, MdmMatchResultEnum theMatchResult) {
        return this.myMdmLinkDao.deleteWithAnyReferenceToPidAndMatchResultNot(thePid.getIdAsLong(), theMatchResult);
    }

    public List<MdmPidTuple> expandPidsFromGroupPidGivenMatchResult(ResourcePersistentId theGroupPid, MdmMatchResultEnum theMdmMatchResultEnum) {
        return this.myMdmLinkDao.expandPidsFromGroupPidGivenMatchResult(theGroupPid.getIdAsLong(), theMdmMatchResultEnum).stream().map(theMdmPidTuple -> new MdmPidTuple().setSourcePid(new ResourcePersistentId((Object)theMdmPidTuple.getSourcePid())).setGoldenPid(new ResourcePersistentId((Object)theMdmPidTuple.getGoldenPid()))).collect(Collectors.toList());
    }

    public List<MdmPidTuple> expandPidsBySourcePidAndMatchResult(ResourcePersistentId theSourcePid, MdmMatchResultEnum theMdmMatchResultEnum) {
        return this.myMdmLinkDao.expandPidsBySourcePidAndMatchResult(theSourcePid.getIdAsLong(), theMdmMatchResultEnum).stream().map(theMdmPidTuple -> new MdmPidTuple().setSourcePid(new ResourcePersistentId((Object)theMdmPidTuple.getSourcePid())).setGoldenPid(new ResourcePersistentId((Object)theMdmPidTuple.getGoldenPid()))).collect(Collectors.toList());
    }

    public List<MdmPidTuple> expandPidsByGoldenResourcePidAndMatchResult(ResourcePersistentId theSourcePid, MdmMatchResultEnum theMdmMatchResultEnum) {
        return this.myMdmLinkDao.expandPidsByGoldenResourcePidAndMatchResult(theSourcePid.getIdAsLong(), theMdmMatchResultEnum).stream().map(theMdmPidTuple -> new MdmPidTuple().setSourcePid(new ResourcePersistentId((Object)theMdmPidTuple.getSourcePid())).setGoldenPid(new ResourcePersistentId((Object)theMdmPidTuple.getGoldenPid()))).collect(Collectors.toList());
    }

    public List<ResourcePersistentId> findPidByResourceNameAndThreshold(String theResourceName, Date theHighThreshold, Pageable thePageable) {
        return this.myMdmLinkDao.findPidByResourceNameAndThreshold(theResourceName, theHighThreshold, thePageable).stream().map(theResourcePids -> new ResourcePersistentId(theResourcePids)).collect(Collectors.toList());
    }

    public List<ResourcePersistentId> findPidByResourceNameAndThresholdAndPartitionId(String theResourceName, Date theHighThreshold, List<Integer> thePartitionIds, Pageable thePageable) {
        return this.myMdmLinkDao.findPidByResourceNameAndThresholdAndPartitionId(theResourceName, theHighThreshold, thePartitionIds, thePageable).stream().map(theResourcePids -> new ResourcePersistentId(theResourcePids)).collect(Collectors.toList());
    }

    public List<MdmLink> findAllById(List<ResourcePersistentId> thePids) {
        List theLongPids = thePids.stream().map(theResourcePersistentId -> theResourcePersistentId.getIdAsLong()).collect(Collectors.toList());
        return this.myMdmLinkDao.findAllById(theLongPids);
    }

    public Optional<MdmLink> findById(ResourcePersistentId thePid) {
        return this.myMdmLinkDao.findById(thePid.getIdAsLong());
    }

    public void deleteAll(List<MdmLink> theLinks) {
        this.myMdmLinkDao.deleteAll(theLinks);
    }

    public List<MdmLink> findAll(Example<MdmLink> theExample) {
        return this.myMdmLinkDao.findAll(theExample);
    }

    public List<MdmLink> findAll() {
        return this.myMdmLinkDao.findAll();
    }

    public Long count() {
        return this.myMdmLinkDao.count();
    }

    public void deleteAll() {
        this.myMdmLinkDao.deleteAll();
    }

    public MdmLink save(MdmLink theMdmLink) {
        return (MdmLink)((Object)this.myMdmLinkDao.save((Object)theMdmLink));
    }

    public Optional<MdmLink> findOne(Example<MdmLink> theExample) {
        return this.myMdmLinkDao.findOne(theExample);
    }

    public void delete(MdmLink theMdmLink) {
        this.myMdmLinkDao.delete((Object)theMdmLink);
    }

    public MdmLink validateMdmLink(IMdmLink theMdmLink) throws UnprocessableEntityException {
        if (theMdmLink instanceof MdmLink) {
            return (MdmLink)theMdmLink;
        }
        throw new UnprocessableEntityException(Msg.code((int)2109) + "Unprocessable MdmLink implementation");
    }

    public Page<MdmLink> search(IIdType theGoldenResourceId, IIdType theSourceId, MdmMatchResultEnum theMatchResult, MdmLinkSourceEnum theLinkSource, MdmPageRequest thePageRequest, List<Integer> thePartitionId) {
        CriteriaBuilder criteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(MdmLink.class);
        Root from = criteriaQuery.from(MdmLink.class);
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>();
        if (theGoldenResourceId != null) {
            Predicate goldenResourcePredicate = criteriaBuilder.equal(from.get("myGoldenResourcePid").as(Long.class), (Object)this.myIdHelperService.getPidOrThrowException(RequestPartitionId.allPartitions(), theGoldenResourceId).getIdAsLong());
            andPredicates.add(goldenResourcePredicate);
        }
        if (theSourceId != null) {
            Predicate sourceIdPredicate = criteriaBuilder.equal(from.get("mySourcePid").as(Long.class), (Object)this.myIdHelperService.getPidOrThrowException(RequestPartitionId.allPartitions(), theSourceId).getIdAsLong());
            andPredicates.add(sourceIdPredicate);
        }
        if (theMatchResult != null) {
            Predicate matchResultPredicate = criteriaBuilder.equal(from.get("myMatchResult").as(MdmMatchResultEnum.class), (Object)theMatchResult);
            andPredicates.add(matchResultPredicate);
        }
        if (theLinkSource != null) {
            Predicate linkSourcePredicate = criteriaBuilder.equal(from.get("myLinkSource").as(MdmLinkSourceEnum.class), (Object)theLinkSource);
            andPredicates.add(linkSourcePredicate);
        }
        if (!CollectionUtils.isEmpty(thePartitionId)) {
            Expression exp = from.get("myPartitionId").get("myPartitionId").as(Integer.class);
            Predicate linkSourcePredicate = exp.in(thePartitionId);
            andPredicates.add(linkSourcePredicate);
        }
        Predicate finalQuery = criteriaBuilder.and(andPredicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.myEntityManager.createQuery(criteriaQuery.where((Expression)finalQuery));
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        countQuery.select((Selection)criteriaBuilder.count((Expression)countQuery.from(MdmLink.class))).where((Expression)finalQuery);
        Long totalResults = (Long)this.myEntityManager.createQuery(countQuery).getSingleResult();
        return new PageImpl(typedQuery.setFirstResult(thePageRequest.getOffset()).setMaxResults(thePageRequest.getCount()).getResultList(), (Pageable)PageRequest.of((int)thePageRequest.getPage(), (int)thePageRequest.getCount()), totalResults.longValue());
    }

    public Optional<? extends IMdmLink> findBySourcePidAndMatchResult(ResourcePersistentId theSourcePid, MdmMatchResultEnum theMatch) {
        return this.myMdmLinkDao.findBySourcePidAndMatchResult(theSourcePid.getIdAsLong(), theMatch);
    }

    public void deleteLinksWithAnyReferenceToPids(List<ResourcePersistentId> theResourcePersistentIds) {
        List goldenResourcePids = theResourcePersistentIds.stream().map(ResourcePersistentId::getIdAsLong).collect(Collectors.toList());
        List chunks = ListUtils.partition(goldenResourcePids, (int)500);
        for (List chunk : chunks) {
            this.myMdmLinkDao.deleteLinksWithAnyReferenceToPids(chunk);
        }
    }
}

