/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.i18n.Msg;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SearchFilterParser {
    private static final String XML_DATE_PATTERN = "[0-9]{4}(-(0[1-9]|1[0-2])(-(0[0-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|([+\\-])((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?";
    private static final Pattern XML_DATE_MATCHER = Pattern.compile("[0-9]{4}(-(0[1-9]|1[0-2])(-(0[0-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|([+\\-])((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?");
    private static final List<String> CODES_CompareOperation = Arrays.asList("eq", "ne", "co", "sw", "ew", "gt", "lt", "ge", "le", "pr", "po", "ss", "sb", "in", "re");
    private static final List<String> CODES_LogicalOperation = Arrays.asList("and", "or", "not");
    private String original = null;
    private int cursor;

    private boolean isDate(String s) {
        Matcher m = XML_DATE_MATCHER.matcher(s);
        return m.matches();
    }

    private FilterLexType peek() throws FilterSyntaxException {
        FilterLexType result;
        while (this.cursor < this.original.length() && this.original.charAt(this.cursor) == ' ') {
            ++this.cursor;
        }
        if (this.cursor >= this.original.length()) {
            result = FilterLexType.fsltEnded;
        } else if (this.original.charAt(this.cursor) >= 'a' && this.original.charAt(this.cursor) <= 'z' || this.original.charAt(this.cursor) >= 'A' && this.original.charAt(this.cursor) <= 'Z' || this.original.charAt(this.cursor) == '_') {
            result = FilterLexType.fsltName;
        } else if (this.original.charAt(this.cursor) >= '0' && this.original.charAt(this.cursor) <= '9') {
            result = FilterLexType.fsltNumber;
        } else if (this.original.charAt(this.cursor) == '\"') {
            result = FilterLexType.fsltString;
        } else if (this.original.charAt(this.cursor) == '.') {
            result = FilterLexType.fsltDot;
        } else if (this.original.charAt(this.cursor) == '(') {
            result = FilterLexType.fsltOpen;
        } else if (this.original.charAt(this.cursor) == ')') {
            result = FilterLexType.fsltClose;
        } else if (this.original.charAt(this.cursor) == '[') {
            result = FilterLexType.fsltOpenSq;
        } else if (this.original.charAt(this.cursor) == ']') {
            result = FilterLexType.fsltCloseSq;
        } else {
            throw new FilterSyntaxException(Msg.code((int)1052) + String.format("Unknown Character \"%s\" at %d", this.peekCh(), this.cursor));
        }
        return result;
    }

    private String peekCh() {
        String result = this.cursor > this.original.length() ? "[end!]" : this.original.substring(this.cursor, this.cursor + 1);
        return result;
    }

    private String consumeName() {
        int i = this.cursor;
        while (++i <= this.original.length() - 1 && (this.original.charAt(i) >= 'a' && this.original.charAt(i) <= 'z' || this.original.charAt(i) >= 'A' && this.original.charAt(i) <= 'Z' || this.original.charAt(i) >= '0' && this.original.charAt(i) <= '9' || this.original.charAt(i) == '-' || this.original.charAt(i) == '_' || this.original.charAt(i) == ':')) {
        }
        String result = this.original.substring(this.cursor, i);
        this.cursor = i;
        return result;
    }

    private String consumeToken() {
        int i = this.cursor;
        while (++i <= this.original.length() - 1 && this.original.charAt(i) > ' ' && !StringUtils.isWhitespace((CharSequence)this.original.substring(i, i + 1)) && this.original.charAt(i) != ')' && this.original.charAt(i) != ']') {
        }
        String result = this.original.substring(this.cursor, i);
        this.cursor = i;
        return result;
    }

    private String consumeNumberOrDate() {
        int i = this.cursor;
        while (++i <= this.original.length() - 1 && (this.original.charAt(i) >= '0' && this.original.charAt(i) <= '9' || this.original.charAt(i) == '.' || this.original.charAt(i) == '-' || this.original.charAt(i) == ':' || this.original.charAt(i) == '+' || this.original.charAt(i) == 'T')) {
        }
        String result = this.original.substring(this.cursor, i);
        this.cursor = i;
        return result;
    }

    private String consumeString() throws FilterSyntaxException {
        ++this.cursor;
        StringBuilder str = new StringBuilder(this.original.length());
        while (this.cursor <= this.original.length() && this.original.charAt(this.cursor) != '\"') {
            if (this.original.charAt(this.cursor) != '\\') {
                str.append(this.original.charAt(this.cursor));
            } else {
                ++this.cursor;
                if (this.original.charAt(this.cursor) == '\"') {
                    str.append('\"');
                } else if (this.original.charAt(this.cursor) == 't') {
                    str.append('\t');
                } else if (this.original.charAt(this.cursor) == 'r') {
                    str.append('\r');
                } else if (this.original.charAt(this.cursor) == 'n') {
                    str.append('\n');
                } else {
                    throw new FilterSyntaxException(Msg.code((int)1053) + String.format("Unknown escape sequence at %d", this.cursor));
                }
            }
            ++this.cursor;
        }
        if (this.cursor > this.original.length() || this.original.charAt(this.cursor) != '\"') {
            throw new FilterSyntaxException(Msg.code((int)1054) + String.format("Problem with string termination at %d", this.cursor));
        }
        if (str.length() == 0) {
            throw new FilterSyntaxException(Msg.code((int)1055) + String.format("Problem with string at %d cannot be empty", this.cursor));
        }
        ++this.cursor;
        return str.toString();
    }

    private Filter parse() throws FilterSyntaxException {
        Filter result = this.parseOpen();
        if (this.cursor < this.original.length()) {
            throw new FilterSyntaxException(Msg.code((int)1056) + String.format("Expression did not terminate at %d", this.cursor));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Filter parseOpen() throws FilterSyntaxException {
        if (this.peek() == FilterLexType.fsltOpen) {
            ++this.cursor;
            FilterParameterGroup grp = new FilterParameterGroup();
            grp.setContained(this.parseOpen());
            if (this.peek() != FilterLexType.fsltClose) {
                throw new FilterSyntaxException(Msg.code((int)1057) + String.format("Expected ')' at %d but found %s", this.cursor, this.peekCh()));
            }
            ++this.cursor;
            FilterLexType lexType = this.peek();
            if (lexType == FilterLexType.fsltName) {
                return this.parseLogical(grp);
            }
            if (lexType == FilterLexType.fsltEnded) return grp;
            if (lexType == FilterLexType.fsltClose) return grp;
            if (lexType != FilterLexType.fsltCloseSq) throw new FilterSyntaxException(Msg.code((int)1058) + String.format("Unexpected Character %s at %d", this.peekCh(), this.cursor));
            return grp;
        }
        String s = this.consumeName();
        if (s.compareToIgnoreCase("not") != 0) return this.parseParameter(s);
        return this.parseLogical(null);
    }

    private Filter parseLogical(Filter filter) throws FilterSyntaxException {
        FilterLogical result = null;
        if (filter == null) {
            String s = "not";
        } else {
            String s = this.consumeName();
            if (!(s.equals("or") || s.equals("and") || s.equals("not"))) {
                throw new FilterSyntaxException(Msg.code((int)1059) + String.format("Unexpected Name %s at %d", s, this.cursor));
            }
            FilterLogical logical = new FilterLogical();
            logical.setFilter1(filter);
            if (s.compareToIgnoreCase("or") == 0) {
                logical.setOperation(FilterLogicalOperation.or);
            } else if (s.compareToIgnoreCase("not") == 0) {
                logical.setOperation(FilterLogicalOperation.not);
            } else {
                logical.setOperation(FilterLogicalOperation.and);
            }
            logical.setFilter2(this.parseOpen());
            result = logical;
        }
        return result;
    }

    private FilterParameterPath parsePath(String name) throws FilterSyntaxException {
        FilterParameterPath result = new FilterParameterPath();
        result.setName(name);
        if (this.peek() == FilterLexType.fsltOpenSq) {
            ++this.cursor;
            result.setFilter(this.parseOpen());
            if (this.peek() != FilterLexType.fsltCloseSq) {
                throw new FilterSyntaxException(Msg.code((int)1060) + String.format("Expected ']' at %d but found %s", this.cursor, this.peekCh()));
            }
            ++this.cursor;
        }
        if (this.peek() == FilterLexType.fsltDot) {
            ++this.cursor;
            if (this.peek() != FilterLexType.fsltName) {
                throw new FilterSyntaxException(Msg.code((int)1061) + String.format("Unexpected Character %s at %d", this.peekCh(), this.cursor));
            }
            result.setNext(this.parsePath(this.consumeName()));
        } else if (result.getFilter() != null) {
            throw new FilterSyntaxException(Msg.code((int)1062) + String.format("Expected '.' at %d but found %s", this.cursor, this.peekCh()));
        }
        return result;
    }

    private Filter parseParameter(String name) throws FilterSyntaxException {
        Filter result;
        FilterParameter filter = new FilterParameter();
        filter.setParamPath(this.parsePath(name));
        if (this.peek() != FilterLexType.fsltName) {
            throw new FilterSyntaxException(Msg.code((int)1063) + String.format("Unexpected Character %s at %d", this.peekCh(), this.cursor));
        }
        String s = this.consumeName();
        int index = CODES_CompareOperation.indexOf(s);
        if (index == -1) {
            throw new FilterSyntaxException(Msg.code((int)1064) + String.format("Unknown operation %s at %d", s, this.cursor));
        }
        filter.setOperation(CompareOperation.values()[index]);
        FilterLexType lexType = this.peek();
        if (lexType == FilterLexType.fsltName) {
            filter.setValue(this.consumeToken());
            filter.setValueType(FilterValueType.token);
        } else if (lexType == FilterLexType.fsltNumber) {
            filter.setValue(this.consumeNumberOrDate());
            filter.setValueType(FilterValueType.numberOrDate);
        } else if (lexType == FilterLexType.fsltString) {
            filter.setValue(this.consumeString());
            filter.setValueType(FilterValueType.string);
        } else {
            throw new FilterSyntaxException(Msg.code((int)1065) + String.format("Unexpected Character %s at %d", this.peekCh(), this.cursor));
        }
        if (filter.getOperation() == CompareOperation.pr) {
            if (filter.getValue().compareToIgnoreCase("true") != 0 && filter.getValue().compareToIgnoreCase("false") != 0) {
                throw new FilterSyntaxException(Msg.code((int)1066) + String.format("Value %s not valid for operation %s at %d", filter.getValue(), CODES_CompareOperation.get(filter.getOperation().ordinal()), this.cursor));
            }
        } else if (filter.getOperation() == CompareOperation.po && !this.isDate(filter.getValue())) {
            throw new FilterSyntaxException(Msg.code((int)1067) + String.format("Value %s not valid for operation %s at %d", filter.getValue(), CODES_CompareOperation.get(filter.getOperation().ordinal()), this.cursor));
        }
        if ((lexType = this.peek()) == FilterLexType.fsltName) {
            result = this.parseLogical(filter);
        } else if (lexType == FilterLexType.fsltEnded || lexType == FilterLexType.fsltClose || lexType == FilterLexType.fsltCloseSq) {
            result = filter;
        } else {
            throw new FilterSyntaxException(Msg.code((int)1068) + String.format("Unexpected Character %s at %d", this.peekCh(), this.cursor));
        }
        return result;
    }

    public static Filter parse(String expression) throws FilterSyntaxException {
        SearchFilterParser parser = new SearchFilterParser();
        parser.original = expression;
        parser.cursor = 0;
        return parser.parse();
    }

    public static enum FilterLexType {
        fsltEnded,
        fsltName,
        fsltString,
        fsltNumber,
        fsltDot,
        fsltOpen,
        fsltClose,
        fsltOpenSq,
        fsltCloseSq;

    }

    public static class FilterSyntaxException
    extends Exception {
        FilterSyntaxException(String theMessage) {
            super(theMessage);
        }
    }

    public static abstract class Filter {
        private FilterItemType itemType;

        public FilterItemType getFilterItemType() {
            return this.itemType;
        }
    }

    public static class FilterParameterGroup
    extends Filter {
        private Filter FContained;

        public Filter getContained() {
            return this.FContained;
        }

        public void setContained(Filter value) {
            this.FContained = value;
        }

        public String toString() {
            return "(" + this.FContained.toString() + ")";
        }
    }

    public static class FilterLogical
    extends Filter {
        private Filter FFilter1;
        private FilterLogicalOperation FOperation;
        private Filter FFilter2;

        public Filter getFilter1() {
            return this.FFilter1;
        }

        void setFilter1(Filter FFilter1) {
            this.FFilter1 = FFilter1;
        }

        public FilterLogicalOperation getOperation() {
            return this.FOperation;
        }

        public void setOperation(FilterLogicalOperation FOperation) {
            this.FOperation = FOperation;
        }

        public Filter getFilter2() {
            return this.FFilter2;
        }

        void setFilter2(Filter FFilter2) {
            this.FFilter2 = FFilter2;
        }

        public String toString() {
            return this.FFilter1.toString() + " " + CODES_LogicalOperation.get(this.getOperation().ordinal()) + " " + this.FFilter2.toString();
        }
    }

    public static enum FilterLogicalOperation {
        and,
        or,
        not;

    }

    public static class FilterParameterPath {
        private String FName;
        private Filter FFilter;
        private FilterParameterPath FNext;

        public String getName() {
            return this.FName;
        }

        public void setName(String value) {
            this.FName = value;
        }

        public Filter getFilter() {
            return this.FFilter;
        }

        public void setFilter(Filter value) {
            this.FFilter = value;
        }

        public FilterParameterPath getNext() {
            return this.FNext;
        }

        public void setNext(FilterParameterPath value) {
            this.FNext = value;
        }

        public String toString() {
            Object result = this.getFilter() != null ? this.getName() + "[" + this.getFilter().toString() + "]" : this.getName();
            if (this.getNext() != null) {
                result = (String)result + "." + this.getNext().toString();
            }
            return result;
        }
    }

    public static class FilterParameter
    extends Filter {
        private FilterParameterPath FParamPath;
        private CompareOperation FOperation;
        private String FValue;
        private FilterValueType FValueType;

        public FilterParameterPath getParamPath() {
            return this.FParamPath;
        }

        void setParamPath(FilterParameterPath value) {
            this.FParamPath = value;
        }

        public CompareOperation getOperation() {
            return this.FOperation;
        }

        public void setOperation(CompareOperation value) {
            this.FOperation = value;
        }

        public String getValue() {
            return this.FValue;
        }

        public void setValue(String value) {
            this.FValue = value;
        }

        public FilterValueType getValueType() {
            return this.FValueType;
        }

        void setValueType(FilterValueType FValueType) {
            this.FValueType = FValueType;
        }

        public String toString() {
            if (this.FValueType == FilterValueType.string) {
                return this.getParamPath().toString() + " " + CODES_CompareOperation.get(this.getOperation().ordinal()) + " \"" + this.getValue() + "\"";
            }
            return this.getParamPath().toString() + " " + CODES_CompareOperation.get(this.getOperation().ordinal()) + " " + this.getValue();
        }
    }

    public static enum CompareOperation {
        eq,
        ne,
        co,
        sw,
        ew,
        gt,
        lt,
        ge,
        le,
        pr,
        po,
        ss,
        sb,
        in,
        re,
        ap,
        sa,
        eb;

    }

    public static enum FilterValueType {
        token,
        string,
        numberOrDate;

    }

    public static enum FilterItemType {
        parameter,
        logical,
        parameterGroup;

    }
}

