/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.FhirResourceDaoValueSetDstu2;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.util.LogicUtil;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FhirResourceDaoCodeSystemR4
extends BaseHapiFhirResourceDao<CodeSystem>
implements IFhirResourceDaoCodeSystem<CodeSystem, Coding, CodeableConcept> {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirResourceDaoCodeSystemR4.class);
    @Autowired
    protected ITermCodeSystemStorageSvc myTerminologyCodeSystemStorageSvc;
    @Autowired
    protected ITermDeferredStorageSvc myTermDeferredStorageSvc;
    @Autowired
    private IValidationSupport myValidationSupport;
    @Autowired
    private FhirContext myFhirContext;

    public List<IIdType> findCodeSystemIdsContainingSystemAndCode(String theCode, String theSystem, RequestDetails theRequest) {
        List ids = this.searchForIds(new SearchParameterMap("code", (IQueryParameterType)new TokenParam(theSystem, theCode)), theRequest);
        ArrayList<IIdType> valueSetIds = new ArrayList<IIdType>();
        for (ResourcePersistentId next : ids) {
            IIdType id = this.myIdHelperService.translatePidIdToForcedId(this.myFhirContext, "CodeSystem", next);
            valueSetIds.add(id);
        }
        return valueSetIds;
    }

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, Coding theCoding, RequestDetails theRequestDetails) {
        return this.lookupCode(theCode, theSystem, theCoding, (IPrimitiveType<String>)null, theRequestDetails);
    }

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, Coding theCoding, IPrimitiveType<String> theDisplayLanguage, RequestDetails theRequestDetails) {
        Object system;
        String code;
        boolean haveDisplayLanguage;
        boolean haveCoding = theCoding != null && StringUtils.isNotBlank((CharSequence)theCoding.getSystem()) && StringUtils.isNotBlank((CharSequence)theCoding.getCode());
        boolean haveCode = theCode != null && !theCode.isEmpty();
        boolean haveSystem = theSystem != null && !theSystem.isEmpty();
        boolean bl = haveDisplayLanguage = theDisplayLanguage != null && !theDisplayLanguage.isEmpty();
        if (!(haveCoding || haveSystem && haveCode)) {
            throw new InvalidRequestException(Msg.code((int)1108) + "No code, coding, or codeableConcept provided to validate");
        }
        boolean[] blArray = new boolean[2];
        blArray[0] = haveCoding;
        boolean bl2 = blArray[1] = haveSystem && haveCode;
        if (!LogicUtil.multiXor(blArray) || haveSystem != haveCode) {
            throw new InvalidRequestException(Msg.code((int)1109) + "$lookup can only validate (system AND code) OR (coding.system AND coding.code)");
        }
        if (haveCoding) {
            code = theCoding.getCode();
            system = theCoding.hasVersion() ? theCoding.getSystem() + "|" + theCoding.getVersion() : theCoding.getSystem();
        } else {
            code = (String)theCode.getValue();
            system = (String)theSystem.getValue();
        }
        String displayLanguage = null;
        if (haveDisplayLanguage) {
            displayLanguage = (String)theDisplayLanguage.getValue();
        }
        ourLog.debug("Looking up {} / {}", system, (Object)code);
        if (this.myValidationSupport.isCodeSystemSupported(new ValidationSupportContext(this.myValidationSupport), (String)system)) {
            ourLog.debug("Code system {} is supported", system);
            IValidationSupport.LookupCodeResult retVal = this.myValidationSupport.lookupCode(new ValidationSupportContext(this.myValidationSupport), (String)system, code, displayLanguage);
            if (retVal != null) {
                return retVal;
            }
        }
        return IValidationSupport.LookupCodeResult.notFound((String)system, (String)code);
    }

    public IFhirResourceDaoCodeSystem.SubsumesResult subsumes(IPrimitiveType<String> theCodeA, IPrimitiveType<String> theCodeB, IPrimitiveType<String> theSystem, Coding theCodingA, Coding theCodingB, RequestDetails theRequestDetails) {
        return this.myTerminologySvc.subsumes(theCodeA, theCodeB, theSystem, (IBaseCoding)theCodingA, (IBaseCoding)theCodingB);
    }

    @Override
    protected void preDelete(CodeSystem theResourceToDelete, ResourceTable theEntityToDelete, RequestDetails theRequestDetails) {
        super.preDelete(theResourceToDelete, theEntityToDelete, theRequestDetails);
        this.myTermDeferredStorageSvc.deleteCodeSystemForResource(theEntityToDelete);
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequest, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequest, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (!retVal.isUnchangedInCurrentOperation()) {
            CodeSystem cs = (CodeSystem)theResource;
            this.addPidToResource(theEntity, theResource);
            this.myTerminologyCodeSystemStorageSvc.storeNewCodeSystemVersionIfNeeded(cs, (ResourceTable)theEntity, theRequest);
        }
        return retVal;
    }

    public IValidationSupport.CodeValidationResult validateCode(IIdType theCodeSystemId, IPrimitiveType<String> theCodeSystemUrl, IPrimitiveType<String> theVersion, IPrimitiveType<String> theCode, IPrimitiveType<String> theDisplay, Coding theCoding, CodeableConcept theCodeableConcept, RequestDetails theRequestDetails) {
        return this.myTerminologySvc.codeSystemValidateCode(theCodeSystemId, FhirResourceDaoValueSetDstu2.toStringOrNull(theCodeSystemUrl), FhirResourceDaoValueSetDstu2.toStringOrNull(theVersion), FhirResourceDaoValueSetDstu2.toStringOrNull(theCode), FhirResourceDaoValueSetDstu2.toStringOrNull(theDisplay), (IBaseDatatype)theCoding, (IBaseDatatype)theCodeableConcept);
    }

    @Override
    public DaoMethodOutcome create(CodeSystem theResource, String theIfNoneExist, boolean thePerformIndexing, @Nonnull TransactionDetails theTransactionDetails, RequestDetails theRequestDetails) {
        if (StringUtils.isNotBlank((CharSequence)theResource.getUrl()) && theResource.getUrl().contains("loinc") && StringUtils.isBlank((CharSequence)theResource.getIdElement().getIdPart())) {
            throw new InvalidParameterException(Msg.code((int)1110) + "'loinc' CodeSystem must have an ID");
        }
        return (DaoMethodOutcome)this.myTransactionService.execute(theRequestDetails, theTransactionDetails, tx -> this.doCreateForPost(theResource, theIfNoneExist, thePerformIndexing, theTransactionDetails, theRequestDetails));
    }
}

