/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoSearchParameter;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.SearchParameter;
import org.springframework.beans.factory.annotation.Autowired;

public class FhirResourceDaoSearchParameterR4
extends BaseHapiFhirResourceDao<SearchParameter>
implements IFhirResourceDaoSearchParameter<SearchParameter> {
    private static final Pattern REGEX_SP_EXPRESSION_HAS_PATH = Pattern.compile("[( ]*([A-Z][a-zA-Z]+\\.)?[a-z].*");
    @Autowired
    private ISearchParamExtractor mySearchParamExtractor;

    protected void reindexAffectedResources(SearchParameter theResource, RequestDetails theRequestDetails) {
        Boolean reindex = theResource != null ? CURRENTLY_REINDEXING.get((IAnyResource)theResource) : null;
        String expression = theResource != null ? theResource.getExpression() : null;
        List base = theResource != null ? theResource.getBase().stream().map(CodeType::getCode).collect(Collectors.toList()) : null;
        this.requestReindexForRelatedResources(reindex, base, theRequestDetails);
    }

    @Override
    protected void postPersist(ResourceTable theEntity, SearchParameter theResource, RequestDetails theRequestDetails) {
        super.postPersist(theEntity, theResource, theRequestDetails);
        this.reindexAffectedResources(theResource, theRequestDetails);
    }

    @Override
    protected void postUpdate(ResourceTable theEntity, SearchParameter theResource, RequestDetails theRequestDetails) {
        super.postUpdate(theEntity, theResource, theRequestDetails);
        this.reindexAffectedResources(theResource, theRequestDetails);
    }

    @Override
    protected void preDelete(SearchParameter theResourceToDelete, ResourceTable theEntityToDelete, RequestDetails theRequestDetails) {
        super.preDelete(theResourceToDelete, theEntityToDelete, theRequestDetails);
        this.reindexAffectedResources(theResourceToDelete, theRequestDetails);
    }

    @Override
    protected void validateResourceForStorage(SearchParameter theResource, ResourceTable theEntityToSave) {
        super.validateResourceForStorage(theResource, theEntityToSave);
        FhirResourceDaoSearchParameterR4.validateSearchParam(theResource, this.getContext(), this.getConfig(), this.mySearchParamRegistry, this.mySearchParamExtractor);
    }

    public static void validateSearchParam(SearchParameter theResource, FhirContext theContext, DaoConfig theDaoConfig, ISearchParamRegistry theSearchParamRegistry, ISearchParamExtractor theSearchParamExtractor) {
        if (!theDaoConfig.getModelConfig().isDefaultSearchParamsCanBeOverridden()) {
            for (IPrimitiveType nextBaseType : theResource.getBase()) {
                boolean isBuiltIn;
                String nextBase = nextBaseType.getValueAsString();
                RuntimeSearchParam existingSearchParam = theSearchParamRegistry.getActiveSearchParam(nextBase, theResource.getCode());
                if (existingSearchParam == null) continue;
                boolean bl = isBuiltIn = existingSearchParam.getId() == null;
                if (!(isBuiltIn |= existingSearchParam.getUri().startsWith("http://hl7.org/fhir/SearchParameter/"))) continue;
                throw new UnprocessableEntityException(Msg.code((int)1111) + "Can not override built-in search parameter " + (String)nextBase + ":" + theResource.getCode() + " because overriding is disabled on this server");
            }
        }
        if (theResource.getStatus() == null) {
            throw new UnprocessableEntityException(Msg.code((int)1112) + "SearchParameter.status is missing or invalid");
        }
        if (!theResource.getStatus().name().equals("ACTIVE")) {
            return;
        }
        if (ElementUtil.isEmpty((List)theResource.getBase()) && (theResource.getType() == null || !Enumerations.SearchParamType.COMPOSITE.name().equals(theResource.getType().name()))) {
            throw new UnprocessableEntityException(Msg.code((int)1113) + "SearchParameter.base is missing");
        }
        boolean isUnique = theResource.getExtensionsByUrl("http://hapifhir.io/fhir/StructureDefinition/sp-unique").stream().anyMatch(t -> "true".equals(t.getValueAsPrimitive().getValueAsString()));
        if (theResource.getType() == null || !theResource.getType().name().equals(Enumerations.SearchParamType.COMPOSITE.name()) || !StringUtils.isBlank((CharSequence)theResource.getExpression())) {
            if (StringUtils.isBlank((CharSequence)theResource.getExpression())) {
                throw new UnprocessableEntityException(Msg.code((int)1114) + "SearchParameter.expression is missing");
            }
            String expression = theResource.getExpression().trim();
            if (isUnique) {
                if (theResource.getComponent().size() == 0) {
                    throw new UnprocessableEntityException(Msg.code((int)1115) + "SearchParameter is marked as unique but has no components");
                }
                for (SearchParameter.SearchParameterComponentComponent next : theResource.getComponent()) {
                    if (!StringUtils.isBlank((CharSequence)next.getDefinition())) continue;
                    throw new UnprocessableEntityException(Msg.code((int)1116) + "SearchParameter is marked as unique but is missing component.definition");
                }
            }
            if (!theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
                String[] expressionSplit;
                for (String nextPath : expressionSplit = theSearchParamExtractor.split(expression)) {
                    int dotIdx = (nextPath = nextPath.trim()).indexOf(46);
                    if (dotIdx == -1) {
                        throw new UnprocessableEntityException(Msg.code((int)1117) + "Invalid SearchParameter.expression value \"" + nextPath + "\". Must start with a resource name.");
                    }
                    String resourceName = nextPath.substring(0, dotIdx);
                    try {
                        theContext.getResourceDefinition(resourceName);
                    }
                    catch (DataFormatException e) {
                        throw new UnprocessableEntityException(Msg.code((int)1118) + "Invalid SearchParameter.expression value \"" + nextPath + "\": " + e.getMessage());
                    }
                    if (!theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3) || !theDaoConfig.isValidateSearchParameterExpressionsOnSave()) continue;
                    IBaseResource temporaryInstance = (IBaseResource)theContext.getResourceDefinition(resourceName).newInstance();
                    try {
                        theContext.newFluentPath().evaluate((IBase)temporaryInstance, nextPath, IBase.class);
                    }
                    catch (Exception e) {
                        String msg = theContext.getLocalizer().getMessageSanitized(FhirResourceDaoSearchParameterR4.class, "invalidSearchParamExpression", new Object[]{nextPath, e.getMessage()});
                        throw new UnprocessableEntityException(Msg.code((int)1119) + msg, (Throwable)e);
                    }
                }
            } else {
                if (!isUnique && theResource.getType() != Enumerations.SearchParamType.COMPOSITE && theResource.getType() != Enumerations.SearchParamType.SPECIAL && !REGEX_SP_EXPRESSION_HAS_PATH.matcher(expression).matches()) {
                    throw new UnprocessableEntityException(Msg.code((int)1120) + "SearchParameter.expression value \"" + expression + "\" is invalid");
                }
                try {
                    theContext.newFluentPath().parse(expression);
                }
                catch (Exception e) {
                    throw new UnprocessableEntityException(Msg.code((int)1121) + "Invalid SearchParameter.expression value \"" + expression + "\": " + e.getMessage());
                }
            }
        }
    }
}

