/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.r5;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoPatient;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.Arrays;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.Patient;
import org.springframework.beans.factory.annotation.Autowired;

public class FhirResourceDaoPatientR5
extends BaseHapiFhirResourceDao<Patient>
implements IFhirResourceDaoPatient<Patient> {
    @Autowired
    private IRequestPartitionHelperSvc myPartitionHelperSvc;

    private IBundleProvider doEverythingOperation(TokenOrListParam theId, IPrimitiveType<Integer> theCount, IPrimitiveType<Integer> theOffset, DateRangeParam theLastUpdated, SortSpec theSort, StringAndListParam theContent, StringAndListParam theNarrative, StringAndListParam theTypes, RequestDetails theRequest) {
        SearchParameterMap paramMap = new SearchParameterMap();
        if (theCount != null) {
            paramMap.setCount((Integer)theCount.getValue());
        }
        if (theOffset != null) {
            throw new IllegalArgumentException(Msg.code((int)1122) + "Everything operation does not support offset searching");
        }
        if (theContent != null) {
            paramMap.add("_content", (IQueryParameterAnd)theContent);
        }
        if (theNarrative != null) {
            paramMap.add("_text", (IQueryParameterAnd)theNarrative);
        }
        if (theTypes != null) {
            paramMap.add("_type", (IQueryParameterAnd)theTypes);
        }
        paramMap.setIncludes(Collections.singleton(IBaseResource.INCLUDE_ALL.asRecursive()));
        paramMap.setEverythingMode(theId != null ? SearchParameterMap.EverythingModeEnum.PATIENT_INSTANCE : SearchParameterMap.EverythingModeEnum.PATIENT_TYPE);
        paramMap.setSort(theSort);
        paramMap.setLastUpdated(theLastUpdated);
        if (theId != null) {
            String[] paramVal;
            if (theRequest.getParameters().containsKey("_mdm") && Arrays.asList(paramVal = (String[])theRequest.getParameters().get("_mdm")).contains("true")) {
                theId.getValuesAsQueryTokens().stream().forEach(param -> param.setMdmExpand(true));
            }
            paramMap.add("_id", (IQueryParameterOr)theId);
        }
        if (!this.isPagingProviderDatabaseBacked(theRequest)) {
            paramMap.setLoadSynchronous(true);
        }
        RequestPartitionId requestPartitionId = this.myPartitionHelperSvc.determineReadPartitionForRequestForSearchType(theRequest, this.getResourceName(), paramMap, null);
        return this.mySearchCoordinatorSvc.registerSearch((IFhirResourceDao)this, paramMap, this.getResourceName(), new CacheControlDirective().parse(theRequest.getHeaders("Cache-Control")), theRequest, requestPartitionId);
    }

    public IBundleProvider patientInstanceEverything(HttpServletRequest theServletRequest, IIdType theId, IPrimitiveType<Integer> theCount, IPrimitiveType<Integer> theOffset, DateRangeParam theLastUpdated, SortSpec theSort, StringAndListParam theContent, StringAndListParam theNarrative, StringAndListParam theFilter, StringAndListParam theTypes, RequestDetails theRequestDetails) {
        TokenOrListParam id = (TokenOrListParam)new TokenOrListParam().add((IQueryParameterType)new TokenParam(theId.getIdPart()));
        return this.doEverythingOperation(id, theCount, theOffset, theLastUpdated, theSort, theContent, theNarrative, theTypes, theRequestDetails);
    }

    public IBundleProvider patientTypeEverything(HttpServletRequest theServletRequest, IPrimitiveType<Integer> theCount, IPrimitiveType<Integer> theOffset, DateRangeParam theLastUpdated, SortSpec theSort, StringAndListParam theContent, StringAndListParam theNarrative, StringAndListParam theFilter, StringAndListParam theTypes, RequestDetails theRequestDetails, TokenOrListParam theId) {
        return this.doEverythingOperation(theId, theCount, theOffset, theLastUpdated, theSort, theContent, theNarrative, theTypes, theRequestDetails);
    }
}

