/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.r5;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoSearchParameter;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.r4.FhirResourceDaoSearchParameterR4;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class FhirResourceDaoSearchParameterR5
extends BaseHapiFhirResourceDao<org.hl7.fhir.r5.model.SearchParameter>
implements IFhirResourceDaoSearchParameter<org.hl7.fhir.r5.model.SearchParameter> {
    @Autowired
    private ISearchParamExtractor mySearchParamExtractor;

    protected void refactorAffectedResources(org.hl7.fhir.r5.model.SearchParameter theResource, RequestDetails theRequestDetails) {
        Boolean reindex = theResource != null ? CURRENTLY_REINDEXING.get((IAnyResource)theResource) : null;
        String expression = theResource != null ? theResource.getExpression() : null;
        List base = theResource != null ? theResource.getBase().stream().map(CodeType::getCode).collect(Collectors.toList()) : null;
        this.requestReindexForRelatedResources(reindex, base, theRequestDetails);
    }

    @Override
    protected void postPersist(ResourceTable theEntity, org.hl7.fhir.r5.model.SearchParameter theResource, RequestDetails theRequestDetails) {
        super.postPersist(theEntity, theResource, theRequestDetails);
        this.refactorAffectedResources(theResource, theRequestDetails);
    }

    @Override
    protected void postUpdate(ResourceTable theEntity, org.hl7.fhir.r5.model.SearchParameter theResource, RequestDetails theRequestDetails) {
        super.postUpdate(theEntity, theResource, theRequestDetails);
        this.refactorAffectedResources(theResource, theRequestDetails);
    }

    @Override
    protected void preDelete(org.hl7.fhir.r5.model.SearchParameter theResourceToDelete, ResourceTable theEntityToDelete, RequestDetails theRequestDetails) {
        super.preDelete(theResourceToDelete, theEntityToDelete, theRequestDetails);
        this.refactorAffectedResources(theResourceToDelete, theRequestDetails);
    }

    @Override
    protected void validateResourceForStorage(org.hl7.fhir.r5.model.SearchParameter theResource, ResourceTable theEntityToSave) {
        super.validateResourceForStorage(theResource, theEntityToSave);
        FhirResourceDaoSearchParameterR4.validateSearchParam((SearchParameter)VersionConvertorFactory_40_50.convertResource((Resource)theResource, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))), this.getContext(), this.getConfig(), this.mySearchParamRegistry, this.mySearchParamExtractor);
    }
}

