/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.NormalizedQuantitySearchLevel;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.DateUtils;
import ca.uhn.fhir.util.StringUtil;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.TermsPredicateOptionsStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedHSearchClauseBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(ExtendedHSearchClauseBuilder.class);
    private static final double QTY_APPROX_TOLERANCE_PERCENT = 0.1;
    private static final double QTY_TOLERANCE_PERCENT = 0.05;
    final FhirContext myFhirContext;
    public final SearchPredicateFactory myPredicateFactory;
    public final BooleanPredicateClausesStep<?> myRootClause;
    public final ModelConfig myModelConfig;
    final List<TemporalPrecisionEnum> ordinalSearchPrecisions = Arrays.asList(TemporalPrecisionEnum.YEAR, TemporalPrecisionEnum.MONTH, TemporalPrecisionEnum.DAY);

    public ExtendedHSearchClauseBuilder(FhirContext myFhirContext, ModelConfig theModelConfig, BooleanPredicateClausesStep<?> myRootClause, SearchPredicateFactory myPredicateFactory) {
        this.myFhirContext = myFhirContext;
        this.myModelConfig = theModelConfig;
        this.myRootClause = myRootClause;
        this.myPredicateFactory = myPredicateFactory;
    }

    public void addResourceTypeClause(String theResourceType) {
        this.myRootClause.must((PredicateFinalStep)this.myPredicateFactory.match().field("myResourceType").matching((Object)theResourceType));
    }

    @Nonnull
    private Set<String> extractOrStringParams(List<? extends IQueryParameterType> nextAnd) {
        HashSet<String> terms = new HashSet<String>();
        for (IQueryParameterType iQueryParameterType : nextAnd) {
            String nextValueTrimmed;
            if (iQueryParameterType instanceof StringParam) {
                StringParam nextOrString = (StringParam)iQueryParameterType;
                nextValueTrimmed = StringUtils.defaultString((String)nextOrString.getValue()).trim();
            } else if (iQueryParameterType instanceof TokenParam) {
                TokenParam nextOrToken = (TokenParam)iQueryParameterType;
                nextValueTrimmed = nextOrToken.getValue();
            } else if (iQueryParameterType instanceof ReferenceParam) {
                ReferenceParam referenceParam = (ReferenceParam)iQueryParameterType;
                nextValueTrimmed = referenceParam.getValue();
                if (nextValueTrimmed.contains("/_history")) {
                    nextValueTrimmed = nextValueTrimmed.substring(0, nextValueTrimmed.indexOf("/_history"));
                }
            } else {
                throw new IllegalArgumentException(Msg.code((int)1088) + "Unsupported full-text param type: " + iQueryParameterType.getClass());
            }
            if (!StringUtils.isNotBlank((CharSequence)nextValueTrimmed)) continue;
            terms.add(nextValueTrimmed);
        }
        return terms;
    }

    private PredicateFinalStep orPredicateOrSingle(List<? extends PredicateFinalStep> theOrList) {
        PredicateFinalStep finalClause;
        if (theOrList.size() == 1) {
            finalClause = theOrList.get(0);
        } else {
            BooleanPredicateClausesStep orClause = this.myPredicateFactory.bool();
            theOrList.forEach(arg_0 -> ((BooleanPredicateClausesStep)orClause).should(arg_0));
            finalClause = orClause;
        }
        return finalClause;
    }

    public void addTokenUnmodifiedSearch(String theSearchParamName, List<List<IQueryParameterType>> theAndOrTerms) {
        if (CollectionUtils.isEmpty(theAndOrTerms)) {
            return;
        }
        for (List<IQueryParameterType> nextAnd : theAndOrTerms) {
            ourLog.debug("addTokenUnmodifiedSearch {} {}", (Object)theSearchParamName, nextAnd);
            List clauses = nextAnd.stream().map(orTerm -> {
                if (orTerm instanceof TokenParam) {
                    TokenParam token = (TokenParam)orTerm;
                    if (StringUtils.isBlank((CharSequence)token.getSystem())) {
                        return this.myPredicateFactory.match().field(ExtendedHSearchClauseBuilder.getTokenCodeFieldPath(theSearchParamName)).matching((Object)token.getValue());
                    }
                    if (StringUtils.isBlank((CharSequence)token.getValue())) {
                        return this.myPredicateFactory.match().field("sp." + theSearchParamName + ".token.system").matching((Object)token.getSystem());
                    }
                    return this.myPredicateFactory.match().field(ExtendedHSearchClauseBuilder.getTokenSystemCodeFieldPath(theSearchParamName)).matching((Object)token.getValueAsQueryToken(this.myFhirContext));
                }
                if (orTerm instanceof StringParam) {
                    StringParam string = (StringParam)orTerm;
                    return this.myPredicateFactory.match().field(ExtendedHSearchClauseBuilder.getTokenCodeFieldPath(theSearchParamName)).matching((Object)string.getValue());
                }
                throw new IllegalArgumentException(Msg.code((int)1089) + "Unexpected param type for token search-param: " + orTerm.getClass().getName());
            }).collect(Collectors.toList());
            PredicateFinalStep finalClause = this.orPredicateOrSingle(clauses);
            this.myRootClause.must(finalClause);
        }
    }

    @Nonnull
    public static String getTokenCodeFieldPath(String theSearchParamName) {
        return "sp." + theSearchParamName + ".token.code";
    }

    @Nonnull
    public static String getTokenSystemCodeFieldPath(@Nonnull String theSearchParamName) {
        return "sp." + theSearchParamName + ".token.code-system";
    }

    /*
     * WARNING - void declaration
     */
    public void addStringTextSearch(String theSearchParamName, List<List<IQueryParameterType>> stringAndOrTerms) {
        Object fieldName;
        void var5_7;
        if (CollectionUtils.isEmpty(stringAndOrTerms)) {
            return;
        }
        String string = theSearchParamName;
        int n = -1;
        switch (string.hashCode()) {
            case -985212102: {
                if (!string.equals("_content")) break;
                boolean bl = false;
                break;
            }
            case 91291148: {
                if (!string.equals("_text")) break;
                boolean bl = true;
            }
        }
        switch (var5_7) {
            case 0: {
                fieldName = "myContentText";
                break;
            }
            case 1: {
                fieldName = "myNarrativeText";
                break;
            }
            default: {
                fieldName = "sp." + theSearchParamName + ".string.text";
            }
        }
        for (List list : stringAndOrTerms) {
            Set<String> terms = this.extractOrStringParams(list);
            ourLog.debug("addStringTextSearch {}, {}", (Object)theSearchParamName, terms);
            if (!terms.isEmpty()) {
                String query = terms.stream().map(s -> "( " + s + " )").collect(Collectors.joining(" | "));
                this.myRootClause.must((PredicateFinalStep)this.myPredicateFactory.simpleQueryString().field((String)fieldName).matching(query).defaultOperator(BooleanOperator.AND));
                continue;
            }
            ourLog.warn("No Terms found in query parameter {}", (Object)list);
        }
    }

    public void addStringExactSearch(String theSearchParamName, List<List<IQueryParameterType>> theStringAndOrTerms) {
        String fieldPath = "sp." + theSearchParamName + ".string.exact";
        for (List<IQueryParameterType> nextAnd : theStringAndOrTerms) {
            Set<String> terms = this.extractOrStringParams(nextAnd);
            ourLog.debug("addStringExactSearch {} {}", (Object)theSearchParamName, terms);
            List orTerms = terms.stream().map(s -> this.myPredicateFactory.match().field(fieldPath).matching(s)).collect(Collectors.toList());
            this.myRootClause.must(this.orPredicateOrSingle(orTerms));
        }
    }

    public void addStringContainsSearch(String theSearchParamName, List<List<IQueryParameterType>> theStringAndOrTerms) {
        String fieldPath = "sp." + theSearchParamName + ".string.norm";
        for (List<IQueryParameterType> nextAnd : theStringAndOrTerms) {
            Set<String> terms = this.extractOrStringParams(nextAnd);
            ourLog.debug("addStringContainsSearch {} {}", (Object)theSearchParamName, terms);
            List orTerms = terms.stream().map(s -> this.normalize((String)s)).map(s -> this.myPredicateFactory.wildcard().field(fieldPath).matching("*" + s + "*")).collect(Collectors.toList());
            this.myRootClause.must(this.orPredicateOrSingle(orTerms));
        }
    }

    @Nonnull
    private String normalize(String theString) {
        return StringUtil.normalizeStringForSearchIndexing((String)theString).toLowerCase(Locale.ROOT);
    }

    public void addStringUnmodifiedSearch(String theSearchParamName, List<List<IQueryParameterType>> theStringAndOrTerms) {
        String fieldPath = "sp." + theSearchParamName + ".string.norm";
        for (List<IQueryParameterType> nextAnd : theStringAndOrTerms) {
            Set<String> terms = this.extractOrStringParams(nextAnd);
            ourLog.debug("addStringUnmodifiedSearch {} {}", (Object)theSearchParamName, terms);
            List orTerms = terms.stream().map(s -> this.myPredicateFactory.wildcard().field(fieldPath).matching(this.normalize((String)s) + "*")).collect(Collectors.toList());
            this.myRootClause.must(this.orPredicateOrSingle(orTerms));
        }
    }

    public void addReferenceUnchainedSearch(String theSearchParamName, List<List<IQueryParameterType>> theReferenceAndOrTerms) {
        String fieldPath = "sp." + theSearchParamName + ".reference.value";
        for (List<IQueryParameterType> nextAnd : theReferenceAndOrTerms) {
            Set<String> terms = this.extractOrStringParams(nextAnd);
            ourLog.trace("reference unchained search {}", terms);
            List orTerms = terms.stream().map(s -> this.myPredicateFactory.match().field(fieldPath).matching(s)).collect(Collectors.toList());
            this.myRootClause.must(this.orPredicateOrSingle(orTerms));
        }
    }

    public void addDateUnmodifiedSearch(String theSearchParamName, List<List<IQueryParameterType>> theDateAndOrTerms) {
        for (List<IQueryParameterType> nextAnd : theDateAndOrTerms) {
            if (nextAnd.size() > 1) {
                throw new IllegalArgumentException(Msg.code((int)2032) + "OR (,) searches on DATE search parameters are not supported for ElasticSearch/Lucene");
            }
            DateParam dateParam = (DateParam)nextAnd.stream().findFirst().orElseThrow(() -> new InvalidRequestException("Date param is missing value"));
            boolean isOrdinalSearch = this.ordinalSearchPrecisions.contains(dateParam.getPrecision());
            PredicateFinalStep searchPredicate = isOrdinalSearch ? this.generateDateOrdinalSearchTerms(theSearchParamName, dateParam) : this.generateDateInstantSearchTerms(theSearchParamName, dateParam);
            this.myRootClause.must(searchPredicate);
        }
    }

    private PredicateFinalStep generateDateOrdinalSearchTerms(String theSearchParamName, DateParam theDateParam) {
        List<RangePredicateOptionsStep> predicateSteps;
        int upperBoundAsOrdinal;
        String lowerOrdinalField = "sp." + theSearchParamName + ".dt.lower-ord";
        String upperOrdinalField = "sp." + theSearchParamName + ".dt.upper-ord";
        ParamPrefixEnum prefix = theDateParam.getPrefix();
        int lowerBoundAsOrdinal = upperBoundAsOrdinal = DateUtils.convertDateToDayInteger((Date)theDateParam.getValue());
        TemporalPrecisionEnum precision = theDateParam.getPrecision();
        if (precision == TemporalPrecisionEnum.YEAR || precision == TemporalPrecisionEnum.MONTH) {
            Pair completedDate = DateUtils.getCompletedDate((String)theDateParam.getValueAsString());
            lowerBoundAsOrdinal = Integer.parseInt(((String)completedDate.getLeft()).replace("-", ""));
            upperBoundAsOrdinal = Integer.parseInt(((String)completedDate.getRight()).replace("-", ""));
        }
        if (Objects.isNull(prefix) || prefix == ParamPrefixEnum.EQUAL) {
            predicateSteps = Arrays.asList(this.myPredicateFactory.range().field(lowerOrdinalField).atLeast((Object)lowerBoundAsOrdinal), this.myPredicateFactory.range().field(upperOrdinalField).atMost((Object)upperBoundAsOrdinal));
            BooleanPredicateClausesStep booleanStep = this.myPredicateFactory.bool();
            predicateSteps.forEach(arg_0 -> ((BooleanPredicateClausesStep)booleanStep).must(arg_0));
            return booleanStep;
        }
        if (ParamPrefixEnum.GREATERTHAN == prefix || ParamPrefixEnum.STARTS_AFTER == prefix) {
            return this.myPredicateFactory.range().field(upperOrdinalField).greaterThan((Object)upperBoundAsOrdinal);
        }
        if (ParamPrefixEnum.GREATERTHAN_OR_EQUALS == prefix) {
            return this.myPredicateFactory.range().field(upperOrdinalField).atLeast((Object)upperBoundAsOrdinal);
        }
        if (ParamPrefixEnum.LESSTHAN == prefix || ParamPrefixEnum.ENDS_BEFORE == prefix) {
            return this.myPredicateFactory.range().field(lowerOrdinalField).lessThan((Object)lowerBoundAsOrdinal);
        }
        if (ParamPrefixEnum.LESSTHAN_OR_EQUALS == prefix) {
            return this.myPredicateFactory.range().field(lowerOrdinalField).atMost((Object)lowerBoundAsOrdinal);
        }
        if (ParamPrefixEnum.NOT_EQUAL == prefix) {
            predicateSteps = Arrays.asList(this.myPredicateFactory.range().field(upperOrdinalField).lessThan((Object)lowerBoundAsOrdinal), this.myPredicateFactory.range().field(lowerOrdinalField).greaterThan((Object)upperBoundAsOrdinal));
            BooleanPredicateClausesStep booleanStep = this.myPredicateFactory.bool();
            predicateSteps.forEach(arg_0 -> ((BooleanPredicateClausesStep)booleanStep).should(arg_0));
            booleanStep.minimumShouldMatchNumber(1);
            return booleanStep;
        }
        throw new IllegalArgumentException(Msg.code((int)2025) + "Date search param does not support prefix of type: " + prefix);
    }

    private PredicateFinalStep generateDateInstantSearchTerms(String theSearchParamName, DateParam theDateParam) {
        String lowerInstantField = "sp." + theSearchParamName + ".dt.lower";
        String upperInstantField = "sp." + theSearchParamName + ".dt.upper";
        ParamPrefixEnum prefix = theDateParam.getPrefix();
        if (ParamPrefixEnum.NOT_EQUAL == prefix) {
            Instant dateInstant = theDateParam.getValue().toInstant();
            List<RangePredicateOptionsStep> predicateSteps = Arrays.asList(this.myPredicateFactory.range().field(upperInstantField).lessThan((Object)dateInstant), this.myPredicateFactory.range().field(lowerInstantField).greaterThan((Object)dateInstant));
            BooleanPredicateClausesStep booleanStep = this.myPredicateFactory.bool();
            predicateSteps.forEach(arg_0 -> ((BooleanPredicateClausesStep)booleanStep).should(arg_0));
            booleanStep.minimumShouldMatchNumber(1);
            return booleanStep;
        }
        DateRangeParam dateRange = new DateRangeParam(theDateParam);
        Instant lowerBoundAsInstant = Optional.ofNullable(dateRange.getLowerBound()).map(param -> param.getValue().toInstant()).orElse(null);
        Instant upperBoundAsInstant = Optional.ofNullable(dateRange.getUpperBound()).map(param -> param.getValue().toInstant()).orElse(null);
        if (Objects.isNull(prefix) || prefix == ParamPrefixEnum.EQUAL) {
            List<RangePredicateOptionsStep> predicateSteps = Arrays.asList(this.myPredicateFactory.range().field(lowerInstantField).atLeast((Object)lowerBoundAsInstant), this.myPredicateFactory.range().field(upperInstantField).atMost((Object)upperBoundAsInstant));
            BooleanPredicateClausesStep booleanStep = this.myPredicateFactory.bool();
            predicateSteps.forEach(arg_0 -> ((BooleanPredicateClausesStep)booleanStep).must(arg_0));
            return booleanStep;
        }
        if (ParamPrefixEnum.GREATERTHAN == prefix || ParamPrefixEnum.STARTS_AFTER == prefix) {
            return this.myPredicateFactory.range().field(upperInstantField).greaterThan((Object)lowerBoundAsInstant);
        }
        if (ParamPrefixEnum.GREATERTHAN_OR_EQUALS == prefix) {
            return this.myPredicateFactory.range().field(upperInstantField).atLeast((Object)lowerBoundAsInstant);
        }
        if (ParamPrefixEnum.LESSTHAN == prefix || ParamPrefixEnum.ENDS_BEFORE == prefix) {
            return this.myPredicateFactory.range().field(lowerInstantField).lessThan((Object)upperBoundAsInstant);
        }
        if (ParamPrefixEnum.LESSTHAN_OR_EQUALS == prefix) {
            return this.myPredicateFactory.range().field(lowerInstantField).atMost((Object)upperBoundAsInstant);
        }
        throw new IllegalArgumentException(Msg.code((int)2026) + "Date search param does not support prefix of type: " + prefix);
    }

    public void addQuantityUnmodifiedSearch(String theSearchParamName, List<List<IQueryParameterType>> theQuantityAndOrTerms) {
        for (List<IQueryParameterType> nextAnd : theQuantityAndOrTerms) {
            BooleanPredicateClausesStep quantityTerms = this.myPredicateFactory.bool();
            quantityTerms.minimumShouldMatchNumber(1);
            for (IQueryParameterType paramType : nextAnd) {
                BooleanPredicateClausesStep orQuantityTerms = this.myPredicateFactory.bool();
                this.addQuantityOrClauses(theSearchParamName, paramType, orQuantityTerms);
                quantityTerms.should((PredicateFinalStep)orQuantityTerms);
            }
            this.myRootClause.must((PredicateFinalStep)quantityTerms);
        }
    }

    private void addQuantityOrClauses(String theSearchParamName, IQueryParameterType theParamType, BooleanPredicateClausesStep<?> theQuantityTerms) {
        QuantityParam canonicalQty;
        QuantityParam qtyParam = QuantityParam.toQuantityParam((IQueryParameterType)theParamType);
        ParamPrefixEnum activePrefix = qtyParam.getPrefix() == null ? ParamPrefixEnum.EQUAL : qtyParam.getPrefix();
        String fieldPath = "nsp." + theSearchParamName + ".quantity";
        if (this.myModelConfig.getNormalizedQuantitySearchLevel() == NormalizedQuantitySearchLevel.NORMALIZED_QUANTITY_SEARCH_SUPPORTED && (canonicalQty = UcumServiceUtil.toCanonicalQuantityOrNull((QuantityParam)qtyParam)) != null) {
            String valueFieldPath = fieldPath + ".value-norm";
            this.setPrefixedQuantityPredicate(theQuantityTerms, activePrefix, canonicalQty, valueFieldPath);
            theQuantityTerms.must((PredicateFinalStep)this.myPredicateFactory.match().field(fieldPath + ".code-norm").matching((Object)canonicalQty.getUnits()));
            return;
        }
        String valueFieldPath = fieldPath + ".value";
        this.setPrefixedQuantityPredicate(theQuantityTerms, activePrefix, qtyParam, valueFieldPath);
        if (StringUtils.isNotBlank((CharSequence)qtyParam.getSystem())) {
            theQuantityTerms.must((PredicateFinalStep)this.myPredicateFactory.match().field(fieldPath + ".system").matching((Object)qtyParam.getSystem()));
        }
        if (StringUtils.isNotBlank((CharSequence)qtyParam.getUnits())) {
            theQuantityTerms.must((PredicateFinalStep)this.myPredicateFactory.match().field(fieldPath + ".code").matching((Object)qtyParam.getUnits()));
        }
    }

    private void setPrefixedQuantityPredicate(BooleanPredicateClausesStep<?> theQuantityTerms, ParamPrefixEnum thePrefix, QuantityParam theQuantity, String valueFieldPath) {
        double value = theQuantity.getValue().doubleValue();
        double approxTolerance = value * 0.1;
        double defaultTolerance = value * 0.05;
        switch (thePrefix) {
            case APPROXIMATE: {
                theQuantityTerms.must((PredicateFinalStep)this.myPredicateFactory.range().field(valueFieldPath).between((Object)(value - approxTolerance), (Object)(value + approxTolerance)));
                break;
            }
            case EQUAL: {
                theQuantityTerms.must((PredicateFinalStep)this.myPredicateFactory.range().field(valueFieldPath).between((Object)(value - defaultTolerance), (Object)(value + defaultTolerance)));
                break;
            }
            case GREATERTHAN: 
            case STARTS_AFTER: {
                theQuantityTerms.must((PredicateFinalStep)this.myPredicateFactory.range().field(valueFieldPath).greaterThan((Object)value));
                break;
            }
            case GREATERTHAN_OR_EQUALS: {
                theQuantityTerms.must((PredicateFinalStep)this.myPredicateFactory.range().field(valueFieldPath).atLeast((Object)value));
                break;
            }
            case LESSTHAN: 
            case ENDS_BEFORE: {
                theQuantityTerms.must((PredicateFinalStep)this.myPredicateFactory.range().field(valueFieldPath).lessThan((Object)value));
                break;
            }
            case LESSTHAN_OR_EQUALS: {
                theQuantityTerms.must((PredicateFinalStep)this.myPredicateFactory.range().field(valueFieldPath).atMost((Object)value));
                break;
            }
            case NOT_EQUAL: {
                theQuantityTerms.mustNot((PredicateFinalStep)this.myPredicateFactory.range().field(valueFieldPath).between((Object)(value - defaultTolerance), (Object)(value + defaultTolerance)));
            }
        }
    }

    public void addUriUnmodifiedSearch(String theParamName, List<List<IQueryParameterType>> theUriUnmodifiedAndOrTerms) {
        for (List<IQueryParameterType> nextAnd : theUriUnmodifiedAndOrTerms) {
            List orTerms = nextAnd.stream().map(p -> ((UriParam)p).getValue()).collect(Collectors.toList());
            TermsPredicateOptionsStep orTermPredicate = this.myPredicateFactory.terms().field(String.join((CharSequence)".", "sp", theParamName, "uri-value")).matchingAny(orTerms);
            this.myRootClause.must((PredicateFinalStep)orTermPredicate);
        }
    }

    public void addNumberUnmodifiedSearch(String theParamName, List<List<IQueryParameterType>> theNumberUnmodifiedAndOrTerms) {
        String fieldPath = String.join((CharSequence)".", "sp", theParamName, "number-value");
        for (List<IQueryParameterType> nextAnd : theNumberUnmodifiedAndOrTerms) {
            List orTerms = nextAnd.stream().map(NumberParam.class::cast).collect(Collectors.toList());
            BooleanPredicateClausesStep numberPredicateStep = this.myPredicateFactory.bool();
            numberPredicateStep.minimumShouldMatchNumber(1);
            for (NumberParam orTerm : orTerms) {
                double value = orTerm.getValue().doubleValue();
                double approxTolerance = value * 0.1;
                double defaultTolerance = value * 0.05;
                ParamPrefixEnum activePrefix = orTerm.getPrefix() == null ? ParamPrefixEnum.EQUAL : orTerm.getPrefix();
                switch (activePrefix) {
                    case APPROXIMATE: {
                        numberPredicateStep.should((PredicateFinalStep)this.myPredicateFactory.range().field(fieldPath).between((Object)(value - approxTolerance), (Object)(value + approxTolerance)));
                        break;
                    }
                    case EQUAL: {
                        numberPredicateStep.should((PredicateFinalStep)this.myPredicateFactory.range().field(fieldPath).between((Object)(value - defaultTolerance), (Object)(value + defaultTolerance)));
                        break;
                    }
                    case GREATERTHAN: 
                    case STARTS_AFTER: {
                        numberPredicateStep.should((PredicateFinalStep)this.myPredicateFactory.range().field(fieldPath).greaterThan((Object)value));
                        break;
                    }
                    case GREATERTHAN_OR_EQUALS: {
                        numberPredicateStep.should((PredicateFinalStep)this.myPredicateFactory.range().field(fieldPath).atLeast((Object)value));
                        break;
                    }
                    case LESSTHAN: 
                    case ENDS_BEFORE: {
                        numberPredicateStep.should((PredicateFinalStep)this.myPredicateFactory.range().field(fieldPath).lessThan((Object)value));
                        break;
                    }
                    case LESSTHAN_OR_EQUALS: {
                        numberPredicateStep.should((PredicateFinalStep)this.myPredicateFactory.range().field(fieldPath).atMost((Object)value));
                        break;
                    }
                    case NOT_EQUAL: {
                        numberPredicateStep.mustNot((PredicateFinalStep)this.myPredicateFactory.match().field(fieldPath).matching((Object)value));
                    }
                }
            }
            this.myRootClause.must((PredicateFinalStep)numberPredicateStep);
        }
    }
}

