/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.search.ExtendedHSearchIndexData;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.MetaUtil;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ExtendedHSearchIndexExtractor {
    private final DaoConfig myDaoConfig;
    private final FhirContext myContext;
    private final ResourceSearchParams myParams;
    private final ISearchParamExtractor mySearchParamExtractor;
    private final ModelConfig myModelConfig;

    public ExtendedHSearchIndexExtractor(DaoConfig theDaoConfig, FhirContext theContext, ResourceSearchParams theActiveParams, ISearchParamExtractor theSearchParamExtractor, ModelConfig theModelConfig) {
        this.myDaoConfig = theDaoConfig;
        this.myContext = theContext;
        this.myParams = theActiveParams;
        this.mySearchParamExtractor = theSearchParamExtractor;
        this.myModelConfig = theModelConfig;
    }

    @Nonnull
    public ExtendedHSearchIndexData extract(IBaseResource theResource, ResourceIndexedSearchParams theNewParams) {
        ExtendedHSearchIndexData retVal = new ExtendedHSearchIndexData(this.myContext, this.myModelConfig);
        if (this.myDaoConfig.isStoreResourceInHSearchIndex()) {
            retVal.setRawResourceData(this.myContext.newJsonParser().encodeResourceToString(theResource));
        }
        retVal.setForcedId(theResource.getIdElement().getIdPart());
        this.extractAutocompleteTokens(theResource, retVal);
        theNewParams.myStringParams.forEach(nextParam -> retVal.addStringIndexData(nextParam.getParamName(), nextParam.getValueExact()));
        theNewParams.myTokenParams.forEach(nextParam -> retVal.addTokenIndexDataIfNotPresent(nextParam.getParamName(), nextParam.getSystem(), nextParam.getValue()));
        theNewParams.myNumberParams.forEach(nextParam -> retVal.addNumberIndexDataIfNotPresent(nextParam.getParamName(), nextParam.getValue()));
        theNewParams.myDateParams.forEach(nextParam -> retVal.addDateIndexData(nextParam.getParamName(), nextParam.getValueLow(), nextParam.getValueLowDateOrdinal().intValue(), nextParam.getValueHigh(), nextParam.getValueHighDateOrdinal().intValue()));
        theNewParams.myQuantityParams.forEach(nextParam -> retVal.addQuantityIndexData(nextParam.getParamName(), nextParam.getUnits(), nextParam.getSystem(), nextParam.getValue().doubleValue()));
        theResource.getMeta().getTag().forEach(tag -> retVal.addTokenIndexData("_tag", tag));
        theResource.getMeta().getSecurity().forEach(sec -> retVal.addTokenIndexData("_security", sec));
        theResource.getMeta().getProfile().forEach(prof -> retVal.addUriIndexData("_profile", (String)prof.getValue()));
        String source = MetaUtil.getSource((FhirContext)this.myContext, (IBaseMetaType)theResource.getMeta());
        if (StringUtils.isNotBlank((CharSequence)source)) {
            retVal.addUriIndexData("_source", source);
        }
        if (theResource.getMeta().getLastUpdated() != null) {
            int ordinal = ResourceIndexedSearchParamDate.calculateOrdinalValue((Date)theResource.getMeta().getLastUpdated()).intValue();
            retVal.addDateIndexData("_lastUpdated", theResource.getMeta().getLastUpdated(), ordinal, theResource.getMeta().getLastUpdated(), ordinal);
        }
        if (!theNewParams.myLinks.isEmpty()) {
            HashMap linkPathToParamName = new HashMap();
            for (String nextParamName : theNewParams.getPopulatedResourceLinkParameters()) {
                RuntimeSearchParam sp = this.myParams.get(nextParamName);
                List pathsSplit = sp.getPathsSplit();
                for (String nextPath : pathsSplit) {
                    nextPath = nextPath.toLowerCase(Locale.ROOT);
                    linkPathToParamName.computeIfAbsent(nextPath, p -> new ArrayList()).add(nextParamName);
                }
            }
            for (ResourceLink nextLink : theNewParams.getResourceLinks()) {
                String insensitivePath = nextLink.getSourcePath().toLowerCase(Locale.ROOT);
                List paramNames = linkPathToParamName.getOrDefault(insensitivePath, Collections.emptyList());
                for (String nextParamName : paramNames) {
                    Object qualifiedTargetResourceId = "";
                    if (!Strings.isNullOrEmpty((String)nextLink.getTargetResourceId())) {
                        qualifiedTargetResourceId = nextLink.getTargetResourceType() + "/" + nextLink.getTargetResourceId();
                    } else if (!Strings.isNullOrEmpty((String)nextLink.getTargetResourceUrl())) {
                        qualifiedTargetResourceId = nextLink.getTargetResourceUrl();
                    }
                    retVal.addResourceLinkIndexData(nextParamName, (String)qualifiedTargetResourceId);
                }
            }
        }
        return retVal;
    }

    private void extractAutocompleteTokens(IBaseResource theResource, ExtendedHSearchIndexData theRetVal) {
        this.myParams.values().stream().filter(p -> p.getParamType() == RestSearchParameterTypeEnum.TOKEN).forEach(p -> this.mySearchParamExtractor.extractValues(p.getPath(), theResource).forEach(nextValue -> this.indexTokenValue(theRetVal, (RuntimeSearchParam)p, (IBase)nextValue)));
    }

    private void indexTokenValue(ExtendedHSearchIndexData theRetVal, RuntimeSearchParam p, IBase nextValue) {
        String nextType = this.mySearchParamExtractor.toRootTypeName(nextValue);
        String spName = p.getName();
        switch (nextType) {
            case "CodeableConcept": {
                this.addToken_CodeableConcept(theRetVal, spName, nextValue);
                break;
            }
            case "Coding": {
                this.addToken_Coding(theRetVal, spName, (IBaseCoding)nextValue);
                break;
            }
        }
    }

    private void addToken_CodeableConcept(ExtendedHSearchIndexData theRetVal, String theSpName, IBase theValue) {
        List codings = this.mySearchParamExtractor.getCodingsFromCodeableConcept(theValue);
        for (IBase nextCoding : codings) {
            this.addToken_Coding(theRetVal, theSpName, (IBaseCoding)nextCoding);
        }
    }

    private void addToken_Coding(ExtendedHSearchIndexData theRetVal, String theSpName, IBaseCoding theNextValue) {
        theRetVal.addTokenIndexData(theSpName, theNextValue);
    }
}

