/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.IParser;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ExtendedHSearchResourceProjection {
    final long myPid;
    final String myForcedId;
    final String myResourceString;

    public ExtendedHSearchResourceProjection(long thePid, String theForcedId, String theResourceString) {
        Validate.notEmpty((CharSequence)theResourceString, (String)("Resource not stored in search index: " + thePid), (Object[])new Object[0]);
        this.myPid = thePid;
        this.myForcedId = theForcedId;
        this.myResourceString = theResourceString;
    }

    public IBaseResource toResource(IParser theParser) {
        IBaseResource result = theParser.parseResource(this.myResourceString);
        IdDt id = this.myForcedId != null ? new IdDt(this.myForcedId) : new IdDt(this.myPid);
        result.setId((IIdType)id);
        return result;
    }

    public long getPid() {
        return this.myPid;
    }
}

