/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class LastNAggregation {
    static final String SP_SUBJECT = "sp.subject.reference.value";
    private static final String SP_CODE_TOKEN_CODE_AND_SYSTEM = "sp.code.token.code-system";
    private static final String SP_DATE_DT_UPPER = "sp.date.dt.upper";
    private static final String GROUP_BY_CODE_SYSTEM_SUB_AGGREGATION = "group_by_code_system";
    private static final String MOST_RECENT_EFFECTIVE_SUB_AGGREGATION = "most_recent_effective";
    private final int myLastNMax;
    private final boolean myAggregateOnSubject;
    private final Gson myJsonParser = new Gson();

    public LastNAggregation(int theLastNMax, boolean theAggregateOnSubject) {
        this.myLastNMax = theLastNMax;
        this.myAggregateOnSubject = theAggregateOnSubject;
    }

    public JsonObject toAggregation() {
        JsonObject lastNAggregation = (JsonObject)this.myJsonParser.fromJson("{   \"terms\":{      \"field\":\"sp.code.token.code-system\",      \"size\":10000,      \"min_doc_count\":1   },   \"aggs\":{      \"most_recent_effective\":{         \"top_hits\":{            \"size\":" + this.myLastNMax + ",            \"sort\":[               {                  \"sp.date.dt.upper\":{                     \"order\":\"desc\"                  }               }            ],            \"_source\":[               \"myId\"            ]         }      }   }}", JsonObject.class);
        if (this.myAggregateOnSubject) {
            lastNAggregation = (JsonObject)this.myJsonParser.fromJson("{  \"terms\": {    \"field\": \"sp.subject.reference.value\",    \"size\": 10000,    \"min_doc_count\": 1  },  \"aggs\": {    \"group_by_code_system\": " + this.myJsonParser.toJson((JsonElement)lastNAggregation) + "  }}", JsonObject.class);
        }
        return lastNAggregation;
    }

    public List<Long> extractResourceIds(@Nonnull JsonObject theAggregationResult) {
        Stream<JsonObject> resultBuckets = Stream.of(theAggregationResult);
        if (this.myAggregateOnSubject) {
            resultBuckets = StreamSupport.stream(theAggregationResult.getAsJsonArray("buckets").spliterator(), false).map(bucket -> bucket.getAsJsonObject().getAsJsonObject(GROUP_BY_CODE_SYSTEM_SUB_AGGREGATION));
        }
        return resultBuckets.flatMap(grouping -> StreamSupport.stream(grouping.getAsJsonArray("buckets").spliterator(), false)).flatMap(bucket -> {
            JsonArray hits = bucket.getAsJsonObject().getAsJsonObject(MOST_RECENT_EFFECTIVE_SUB_AGGREGATION).getAsJsonObject("hits").getAsJsonArray("hits");
            return StreamSupport.stream(hits.spliterator(), false);
        }).map(hit -> hit.getAsJsonObject().getAsJsonObject("_source").get("myId").getAsLong()).collect(Collectors.toList());
    }
}

