/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.jpa.search.builder.ISearchQueryExecutor;
import java.util.Iterator;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.engine.search.query.SearchScrollResult;

public class SearchScrollQueryExecutorAdaptor
implements ISearchQueryExecutor {
    private final SearchScroll<Long> myScroll;
    private Iterator<Long> myCurrentIterator;

    public SearchScrollQueryExecutorAdaptor(SearchScroll<Long> theScroll) {
        this.myScroll = theScroll;
        this.advanceNextScrollPage();
    }

    private void advanceNextScrollPage() {
        SearchScrollResult scrollResults = this.myScroll.next();
        this.myCurrentIterator = scrollResults.hits().iterator();
    }

    @Override
    public void close() {
        this.myScroll.close();
    }

    @Override
    public boolean hasNext() {
        return this.myCurrentIterator.hasNext();
    }

    @Override
    public Long next() {
        Long result = this.myCurrentIterator.next();
        if (!this.myCurrentIterator.hasNext()) {
            this.advanceNextScrollPage();
        }
        return result;
    }
}

