/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.model.DeleteConflict;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.jpa.dao.data.IResourceLinkDao;
import ca.uhn.fhir.jpa.delete.DeleteConflictFinderService;
import ca.uhn.fhir.jpa.delete.DeleteConflictOutcome;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteConflictService {
    public static final int FIRST_QUERY_RESULT_COUNT = 1;
    private static final Logger ourLog = LoggerFactory.getLogger(DeleteConflictService.class);
    public static int MAX_RETRY_ATTEMPTS = 10;
    public static String MAX_RETRY_ATTEMPTS_EXCEEDED_MSG = "Requested delete operation stopped before all conflicts were handled. May need to increase the configured Maximum Delete Conflict Query Count.";
    @Autowired
    protected IResourceLinkDao myResourceLinkDao;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    DeleteConflictFinderService myDeleteConflictFinderService;
    @Autowired
    DaoConfig myDaoConfig;
    @Autowired
    private FhirContext myFhirContext;

    private DeleteConflictOutcome findAndHandleConflicts(RequestDetails theRequest, DeleteConflictList theDeleteConflicts, ResourceTable theEntity, boolean theForValidate, int theMinQueryResultCount, TransactionDetails theTransactionDetails) {
        List<ResourceLink> resultList = this.myDeleteConflictFinderService.findConflicts(theEntity, theMinQueryResultCount);
        if (resultList.isEmpty()) {
            return null;
        }
        return this.handleConflicts(theRequest, theDeleteConflicts, theEntity, theForValidate, resultList, theTransactionDetails);
    }

    private DeleteConflictOutcome handleConflicts(RequestDetails theRequest, DeleteConflictList theDeleteConflicts, ResourceTable theEntity, boolean theForValidate, List<ResourceLink> theResultList, TransactionDetails theTransactionDetails) {
        if (!this.myDaoConfig.isEnforceReferentialIntegrityOnDelete() && !theForValidate) {
            ourLog.debug("Deleting {} resource dependencies which can no longer be satisfied", (Object)theResultList.size());
            this.myResourceLinkDao.deleteAll(theResultList);
            return null;
        }
        this.addConflictsToList(theDeleteConflicts, theEntity, theResultList);
        if (theDeleteConflicts.isEmpty()) {
            return new DeleteConflictOutcome();
        }
        HookParams hooks = new HookParams().add(DeleteConflictList.class, (Object)theDeleteConflicts).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(TransactionDetails.class, (Object)theTransactionDetails);
        return (DeleteConflictOutcome)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRESTORAGE_DELETE_CONFLICTS, (HookParams)hooks);
    }

    private void addConflictsToList(DeleteConflictList theDeleteConflicts, ResourceTable theEntity, List<ResourceLink> theResultList) {
        for (ResourceLink link : theResultList) {
            IdDt targetId = theEntity.getIdDt();
            IdDt sourceId = link.getSourceResource().getIdDt();
            String sourcePath = link.getSourcePath();
            if (theDeleteConflicts.isResourceIdMarkedForDeletion((IIdType)sourceId) && theDeleteConflicts.isResourceIdMarkedForDeletion((IIdType)targetId)) continue;
            theDeleteConflicts.add(new DeleteConflict(sourceId, sourcePath, targetId));
        }
    }

    public int validateOkToDelete(DeleteConflictList theDeleteConflicts, ResourceTable theEntity, boolean theForValidate, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        int shouldRetryCount;
        int retryCount;
        DeleteConflictList newConflicts = new DeleteConflictList(theDeleteConflicts);
        DeleteConflictOutcome outcome = this.findAndHandleConflicts(theRequest, newConflicts, theEntity, theForValidate, 1, theTransactionDetails);
        for (retryCount = 0; outcome != null && retryCount < (shouldRetryCount = Math.min(outcome.getShouldRetryCount(), MAX_RETRY_ATTEMPTS)); ++retryCount) {
            newConflicts = new DeleteConflictList(newConflicts);
            outcome = this.findAndHandleConflicts(theRequest, newConflicts, theEntity, theForValidate, this.myDaoConfig.getMaximumDeleteConflictQueryCount(), theTransactionDetails);
        }
        theDeleteConflicts.addAll(newConflicts);
        if (retryCount >= MAX_RETRY_ATTEMPTS && !theDeleteConflicts.isEmpty()) {
            IBaseOperationOutcome oo = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirContext);
            OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)oo, (String)"error", (String)MAX_RETRY_ATTEMPTS_EXCEEDED_MSG, null, (String)"processing");
            throw new ResourceVersionConflictException(Msg.code((int)821) + MAX_RETRY_ATTEMPTS_EXCEEDED_MSG, oo);
        }
        return retryCount;
    }

    @VisibleForTesting
    static void setMaxRetryAttempts(Integer theMaxRetryAttempts) {
        MAX_RETRY_ATTEMPTS = theMaxRetryAttempts;
    }
}

