/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete.batch2;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.IResourceLinkDao;
import ca.uhn.fhir.jpa.dao.expunge.ResourceForeignKey;
import ca.uhn.fhir.jpa.dao.expunge.ResourceTableFKProvider;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteExpungeSqlBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(DeleteExpungeSqlBuilder.class);
    public static final String PROCESS_NAME = "Delete Expunging";
    public static final String THREAD_PREFIX = "delete-expunge";
    private final ResourceTableFKProvider myResourceTableFKProvider;
    private final DaoConfig myDaoConfig;
    private final IIdHelperService myIdHelper;
    private final IResourceLinkDao myResourceLinkDao;

    public DeleteExpungeSqlBuilder(ResourceTableFKProvider theResourceTableFKProvider, DaoConfig theDaoConfig, IIdHelperService theIdHelper, IResourceLinkDao theResourceLinkDao) {
        this.myResourceTableFKProvider = theResourceTableFKProvider;
        this.myDaoConfig = theDaoConfig;
        this.myIdHelper = theIdHelper;
        this.myResourceLinkDao = theResourceLinkDao;
    }

    @Nonnull
    List<String> convertPidsToDeleteExpungeSql(List<ResourcePersistentId> thePersistentIds) {
        List pids = ResourcePersistentId.toLongList(thePersistentIds);
        this.validateOkToDeleteAndExpunge(pids);
        ArrayList<String> rawSql = new ArrayList<String>();
        String pidListString = pids.toString().replace("[", "(").replace("]", ")");
        List<ResourceForeignKey> resourceForeignKeys = this.myResourceTableFKProvider.getResourceForeignKeys();
        for (ResourceForeignKey resourceForeignKey : resourceForeignKeys) {
            rawSql.add(this.deleteRecordsByColumnSql(pidListString, resourceForeignKey));
        }
        ResourceForeignKey resourceTablePk = new ResourceForeignKey("HFJ_RESOURCE", "RES_ID");
        rawSql.add(this.deleteRecordsByColumnSql(pidListString, resourceTablePk));
        return rawSql;
    }

    public void validateOkToDeleteAndExpunge(List<Long> thePids) {
        if (!this.myDaoConfig.isEnforceReferentialIntegrityOnDelete()) {
            ourLog.info("Referential integrity on delete disabled.  Skipping referential integrity check.");
            return;
        }
        List targetPidsAsResourceIds = ResourcePersistentId.fromLongList(thePids);
        List<ResourceLink> conflictResourceLinks = Collections.synchronizedList(new ArrayList());
        this.findResourceLinksWithTargetPidIn(targetPidsAsResourceIds, targetPidsAsResourceIds, conflictResourceLinks);
        if (conflictResourceLinks.isEmpty()) {
            return;
        }
        ResourceLink firstConflict = conflictResourceLinks.get(0);
        String sourceResourceId = this.myIdHelper.resourceIdFromPidOrThrowException(new ResourcePersistentId((Object)firstConflict.getSourceResourcePid()), firstConflict.getSourceResourceType()).toVersionless().getValue();
        String targetResourceId = this.myIdHelper.resourceIdFromPidOrThrowException(new ResourcePersistentId((Object)firstConflict.getTargetResourcePid()), firstConflict.getTargetResourceType()).toVersionless().getValue();
        throw new InvalidRequestException(Msg.code((int)822) + "DELETE with _expunge=true failed.  Unable to delete " + targetResourceId + " because " + sourceResourceId + " refers to it via the path " + firstConflict.getSourcePath());
    }

    public void findResourceLinksWithTargetPidIn(List<ResourcePersistentId> theAllTargetPids, List<ResourcePersistentId> theSomeTargetPids, List<ResourceLink> theConflictResourceLinks) {
        List allTargetPidsAsLongs = ResourcePersistentId.toLongList(theAllTargetPids);
        List someTargetPidsAsLongs = ResourcePersistentId.toLongList(theSomeTargetPids);
        if (theConflictResourceLinks.isEmpty()) {
            List conflictResourceLinks = this.myResourceLinkDao.findWithTargetPidIn(someTargetPidsAsLongs).stream().filter(link -> !allTargetPidsAsLongs.contains(link.getSourceResourcePid())).collect(Collectors.toList());
            theConflictResourceLinks.addAll(conflictResourceLinks);
        }
    }

    private String deleteRecordsByColumnSql(String thePidListString, ResourceForeignKey theResourceForeignKey) {
        return "DELETE FROM " + theResourceForeignKey.table + " WHERE " + theResourceForeignKey.key + " IN " + thePidListString;
    }
}

