/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete.batch2;

import ca.uhn.fhir.jpa.api.svc.IDeleteExpungeSvc;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.delete.batch2.DeleteExpungeSqlBuilder;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.MANDATORY)
public class DeleteExpungeSvcImpl
implements IDeleteExpungeSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(DeleteExpungeSvcImpl.class);
    private final EntityManager myEntityManager;
    private final DeleteExpungeSqlBuilder myDeleteExpungeSqlBuilder;
    private final IFulltextSearchSvc myFullTextSearchSvc;

    public DeleteExpungeSvcImpl(EntityManager theEntityManager, DeleteExpungeSqlBuilder theDeleteExpungeSqlBuilder, IFulltextSearchSvc theFullTextSearchSvc) {
        this.myEntityManager = theEntityManager;
        this.myDeleteExpungeSqlBuilder = theDeleteExpungeSqlBuilder;
        this.myFullTextSearchSvc = theFullTextSearchSvc;
    }

    public void deleteExpunge(List<ResourcePersistentId> thePersistentIds) {
        List<String> sqlList = this.myDeleteExpungeSqlBuilder.convertPidsToDeleteExpungeSql(thePersistentIds);
        ourLog.debug("Executing {} delete expunge sql commands", (Object)sqlList.size());
        long totalDeleted = 0L;
        for (String sql : sqlList) {
            ourLog.trace("Executing sql " + sql);
            totalDeleted += (long)this.myEntityManager.createNativeQuery(sql).executeUpdate();
        }
        ourLog.info("{} records deleted", (Object)totalDeleted);
        this.clearHibernateSearchIndex(thePersistentIds);
    }

    private void clearHibernateSearchIndex(List<ResourcePersistentId> thePersistentIds) {
        if (this.myFullTextSearchSvc != null) {
            List<Object> objectIds = thePersistentIds.stream().map(ResourcePersistentId::getIdAsLong).collect(Collectors.toList());
            this.myFullTextSearchSvc.deleteIndexedDocumentsByTypeAndId(ResourceTable.class, objectIds);
            ourLog.info("Cleared Hibernate Search indexes.");
        }
    }
}

