/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Table(name="TRM_CODESYSTEM", uniqueConstraints={@UniqueConstraint(name="IDX_CS_CODESYSTEM", columnNames={"CODE_SYSTEM_URI"})})
@Entity
public class TermCodeSystem
implements Serializable {
    public static final int MAX_URL_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    private static final int MAX_NAME_LENGTH = 200;
    @Column(name="CODE_SYSTEM_URI", nullable=false, length=200)
    private String myCodeSystemUri;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CURRENT_VERSION_PID", referencedColumnName="PID", nullable=true, foreignKey=@ForeignKey(name="FK_TRMCODESYSTEM_CURVER"))
    private TermCodeSystemVersion myCurrentVersion;
    @Column(name="CURRENT_VERSION_PID", nullable=true, insertable=false, updatable=false)
    private Long myCurrentVersionPid;
    @Id
    @SequenceGenerator(name="SEQ_CODESYSTEM_PID", sequenceName="SEQ_CODESYSTEM_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CODESYSTEM_PID")
    @Column(name="PID")
    private Long myPid;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", nullable=false, updatable=true, foreignKey=@ForeignKey(name="FK_TRMCODESYSTEM_RES"))
    private ResourceTable myResource;
    @Column(name="RES_ID", insertable=false, updatable=false)
    private Long myResourcePid;
    @Column(name="CS_NAME", nullable=true, length=200)
    private String myName;

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        TermCodeSystem that = (TermCodeSystem)theO;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.myCodeSystemUri, (Object)that.myCodeSystemUri);
        return b.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder(17, 37);
        b.append((Object)this.myCodeSystemUri);
        return b.toHashCode();
    }

    public String getCodeSystemUri() {
        return this.myCodeSystemUri;
    }

    public TermCodeSystem setCodeSystemUri(@Nonnull String theCodeSystemUri) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theCodeSystemUri, (String)"theCodeSystemUri must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theCodeSystemUri, (int)200, (String)("URI exceeds maximum length (200): " + StringUtils.length((CharSequence)theCodeSystemUri)));
        this.myCodeSystemUri = theCodeSystemUri;
        return this;
    }

    public String getName() {
        return this.myName;
    }

    public TermCodeSystem setName(String theName) {
        this.myName = StringUtils.left((String)theName, (int)200);
        return this;
    }

    public TermCodeSystemVersion getCurrentVersion() {
        return this.myCurrentVersion;
    }

    public TermCodeSystem setCurrentVersion(TermCodeSystemVersion theCurrentVersion) {
        this.myCurrentVersion = theCurrentVersion;
        return this;
    }

    public Long getPid() {
        return this.myPid;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public TermCodeSystem setResource(ResourceTable theResource) {
        this.myResource = theResource;
        return this;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("pid", (Object)this.myPid);
        b.append("codeSystemUri", (Object)this.myCodeSystemUri);
        b.append("currentVersionPid", (Object)this.myCurrentVersionPid);
        b.append("resourcePid", (Object)this.myResourcePid);
        b.append("name", (Object)this.myName);
        return b.toString();
    }
}

