/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermConceptMapGroup;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="TRM_CONCEPT_MAP", uniqueConstraints={@UniqueConstraint(name="IDX_CONCEPT_MAP_URL", columnNames={"URL", "VER"})})
public class TermConceptMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int MAX_URL_LENGTH = 200;
    public static final int MAX_VER_LENGTH = 200;
    @Id
    @SequenceGenerator(name="SEQ_CONCEPT_MAP_PID", sequenceName="SEQ_CONCEPT_MAP_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CONCEPT_MAP_PID")
    @Column(name="PID")
    private Long myId;
    @OneToOne
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", nullable=false, updatable=false, foreignKey=@ForeignKey(name="FK_TRMCONCEPTMAP_RES"))
    private ResourceTable myResource;
    @Column(name="RES_ID", insertable=false, updatable=false)
    private Long myResourcePid;
    @Column(name="SOURCE_URL", nullable=true, length=200)
    private String mySource;
    @Column(name="TARGET_URL", nullable=true, length=200)
    private String myTarget;
    @Column(name="URL", nullable=false, length=200)
    private String myUrl;
    @Column(name="VER", nullable=true, length=200)
    private String myVersion;
    @OneToMany(mappedBy="myConceptMap")
    private List<TermConceptMapGroup> myConceptMapGroups;

    public List<TermConceptMapGroup> getConceptMapGroups() {
        if (this.myConceptMapGroups == null) {
            this.myConceptMapGroups = new ArrayList<TermConceptMapGroup>();
        }
        return this.myConceptMapGroups;
    }

    public Long getId() {
        return this.myId;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public TermConceptMap setResource(ResourceTable theResource) {
        this.myResource = theResource;
        return this;
    }

    public Long getResourcePid() {
        return this.myResourcePid;
    }

    public TermConceptMap setResourcePid(Long theResourcePid) {
        this.myResourcePid = theResourcePid;
        return this;
    }

    public String getSource() {
        return this.mySource;
    }

    public TermConceptMap setSource(String theSource) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theSource, (int)200, (String)("Source exceeds maximum length (200): " + StringUtils.length((CharSequence)theSource)));
        this.mySource = theSource;
        return this;
    }

    public String getTarget() {
        return this.myTarget;
    }

    public TermConceptMap setTarget(String theTarget) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theTarget, (int)200, (String)("Target exceeds maximum length (200): " + StringUtils.length((CharSequence)theTarget)));
        this.myTarget = theTarget;
        return this;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public TermConceptMap setUrl(@Nonnull String theUrl) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theUrl, (String)"theUrl must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theUrl, (int)200, (String)("URL exceeds maximum length (200): " + StringUtils.length((CharSequence)theUrl)));
        this.myUrl = theUrl;
        return this;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public TermConceptMap setVersion(String theVersion) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theVersion, (int)200, (String)("Version exceeds maximum length (200): " + StringUtils.length((CharSequence)theVersion)));
        this.myVersion = theVersion;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("myId", (Object)this.myId).append(this.myResource != null ? "myResource=" + this.myResource.toString() : "myResource=(null)").append("myResourcePid", (Object)this.myResourcePid).append("mySource", (Object)this.mySource).append("myTarget", (Object)this.myTarget).append("myUrl", (Object)this.myUrl).append("myVersion", (Object)this.myVersion).append(this.myConceptMapGroups != null ? "myConceptMapGroups - size=" + this.myConceptMapGroups.size() : "myConceptMapGroups=(null)").toString();
    }
}

