/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElement;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.r4.model.Enumerations;

@Entity
@Table(name="TRM_CONCEPT_MAP_GRP_ELM_TGT", indexes={@Index(name="IDX_CNCPT_MP_GRP_ELM_TGT_CD", columnList="TARGET_CODE")})
public class TermConceptMapGroupElementTarget
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int MAX_EQUIVALENCE_LENGTH = 50;
    @Id
    @SequenceGenerator(name="SEQ_CNCPT_MAP_GRP_ELM_TGT_PID", sequenceName="SEQ_CNCPT_MAP_GRP_ELM_TGT_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CNCPT_MAP_GRP_ELM_TGT_PID")
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="CONCEPT_MAP_GRP_ELM_PID", nullable=false, referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_TCMGETARGET_ELEMENT"))
    private TermConceptMapGroupElement myConceptMapGroupElement;
    @Column(name="TARGET_CODE", nullable=false, length=500)
    private String myCode;
    @Column(name="TARGET_DISPLAY", nullable=true, length=500)
    private String myDisplay;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TARGET_EQUIVALENCE", nullable=true, length=50)
    private Enumerations.ConceptMapEquivalence myEquivalence;
    @Column(name="CONCEPT_MAP_URL", nullable=true, length=200)
    private String myConceptMapUrl;
    @Column(name="SYSTEM_URL", nullable=true, length=200)
    private String mySystem;
    @Column(name="SYSTEM_VERSION", nullable=true, length=200)
    private String mySystemVersion;
    @Column(name="VALUESET_URL", nullable=true, length=200)
    private String myValueSet;

    public String getCode() {
        return this.myCode;
    }

    public TermConceptMapGroupElementTarget setCode(@Nonnull String theCode) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theCode, (String)"theCode must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theCode, (int)500, (String)("Code exceeds maximum length (500): " + StringUtils.length((CharSequence)theCode)));
        this.myCode = theCode;
        return this;
    }

    public TermConceptMapGroupElement getConceptMapGroupElement() {
        return this.myConceptMapGroupElement;
    }

    public void setConceptMapGroupElement(TermConceptMapGroupElement theTermConceptMapGroupElement) {
        this.myConceptMapGroupElement = theTermConceptMapGroupElement;
    }

    public String getConceptMapUrl() {
        if (this.myConceptMapUrl == null) {
            this.myConceptMapUrl = this.getConceptMapGroupElement().getConceptMapGroup().getConceptMap().getUrl();
        }
        return this.myConceptMapUrl;
    }

    public String getDisplay() {
        return this.myDisplay;
    }

    public TermConceptMapGroupElementTarget setDisplay(String theDisplay) {
        this.myDisplay = theDisplay;
        return this;
    }

    public Enumerations.ConceptMapEquivalence getEquivalence() {
        return this.myEquivalence;
    }

    public TermConceptMapGroupElementTarget setEquivalence(Enumerations.ConceptMapEquivalence theEquivalence) {
        this.myEquivalence = theEquivalence;
        return this;
    }

    public Long getId() {
        return this.myId;
    }

    public String getSystem() {
        if (this.mySystem == null) {
            this.mySystem = this.getConceptMapGroupElement().getConceptMapGroup().getTarget();
        }
        return this.mySystem;
    }

    public String getSystemVersion() {
        if (this.mySystemVersion == null) {
            this.mySystemVersion = this.getConceptMapGroupElement().getConceptMapGroup().getTargetVersion();
        }
        return this.mySystemVersion;
    }

    public String getValueSet() {
        if (this.myValueSet == null) {
            this.myValueSet = this.getConceptMapGroupElement().getConceptMapGroup().getTargetValueSet();
        }
        return this.myValueSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TermConceptMapGroupElementTarget)) {
            return false;
        }
        TermConceptMapGroupElementTarget that = (TermConceptMapGroupElementTarget)o;
        return new EqualsBuilder().append((Object)this.getCode(), (Object)that.getCode()).append((Object)this.getEquivalence(), (Object)that.getEquivalence()).append((Object)this.getSystem(), (Object)that.getSystem()).append((Object)this.getSystemVersion(), (Object)that.getSystemVersion()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getCode()).append((Object)this.getEquivalence()).append((Object)this.getSystem()).append((Object)this.getSystemVersion()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("myId", (Object)this.myId).append(this.myConceptMapGroupElement != null ? "myConceptMapGroupElement - id=" + this.myConceptMapGroupElement.getId() : "myConceptMapGroupElement=(null)").append("myCode", (Object)this.myCode).append("myDisplay", (Object)this.myDisplay).append("myEquivalence", (Object)this.myEquivalence.toCode()).append("myConceptMapUrl", (Object)this.getConceptMapUrl()).append("mySystem", (Object)this.getSystem()).append("mySystemVersion", (Object)this.getSystemVersion()).append("myValueSet", (Object)this.getValueSet()).toString();
    }
}

