/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermValueSet;
import ca.uhn.fhir.jpa.entity.TermValueSetConcept;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Table(name="TRM_VALUESET_C_DESIGNATION", indexes={@Index(name="FK_TRM_VALUESET_CONCEPT_PID", columnList="VALUESET_CONCEPT_PID", unique=false)})
@Entity
public class TermValueSetConceptDesignation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_VALUESET_C_DSGNTN_PID", sequenceName="SEQ_VALUESET_C_DSGNTN_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_VALUESET_C_DSGNTN_PID")
    @Column(name="PID")
    private Long myId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="VALUESET_CONCEPT_PID", referencedColumnName="PID", nullable=false, foreignKey=@ForeignKey(name="FK_TRM_VALUESET_CONCEPT_PID"))
    private TermValueSetConcept myConcept;
    @Column(name="VALUESET_CONCEPT_PID", insertable=false, updatable=false, nullable=false)
    private Long myConceptPid;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="VALUESET_PID", referencedColumnName="PID", nullable=false, foreignKey=@ForeignKey(name="FK_TRM_VSCD_VS_PID"))
    private TermValueSet myValueSet;
    @Column(name="VALUESET_PID", insertable=false, updatable=false, nullable=false)
    private Long myValueSetPid;
    @Transient
    private String myValueSetUrl;
    @Transient
    private String myValueSetName;
    @Column(name="LANG", nullable=true, length=500)
    private String myLanguage;
    @Column(name="USE_SYSTEM", nullable=true, length=500)
    private String myUseSystem;
    @Column(name="USE_CODE", nullable=true, length=500)
    private String myUseCode;
    @Column(name="USE_DISPLAY", nullable=true, length=500)
    private String myUseDisplay;
    @Column(name="VAL", nullable=false, length=2000)
    private String myValue;
    @Transient
    private transient Integer myHashCode;

    public Long getId() {
        return this.myId;
    }

    public TermValueSetConcept getConcept() {
        return this.myConcept;
    }

    public TermValueSetConceptDesignation setConcept(TermValueSetConcept theConcept) {
        this.myConcept = theConcept;
        return this;
    }

    public TermValueSet getValueSet() {
        return this.myValueSet;
    }

    public TermValueSetConceptDesignation setValueSet(TermValueSet theValueSet) {
        this.myValueSet = theValueSet;
        return this;
    }

    public String getValueSetUrl() {
        if (this.myValueSetUrl == null) {
            this.myValueSetUrl = this.getValueSet().getUrl();
        }
        return this.myValueSetUrl;
    }

    public String getValueSetName() {
        if (this.myValueSetName == null) {
            this.myValueSetName = this.getValueSet().getName();
        }
        return this.myValueSetName;
    }

    public String getLanguage() {
        return this.myLanguage;
    }

    public TermValueSetConceptDesignation setLanguage(String theLanguage) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theLanguage, (int)500, (String)("Language exceeds maximum length (500): " + StringUtils.length((CharSequence)theLanguage)));
        this.myLanguage = theLanguage;
        return this;
    }

    public String getUseSystem() {
        return this.myUseSystem;
    }

    public TermValueSetConceptDesignation setUseSystem(String theUseSystem) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theUseSystem, (int)500, (String)("Use system exceeds maximum length (500): " + StringUtils.length((CharSequence)theUseSystem)));
        this.myUseSystem = theUseSystem;
        return this;
    }

    public String getUseCode() {
        return this.myUseCode;
    }

    public TermValueSetConceptDesignation setUseCode(String theUseCode) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theUseCode, (int)500, (String)("Use code exceeds maximum length (500): " + StringUtils.length((CharSequence)theUseCode)));
        this.myUseCode = theUseCode;
        return this;
    }

    public String getUseDisplay() {
        return this.myUseDisplay;
    }

    public TermValueSetConceptDesignation setUseDisplay(String theUseDisplay) {
        this.myUseDisplay = StringUtils.left((String)theUseDisplay, (int)500);
        return this;
    }

    public String getValue() {
        return this.myValue;
    }

    public TermValueSetConceptDesignation setValue(@Nonnull String theValue) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theValue, (String)"theValue must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theValue, (int)2000, (String)("Value exceeds maximum length (2000): " + StringUtils.length((CharSequence)theValue)));
        this.myValue = theValue;
        return this;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof TermValueSetConceptDesignation)) {
            return false;
        }
        TermValueSetConceptDesignation that = (TermValueSetConceptDesignation)theO;
        return new EqualsBuilder().append((Object)this.getLanguage(), (Object)that.getLanguage()).append((Object)this.getUseSystem(), (Object)that.getUseSystem()).append((Object)this.getUseCode(), (Object)that.getUseCode()).append((Object)this.getUseDisplay(), (Object)that.getUseDisplay()).append((Object)this.getValue(), (Object)that.getValue()).isEquals();
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.getLanguage()).append((Object)this.getUseSystem()).append((Object)this.getUseCode()).append((Object)this.getUseDisplay()).append((Object)this.getValue()).toHashCode();
        }
        return this.myHashCode;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("myId", (Object)this.myId).append(this.myConcept != null ? "myConcept - id=" + this.myConcept.getId() : "myConcept=(null)").append("myConceptPid", (Object)this.myConceptPid).append(this.myValueSet != null ? "myValueSet - id=" + this.myValueSet.getId() : "myValueSet=(null)").append("myValueSetPid", (Object)this.myValueSetPid).append("myValueSetUrl", (Object)this.getValueSetUrl()).append("myValueSetName", (Object)this.getValueSetName()).append("myLanguage", (Object)this.myLanguage).append("myUseSystem", (Object)this.myUseSystem).append("myUseCode", (Object)this.myUseCode).append("myUseDisplay", (Object)this.myUseDisplay).append("myValue", (Object)this.myValue).toString();
    }
}

