/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.graphql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.IDaoRegistry;
import ca.uhn.fhir.jpa.graphql.GraphQLProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.MessageSupplier;
import ca.uhn.fhir.util.StringUtil;
import ca.uhn.fhir.util.VersionUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.scalar.GraphqlStringCoercing;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.validator.VersionSpecificWorkerContextWrapper;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.GraphQLSchemaGenerator;
import org.hl7.fhir.utilities.graphql.IGraphQLStorageServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLProviderWithIntrospection
extends GraphQLProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(GraphQLProviderWithIntrospection.class);
    private final GraphQLSchemaGenerator myGenerator;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final VersionSpecificWorkerContextWrapper myContext;
    private final IDaoRegistry myDaoRegistry;

    public GraphQLProviderWithIntrospection(FhirContext theFhirContext, IValidationSupport theValidationSupport, IGraphQLStorageServices theIGraphQLStorageServices, ISearchParamRegistry theSearchParamRegistry, IDaoRegistry theDaoRegistry) {
        super(theFhirContext, theValidationSupport, theIGraphQLStorageServices);
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.myDaoRegistry = theDaoRegistry;
        this.myContext = VersionSpecificWorkerContextWrapper.newVersionSpecificWorkerContextWrapper((IValidationSupport)theValidationSupport);
        this.myGenerator = new GraphQLSchemaGenerator((IWorkerContext)this.myContext, VersionUtil.getVersion());
    }

    public String processGraphQlGetRequest(ServletRequestDetails theRequestDetails, IIdType theId, String theQueryUrl) {
        return super.processGraphQlGetRequest(theRequestDetails, theId, theQueryUrl);
    }

    public String processGraphQlPostRequest(ServletRequestDetails theServletRequestDetails, RequestDetails theRequestDetails, IIdType theId, String theQueryBody) {
        if (theQueryBody.contains("__schema")) {
            Collection<String> resourceTypes;
            if (theId != null) {
                throw new InvalidRequestException(Msg.code((int)2035) + "GraphQL introspection not supported at instance level. Please try at server- or instance- level.");
            }
            EnumSet<GraphQLSchemaGenerator.FHIROperationType> operations = EnumSet.of(GraphQLSchemaGenerator.FHIROperationType.READ, GraphQLSchemaGenerator.FHIROperationType.SEARCH);
            if (theRequestDetails.getResourceName() != null) {
                resourceTypes = Collections.singleton(theRequestDetails.getResourceName());
            } else {
                resourceTypes = new HashSet<String>();
                for (String next : this.myContext.getResourceNames()) {
                    if (!this.myDaoRegistry.isResourceTypeSupported(next)) continue;
                    resourceTypes.add(next);
                }
                resourceTypes = resourceTypes.stream().sorted().collect(Collectors.toList());
            }
            return this.generateSchema(theQueryBody, resourceTypes, operations);
        }
        return super.processGraphQlPostRequest(theServletRequestDetails, theRequestDetails, theId, theQueryBody);
    }

    private String generateSchema(String theQueryBody, Collection<String> theResourceTypes, EnumSet<GraphQLSchemaGenerator.FHIROperationType> theOperations) {
        StringBuilder schemaBuilder = new StringBuilder();
        try (StringBuilderWriter writer = new StringBuilderWriter(schemaBuilder);){
            this.myGenerator.generateTypes((Writer)writer, theOperations);
            writer.append("\ntype Resource {").append("\n  id: [token]\n}").append("\n");
            writer.append("\ninput ResourceInput {").append("\n  id: [token]\n}").append("\n");
            for (String nextResourceType : theResourceTypes) {
                StructureDefinition sd = this.fetchStructureDefinition(nextResourceType);
                List<SearchParameter> parameters = this.toR5SearchParams(this.mySearchParamRegistry.getActiveSearchParams(nextResourceType).values());
                this.myGenerator.generateResource((Writer)writer, sd, parameters, theOperations);
            }
            writer.append("\ntype Query {");
            for (String nextResourceType : theResourceTypes) {
                if (theOperations.contains(GraphQLSchemaGenerator.FHIROperationType.READ)) {
                    writer.append("\n  ").append(nextResourceType).append("(id: String): ").append(nextResourceType).append("\n");
                }
                if (!theOperations.contains(GraphQLSchemaGenerator.FHIROperationType.SEARCH)) continue;
                List<SearchParameter> parameters = this.toR5SearchParams(this.mySearchParamRegistry.getActiveSearchParams(nextResourceType).values());
                this.myGenerator.generateListAccessQuery((Writer)writer, parameters, nextResourceType);
                this.myGenerator.generateConnectionAccessQuery((Writer)writer, parameters, nextResourceType);
            }
            writer.append("\n}");
            writer.flush();
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code((int)2036) + e.getMessage(), (Throwable)e);
        }
        String schema = schemaBuilder.toString().replace("\r", "");
        ourLog.debug("Schema generated: {} chars", (Object)schema.length());
        ourLog.debug("Schema generated: {}", (Object)MessageSupplier.msg(() -> StringUtil.prependLineNumbers((String)schema)));
        SchemaParser schemaParser = new SchemaParser();
        TypeDefinitionRegistry typeDefinitionRegistry = schemaParser.parse(schema);
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        for (String next : typeDefinitionRegistry.scalars().keySet()) {
            if (Character.isUpperCase(next.charAt(0))) continue;
            runtimeWiringBuilder.scalar(new GraphQLScalarType.Builder().name(next).coercing((Coercing)new GraphqlStringCoercing()).build());
        }
        RuntimeWiring runtimeWiring = runtimeWiringBuilder.build();
        GraphQLSchema graphQLSchema = schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, runtimeWiring);
        GraphQL build = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
        ExecutionResult executionResult = build.execute(theQueryBody);
        Map data = executionResult.toSpecification();
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)data);
    }

    @Nonnull
    private List<SearchParameter> toR5SearchParams(Collection<RuntimeSearchParam> searchParams) {
        ArrayList<SearchParameter> parameters = new ArrayList<SearchParameter>();
        for (RuntimeSearchParam next : searchParams) {
            SearchParameter sp = this.toR5SearchParam(next);
            if (sp == null) continue;
            parameters.add(sp);
        }
        return parameters;
    }

    @Nullable
    private SearchParameter toR5SearchParam(RuntimeSearchParam next) {
        SearchParameter sp = new SearchParameter();
        sp.setUrl(next.getUri());
        sp.setCode(next.getName());
        sp.setName(next.getName());
        switch (next.getParamType()) {
            case NUMBER: {
                sp.setType(Enumerations.SearchParamType.NUMBER);
                break;
            }
            case DATE: {
                sp.setType(Enumerations.SearchParamType.DATE);
                break;
            }
            case STRING: {
                sp.setType(Enumerations.SearchParamType.STRING);
                break;
            }
            case TOKEN: {
                sp.setType(Enumerations.SearchParamType.TOKEN);
                break;
            }
            case REFERENCE: {
                sp.setType(Enumerations.SearchParamType.REFERENCE);
                break;
            }
            case COMPOSITE: {
                sp.setType(Enumerations.SearchParamType.COMPOSITE);
                break;
            }
            case QUANTITY: {
                sp.setType(Enumerations.SearchParamType.QUANTITY);
                break;
            }
            case URI: {
                sp.setType(Enumerations.SearchParamType.URI);
                break;
            }
            default: {
                return null;
            }
        }
        return sp;
    }

    @Nonnull
    private StructureDefinition fetchStructureDefinition(String resourceName) {
        StructureDefinition retVal = (StructureDefinition)this.myContext.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
        Validate.notNull((Object)retVal);
        return retVal;
    }
}

